/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

struct wizz *wizz;

struct wizz *init_wizz(void){
    struct wizz *wizz;

    wizz = g_new0(struct wizz, 1);
    wizz->items = g_ptr_array_new();
    return wizz;
};

void free_wizz_item(struct wizz_item *wi){
    
    if (wi->tname) g_free(wi->tname);
    if (wi->pexch) g_free(wi->pexch);
    if (wi->pexchtype) g_free(wi->pexchtype);
    
    g_free(wi);
}


void free_wizz(struct wizz *wizz){
    int i;
    struct wizz_item *wi;

    for (i=wizz->items->len-1; i>=0; i--){
        wi = (struct wizz_item *)g_ptr_array_index(wizz->items, i);
        free_wizz_item(wi);
    }
    
    g_ptr_array_free(wizz->items, TRUE);  /* YES, TRUE */
    g_free(wizz);
}

struct wizz_item *find_wizz(struct wizz *wizz, gchar *str){
    struct wizz_item *wi;
    int i;

    for (i=0; i<wizz->items->len; i++){
        wi = (struct wizz_item *)g_ptr_array_index(wizz->items, i);
        if (!wi->tname) continue;
        if (strcasecmp(wi->tname, str)==0) return wi;
    }
    return NULL;
}

int load_wizz_from_file(struct wizz *wizz, gchar *filename){
    FILE *f;
    GString *gs;
    struct wizz_item *wi=NULL;
    gchar **items, *k, *v;
    long int pos;

    gs = g_string_sized_new(100);
    
    f=NULL;
    pos=0;
    /*dbg("load_wizz_from_file('%s')\n", filename);*/
    if (filename){
        f = fopen(filename, "rt");
        if (!f) {
    /*        dbg("Can't open '%s'\n", filename);*/
            return -1;
        }
    }
    
    while(1){
        if (filename){
            if (!safe_fgets(gs, f, 1)) break;
        }else{
            if (!safe_mgets(gs, txt_tucnakwiz, &pos, sizeof(txt_tucnakwiz), 1)) break;
        }
        g_strstrip(gs->str);
    
        if (gs->str[0]=='['){
            gchar *tname;
            
                
            tname = g_strdup(gs->str+1);
            if (strlen(tname)>0 && tname[strlen(tname)-1]==']')
                tname[strlen(tname)-1]='\0';
            
            wi = find_wizz(wizz, tname);
            if (!wi) {
                wi = g_new0(struct wizz_item,1);
                g_ptr_array_add(wizz->items, wi);
                
            }

            /*dbg("BEGIN '%s'\n", gs->str+1);*/
            if (wi->tname) g_free(wi->tname);
            wi->tname = tname;  
/*            dbg("  set tname='%s' \n", tname);*/
            continue;
        }
        items=g_strsplit(gs->str, "=", 2);
        
        if (!items[0] || !items[1]) {
            g_strfreev(items);
            continue;
        }
        k=items[0];
        v=items[1];
        
        /*dbg("   '%s'='%s'\n", k, v);*/

        if      (g_strcasecmp(k, "rstused")==0)
            wi->rstused=atoi(v);
        else if (g_strcasecmp(k, "qsoused")==0)
            wi->qsoused=atoi(v); 
        else if (g_strcasecmp(k, "wwlused")==0)
            wi->wwlused=atoi(v); 
        else if (g_strcasecmp(k, "excused")==0)
            wi->excused=atoi(v); 
        else if (g_strcasecmp(k, "qsopointsmultiplier")==0)
            wi->qsomult=atoi(v); 
        else if (g_strcasecmp(k, "minqsopoints")==0)
            wi->minqsop=atoi(v); 
        else if (g_strcasecmp(k, "maxqsopoints")==0)
            wi->maxqsop=atoi(v); 
        else if (g_strcasecmp(k, "qsocalcmethod")==0)
            wi->qsop_method=atoi(v); 
        else if (g_strcasecmp(k, "wwlbonus")==0)
            wi->wwlbonu=atoi(v); 
        else if (g_strcasecmp(k, "wwlmultiplier")==0)
            wi->wwlmult=atoi(v); 
        else if (g_strcasecmp(k, "dxccbonus")==0)
            wi->dxcbonu=atoi(v); 
        else if (g_strcasecmp(k, "dxccmultiplier")==0)
            wi->dxcmult=atoi(v); 
        else if (g_strcasecmp(k, "optionalexchangebonus")==0)
            wi->excbonu=atoi(v); 
        else if (g_strcasecmp(k, "optionalexchangemultiplier")==0)
            wi->excmult=atoi(v); 
        else if (g_strcasecmp(k, "totalcalcmethod")==0)
            wi->total_method=atoi(v); 
        
        else  if (g_strcasecmp(k, "wwltype")==0){
            wi->wwltype=0;
            if (g_strcasecmp(v, "normal")==0) wi->wwltype=1;
            if (g_strcasecmp(v, "extended")==0) wi->wwltype=2;
        }else if (g_strcasecmp(k, "shorttonormal")==0){
            wi->shorttonormal=0;
            if (g_strcasecmp(v, "yes")==0) wi->shorttonormal=1;
        }else if (g_strcasecmp(k, "insertoptionalexchange")==0){
            wi->insertpexch=0;
            if (g_strcasecmp(v, "yes")==0) wi->insertpexch=1;
        }else if (g_strcasecmp(k, "optionalexchangetype")==0){

            if (wi->pexchtype) g_free(wi->pexchtype);
            wi->pexchtype = g_strdup(v);
        }else if (g_strcasecmp(k, "ownoptionalexchange")==0){
            /* no action */
        }else 
            dbg("!!! unresolved key '%s'\n", k);
        
        
        g_strfreev(items);
    }

    if (filename) fclose(f);
    g_string_free(gs, 1);
    return 0;
}


void read_wizz_files(struct wizz *wizz){
    gchar *s;
    int ret;
    
/*    before=sbrk(0);*/
    s = g_strconcat(getenv("HOME"), "/tucnak/tucnakwiz", NULL); 
    ret=load_wizz_from_file(wizz, s);
    g_free(s);
    if (ret<0){
        load_wizz_from_file(wizz, NULL);
    }
}

struct wizz_item *get_wizz(struct wizz *wizz, int i){
    return (struct wizz_item *) g_ptr_array_index(wizz->items, i);
}

