#!/usr/bin/perl

use File::Basename;

$packagename = "ttf-baekmuk";

if ($#ARGV != 1) {
    print "Usage: uupdate.pl <ARCHIVE> <VERSION>\n";
    exit 1;
}

$archive = $ARGV[0];
$version = $ARGV[1];

$dir = dirname($archive) . "/$packagename-$version";

$ret = system("mkdir $dir");
die "mkdir $dir failed" if ($ret != 0);

$ret = system "mv $archive $dir/";
die "mv failed" if ($ret != 0);

open CHANGELOG, "dpkg-parsechangelog |";
while (<CHANGELOG>) {
    if (/^Version: (\d+:)?(.*)-([0-9a-z.+]+)$/) {
	$currentversion = "$2-$3";
	last;
    }
}
close CHANGELOG;
die "cannot know the current version! " unless ($upstreamversion);

ret = system "cd $dir && zcat ../$packagename_$currentversion.diff.gz | patch -p1";
die "patch failed" if ($ret != 0);

print "New archive is in $dir!\n";

exit 0;
