/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package games.strategy.triplea.ai.Dynamix_AI.UI;

import games.strategy.triplea.ai.Dynamix_AI.DSettings;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.GlobalCenter;
import games.strategy.triplea.ai.Dynamix_AI.Others.BattleCalculationType;
import games.strategy.triplea.ai.Dynamix_AI.Others.ThreatInvalidationType;
import games.strategy.triplea.ui.TripleAFrame;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.logging.Level;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

/**
 * 
 * @author Stephen
 */
public class SettingsWindow extends javax.swing.JDialog
{
	private static final long serialVersionUID = -5989598624017028122L;
	
	/** Creates new form SettingsWindow */
	public SettingsWindow(final TripleAFrame frame)
	{
		super(frame);
		initComponents();
	}
	
	/**
	 * This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	// <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents()
	{
		java.awt.GridBagConstraints gridBagConstraints;
		
		buttonGroup1 = new javax.swing.ButtonGroup();
		buttonGroup2 = new javax.swing.ButtonGroup();
		v_invalidationTypeButtonGroup = new javax.swing.ButtonGroup();
		jPanel7 = new javax.swing.JPanel();
		v_restoreDefaultsButton = new javax.swing.JButton();
		v_settingsDetailsButton = new javax.swing.JButton();
		jPanel14 = new javax.swing.JPanel();
		jPanel13 = new javax.swing.JPanel();
		v_cancelButton = new javax.swing.JButton();
		v_okButton = new javax.swing.JButton();
		v_tabPaneMain = new javax.swing.JTabbedPane();
		jPanel1 = new javax.swing.JPanel();
		jLabel14 = new javax.swing.JLabel();
		v_battleCalculator = new javax.swing.JRadioButton();
		v_basicStrengthEval = new javax.swing.JRadioButton();
		v_basicScoreEval = new javax.swing.JRadioButton();
		v_quickBattleCalculator = new javax.swing.JRadioButton();
		jPanel26 = new javax.swing.JPanel();
		v_pausingPanel = new javax.swing.JPanel();
		v_totalLengthGoalsPanel = new javax.swing.JPanel();
		v_purchaseWait_AL = new javax.swing.JSpinner();
		jLabel5 = new javax.swing.JLabel();
		v_combatMoveWait_AL = new javax.swing.JSpinner();
		jLabel6 = new javax.swing.JLabel();
		v_nonCombatMoveWait_AL = new javax.swing.JSpinner();
		jLabel7 = new javax.swing.JLabel();
		v_placementWait_AL = new javax.swing.JSpinner();
		jLabel8 = new javax.swing.JLabel();
		jLabel1 = new javax.swing.JLabel();
		jLabel2 = new javax.swing.JLabel();
		jLabel3 = new javax.swing.JLabel();
		jLabel4 = new javax.swing.JLabel();
		jPanel21 = new javax.swing.JPanel();
		jPanel23 = new javax.swing.JPanel();
		v_allowCalcingDecrease = new javax.swing.JCheckBox();
		v_calcDecreaseToPercentage = new javax.swing.JSpinner();
		jLabel13 = new javax.swing.JLabel();
		jPanel24 = new javax.swing.JPanel();
		jPanel25 = new javax.swing.JPanel();
		jPanel18 = new javax.swing.JPanel();
		v_aic_disableAllUnitPurchasesAndPlacements = new javax.swing.JCheckBox();
		v_aic_disableAllUnitMovement = new javax.swing.JCheckBox();
		v_resourceCollectionMultiplier = new javax.swing.JCheckBox();
		v_resourceCollectionMultiplyPercent = new javax.swing.JSpinner();
		v_unitPlacementMultiplier = new javax.swing.JCheckBox();
		v_unitPlacementMultiplyAmount = new javax.swing.JSpinner();
		jLabel47 = new javax.swing.JLabel();
		jLabel48 = new javax.swing.JLabel();
		v_resourceCollectionIncreaser = new javax.swing.JCheckBox();
		v_resourceCollectionIncreaseAmount = new javax.swing.JSpinner();
		jPanel4 = new javax.swing.JPanel();
		v_calcRunCountAssignmentsScrollPane = new javax.swing.JScrollPane();
		v_calcRunCountAssignmentsHolderPanel = new javax.swing.JPanel();
		jLabel17 = new javax.swing.JLabel();
		v_capurchase_determinesUnitThatWouldHelpTargetInvasionMost = new javax.swing.JSpinner();
		jLabel16 = new javax.swing.JLabel();
		jLabel18 = new javax.swing.JLabel();
		jLabel19 = new javax.swing.JLabel();
		v_cacm_determinesIfTaskCreationsWorthwhileBasedOnTakeoverChance = new javax.swing.JSpinner();
		jLabel20 = new javax.swing.JLabel();
		jLabel21 = new javax.swing.JLabel();
		jLabel22 = new javax.swing.JLabel();
		v_cacmncm_sortsPossibleTaskRecruitsForOptimalAttackDefense = new javax.swing.JSpinner();
		jLabel23 = new javax.swing.JLabel();
		jLabel24 = new javax.swing.JLabel();
		v_cacmncm_determinesIfTasksRequirementsAreMetEnoughForRecruitingStop = new javax.swing.JSpinner();
		jLabel25 = new javax.swing.JLabel();
		jLabel26 = new javax.swing.JLabel();
		jLabel27 = new javax.swing.JLabel();
		jLabel28 = new javax.swing.JLabel();
		jLabel29 = new javax.swing.JLabel();
		jLabel30 = new javax.swing.JLabel();
		v_cacm_determinesAttackResultsToSeeIfTaskWorthwhile = new javax.swing.JSpinner();
		v_cacmncm_determinesResponseResultsToSeeIfTaskWorthwhile = new javax.swing.JSpinner();
		jLabel31 = new javax.swing.JLabel();
		jLabel32 = new javax.swing.JLabel();
		jLabel33 = new javax.swing.JLabel();
		jLabel34 = new javax.swing.JLabel();
		jLabel35 = new javax.swing.JLabel();
		jLabel36 = new javax.swing.JLabel();
		v_cacmncm_determinesIfTaskEndangersCap = new javax.swing.JSpinner();
		jLabel37 = new javax.swing.JLabel();
		v_cacmncm_determinesSurvivalChanceAfterTaskToSeeIfToInvalidateAttackers = new javax.swing.JSpinner();
		jLabel38 = new javax.swing.JLabel();
		jLabel39 = new javax.swing.JLabel();
		jLabel40 = new javax.swing.JLabel();
		jLabel41 = new javax.swing.JLabel();
		v_cancm_determinesSurvivalChanceOfFromTerAfterMoveToSeeIfToCancelMove = new javax.swing.JSpinner();
		jLabel42 = new javax.swing.JLabel();
		jLabel43 = new javax.swing.JLabel();
		v_caretreat_determinesIfAIShouldRetreat = new javax.swing.JSpinner();
		jLabel44 = new javax.swing.JLabel();
		jLabel45 = new javax.swing.JLabel();
		jLabel63 = new javax.swing.JLabel();
		jLabel64 = new javax.swing.JLabel();
		jLabel82 = new javax.swing.JLabel();
		v_cacm_determinesIfTradeTasksRequirementsAreMetEnoughForRecruitingStop = new javax.swing.JSpinner();
		jPanel15 = new javax.swing.JPanel();
		v_aa_scrollPane1 = new javax.swing.JScrollPane();
		jPanel19 = new javax.swing.JPanel();
		jLabel118 = new javax.swing.JLabel();
		v_tr_attackOffensive_Capitals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement = new javax.swing.JSpinner();
		jLabel100 = new javax.swing.JLabel();
		v_tr_attackOffensive_counterAttackSurvivalChanceRequired = new javax.swing.JSpinner();
		v_tr_attackLandGrab_onlyGrabLandIfWeCanBlitzIt = new javax.swing.JCheckBox();
		jLabel124 = new javax.swing.JLabel();
		jLabel119 = new javax.swing.JLabel();
		jLabel103 = new javax.swing.JLabel();
		jLabel109 = new javax.swing.JLabel();
		v_tr_enableAttackStabalize = new javax.swing.JCheckBox();
		v_tr_attackOffensive_Capitals_takeoverChanceRequired = new javax.swing.JSpinner();
		jLabel66 = new javax.swing.JLabel();
		jLabel106 = new javax.swing.JLabel();
		jLabel102 = new javax.swing.JLabel();
		jLabel104 = new javax.swing.JLabel();
		jLabel117 = new javax.swing.JLabel();
		v_tr_attackOffensive_counterAttackTradeScoreRequiredToBypassSurvivalRequirement = new javax.swing.JSpinner();
		jLabel101 = new javax.swing.JLabel();
		jLabel96 = new javax.swing.JLabel();
		v_tr_attackOffensive_takeoverChanceRequired = new javax.swing.JSpinner();
		jLabel98 = new javax.swing.JLabel();
		v_tr_reinforceFrontline_enemyAttackTradeScoreRequiredToBypassRequirements = new javax.swing.JSpinner();
		v_tr_reinforceFrontLine_enemyAttackSurvivalChanceRequired = new javax.swing.JSpinner();
		v_tr_attackOffensive_Neutrals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement = new javax.swing.JSpinner();
		jLabel97 = new javax.swing.JLabel();
		jLabel123 = new javax.swing.JLabel();
		v_tr_attackTrade_certaintyOfReachingDesiredNumberOfLeftoverLandUnitsRequired = new javax.swing.JSpinner();
		jLabel107 = new javax.swing.JLabel();
		v_tr_reinforceStabalize_enemyAttackSurvivalChanceRequired = new javax.swing.JSpinner();
		v_tr_attackOffensive_Neutrals_counterAttackSurvivalChanceRequired = new javax.swing.JSpinner();
		jLabel114 = new javax.swing.JLabel();
		v_tr_attackStabalize_takeoverChanceRequired = new javax.swing.JSpinner();
		jLabel110 = new javax.swing.JLabel();
		jLabel115 = new javax.swing.JLabel();
		jLabel99 = new javax.swing.JLabel();
		jLabel105 = new javax.swing.JLabel();
		jLabel111 = new javax.swing.JLabel();
		jLabel112 = new javax.swing.JLabel();
		v_tr_enableAttackOffensive = new javax.swing.JCheckBox();
		jLabel122 = new javax.swing.JLabel();
		v_tr_attackOffensive_Capitals_counterAttackSurvivalChanceRequired = new javax.swing.JSpinner();
		jLabel116 = new javax.swing.JLabel();
		v_tr_attackTrade_totalTradeScore = new javax.swing.JSpinner();
		v_tr_enableReinforceStabalize = new javax.swing.JCheckBox();
		v_tr_enableAttackTrade = new javax.swing.JCheckBox();
		jLabel113 = new javax.swing.JLabel();
		jLabel50 = new javax.swing.JLabel();
		v_tr_enableReinforceBlock = new javax.swing.JCheckBox();
		v_tr_attackOffensive_Neutrals_takeoverChanceRequired = new javax.swing.JSpinner();
		jLabel121 = new javax.swing.JLabel();
		v_tr_enableAttackLandGrab = new javax.swing.JCheckBox();
		v_tr_enableReinforceFrontline = new javax.swing.JCheckBox();
		v_tr_attackStabalize_counterAttackSurvivalChanceRequired = new javax.swing.JSpinner();
		jLabel108 = new javax.swing.JLabel();
		v_tr_attackStabalize_counterAttackTradeScoreRequiredToBypassSurvivalRequirement = new javax.swing.JSpinner();
		jLabel120 = new javax.swing.JLabel();
		jPanel17 = new javax.swing.JPanel();
		v_cr_enableCallForLandGrab = new javax.swing.JCheckBox();
		v_cr_enableCallForDefensiveFront = new javax.swing.JCheckBox();
		v_cr_enableCallForCapitalDefense = new javax.swing.JCheckBox();
		jPanel27 = new javax.swing.JPanel();
		jPanel8 = new javax.swing.JPanel();
		v_logHolderTabbedPane = new javax.swing.JTabbedPane();
		jPanel9 = new javax.swing.JPanel();
		v_aiOutputLogAreaScrollPane = new javax.swing.JScrollPane();
		v_aiOutputLogArea = new javax.swing.JTextArea();
		v_enableAILogging = new javax.swing.JCheckBox();
		jLabel15 = new javax.swing.JLabel();
		v_logDepth = new javax.swing.JComboBox();
		v_limitLogHistoryToSpinner = new javax.swing.JSpinner();
		v_limitLogHistoryCB = new javax.swing.JCheckBox();
		jLabel46 = new javax.swing.JLabel();
		v_pauseAIs = new javax.swing.JCheckBox();
		jPanel2 = new javax.swing.JPanel();
		v_aa_scrollPane = new javax.swing.JScrollPane();
		jPanel12 = new javax.swing.JPanel();
		jPanel3 = new javax.swing.JPanel();
		jLabel58 = new javax.swing.JLabel();
		v_aa_globalThreatInvalidation = new javax.swing.JRadioButton();
		jLabel55 = new javax.swing.JLabel();
		v_aa_hotspotInvalidation = new javax.swing.JRadioButton();
		v_aa_radiusOfHotspotThreatInvalidation = new javax.swing.JSpinner();
		v_aa_percentageOfResistedThreatsThatTasksInvalidate = new javax.swing.JSpinner();
		v_aa_noThreatInvalidation = new javax.swing.JRadioButton();
		jLabel65 = new javax.swing.JLabel();
		jPanel10 = new javax.swing.JPanel();
		v_aa_resourcePercentageThatMustExistForFactoryBuy = new javax.swing.JSpinner();
		jLabel57 = new javax.swing.JLabel();
		jLabel53 = new javax.swing.JLabel();
		jLabel54 = new javax.swing.JLabel();
		v_aa_maxUnitTypesForPurchaseMix = new javax.swing.JSpinner();
		jPanel28 = new javax.swing.JPanel();
		jPanel5 = new javax.swing.JPanel();
		jLabel67 = new javax.swing.JLabel();
		v_aa_survivalChanceOfLandingTerRequiredForPlaneRecruit = new javax.swing.JSpinner();
		jLabel68 = new javax.swing.JLabel();
		jLabel69 = new javax.swing.JLabel();
		v_aa_ignoreAlliedUnitsAsDefenses = new javax.swing.JCheckBox();
		jPanel22 = new javax.swing.JPanel();
		
		setTitle("Dynamix AI Settings");
		setMinimumSize(new java.awt.Dimension(775, 400));
		addWindowListener(new java.awt.event.WindowAdapter()
		{
			@Override
			public void windowClosing(final java.awt.event.WindowEvent evt)
			{
				formWindowClosing(evt);
			}
			
			@Override
			public void windowOpened(final java.awt.event.WindowEvent evt)
			{
				formWindowOpened(evt);
			}
		});
		getContentPane().setLayout(new java.awt.GridBagLayout());
		
		jPanel7.setName("jPanel3"); // NOI18N
		jPanel7.setPreferredSize(new java.awt.Dimension(600, 45));
		jPanel7.setLayout(new java.awt.GridBagLayout());
		
		v_restoreDefaultsButton.setText("Restore Defaults");
		v_restoreDefaultsButton.setMinimumSize(new java.awt.Dimension(118, 23));
		v_restoreDefaultsButton.setName("v_restoreDefaultsButton"); // NOI18N
		v_restoreDefaultsButton.setPreferredSize(new java.awt.Dimension(118, 23));
		v_restoreDefaultsButton.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(final java.awt.event.ActionEvent evt)
			{
				v_restoreDefaultsButtonActionPerformed(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(11, 0, 11, 0);
		jPanel7.add(v_restoreDefaultsButton, gridBagConstraints);
		
		v_settingsDetailsButton.setText("Settings Details");
		v_settingsDetailsButton.setMinimumSize(new java.awt.Dimension(115, 23));
		v_settingsDetailsButton.setName("v_settingsDetailsButton"); // NOI18N
		v_settingsDetailsButton.setPreferredSize(new java.awt.Dimension(115, 23));
		v_settingsDetailsButton.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(final java.awt.event.ActionEvent evt)
			{
				v_settingsDetailsButtonActionPerformed(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		gridBagConstraints.insets = new java.awt.Insets(11, 6, 11, 0);
		jPanel7.add(v_settingsDetailsButton, gridBagConstraints);
		
		jPanel14.setName("jPanel14"); // NOI18N
		jPanel14.setLayout(new java.awt.GridBagLayout());
		
		jPanel13.setName("jPanel13"); // NOI18N
		jPanel13.setLayout(new java.awt.GridBagLayout());
		
		v_cancelButton.setText("Cancel");
		v_cancelButton.setName("v_cancelButton"); // NOI18N
		v_cancelButton.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(final java.awt.event.ActionEvent evt)
			{
				v_cancelButtonActionPerformed(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
		jPanel13.add(v_cancelButton, gridBagConstraints);
		
		v_okButton.setText("OK");
		v_okButton.setName("v_okButton"); // NOI18N
		v_okButton.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(final java.awt.event.ActionEvent evt)
			{
				v_okButtonActionPerformed(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		jPanel13.add(v_okButton, gridBagConstraints);
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		jPanel14.add(jPanel13, gridBagConstraints);
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(11, 6, 11, 0);
		jPanel7.add(jPanel14, gridBagConstraints);
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(0, 7, 0, 7);
		getContentPane().add(jPanel7, gridBagConstraints);
		
		v_tabPaneMain.setTabLayoutPolicy(javax.swing.JTabbedPane.SCROLL_TAB_LAYOUT);
		v_tabPaneMain.setName("v_tabPaneMain"); // NOI18N
		v_tabPaneMain.setPreferredSize(new java.awt.Dimension(500, 250));
		
		jPanel1.setName("jPanel1"); // NOI18N
		jPanel1.setPreferredSize(new java.awt.Dimension(500, 131));
		jPanel1.setLayout(new java.awt.GridBagLayout());
		
		jLabel14.setText("Battle Calculation Method:");
		jLabel14.setName("jLabel14"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(12, 10, 5, 0);
		jPanel1.add(jLabel14, gridBagConstraints);
		
		buttonGroup2.add(v_battleCalculator);
		v_battleCalculator.setSelected(true);
		v_battleCalculator.setText("Battle Calculator");
		v_battleCalculator.setName("v_battleCalculator"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 4;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(7, 0, 0, 0);
		jPanel1.add(v_battleCalculator, gridBagConstraints);
		
		buttonGroup2.add(v_basicStrengthEval);
		v_basicStrengthEval.setText("Basic Strength Eval");
		v_basicStrengthEval.setEnabled(false);
		v_basicStrengthEval.setName("v_basicStrengthEval"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 0, 0);
		jPanel1.add(v_basicStrengthEval, gridBagConstraints);
		
		buttonGroup2.add(v_basicScoreEval);
		v_basicScoreEval.setText("Basic Score Eval");
		v_basicScoreEval.setEnabled(false);
		v_basicScoreEval.setName("v_basicScoreEval"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(7, 0, 0, 0);
		jPanel1.add(v_basicScoreEval, gridBagConstraints);
		
		buttonGroup2.add(v_quickBattleCalculator);
		v_quickBattleCalculator.setText("Quick Battle Calculator");
		v_quickBattleCalculator.setEnabled(false);
		v_quickBattleCalculator.setName("v_quickBattleCalculator"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 3;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(7, 0, 0, 0);
		jPanel1.add(v_quickBattleCalculator, gridBagConstraints);
		
		jPanel26.setName("jPanel26"); // NOI18N
		jPanel26.setLayout(null);
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 5;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.weighty = 99.0;
		jPanel1.add(jPanel26, gridBagConstraints);
		
		v_tabPaneMain.addTab("General", jPanel1);
		
		v_pausingPanel.setName("v_pausingPanel"); // NOI18N
		v_pausingPanel.setPreferredSize(new java.awt.Dimension(500, 199));
		v_pausingPanel.setLayout(new java.awt.GridBagLayout());
		
		v_totalLengthGoalsPanel.setName("v_totalLengthGoalsPanel"); // NOI18N
		v_totalLengthGoalsPanel.setLayout(new java.awt.GridBagLayout());
		
		v_purchaseWait_AL.setModel(new javax.swing.SpinnerNumberModel(750, 0, 25000, 50));
		v_purchaseWait_AL.setName("v_purchaseWait_AL"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.gridheight = 2;
		gridBagConstraints.insets = new java.awt.Insets(11, 10, 0, 0);
		v_totalLengthGoalsPanel.add(v_purchaseWait_AL, gridBagConstraints);
		
		jLabel5.setText("Milliseconds");
		jLabel5.setToolTipText("Set the target duration of each purchase phase action");
		jLabel5.setName("jLabel5"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(14, 10, 0, 10);
		v_totalLengthGoalsPanel.add(jLabel5, gridBagConstraints);
		
		v_combatMoveWait_AL.setModel(new javax.swing.SpinnerNumberModel(750, 0, 25000, 50));
		v_combatMoveWait_AL.setName("v_combatMoveWait_AL"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.gridheight = 2;
		gridBagConstraints.insets = new java.awt.Insets(11, 10, 0, 0);
		v_totalLengthGoalsPanel.add(v_combatMoveWait_AL, gridBagConstraints);
		
		jLabel6.setText("Milliseconds");
		jLabel6.setToolTipText("Set the target duration of each combat move phase action");
		jLabel6.setName("jLabel6"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.insets = new java.awt.Insets(14, 10, 0, 10);
		v_totalLengthGoalsPanel.add(jLabel6, gridBagConstraints);
		
		v_nonCombatMoveWait_AL.setModel(new javax.swing.SpinnerNumberModel(750, 0, 25000, 50));
		v_nonCombatMoveWait_AL.setName("v_nonCombatMoveWait_AL"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 4;
		gridBagConstraints.gridheight = 2;
		gridBagConstraints.insets = new java.awt.Insets(11, 10, 0, 0);
		v_totalLengthGoalsPanel.add(v_nonCombatMoveWait_AL, gridBagConstraints);
		
		jLabel7.setText("Milliseconds");
		jLabel7.setToolTipText("Set the target duration of each non combat move phase action");
		jLabel7.setName("jLabel7"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 4;
		gridBagConstraints.insets = new java.awt.Insets(14, 10, 0, 10);
		v_totalLengthGoalsPanel.add(jLabel7, gridBagConstraints);
		
		v_placementWait_AL.setModel(new javax.swing.SpinnerNumberModel(750, 0, 25000, 50));
		v_placementWait_AL.setName("v_placementWait_AL"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 6;
		gridBagConstraints.gridheight = 2;
		gridBagConstraints.insets = new java.awt.Insets(11, 10, 11, 0);
		v_totalLengthGoalsPanel.add(v_placementWait_AL, gridBagConstraints);
		
		jLabel8.setText("Milliseconds");
		jLabel8.setToolTipText("Set the target duration of each placement phase action");
		jLabel8.setName("jLabel8"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 6;
		gridBagConstraints.insets = new java.awt.Insets(14, 10, 0, 10);
		v_totalLengthGoalsPanel.add(jLabel8, gridBagConstraints);
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 4;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.gridheight = 4;
		v_pausingPanel.add(v_totalLengthGoalsPanel, gridBagConstraints);
		
		jLabel1.setText("Purchase Phase:");
		jLabel1.setName("jLabel1"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(13, 10, 7, 0);
		v_pausingPanel.add(jLabel1, gridBagConstraints);
		
		jLabel2.setText("Combat Move Phase:");
		jLabel2.setName("jLabel2"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 0);
		v_pausingPanel.add(jLabel2, gridBagConstraints);
		
		jLabel3.setText("Non Combat Move Phase:");
		jLabel3.setName("jLabel3"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 3;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 0);
		v_pausingPanel.add(jLabel3, gridBagConstraints);
		
		jLabel4.setText("Placement Phase:");
		jLabel4.setName("jLabel4"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 4;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 13, 0);
		v_pausingPanel.add(jLabel4, gridBagConstraints);
		
		jPanel21.setName("jPanel21"); // NOI18N
		jPanel21.setLayout(null);
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 7;
		gridBagConstraints.weighty = 99.0;
		v_pausingPanel.add(jPanel21, gridBagConstraints);
		
		jPanel23.setName("jPanel23"); // NOI18N
		jPanel23.setLayout(new java.awt.GridBagLayout());
		
		v_allowCalcingDecrease.setSelected(true);
		v_allowCalcingDecrease.setText("When an action is taking longer than the time specified, reduce the calc'ing run count to:");
		v_allowCalcingDecrease.setName("v_allowCalcingDecrease"); // NOI18N
		v_allowCalcingDecrease.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_allowCalcingDecreaseStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		jPanel23.add(v_allowCalcingDecrease, gridBagConstraints);
		
		v_calcDecreaseToPercentage.setModel(new javax.swing.SpinnerNumberModel(75, 1, 100, 1));
		v_calcDecreaseToPercentage.setToolTipText("");
		v_calcDecreaseToPercentage.setName("v_calcDecreaseToPercentage"); // NOI18N
		v_calcDecreaseToPercentage.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
		jPanel23.add(v_calcDecreaseToPercentage, gridBagConstraints);
		
		jLabel13.setText("%");
		jLabel13.setName("jLabel13"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		jPanel23.add(jLabel13, gridBagConstraints);
		
		jPanel24.setName("jPanel24"); // NOI18N
		jPanel24.setLayout(null);
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 3;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.weighty = 99.0;
		jPanel23.add(jPanel24, gridBagConstraints);
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 5;
		gridBagConstraints.gridwidth = 6;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		v_pausingPanel.add(jPanel23, gridBagConstraints);
		
		jPanel25.setName("jPanel25"); // NOI18N
		jPanel25.setLayout(null);
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 3;
		gridBagConstraints.gridy = 6;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.weighty = 99.0;
		v_pausingPanel.add(jPanel25, gridBagConstraints);
		
		v_tabPaneMain.addTab("Pausing", v_pausingPanel);
		
		jPanel18.setName("jPanel18"); // NOI18N
		jPanel18.setLayout(new java.awt.GridBagLayout());
		
		v_aic_disableAllUnitPurchasesAndPlacements.setText("Disable All Unit Purchases/Placements");
		v_aic_disableAllUnitPurchasesAndPlacements.setToolTipText("Causes all Dynamix AI's to skip their purchase and placement phases, as well as destroy their own PU's at the end of each round.");
		v_aic_disableAllUnitPurchasesAndPlacements.setName("v_aic_disableAllUnitPurchasesAndPlacements"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 4;
		gridBagConstraints.gridwidth = 5;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weighty = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		jPanel18.add(v_aic_disableAllUnitPurchasesAndPlacements, gridBagConstraints);
		
		v_aic_disableAllUnitMovement.setText("Disable All Unit Movements");
		v_aic_disableAllUnitMovement.setToolTipText("Causes all Dynamix AI's to skip their cm and ncm movement phases.");
		v_aic_disableAllUnitMovement.setName("v_aic_disableAllUnitMovement"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 3;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		jPanel18.add(v_aic_disableAllUnitMovement, gridBagConstraints);
		
		v_resourceCollectionMultiplier.setText("Resource Collection Multiplier:");
		v_resourceCollectionMultiplier.setToolTipText("This cheat multiplies the number of resources collected at the end of the round by the percentage supplied.");
		v_resourceCollectionMultiplier.setName("v_resourceCollectionMultiplier"); // NOI18N
		v_resourceCollectionMultiplier.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_resourceCollectionMultiplierStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(12, 10, 5, 0);
		jPanel18.add(v_resourceCollectionMultiplier, gridBagConstraints);
		
		v_resourceCollectionMultiplyPercent.setModel(new javax.swing.SpinnerNumberModel(100, 100, 200, 10));
		v_resourceCollectionMultiplyPercent.setEnabled(false);
		v_resourceCollectionMultiplyPercent.setName("v_resourceCollectionMultiplyPercent"); // NOI18N
		v_resourceCollectionMultiplyPercent.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.ipadx = 13;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		jPanel18.add(v_resourceCollectionMultiplyPercent, gridBagConstraints);
		
		v_unitPlacementMultiplier.setText("Unit Placement Multiplier:");
		v_unitPlacementMultiplier.setToolTipText("This cheat multiplies the number of units placed down on each factory by the percentage supplied.");
		v_unitPlacementMultiplier.setName("v_unitPlacementMultiplier"); // NOI18N
		v_unitPlacementMultiplier.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_unitPlacementMultiplierStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		jPanel18.add(v_unitPlacementMultiplier, gridBagConstraints);
		
		v_unitPlacementMultiplyAmount.setModel(new javax.swing.SpinnerNumberModel(100, 100, 200, 10));
		v_unitPlacementMultiplyAmount.setEnabled(false);
		v_unitPlacementMultiplyAmount.setName("v_unitPlacementMultiplyAmount"); // NOI18N
		v_unitPlacementMultiplyAmount.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.ipadx = 13;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		jPanel18.add(v_unitPlacementMultiplyAmount, gridBagConstraints);
		
		jLabel47.setText("%");
		jLabel47.setName("jLabel47"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 3;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		jPanel18.add(jLabel47, gridBagConstraints);
		
		jLabel48.setText("%");
		jLabel48.setName("jLabel48"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 3;
		gridBagConstraints.gridy = 2;
		jPanel18.add(jLabel48, gridBagConstraints);
		
		v_resourceCollectionIncreaser.setText("Resource Collection Increaser:");
		v_resourceCollectionIncreaser.setToolTipText("This cheat increases the number of resources collected at the end of the round by the amount supplied.");
		v_resourceCollectionIncreaser.setName("v_resourceCollectionIncreaser"); // NOI18N
		v_resourceCollectionIncreaser.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_resourceCollectionIncreaserStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		jPanel18.add(v_resourceCollectionIncreaser, gridBagConstraints);
		
		v_resourceCollectionIncreaseAmount.setModel(new javax.swing.SpinnerNumberModel(0, 0, 100, 10));
		v_resourceCollectionIncreaseAmount.setEnabled(false);
		v_resourceCollectionIncreaseAmount.setName("v_resourceCollectionIncreaseAmount"); // NOI18N
		v_resourceCollectionIncreaseAmount.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.ipadx = 13;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		jPanel18.add(v_resourceCollectionIncreaseAmount, gridBagConstraints);
		
		v_tabPaneMain.addTab("Cheating", jPanel18);
		
		jPanel4.setName("jPanel4"); // NOI18N
		jPanel4.setLayout(new java.awt.GridLayout(1, 0));
		
		v_calcRunCountAssignmentsScrollPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
		v_calcRunCountAssignmentsScrollPane.setName("v_calcRunCountAssignmentsScrollPane"); // NOI18N
		
		v_calcRunCountAssignmentsHolderPanel.setName("v_calcRunCountAssignmentsHolderPanel"); // NOI18N
		v_calcRunCountAssignmentsHolderPanel.setPreferredSize(new java.awt.Dimension(500, 519));
		v_calcRunCountAssignmentsHolderPanel.setLayout(new java.awt.GridBagLayout());
		
		jLabel17.setText("calculations");
		jLabel17.setName("jLabel17"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(7, 5, 0, 5);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel17, gridBagConstraints);
		
		v_capurchase_determinesUnitThatWouldHelpTargetInvasionMost.setModel(new javax.swing.SpinnerNumberModel(50, 1, 5000, 10));
		v_capurchase_determinesUnitThatWouldHelpTargetInvasionMost.setName("v_capurchase_determinesUnitThatWouldHelpTargetInvasionMost"); // NOI18N
		v_capurchase_determinesUnitThatWouldHelpTargetInvasionMost.setPreferredSize(new java.awt.Dimension(70, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(7, 0, 0, 0);
		v_calcRunCountAssignmentsHolderPanel.add(v_capurchase_determinesUnitThatWouldHelpTargetInvasionMost, gridBagConstraints);
		
		jLabel16.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel16.setText("Purchase - Determines the unit that would help win invasion on enemy target the most:");
		jLabel16.setName("jLabel16"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(12, 10, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel16, gridBagConstraints);
		
		jLabel18.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel18.setText("(Frequency: Very High, Suggested Range: 10 - 250)");
		jLabel18.setName("jLabel18"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 25, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel18, gridBagConstraints);
		
		jLabel19.setText("calculations");
		jLabel19.setName("jLabel19"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 2;
		v_calcRunCountAssignmentsHolderPanel.add(jLabel19, gridBagConstraints);
		
		v_cacm_determinesIfTaskCreationsWorthwhileBasedOnTakeoverChance.setModel(new javax.swing.SpinnerNumberModel(250, 1, 5000, 10));
		v_cacm_determinesIfTaskCreationsWorthwhileBasedOnTakeoverChance.setName("v_cacm_determinesIfTaskCreationsWorthwhileBasedOnTakeoverChance"); // NOI18N
		v_cacm_determinesIfTaskCreationsWorthwhileBasedOnTakeoverChance.setPreferredSize(new java.awt.Dimension(70, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 2;
		v_calcRunCountAssignmentsHolderPanel.add(v_cacm_determinesIfTaskCreationsWorthwhileBasedOnTakeoverChance, gridBagConstraints);
		
		jLabel20.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel20.setText("CM - Determines if the creation of a task is worthwhile based on takeover chance:");
		jLabel20.setName("jLabel20"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel20, gridBagConstraints);
		
		jLabel21.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel21.setText("(Frequency: Average, Suggested Range: 50 - 500)");
		jLabel21.setName("jLabel21"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 3;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 25, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel21, gridBagConstraints);
		
		jLabel22.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel22.setText("CM & NCM - Sorts possible task recruits for optimal attack/defense:");
		jLabel22.setName("jLabel22"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 4;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel22, gridBagConstraints);
		
		v_cacmncm_sortsPossibleTaskRecruitsForOptimalAttackDefense.setModel(new javax.swing.SpinnerNumberModel(25, 1, 5000, 5));
		v_cacmncm_sortsPossibleTaskRecruitsForOptimalAttackDefense.setName("v_cacmncm_sortsPossibleTaskRecruitsForOptimalAttackDefense"); // NOI18N
		v_cacmncm_sortsPossibleTaskRecruitsForOptimalAttackDefense.setPreferredSize(new java.awt.Dimension(70, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 4;
		v_calcRunCountAssignmentsHolderPanel.add(v_cacmncm_sortsPossibleTaskRecruitsForOptimalAttackDefense, gridBagConstraints);
		
		jLabel23.setText("calculations");
		jLabel23.setName("jLabel23"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 4;
		v_calcRunCountAssignmentsHolderPanel.add(jLabel23, gridBagConstraints);
		
		jLabel24.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel24.setText("(Frequency: Very High, Suggested Range: 5 - 250)");
		jLabel24.setName("jLabel24"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 5;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 25, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel24, gridBagConstraints);
		
		v_cacmncm_determinesIfTasksRequirementsAreMetEnoughForRecruitingStop.setModel(new javax.swing.SpinnerNumberModel(250, 1, 5000, 10));
		v_cacmncm_determinesIfTasksRequirementsAreMetEnoughForRecruitingStop.setName("v_cacmncm_determinesIfTasksRequirementsAreMetEnoughForRecruitingStop"); // NOI18N
		v_cacmncm_determinesIfTasksRequirementsAreMetEnoughForRecruitingStop.setPreferredSize(new java.awt.Dimension(70, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 6;
		v_calcRunCountAssignmentsHolderPanel.add(v_cacmncm_determinesIfTasksRequirementsAreMetEnoughForRecruitingStop, gridBagConstraints);
		
		jLabel25.setText("calculations");
		jLabel25.setName("jLabel25"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 6;
		v_calcRunCountAssignmentsHolderPanel.add(jLabel25, gridBagConstraints);
		
		jLabel26.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel26.setText("CM & NCM - Determines if the task's requirements are far enough met for unit recruiting to stop:");
		jLabel26.setName("jLabel26"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 6;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel26, gridBagConstraints);
		
		jLabel27.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel27.setText("(Frequency: High, Suggested Range: 50 - 1000)");
		jLabel27.setName("jLabel27"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 7;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 25, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel27, gridBagConstraints);
		
		jLabel28.setText("calculations");
		jLabel28.setName("jLabel28"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 10;
		v_calcRunCountAssignmentsHolderPanel.add(jLabel28, gridBagConstraints);
		
		jLabel29.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel29.setText("CM - Determines attack results for determining if task is worthwhile:");
		jLabel29.setName("jLabel29"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 10;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel29, gridBagConstraints);
		
		jLabel30.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel30.setText("(Frequency: Average, Suggested Range: 250 - 2500)");
		jLabel30.setName("jLabel30"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 11;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 25, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel30, gridBagConstraints);
		
		v_cacm_determinesAttackResultsToSeeIfTaskWorthwhile.setModel(new javax.swing.SpinnerNumberModel(500, 1, 5000, 10));
		v_cacm_determinesAttackResultsToSeeIfTaskWorthwhile.setName("v_cacm_determinesAttackResultsToSeeIfTaskWorthwhile"); // NOI18N
		v_cacm_determinesAttackResultsToSeeIfTaskWorthwhile.setPreferredSize(new java.awt.Dimension(70, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 10;
		v_calcRunCountAssignmentsHolderPanel.add(v_cacm_determinesAttackResultsToSeeIfTaskWorthwhile, gridBagConstraints);
		
		v_cacmncm_determinesResponseResultsToSeeIfTaskWorthwhile.setModel(new javax.swing.SpinnerNumberModel(500, 1, 5000, 10));
		v_cacmncm_determinesResponseResultsToSeeIfTaskWorthwhile.setName("v_cacmncm_determinesResponseResultsToSeeIfTaskWorthwhile"); // NOI18N
		v_cacmncm_determinesResponseResultsToSeeIfTaskWorthwhile.setPreferredSize(new java.awt.Dimension(70, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 12;
		v_calcRunCountAssignmentsHolderPanel.add(v_cacmncm_determinesResponseResultsToSeeIfTaskWorthwhile, gridBagConstraints);
		
		jLabel31.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel31.setText("(Frequency: Average, Suggested Range: 250 - 2500)");
		jLabel31.setName("jLabel31"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 13;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 25, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel31, gridBagConstraints);
		
		jLabel32.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel32.setText("CM & NCM - Determines counter-attack results for determining if task is worthwhile:");
		jLabel32.setName("jLabel32"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 12;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel32, gridBagConstraints);
		
		jLabel33.setText("calculations");
		jLabel33.setName("jLabel33"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 12;
		v_calcRunCountAssignmentsHolderPanel.add(jLabel33, gridBagConstraints);
		
		jLabel34.setText("calculations");
		jLabel34.setName("jLabel34"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 14;
		v_calcRunCountAssignmentsHolderPanel.add(jLabel34, gridBagConstraints);
		
		jLabel35.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel35.setText("CM & NCM - Determines if task endangers the capital:");
		jLabel35.setName("jLabel35"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 14;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel35, gridBagConstraints);
		
		jLabel36.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel36.setText("(Frequency: Low, Suggested Range: 100 - 1500)");
		jLabel36.setName("jLabel36"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 15;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 25, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel36, gridBagConstraints);
		
		v_cacmncm_determinesIfTaskEndangersCap.setModel(new javax.swing.SpinnerNumberModel(250, 1, 5000, 10));
		v_cacmncm_determinesIfTaskEndangersCap.setName("v_cacmncm_determinesIfTaskEndangersCap"); // NOI18N
		v_cacmncm_determinesIfTaskEndangersCap.setPreferredSize(new java.awt.Dimension(70, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 14;
		v_calcRunCountAssignmentsHolderPanel.add(v_cacmncm_determinesIfTaskEndangersCap, gridBagConstraints);
		
		jLabel37.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel37.setText("(Frequency: Very Low, Suggested Range: 50 - 1000)");
		jLabel37.setName("jLabel37"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 17;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 25, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel37, gridBagConstraints);
		
		v_cacmncm_determinesSurvivalChanceAfterTaskToSeeIfToInvalidateAttackers.setModel(new javax.swing.SpinnerNumberModel(250, 1, 5000, 10));
		v_cacmncm_determinesSurvivalChanceAfterTaskToSeeIfToInvalidateAttackers.setName("v_cacmncm_determinesSurvivalChanceAfterTaskToSeeIfToInvalidateAttackers"); // NOI18N
		v_cacmncm_determinesSurvivalChanceAfterTaskToSeeIfToInvalidateAttackers.setPreferredSize(new java.awt.Dimension(70, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 16;
		v_calcRunCountAssignmentsHolderPanel.add(v_cacmncm_determinesSurvivalChanceAfterTaskToSeeIfToInvalidateAttackers, gridBagConstraints);
		
		jLabel38.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel38.setText("CM & NCM - Determines survival chance after performing task to check if AI should invalidate attackers:");
		jLabel38.setName("jLabel38"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 16;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel38, gridBagConstraints);
		
		jLabel39.setText("calculations");
		jLabel39.setName("jLabel39"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 16;
		v_calcRunCountAssignmentsHolderPanel.add(jLabel39, gridBagConstraints);
		
		jLabel40.setText("calculations");
		jLabel40.setName("jLabel40"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 18;
		v_calcRunCountAssignmentsHolderPanel.add(jLabel40, gridBagConstraints);
		
		jLabel41.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel41.setText("NCM - Determines vulnerability of from-ter after move to check if AI should cancel move:");
		jLabel41.setName("jLabel41"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 18;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel41, gridBagConstraints);
		
		v_cancm_determinesSurvivalChanceOfFromTerAfterMoveToSeeIfToCancelMove.setModel(new javax.swing.SpinnerNumberModel(100, 1, 5000, 10));
		v_cancm_determinesSurvivalChanceOfFromTerAfterMoveToSeeIfToCancelMove.setName("v_cancm_determinesSurvivalChanceOfFromTerAfterMoveToSeeIfToCancelMove"); // NOI18N
		v_cancm_determinesSurvivalChanceOfFromTerAfterMoveToSeeIfToCancelMove.setPreferredSize(new java.awt.Dimension(70, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 18;
		v_calcRunCountAssignmentsHolderPanel.add(v_cancm_determinesSurvivalChanceOfFromTerAfterMoveToSeeIfToCancelMove, gridBagConstraints);
		
		jLabel42.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel42.setText("(Frequency: Average, Suggested Range: 25 - 1000)");
		jLabel42.setName("jLabel42"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 19;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 25, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel42, gridBagConstraints);
		
		jLabel43.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel43.setText("(Frequency: Low, Suggested Range: 1000 - 10000)");
		jLabel43.setName("jLabel43"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 21;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weighty = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 25, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel43, gridBagConstraints);
		
		v_caretreat_determinesIfAIShouldRetreat.setModel(new javax.swing.SpinnerNumberModel(2000, 1, 5000, 10));
		v_caretreat_determinesIfAIShouldRetreat.setName("v_caretreat_determinesIfAIShouldRetreat"); // NOI18N
		v_caretreat_determinesIfAIShouldRetreat.setPreferredSize(new java.awt.Dimension(70, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 20;
		v_calcRunCountAssignmentsHolderPanel.add(v_caretreat_determinesIfAIShouldRetreat, gridBagConstraints);
		
		jLabel44.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel44.setText("Retreat Query - Determines if AI should retreat:");
		jLabel44.setName("jLabel44"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 20;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel44, gridBagConstraints);
		
		jLabel45.setText("calculations");
		jLabel45.setName("jLabel45"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 20;
		v_calcRunCountAssignmentsHolderPanel.add(jLabel45, gridBagConstraints);
		
		jLabel63.setText("calculations");
		jLabel63.setName("jLabel63"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 8;
		v_calcRunCountAssignmentsHolderPanel.add(jLabel63, gridBagConstraints);
		
		jLabel64.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel64.setText("CM - Determines if the trade task's requirements are far enough met for unit recruiting to stop:");
		jLabel64.setName("jLabel64"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 8;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel64, gridBagConstraints);
		
		jLabel82.setFont(new java.awt.Font("Tahoma", 0, 10));
		jLabel82.setText("(Frequency: Average, Suggested Range: 500 - 2500)");
		jLabel82.setName("jLabel82"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 9;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 25, 5, 0);
		v_calcRunCountAssignmentsHolderPanel.add(jLabel82, gridBagConstraints);
		
		v_cacm_determinesIfTradeTasksRequirementsAreMetEnoughForRecruitingStop.setModel(new javax.swing.SpinnerNumberModel(1000, 1, 5000, 10));
		v_cacm_determinesIfTradeTasksRequirementsAreMetEnoughForRecruitingStop.setName("v_cacm_determinesIfTradeTasksRequirementsAreMetEnoughForRecruitingStop"); // NOI18N
		v_cacm_determinesIfTradeTasksRequirementsAreMetEnoughForRecruitingStop.setPreferredSize(new java.awt.Dimension(70, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 8;
		v_calcRunCountAssignmentsHolderPanel.add(v_cacm_determinesIfTradeTasksRequirementsAreMetEnoughForRecruitingStop, gridBagConstraints);
		
		v_calcRunCountAssignmentsScrollPane.setViewportView(v_calcRunCountAssignmentsHolderPanel);
		
		jPanel4.add(v_calcRunCountAssignmentsScrollPane);
		
		v_tabPaneMain.addTab("Calculations", jPanel4);
		
		jPanel15.setName("jPanel15"); // NOI18N
		jPanel15.setLayout(new java.awt.GridLayout(1, 0));
		
		v_aa_scrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
		v_aa_scrollPane1.setName("v_aa_scrollPane1"); // NOI18N
		
		jPanel19.setMinimumSize(new java.awt.Dimension(541, 828));
		jPanel19.setName("jPanel19"); // NOI18N
		jPanel19.setPreferredSize(new java.awt.Dimension(500, 900));
		jPanel19.setLayout(new java.awt.GridBagLayout());
		
		jLabel118.setText("        Enemy-Attack Trade Score Required For Survival-Chance Requirement Bypass:");
		jLabel118.setToolTipText("The min trade score(total PU swing, if we get attacked) we need to bypass the survival chance requirement. (Simplified Trade Score: Ter production - our TUV loss + enemy TUV loss)");
		jLabel118.setName("jLabel118"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 23;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel118, gridBagConstraints);
		
		v_tr_attackOffensive_Capitals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_attackOffensive_Capitals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setName("v_tr_attackOffensive_Capitals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement"); // NOI18N
		v_tr_attackOffensive_Capitals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 11;
		jPanel19.add(v_tr_attackOffensive_Capitals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement, gridBagConstraints);
		
		jLabel100.setText("%");
		jLabel100.setName("jLabel100"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 6;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		jPanel19.add(jLabel100, gridBagConstraints);
		
		v_tr_attackOffensive_counterAttackSurvivalChanceRequired.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_attackOffensive_counterAttackSurvivalChanceRequired.setName("v_tr_attackOffensive_counterAttackSurvivalChanceRequired"); // NOI18N
		v_tr_attackOffensive_counterAttackSurvivalChanceRequired.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 2;
		jPanel19.add(v_tr_attackOffensive_counterAttackSurvivalChanceRequired, gridBagConstraints);
		
		v_tr_attackLandGrab_onlyGrabLandIfWeCanBlitzIt.setName("v_tr_attackLandGrab_onlyGrabLandIfWeCanBlitzIt"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 20;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		jPanel19.add(v_tr_attackLandGrab_onlyGrabLandIfWeCanBlitzIt, gridBagConstraints);
		
		jLabel124.setText("        Certainty Of Reaching Desired Number Of Leftover Land Units Required:");
		jLabel124.setToolTipText("The percentage of times we end up with X land units(ai-determined) when we simulate the counter-attack battle with the battle calc'er must meet this percentage for the task to be performed.");
		jLabel124.setName("jLabel124"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 18;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel124, gridBagConstraints);
		
		jLabel119.setText("        Counter-Attack Trade Score Required For Survival-Chance Requirement Bypass:");
		jLabel119.setToolTipText("The min trade score(total PU swing, if we get attacked) we need to bypass the survival chance requirement. (Simplified Trade Score: Ter production - our TUV loss + enemy TUV loss)");
		jLabel119.setName("jLabel119"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 3;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel119, gridBagConstraints);
		
		jLabel103.setText("        Attack Takeover Chance Required:");
		jLabel103.setToolTipText("The percentage of times we win when we simulate the battle with the battle calc'er must meet this percentage for the task to be performed.");
		jLabel103.setName("jLabel103"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 9;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel103, gridBagConstraints);
		
		jLabel109.setText("%");
		jLabel109.setName("jLabel109"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 14;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		jPanel19.add(jLabel109, gridBagConstraints);
		
		v_tr_enableAttackStabalize.setSelected(true);
		v_tr_enableAttackStabalize.setText("Attack - Stabalize");
		v_tr_enableAttackStabalize.setToolTipText("Stabalization attacks on our capital(to retake it), and if the game's a FFA, the territories around our capital.");
		v_tr_enableAttackStabalize.setName("v_tr_enableAttackStabalize"); // NOI18N
		v_tr_enableAttackStabalize.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_tr_enableAttackStabalizev_tr_enableAttackStabalizeStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 12;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(v_tr_enableAttackStabalize, gridBagConstraints);
		
		v_tr_attackOffensive_Capitals_takeoverChanceRequired.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_attackOffensive_Capitals_takeoverChanceRequired.setName("v_tr_attackOffensive_Capitals_takeoverChanceRequired"); // NOI18N
		v_tr_attackOffensive_Capitals_takeoverChanceRequired.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 9;
		jPanel19.add(v_tr_attackOffensive_Capitals_takeoverChanceRequired, gridBagConstraints);
		
		jLabel66.setText("        Attack Takeover Chance Required:");
		jLabel66.setToolTipText("The percentage of times we win when we simulate the battle with the battle calc'er must meet this percentage for the task to be performed.");
		jLabel66.setName("jLabel66"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 5;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel66, gridBagConstraints);
		
		jLabel106.setText("%");
		jLabel106.setName("jLabel106"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 9;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		jPanel19.add(jLabel106, gridBagConstraints);
		
		jLabel102.setText("%");
		jLabel102.setName("jLabel102"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 5;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		jPanel19.add(jLabel102, gridBagConstraints);
		
		jLabel104.setText("        Counter-Attack Survival Chance Required:");
		jLabel104.setToolTipText("The percentage of times we survive when we simulate the counter-attack battle with the battle calc'er must meet this percentage for the task to be performed.");
		jLabel104.setName("jLabel104"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 10;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel104, gridBagConstraints);
		
		jLabel117.setText("        Total Trade Score Required: ");
		jLabel117.setToolTipText("The trade score(total PU swing) required to perform a trade attack. (Simplified Trade Score: Ter production - our TUV loss + enemy TUV loss)");
		jLabel117.setName("jLabel117"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 17;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel117, gridBagConstraints);
		
		v_tr_attackOffensive_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_attackOffensive_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setName("v_tr_attackOffensive_counterAttackTradeScoreRequiredToBypassSurvivalRequirement"); // NOI18N
		v_tr_attackOffensive_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 3;
		jPanel19.add(v_tr_attackOffensive_counterAttackTradeScoreRequiredToBypassSurvivalRequirement, gridBagConstraints);
		
		jLabel101.setText("        Attack Takeover Chance Required:");
		jLabel101.setToolTipText("The percentage of times we win when we simulate the battle with the battle calc'er must meet this percentage for the task to be performed.");
		jLabel101.setName("jLabel101"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel101, gridBagConstraints);
		
		jLabel96.setText("%");
		jLabel96.setName("jLabel96"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 1;
		jPanel19.add(jLabel96, gridBagConstraints);
		
		v_tr_attackOffensive_takeoverChanceRequired.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_attackOffensive_takeoverChanceRequired.setName("v_tr_attackOffensive_takeoverChanceRequired"); // NOI18N
		v_tr_attackOffensive_takeoverChanceRequired.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		jPanel19.add(v_tr_attackOffensive_takeoverChanceRequired, gridBagConstraints);
		
		jLabel98.setText("%");
		jLabel98.setName("jLabel98"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		jPanel19.add(jLabel98, gridBagConstraints);
		
		v_tr_reinforceFrontline_enemyAttackTradeScoreRequiredToBypassRequirements.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_reinforceFrontline_enemyAttackTradeScoreRequiredToBypassRequirements.setName("v_tr_reinforceFrontline_enemyAttackTradeScoreRequiredToBypassRequirements"); // NOI18N
		v_tr_reinforceFrontline_enemyAttackTradeScoreRequiredToBypassRequirements.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 23;
		jPanel19.add(v_tr_reinforceFrontline_enemyAttackTradeScoreRequiredToBypassRequirements, gridBagConstraints);
		
		v_tr_reinforceFrontLine_enemyAttackSurvivalChanceRequired.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_reinforceFrontLine_enemyAttackSurvivalChanceRequired.setName("v_tr_reinforceFrontLine_enemyAttackSurvivalChanceRequired"); // NOI18N
		v_tr_reinforceFrontLine_enemyAttackSurvivalChanceRequired.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 22;
		jPanel19.add(v_tr_reinforceFrontLine_enemyAttackSurvivalChanceRequired, gridBagConstraints);
		
		v_tr_attackOffensive_Neutrals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_attackOffensive_Neutrals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setName("v_tr_attackOffensive_Neutrals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement"); // NOI18N
		v_tr_attackOffensive_Neutrals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 7;
		jPanel19.add(v_tr_attackOffensive_Neutrals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement, gridBagConstraints);
		
		jLabel97.setText("        Counter-Attack Survival Chance Required:");
		jLabel97.setToolTipText("The percentage of times we survive when we simulate the counter-attack battle with the battle calc'er must meet this percentage for the task to be performed.");
		jLabel97.setName("jLabel97"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 6;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel97, gridBagConstraints);
		
		jLabel123.setText("%");
		jLabel123.setName("jLabel123"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 18;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		jPanel19.add(jLabel123, gridBagConstraints);
		
		v_tr_attackTrade_certaintyOfReachingDesiredNumberOfLeftoverLandUnitsRequired.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_attackTrade_certaintyOfReachingDesiredNumberOfLeftoverLandUnitsRequired.setName("v_tr_attackTrade_certaintyOfReachingDesiredNumberOfLeftoverLandUnitsRequired"); // NOI18N
		v_tr_attackTrade_certaintyOfReachingDesiredNumberOfLeftoverLandUnitsRequired.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 18;
		jPanel19.add(v_tr_attackTrade_certaintyOfReachingDesiredNumberOfLeftoverLandUnitsRequired, gridBagConstraints);
		
		jLabel107.setText("        Counter-Attack Survival Chance Required:");
		jLabel107.setToolTipText("The percentage of times we survive when we simulate the counter-attack battle with the battle calc'er must meet this percentage for the task to be performed.");
		jLabel107.setName("jLabel107"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 14;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel107, gridBagConstraints);
		
		v_tr_reinforceStabalize_enemyAttackSurvivalChanceRequired.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_reinforceStabalize_enemyAttackSurvivalChanceRequired.setName("v_tr_reinforceStabalize_enemyAttackSurvivalChanceRequired"); // NOI18N
		v_tr_reinforceStabalize_enemyAttackSurvivalChanceRequired.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 25;
		jPanel19.add(v_tr_reinforceStabalize_enemyAttackSurvivalChanceRequired, gridBagConstraints);
		
		v_tr_attackOffensive_Neutrals_counterAttackSurvivalChanceRequired.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_attackOffensive_Neutrals_counterAttackSurvivalChanceRequired.setName("v_tr_attackOffensive_Neutrals_counterAttackSurvivalChanceRequired"); // NOI18N
		v_tr_attackOffensive_Neutrals_counterAttackSurvivalChanceRequired.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 6;
		jPanel19.add(v_tr_attackOffensive_Neutrals_counterAttackSurvivalChanceRequired, gridBagConstraints);
		
		jLabel114.setText("%");
		jLabel114.setName("jLabel114"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 25;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		jPanel19.add(jLabel114, gridBagConstraints);
		
		v_tr_attackStabalize_takeoverChanceRequired.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_attackStabalize_takeoverChanceRequired.setName("v_tr_attackStabalize_takeoverChanceRequired"); // NOI18N
		v_tr_attackStabalize_takeoverChanceRequired.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 13;
		jPanel19.add(v_tr_attackStabalize_takeoverChanceRequired, gridBagConstraints);
		
		jLabel110.setText("        Attack Takeover Chance Required:");
		jLabel110.setToolTipText("The percentage of times we win when we simulate the battle with the battle calc'er must meet this percentage for the task to be performed.");
		jLabel110.setName("jLabel110"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 13;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel110, gridBagConstraints);
		
		jLabel115.setText("        Only Grab Land If We Can Blitz It:");
		jLabel115.setToolTipText("If checked, the AI will only grab empty territories if it can blitz back. In other words, if its checked, the AI will not perform 'walk-ins' on empty territories, only blitz.");
		jLabel115.setName("jLabel115"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 20;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel115, gridBagConstraints);
		
		jLabel99.setText("        Counter-Attack Survival Chance Required:");
		jLabel99.setToolTipText("The percentage of times we survive when we simulate the counter-attack(by enemies) battle with the battle calc'er must meet this percentage for the task to be performed.");
		jLabel99.setName("jLabel99"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel99, gridBagConstraints);
		
		jLabel105.setText("%");
		jLabel105.setName("jLabel105"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 10;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		jPanel19.add(jLabel105, gridBagConstraints);
		
		jLabel111.setText("        Enemy-Attack Survival Chance Required:");
		jLabel111.setToolTipText("The percentage of times we survive when we simulate the enemy-attack battle with the battle calc'er must meet this percentage for the task to be performed.");
		jLabel111.setName("jLabel111"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 22;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel111, gridBagConstraints);
		
		jLabel112.setText("%");
		jLabel112.setName("jLabel112"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 22;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		jPanel19.add(jLabel112, gridBagConstraints);
		
		v_tr_enableAttackOffensive.setSelected(true);
		v_tr_enableAttackOffensive.setText("Attack - Offensive");
		v_tr_enableAttackOffensive.setToolTipText("Regular attacks on enemy territories.");
		v_tr_enableAttackOffensive.setName("v_tr_enableAttackOffensive"); // NOI18N
		v_tr_enableAttackOffensive.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_tr_enableAttackOffensivev_tr_enableAttackOffensiveStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(12, 10, 7, 0);
		jPanel19.add(v_tr_enableAttackOffensive, gridBagConstraints);
		
		jLabel122.setText("        Counter-Attack Trade Score Required For Survival-Chance Requirement Bypass:");
		jLabel122.setToolTipText("The min trade score(total PU swing, if we get attacked) we need to bypass the survival chance requirement. (Simplified Trade Score: Ter production - our TUV loss + enemy TUV loss)");
		jLabel122.setName("jLabel122"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 15;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel122, gridBagConstraints);
		
		v_tr_attackOffensive_Capitals_counterAttackSurvivalChanceRequired.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_attackOffensive_Capitals_counterAttackSurvivalChanceRequired.setName("v_tr_attackOffensive_Capitals_counterAttackSurvivalChanceRequired"); // NOI18N
		v_tr_attackOffensive_Capitals_counterAttackSurvivalChanceRequired.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 10;
		jPanel19.add(v_tr_attackOffensive_Capitals_counterAttackSurvivalChanceRequired, gridBagConstraints);
		
		jLabel116.setText("   Attack - Offensive (Capitals)");
		jLabel116.setToolTipText("Regular attacks on enemy capitals.");
		jLabel116.setName("jLabel116"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 8;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel116, gridBagConstraints);
		
		v_tr_attackTrade_totalTradeScore.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_attackTrade_totalTradeScore.setName("v_tr_attackTrade_totalTradeScore"); // NOI18N
		v_tr_attackTrade_totalTradeScore.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 17;
		jPanel19.add(v_tr_attackTrade_totalTradeScore, gridBagConstraints);
		
		v_tr_enableReinforceStabalize.setSelected(true);
		v_tr_enableReinforceStabalize.setText("Reinforce - Stabalize");
		v_tr_enableReinforceStabalize.setToolTipText("Stabalization reinforcements on our capital, and sometimes the territories around our capital.");
		v_tr_enableReinforceStabalize.setName("v_tr_enableReinforceStabalize"); // NOI18N
		v_tr_enableReinforceStabalize.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_tr_enableReinforceStabalizev_tr_enableReinforceStabalizeStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 24;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(v_tr_enableReinforceStabalize, gridBagConstraints);
		
		v_tr_enableAttackTrade.setSelected(true);
		v_tr_enableAttackTrade.setText("Attack - Trade");
		v_tr_enableAttackTrade.setToolTipText("Special attacks on territories, for TUV swing against non-neutral enemy, PU gain, or the pushing back or stalling of enemy forces.");
		v_tr_enableAttackTrade.setName("v_tr_enableAttackTrade"); // NOI18N
		v_tr_enableAttackTrade.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_tr_enableAttackTradev_tr_enableAttackTradeStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 16;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(v_tr_enableAttackTrade, gridBagConstraints);
		
		jLabel113.setText("        Enemy-Attack Survival Chance Required:");
		jLabel113.setToolTipText("The percentage of times we survive when we simulate the enemy-attack battle with the battle calc'er must meet this percentage for the task to be performed.");
		jLabel113.setName("jLabel113"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 25;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel113, gridBagConstraints);
		
		jLabel50.setText("   Attack - Offensive (Neutrals)");
		jLabel50.setToolTipText("Regular attacks on neutral territories.");
		jLabel50.setName("jLabel50"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 4;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel50, gridBagConstraints);
		
		v_tr_enableReinforceBlock.setSelected(true);
		v_tr_enableReinforceBlock.setText("Reinforce - Block");
		v_tr_enableReinforceBlock.setToolTipText("Reinforcements on empty ters to block the enemy from blitzing our territory, and gaining PUs. Only one unit is used for this block.");
		v_tr_enableReinforceBlock.setName("v_tr_enableReinforceBlock"); // NOI18N
		v_tr_enableReinforceBlock.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_tr_enableReinforceBlockv_tr_enableReinforceBlockStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 26;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.weighty = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(v_tr_enableReinforceBlock, gridBagConstraints);
		
		v_tr_attackOffensive_Neutrals_takeoverChanceRequired.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_attackOffensive_Neutrals_takeoverChanceRequired.setName("v_tr_attackOffensive_Neutrals_takeoverChanceRequired"); // NOI18N
		v_tr_attackOffensive_Neutrals_takeoverChanceRequired.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 5;
		jPanel19.add(v_tr_attackOffensive_Neutrals_takeoverChanceRequired, gridBagConstraints);
		
		jLabel121.setText("        Counter-Attack Trade Score Required For Survival-Chance Requirement Bypass:");
		jLabel121.setToolTipText("The min trade score(total PU swing, if we get attacked) we need to bypass the survival chance requirement. (Simplified Trade Score: Ter production - our TUV loss + enemy TUV loss)");
		jLabel121.setName("jLabel121"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 11;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel121, gridBagConstraints);
		
		v_tr_enableAttackLandGrab.setSelected(true);
		v_tr_enableAttackLandGrab.setText("Attack - Land Grab");
		v_tr_enableAttackLandGrab.setToolTipText("Blitz or walk-in attacks on empty territories owned by enemies.");
		v_tr_enableAttackLandGrab.setName("v_tr_enableAttackLandGrab"); // NOI18N
		v_tr_enableAttackLandGrab.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_tr_enableAttackLandGrabv_tr_enableAttackLandGrabStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 19;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(v_tr_enableAttackLandGrab, gridBagConstraints);
		
		v_tr_enableReinforceFrontline.setSelected(true);
		v_tr_enableReinforceFrontline.setText("Reinforce - Front Line");
		v_tr_enableReinforceFrontline.setToolTipText("Regular reinforcements on the front line.");
		v_tr_enableReinforceFrontline.setName("v_tr_enableReinforceFrontline"); // NOI18N
		v_tr_enableReinforceFrontline.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_tr_enableReinforceFrontlinev_tr_enableReinforceFrontlineStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 21;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(v_tr_enableReinforceFrontline, gridBagConstraints);
		
		v_tr_attackStabalize_counterAttackSurvivalChanceRequired.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_attackStabalize_counterAttackSurvivalChanceRequired.setName("v_tr_attackStabalize_counterAttackSurvivalChanceRequired"); // NOI18N
		v_tr_attackStabalize_counterAttackSurvivalChanceRequired.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 14;
		jPanel19.add(v_tr_attackStabalize_counterAttackSurvivalChanceRequired, gridBagConstraints);
		
		jLabel108.setText("%");
		jLabel108.setName("jLabel108"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 13;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		jPanel19.add(jLabel108, gridBagConstraints);
		
		v_tr_attackStabalize_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setMinimumSize(new java.awt.Dimension(60, 20));
		v_tr_attackStabalize_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setName("v_tr_attackStabalize_counterAttackTradeScoreRequiredToBypassSurvivalRequirement"); // NOI18N
		v_tr_attackStabalize_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 15;
		jPanel19.add(v_tr_attackStabalize_counterAttackTradeScoreRequiredToBypassSurvivalRequirement, gridBagConstraints);
		
		jLabel120.setText("        Counter-Attack Trade Score Required For Survival-Chance Requirement Bypass:");
		jLabel120.setToolTipText("The min trade score(total PU swing, if we get attacked) we need to bypass the survival chance requirement. (Simplified Trade Score: Ter production - our TUV loss + enemy TUV loss)");
		jLabel120.setName("jLabel120"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 7;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 10, 7, 0);
		jPanel19.add(jLabel120, gridBagConstraints);
		
		v_aa_scrollPane1.setViewportView(jPanel19);
		
		jPanel15.add(v_aa_scrollPane1);
		
		v_tabPaneMain.addTab("Tasks", jPanel15);
		
		jPanel17.setName("jPanel17"); // NOI18N
		jPanel17.setPreferredSize(new java.awt.Dimension(500, 206));
		jPanel17.setLayout(new java.awt.GridBagLayout());
		
		v_cr_enableCallForLandGrab.setSelected(true);
		v_cr_enableCallForLandGrab.setText("Call - For Land Grab");
		v_cr_enableCallForLandGrab.setToolTipText("Calls for a unit to come grab a territory for production gain.");
		v_cr_enableCallForLandGrab.setName("v_cr_enableCallForLandGrab"); // NOI18N
		v_cr_enableCallForLandGrab.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_cr_enableCallForLandGrabStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.ipadx = 329;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(12, 10, 5, 0);
		jPanel17.add(v_cr_enableCallForLandGrab, gridBagConstraints);
		
		v_cr_enableCallForDefensiveFront.setSelected(true);
		v_cr_enableCallForDefensiveFront.setText("Call - For Defensive Front");
		v_cr_enableCallForDefensiveFront.setToolTipText("Calls for units to come to a defensive front, usually just to hold the enemy at bay.");
		v_cr_enableCallForDefensiveFront.setName("v_cr_enableCallForDefensiveFront"); // NOI18N
		v_cr_enableCallForDefensiveFront.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_cr_enableCallForDefensiveFrontStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.ipadx = 301;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		jPanel17.add(v_cr_enableCallForDefensiveFront, gridBagConstraints);
		
		v_cr_enableCallForCapitalDefense.setSelected(true);
		v_cr_enableCallForCapitalDefense.setText("Call - For Capital Defense");
		v_cr_enableCallForCapitalDefense.setToolTipText("Calls for units to come to the capital, or at least nearby, to ensure it's protection.");
		v_cr_enableCallForCapitalDefense.setName("v_cr_enableCallForCapitalDefense"); // NOI18N
		v_cr_enableCallForCapitalDefense.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_cr_enableCallForCapitalDefenseStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.ipadx = 303;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		jPanel17.add(v_cr_enableCallForCapitalDefense, gridBagConstraints);
		
		jPanel27.setName("jPanel27"); // NOI18N
		jPanel27.setLayout(null);
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 3;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.weighty = 99.0;
		jPanel17.add(jPanel27, gridBagConstraints);
		
		v_tabPaneMain.addTab("Calls", jPanel17);
		
		jPanel8.setName("jPanel8"); // NOI18N
		jPanel8.setPreferredSize(new java.awt.Dimension(500, 314));
		jPanel8.setLayout(new java.awt.GridBagLayout());
		
		v_logHolderTabbedPane.setTabLayoutPolicy(javax.swing.JTabbedPane.SCROLL_TAB_LAYOUT);
		v_logHolderTabbedPane.setFont(new java.awt.Font("Segoe UI", 0, 10));
		v_logHolderTabbedPane.setName("v_logHolderTabbedPane"); // NOI18N
		
		jPanel9.setName("jPanel9"); // NOI18N
		jPanel9.setLayout(new java.awt.GridLayout(1, 0));
		
		v_aiOutputLogAreaScrollPane.setName("v_aiOutputLogAreaScrollPane"); // NOI18N
		
		v_aiOutputLogArea.setColumns(20);
		v_aiOutputLogArea.setEditable(false);
		v_aiOutputLogArea.setFont(new java.awt.Font("Segoe UI", 0, 10));
		v_aiOutputLogArea.setRows(5);
		v_aiOutputLogArea.setName("v_aiOutputLogArea"); // NOI18N
		v_aiOutputLogAreaScrollPane.setViewportView(v_aiOutputLogArea);
		
		jPanel9.add(v_aiOutputLogAreaScrollPane);
		
		v_logHolderTabbedPane.addTab("Pre-Game", jPanel9);
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.gridwidth = 7;
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.weighty = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 7, 7, 7);
		jPanel8.add(v_logHolderTabbedPane, gridBagConstraints);
		
		v_enableAILogging.setSelected(true);
		v_enableAILogging.setText("Enable AI Logging");
		v_enableAILogging.setName("v_enableAILogging"); // NOI18N
		v_enableAILogging.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_enableAILoggingStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(7, 7, 0, 0);
		jPanel8.add(v_enableAILogging, gridBagConstraints);
		
		jLabel15.setText("Log Depth:");
		jLabel15.setName("jLabel15"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(7, 12, 0, 0);
		jPanel8.add(jLabel15, gridBagConstraints);
		
		v_logDepth.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Fine", "Finer", "Finest" }));
		v_logDepth.setSelectedItem(v_logDepth.getItemAt(2));
		v_logDepth.setName("v_logDepth"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(7, 5, 0, 0);
		jPanel8.add(v_logDepth, gridBagConstraints);
		
		v_limitLogHistoryToSpinner.setModel(new javax.swing.SpinnerNumberModel(5, 1, 100, 1));
		v_limitLogHistoryToSpinner.setMinimumSize(new java.awt.Dimension(60, 20));
		v_limitLogHistoryToSpinner.setName("v_limitLogHistoryToSpinner"); // NOI18N
		v_limitLogHistoryToSpinner.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 5;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.ipadx = 10;
		gridBagConstraints.insets = new java.awt.Insets(7, 0, 0, 0);
		jPanel8.add(v_limitLogHistoryToSpinner, gridBagConstraints);
		
		v_limitLogHistoryCB.setSelected(true);
		v_limitLogHistoryCB.setText("Limit Log History To:");
		v_limitLogHistoryCB.setName("v_limitLogHistoryCB"); // NOI18N
		v_limitLogHistoryCB.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_limitLogHistoryCBStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 4;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(7, 0, 0, 12);
		jPanel8.add(v_limitLogHistoryCB, gridBagConstraints);
		
		jLabel46.setText("rounds");
		jLabel46.setName("jLabel46"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 6;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(7, 5, 0, 7);
		jPanel8.add(jLabel46, gridBagConstraints);
		
		v_pauseAIs.setText("Pause AI's");
		v_pauseAIs.setToolTipText("Can be used if you want to examine the logs without the AIs running. (Only affects Dynamix AI's)");
		v_pauseAIs.setName("v_pauseAIs"); // NOI18N
		v_pauseAIs.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_pauseAIsStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 3;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 0, 0, 0);
		jPanel8.add(v_pauseAIs, gridBagConstraints);
		
		v_tabPaneMain.addTab("Debugging", jPanel8);
		
		jPanel2.setName("jPanel2"); // NOI18N
		jPanel2.setLayout(new java.awt.GridLayout(1, 0));
		
		v_aa_scrollPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
		v_aa_scrollPane.setName("v_aa_scrollPane"); // NOI18N
		v_aa_scrollPane.setPreferredSize(new java.awt.Dimension(999, 555));
		
		jPanel12.setMaximumSize(new java.awt.Dimension(2000, 1000));
		jPanel12.setMinimumSize(new java.awt.Dimension(750, 315));
		jPanel12.setName("jPanel12"); // NOI18N
		jPanel12.setPreferredSize(new java.awt.Dimension(500, 315));
		jPanel12.setLayout(new java.awt.GridBagLayout());
		
		jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("CM & NCM Task Settings (Tasks are the main components of the combat and non combat move phases)"));
		jPanel3.setMaximumSize(new java.awt.Dimension(1000, 750));
		jPanel3.setMinimumSize(new java.awt.Dimension(608, 93));
		jPanel3.setName("jPanel3"); // NOI18N
		jPanel3.setPreferredSize(new java.awt.Dimension(625, 93));
		jPanel3.setLayout(new java.awt.GridBagLayout());
		
		jLabel58.setText("Threat Invalidation Type:");
		jLabel58.setName("jLabel58"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 0);
		jPanel3.add(jLabel58, gridBagConstraints);
		
		v_invalidationTypeButtonGroup.add(v_aa_globalThreatInvalidation);
		v_aa_globalThreatInvalidation.setText("Global Invalidation");
		v_aa_globalThreatInvalidation
					.setToolTipText("When a task is successful and strongly held, X% of it's threats(user-set, below) become invalidated globally, for the rest of the phase. (So if one ter resists a stack of air, X% of that air stack will be ignored by all other tasks)");
		v_aa_globalThreatInvalidation.setName("v_aa_globalThreatInvalidation"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 18, 0, 0);
		jPanel3.add(v_aa_globalThreatInvalidation, gridBagConstraints);
		
		jLabel55.setText("Percentage of threats that become invalidated when a task is resistant to them:");
		jLabel55.setToolTipText("If a task is successful and strongly held, the AI will 'invalidate' X percent of the threats to the task. Note that an excessively high invalidation rate may cause the AI to leave units in vulnerable positions.");
		jLabel55.setName("jLabel55"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.gridwidth = 4;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 0);
		jPanel3.add(jLabel55, gridBagConstraints);
		
		v_invalidationTypeButtonGroup.add(v_aa_hotspotInvalidation);
		v_aa_hotspotInvalidation.setText("Hotspot Invalidation, Radius:");
		v_aa_hotspotInvalidation
					.setToolTipText("When a task is successful and strongly held, X% of it's threats(user-set, below) become invalidated for all ters within the radius specified, for the rest of the phase. (So if one ter resists a stack of air, X% of that air stack will be ignored by all ters within the user-set radius)");
		v_aa_hotspotInvalidation.setName("v_aa_hotspotInvalidation"); // NOI18N
		v_aa_hotspotInvalidation.addChangeListener(new javax.swing.event.ChangeListener()
		{
			public void stateChanged(final javax.swing.event.ChangeEvent evt)
			{
				v_aa_hotspotInvalidationStateChanged(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 3;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 18, 0, 0);
		jPanel3.add(v_aa_hotspotInvalidation, gridBagConstraints);
		
		v_aa_radiusOfHotspotThreatInvalidation.setModel(new javax.swing.SpinnerNumberModel(1, 1, 10, 1));
		v_aa_radiusOfHotspotThreatInvalidation.setMinimumSize(new java.awt.Dimension(60, 20));
		v_aa_radiusOfHotspotThreatInvalidation.setName("v_aa_radiusOfHotspotThreatInvalidation"); // NOI18N
		v_aa_radiusOfHotspotThreatInvalidation.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 4;
		gridBagConstraints.gridy = 0;
		jPanel3.add(v_aa_radiusOfHotspotThreatInvalidation, gridBagConstraints);
		
		v_aa_percentageOfResistedThreatsThatTasksInvalidate.setModel(new javax.swing.SpinnerNumberModel(50, 0, 100, 1));
		v_aa_percentageOfResistedThreatsThatTasksInvalidate.setMinimumSize(new java.awt.Dimension(60, 20));
		v_aa_percentageOfResistedThreatsThatTasksInvalidate.setName("v_aa_percentageOfResistedThreatsThatTasksInvalidate"); // NOI18N
		v_aa_percentageOfResistedThreatsThatTasksInvalidate.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 4;
		gridBagConstraints.gridy = 1;
		jPanel3.add(v_aa_percentageOfResistedThreatsThatTasksInvalidate, gridBagConstraints);
		
		v_invalidationTypeButtonGroup.add(v_aa_noThreatInvalidation);
		v_aa_noThreatInvalidation.setText("None");
		v_aa_noThreatInvalidation.setToolTipText("The AI will not invalidate any threats, meaning the AI will attempt to, for example, defend every territory on a front.");
		v_aa_noThreatInvalidation.setName("v_aa_noThreatInvalidation"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 18, 0, 0);
		jPanel3.add(v_aa_noThreatInvalidation, gridBagConstraints);
		
		jLabel65.setText("%");
		jLabel65.setName("jLabel65"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 5;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		jPanel3.add(jLabel65, gridBagConstraints);
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.gridwidth = 5;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
		jPanel12.add(jPanel3, gridBagConstraints);
		
		jPanel10.setBorder(javax.swing.BorderFactory.createTitledBorder("Purchase Phase Settings"));
		jPanel10.setMaximumSize(new java.awt.Dimension(1000, 250));
		jPanel10.setMinimumSize(new java.awt.Dimension(730, 90));
		jPanel10.setName("jPanel10"); // NOI18N
		jPanel10.setPreferredSize(new java.awt.Dimension(625, 90));
		jPanel10.setLayout(new java.awt.GridBagLayout());
		
		v_aa_resourcePercentageThatMustExistForFactoryBuy.setModel(new javax.swing.SpinnerNumberModel(50, 25, 75, 1));
		v_aa_resourcePercentageThatMustExistForFactoryBuy.setMinimumSize(new java.awt.Dimension(60, 20));
		v_aa_resourcePercentageThatMustExistForFactoryBuy.setName("v_aa_resourcePercentageThatMustExistForFactoryBuy"); // NOI18N
		v_aa_resourcePercentageThatMustExistForFactoryBuy.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		jPanel10.add(v_aa_resourcePercentageThatMustExistForFactoryBuy, gridBagConstraints);
		
		jLabel57.setText("Max unit types to calculate for factory purchase mix:");
		jLabel57.setToolTipText("If you lower this, the AI will purchase faster, but there will also be less of a variety of units in each purchase mix.");
		jLabel57.setName("jLabel57"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
		jPanel10.add(jLabel57, gridBagConstraints);
		
		jLabel53.setText("Percentage of resources that must exist afterpurchases for AI to buy factory:");
		jLabel53.setToolTipText("The percentage of the resources(PUs) that the AI had at the beginning of the purchase phase that must exist after all purchases for the AI to buy a factory.");
		jLabel53.setName("jLabel53"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(10, 10, 5, 0);
		jPanel10.add(jLabel53, gridBagConstraints);
		
		jLabel54.setText("%");
		jLabel54.setName("jLabel54"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		jPanel10.add(jLabel54, gridBagConstraints);
		
		v_aa_maxUnitTypesForPurchaseMix.setModel(new javax.swing.SpinnerNumberModel(5, 1, 25, 1));
		v_aa_maxUnitTypesForPurchaseMix.setMinimumSize(new java.awt.Dimension(60, 20));
		v_aa_maxUnitTypesForPurchaseMix.setName("v_aa_maxUnitTypesForPurchaseMix"); // NOI18N
		v_aa_maxUnitTypesForPurchaseMix.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		jPanel10.add(v_aa_maxUnitTypesForPurchaseMix, gridBagConstraints);
		
		jPanel28.setName("jPanel28"); // NOI18N
		jPanel28.setLayout(null);
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 3;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.weighty = 99.0;
		jPanel10.add(jPanel28, gridBagConstraints);
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.gridwidth = 5;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
		jPanel12.add(jPanel10, gridBagConstraints);
		
		jPanel5.setBorder(javax.swing.BorderFactory.createTitledBorder("Others"));
		jPanel5.setMaximumSize(new java.awt.Dimension(1000, 750));
		jPanel5.setMinimumSize(new java.awt.Dimension(534, 93));
		jPanel5.setName("jPanel5"); // NOI18N
		jPanel5.setPreferredSize(new java.awt.Dimension(625, 93));
		jPanel5.setLayout(new java.awt.GridBagLayout());
		
		jLabel67.setText("Survival chance that one of the landing ters must match for air unit to be recruitable:");
		jLabel67.setToolTipText("For an air unit to be considered 'recruitable', it must be able to reach a landing territory that has at least an X percent chance of survival.");
		jLabel67.setName("jLabel67"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 0);
		jPanel5.add(jLabel67, gridBagConstraints);
		
		v_aa_survivalChanceOfLandingTerRequiredForPlaneRecruit.setModel(new javax.swing.SpinnerNumberModel(75, 0, 100, 1));
		v_aa_survivalChanceOfLandingTerRequiredForPlaneRecruit.setMinimumSize(new java.awt.Dimension(60, 20));
		v_aa_survivalChanceOfLandingTerRequiredForPlaneRecruit.setName("v_aa_survivalChanceOfLandingTerRequiredForPlaneRecruit"); // NOI18N
		v_aa_survivalChanceOfLandingTerRequiredForPlaneRecruit.setPreferredSize(new java.awt.Dimension(60, 20));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		jPanel5.add(v_aa_survivalChanceOfLandingTerRequiredForPlaneRecruit, gridBagConstraints);
		
		jLabel68.setText("%");
		jLabel68.setName("jLabel68"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		jPanel5.add(jLabel68, gridBagConstraints);
		
		jLabel69.setText("Ignore allied units when trying to reinforce territories:");
		jLabel69.setToolTipText("If this is enabled, the AI will completely ignore any allied units when checking for territory defenses.");
		jLabel69.setName("jLabel69"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 0);
		jPanel5.add(jLabel69, gridBagConstraints);
		
		v_aa_ignoreAlliedUnitsAsDefenses.setName("v_aa_ignoreAlliedUnitsAsDefenses"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		jPanel5.add(v_aa_ignoreAlliedUnitsAsDefenses, gridBagConstraints);
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.gridwidth = 5;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
		gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
		jPanel12.add(jPanel5, gridBagConstraints);
		
		jPanel22.setName("jPanel22"); // NOI18N
		jPanel22.setLayout(null);
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 3;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.weighty = 99.0;
		jPanel12.add(jPanel22, gridBagConstraints);
		
		v_aa_scrollPane.setViewportView(jPanel12);
		
		jPanel2.add(v_aa_scrollPane);
		
		v_tabPaneMain.addTab("Advanced", jPanel2);
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.weightx = 99.0;
		gridBagConstraints.weighty = 99.0;
		gridBagConstraints.insets = new java.awt.Insets(7, 7, 0, 7);
		getContentPane().add(v_tabPaneMain, gridBagConstraints);
		
		final java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
		setBounds((screenSize.width - 775) / 2, (screenSize.height - 401) / 2, 775, 401);
	}// </editor-fold>//GEN-END:initComponents
	
	private void formWindowOpened(final java.awt.event.WindowEvent evt)// GEN-FIRST:event_formWindowOpened
	{// GEN-HEADEREND:event_formWindowOpened
		LoadSettings(DSettings.LoadSettings());
		this.pack();
	}// GEN-LAST:event_formWindowOpened
	
	/**
	 * Loads the settings provided and displays it in this settings window.
	 * 
	 * @param settings
	 */
	private void LoadSettings(final DSettings settings)
	{
		v_purchaseWait_AL.setValue(settings.PurchaseWait_AL);
		v_combatMoveWait_AL.setValue(settings.CombatMoveWait_AL);
		v_nonCombatMoveWait_AL.setValue(settings.NonCombatMoveWait_AL);
		v_placementWait_AL.setValue(settings.PlacementWait_AL);
		v_allowCalcingDecrease.setSelected(settings.AllowCalcingDecrease);
		v_calcDecreaseToPercentage.setValue(settings.CalcingDecreaseToPercentage);
		v_aic_disableAllUnitPurchasesAndPlacements.setSelected(settings.AIC_disableAllUnitPurchasesAndPlacements);
		v_aic_disableAllUnitMovement.setSelected(settings.AIC_disableAllUnitMovements);
		v_capurchase_determinesUnitThatWouldHelpTargetInvasionMost.setValue(settings.CA_Purchase_determinesUnitThatWouldHelpTargetInvasionMost);
		v_cacm_determinesIfTaskCreationsWorthwhileBasedOnTakeoverChance.setValue(settings.CA_CM_determinesIfTaskCreationsWorthwhileBasedOnTakeoverChance);
		v_cacmncm_sortsPossibleTaskRecruitsForOptimalAttackDefense.setValue(settings.CA_CMNCM_sortsPossibleTaskRecruitsForOptimalAttackDefense);
		v_cacmncm_determinesIfTasksRequirementsAreMetEnoughForRecruitingStop.setValue(settings.CA_CMNCM_determinesIfTasksRequirementsAreMetEnoughForRecruitingStop);
		v_cacm_determinesIfTradeTasksRequirementsAreMetEnoughForRecruitingStop.setValue(settings.CA_CM_determinesIfTradeTasksRequirementsAreMetEnoughForRecruitingStop);
		v_cacm_determinesAttackResultsToSeeIfTaskWorthwhile.setValue(settings.CA_CM_determinesAttackResultsToSeeIfTaskWorthwhile);
		v_cacmncm_determinesResponseResultsToSeeIfTaskWorthwhile.setValue(settings.CA_CMNCM_determinesResponseResultsToSeeIfTaskWorthwhile);
		v_cacmncm_determinesIfTaskEndangersCap.setValue(settings.CA_CMNCM_determinesIfTaskEndangersCap);
		v_cacmncm_determinesSurvivalChanceAfterTaskToSeeIfToInvalidateAttackers.setValue(settings.CA_CMNCM_determinesSurvivalChanceAfterTaskToSeeIfToInvalidateAttackers);
		v_cancm_determinesSurvivalChanceOfFromTerAfterMoveToSeeIfToCancelMove.setValue(settings.CA_NCM_determinesSurvivalChanceOfFromTerAfterMoveToSeeIfToCancelMove);
		v_caretreat_determinesIfAIShouldRetreat.setValue(settings.CA_Retreat_determinesIfAIShouldRetreat);
		if (settings.BattleCalculationMethod.equals(BattleCalculationType.BasicStrengthEval))
			v_basicStrengthEval.setSelected(true);
		else if (settings.BattleCalculationMethod.equals(BattleCalculationType.BasicScoreEval))
			v_basicScoreEval.setSelected(true);
		else if (settings.BattleCalculationMethod.equals(BattleCalculationType.QuickBattleCalculator))
			v_quickBattleCalculator.setSelected(true);
		else if (settings.BattleCalculationMethod.equals(BattleCalculationType.BattleCalculator))
			v_battleCalculator.setSelected(true);
		v_resourceCollectionMultiplier.setSelected(settings.EnableResourceCollectionMultiplier);
		v_resourceCollectionMultiplyPercent.setValue(settings.ResourceCollectionMultiplyPercent);
		v_resourceCollectionIncreaser.setSelected(settings.EnableResourceCollectionIncreaser);
		v_resourceCollectionIncreaseAmount.setValue(settings.ResourceCollectionIncreaseAmount);
		v_unitPlacementMultiplier.setSelected(settings.EnableUnitPlacementMultiplier);
		v_unitPlacementMultiplyAmount.setValue(settings.UnitPlacementMultiplyPercent);
		v_tr_enableAttackOffensive.setSelected(settings.TR_enableAttackOffensive);
		v_tr_attackOffensive_takeoverChanceRequired.setValue(settings.TR_attackOffensive_takeoverChanceRequired);
		v_tr_attackOffensive_counterAttackSurvivalChanceRequired.setValue(settings.TR_attackOffensive_counterAttackSurvivalChanceRequired);
		v_tr_attackOffensive_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setValue(settings.TR_attackOffensive_counterAttackTradeScoreRequiredToBypassSurvivalRequirement);
		v_tr_attackOffensive_Neutrals_takeoverChanceRequired.setValue(settings.TR_attackOffensive_Neutrals_takeoverChanceRequired);
		v_tr_attackOffensive_Neutrals_counterAttackSurvivalChanceRequired.setValue(settings.TR_attackOffensive_Neutrals_counterAttackSurvivalChanceRequired);
		v_tr_attackOffensive_Neutrals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement
					.setValue(settings.TR_attackOffensive_Neutrals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement);
		v_tr_attackOffensive_Capitals_takeoverChanceRequired.setValue(settings.TR_attackOffensive_Capitals_takeoverChanceRequired);
		v_tr_attackOffensive_Capitals_counterAttackSurvivalChanceRequired.setValue(settings.TR_attackOffensive_Capitals_counterAttackSurvivalChanceRequired);
		v_tr_attackOffensive_Capitals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement
					.setValue(settings.TR_attackOffensive_Capitals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement);
		v_tr_enableAttackStabalize.setSelected(settings.TR_enableAttackStabalize);
		v_tr_attackStabalize_takeoverChanceRequired.setValue(settings.TR_attackStabalize_takeoverChanceRequired);
		v_tr_attackStabalize_counterAttackSurvivalChanceRequired.setValue(settings.TR_attackStabalize_counterAttackSurvivalChanceRequired);
		v_tr_attackStabalize_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setValue(settings.TR_attackStabalize_counterAttackTradeScoreRequiredToBypassSurvivalRequirement);
		v_tr_enableAttackTrade.setSelected(settings.TR_enableAttackTrade);
		v_tr_attackTrade_totalTradeScore.setValue(settings.TR_attackTrade_totalTradeScoreRequired);
		v_tr_attackTrade_certaintyOfReachingDesiredNumberOfLeftoverLandUnitsRequired.setValue(settings.TR_attackTrade_certaintyOfReachingDesiredNumberOfLeftoverLandUnitsRequired);
		v_tr_enableAttackLandGrab.setSelected(settings.TR_enableAttackLandGrab);
		v_tr_attackLandGrab_onlyGrabLandIfWeCanBlitzIt.setSelected(settings.TR_attackLandGrab_onlyGrabLandIfWeCanBlitzIt);
		v_tr_enableReinforceFrontline.setSelected(settings.TR_enableReinforceFrontLine);
		v_tr_reinforceFrontLine_enemyAttackSurvivalChanceRequired.setValue(settings.TR_reinforceFrontLine_enemyAttackSurvivalChanceRequired);
		v_tr_reinforceFrontline_enemyAttackTradeScoreRequiredToBypassRequirements.setValue(settings.TR_reinforceFrontline_enemyAttackTradeScoreRequiredToBypassRequirements);
		v_tr_enableReinforceStabalize.setSelected(settings.TR_enableReinforceStabalize);
		v_tr_reinforceStabalize_enemyAttackSurvivalChanceRequired.setValue(settings.TR_reinforceStabalize_enemyAttackSurvivalChanceRequired);
		v_tr_enableReinforceBlock.setSelected(settings.TR_enableReinforceBlock);
		v_cr_enableCallForLandGrab.setSelected(settings.CR_enableCallForLandGrab);
		v_cr_enableCallForDefensiveFront.setSelected(settings.CR_enableCallForDefensiveFront);
		v_cr_enableCallForCapitalDefense.setSelected(settings.CR_enableCallForCapitalDefense);
		v_enableAILogging.setSelected(settings.EnableAILogging);
		if (settings.AILoggingDepth.equals(Level.FINE))
			v_logDepth.setSelectedIndex(0);
		else if (settings.AILoggingDepth.equals(Level.FINER))
			v_logDepth.setSelectedIndex(1);
		else if (settings.AILoggingDepth.equals(Level.FINEST))
			v_logDepth.setSelectedIndex(2);
		v_limitLogHistoryCB.setSelected(settings.LimitLogHistory);
		v_limitLogHistoryToSpinner.setValue(settings.LimitLogHistoryTo);
		v_aa_resourcePercentageThatMustExistForFactoryBuy.setValue(settings.AA_resourcePercentageThatMustExistForFactoryBuy);
		v_aa_maxUnitTypesForPurchaseMix.setValue(settings.AA_maxUnitTypesForPurchaseMix);
		if (settings.AA_threatInvalidationType.equals(ThreatInvalidationType.None))
			v_aa_noThreatInvalidation.setSelected(true);
		else if (settings.AA_threatInvalidationType.equals(ThreatInvalidationType.Global))
			v_aa_globalThreatInvalidation.setSelected(true);
		else if (settings.AA_threatInvalidationType.equals(ThreatInvalidationType.AroundHotspot))
			v_aa_hotspotInvalidation.setSelected(true);
		v_aa_radiusOfHotspotThreatInvalidation.setValue(settings.AA_threatInvalidationAroundHotspotRadius);
		v_aa_percentageOfResistedThreatsThatTasksInvalidate.setValue(settings.AA_percentageOfResistedThreatThatTasksInvalidate);
		v_aa_survivalChanceOfLandingTerRequiredForPlaneRecruit.setValue(settings.AA_survivalChanceOfLandingTerRequiredForPlaneRecruit);
		v_aa_ignoreAlliedUnitsAsDefenses.setSelected(settings.AA_ignoreAlliedUnitsAsDefenses);
	}
	
	public DSettings CreateSettings()
	{
		final DSettings settings = new DSettings();
		settings.PurchaseWait_AL = Integer.parseInt(v_purchaseWait_AL.getValue().toString());
		settings.CombatMoveWait_AL = Integer.parseInt(v_combatMoveWait_AL.getValue().toString());
		settings.NonCombatMoveWait_AL = Integer.parseInt(v_nonCombatMoveWait_AL.getValue().toString());
		settings.PlacementWait_AL = Integer.parseInt(v_placementWait_AL.getValue().toString());
		settings.AllowCalcingDecrease = v_allowCalcingDecrease.isSelected();
		settings.CalcingDecreaseToPercentage = Integer.parseInt(v_calcDecreaseToPercentage.getValue().toString());
		settings.AIC_disableAllUnitPurchasesAndPlacements = v_aic_disableAllUnitPurchasesAndPlacements.isSelected();
		settings.AIC_disableAllUnitMovements = v_aic_disableAllUnitMovement.isSelected();
		settings.CA_Purchase_determinesUnitThatWouldHelpTargetInvasionMost = Integer.parseInt(v_capurchase_determinesUnitThatWouldHelpTargetInvasionMost.getValue().toString());
		settings.CA_CM_determinesIfTaskCreationsWorthwhileBasedOnTakeoverChance = Integer.parseInt(v_cacm_determinesIfTaskCreationsWorthwhileBasedOnTakeoverChance.getValue().toString());
		settings.CA_CMNCM_sortsPossibleTaskRecruitsForOptimalAttackDefense = Integer.parseInt(v_cacmncm_sortsPossibleTaskRecruitsForOptimalAttackDefense.getValue().toString());
		settings.CA_CMNCM_determinesIfTasksRequirementsAreMetEnoughForRecruitingStop = Integer.parseInt(v_cacmncm_determinesIfTasksRequirementsAreMetEnoughForRecruitingStop.getValue().toString());
		settings.CA_CM_determinesIfTradeTasksRequirementsAreMetEnoughForRecruitingStop = Integer.parseInt(v_cacm_determinesIfTradeTasksRequirementsAreMetEnoughForRecruitingStop.getValue().toString());
		settings.CA_CM_determinesAttackResultsToSeeIfTaskWorthwhile = Integer.parseInt(v_cacm_determinesAttackResultsToSeeIfTaskWorthwhile.getValue().toString());
		settings.CA_CMNCM_determinesResponseResultsToSeeIfTaskWorthwhile = Integer.parseInt(v_cacmncm_determinesResponseResultsToSeeIfTaskWorthwhile.getValue().toString());
		settings.CA_CMNCM_determinesIfTaskEndangersCap = Integer.parseInt(v_cacmncm_determinesIfTaskEndangersCap.getValue().toString());
		settings.CA_CMNCM_determinesSurvivalChanceAfterTaskToSeeIfToInvalidateAttackers = Integer.parseInt(v_cacmncm_determinesSurvivalChanceAfterTaskToSeeIfToInvalidateAttackers.getValue()
					.toString());
		settings.CA_NCM_determinesSurvivalChanceOfFromTerAfterMoveToSeeIfToCancelMove = Integer.parseInt(v_cancm_determinesSurvivalChanceOfFromTerAfterMoveToSeeIfToCancelMove.getValue().toString());
		settings.CA_Retreat_determinesIfAIShouldRetreat = Integer.parseInt(v_caretreat_determinesIfAIShouldRetreat.getValue().toString());
		if (v_basicStrengthEval.isSelected())
			settings.BattleCalculationMethod = BattleCalculationType.BasicStrengthEval;
		else if (v_basicScoreEval.isSelected())
			settings.BattleCalculationMethod = BattleCalculationType.BasicScoreEval;
		else if (v_quickBattleCalculator.isSelected())
			settings.BattleCalculationMethod = BattleCalculationType.QuickBattleCalculator;
		else if (v_battleCalculator.isSelected())
			settings.BattleCalculationMethod = BattleCalculationType.BattleCalculator;
		settings.EnableResourceCollectionMultiplier = v_resourceCollectionMultiplier.isSelected();
		settings.ResourceCollectionMultiplyPercent = Integer.parseInt(v_resourceCollectionMultiplyPercent.getValue().toString());
		settings.EnableResourceCollectionIncreaser = v_resourceCollectionIncreaser.isSelected();
		settings.ResourceCollectionIncreaseAmount = Integer.parseInt(v_resourceCollectionIncreaseAmount.getValue().toString());
		settings.EnableUnitPlacementMultiplier = v_unitPlacementMultiplier.isSelected();
		settings.UnitPlacementMultiplyPercent = Integer.parseInt(v_unitPlacementMultiplyAmount.getValue().toString());
		settings.TR_enableAttackOffensive = v_tr_enableAttackOffensive.isSelected();
		settings.TR_attackOffensive_takeoverChanceRequired = Integer.parseInt(v_tr_attackOffensive_takeoverChanceRequired.getValue().toString());
		settings.TR_attackOffensive_counterAttackSurvivalChanceRequired = Integer.parseInt(v_tr_attackOffensive_counterAttackSurvivalChanceRequired.getValue().toString());
		settings.TR_attackOffensive_counterAttackTradeScoreRequiredToBypassSurvivalRequirement = Integer.parseInt(v_tr_attackOffensive_counterAttackTradeScoreRequiredToBypassSurvivalRequirement
					.getValue().toString());
		settings.TR_attackOffensive_Neutrals_takeoverChanceRequired = Integer.parseInt(v_tr_attackOffensive_Neutrals_takeoverChanceRequired.getValue().toString());
		settings.TR_attackOffensive_Neutrals_counterAttackSurvivalChanceRequired = Integer.parseInt(v_tr_attackOffensive_Neutrals_counterAttackSurvivalChanceRequired.getValue().toString());
		settings.TR_attackOffensive_Neutrals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement = Integer
					.parseInt(v_tr_attackOffensive_Neutrals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.getValue().toString());
		settings.TR_attackOffensive_Capitals_takeoverChanceRequired = Integer.parseInt(v_tr_attackOffensive_Capitals_takeoverChanceRequired.getValue().toString());
		settings.TR_attackOffensive_Capitals_counterAttackSurvivalChanceRequired = Integer.parseInt(v_tr_attackOffensive_Capitals_counterAttackSurvivalChanceRequired.getValue().toString());
		settings.TR_attackOffensive_Capitals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement = Integer
					.parseInt(v_tr_attackOffensive_Capitals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.getValue().toString());
		settings.TR_enableAttackStabalize = v_tr_enableAttackStabalize.isSelected();
		settings.TR_attackStabalize_takeoverChanceRequired = Integer.parseInt(v_tr_attackStabalize_takeoverChanceRequired.getValue().toString());
		settings.TR_attackStabalize_counterAttackSurvivalChanceRequired = Integer.parseInt(v_tr_attackStabalize_counterAttackSurvivalChanceRequired.getValue().toString());
		settings.TR_attackStabalize_counterAttackTradeScoreRequiredToBypassSurvivalRequirement = Integer.parseInt(v_tr_attackStabalize_counterAttackTradeScoreRequiredToBypassSurvivalRequirement
					.getValue().toString());
		settings.TR_enableAttackTrade = v_tr_enableAttackTrade.isSelected();
		settings.TR_attackTrade_totalTradeScoreRequired = Integer.parseInt(v_tr_attackTrade_totalTradeScore.getValue().toString());
		settings.TR_attackTrade_certaintyOfReachingDesiredNumberOfLeftoverLandUnitsRequired = Integer.parseInt(v_tr_attackTrade_certaintyOfReachingDesiredNumberOfLeftoverLandUnitsRequired.getValue()
					.toString());
		settings.TR_enableAttackLandGrab = v_tr_enableAttackLandGrab.isSelected();
		settings.TR_attackLandGrab_onlyGrabLandIfWeCanBlitzIt = v_tr_attackLandGrab_onlyGrabLandIfWeCanBlitzIt.isSelected();
		settings.TR_enableReinforceFrontLine = v_tr_enableReinforceFrontline.isSelected();
		settings.TR_reinforceFrontLine_enemyAttackSurvivalChanceRequired = Integer.parseInt(v_tr_reinforceFrontLine_enemyAttackSurvivalChanceRequired.getValue().toString());
		settings.TR_reinforceFrontline_enemyAttackTradeScoreRequiredToBypassRequirements = Integer.parseInt(v_tr_reinforceFrontline_enemyAttackTradeScoreRequiredToBypassRequirements.getValue()
					.toString());
		settings.TR_enableReinforceStabalize = v_tr_enableReinforceStabalize.isSelected();
		settings.TR_reinforceStabalize_enemyAttackSurvivalChanceRequired = Integer.parseInt(v_tr_reinforceStabalize_enemyAttackSurvivalChanceRequired.getValue().toString());
		settings.TR_enableReinforceBlock = v_tr_enableReinforceBlock.isSelected();
		settings.CR_enableCallForLandGrab = v_cr_enableCallForLandGrab.isSelected();
		settings.CR_enableCallForDefensiveFront = v_cr_enableCallForDefensiveFront.isSelected();
		settings.CR_enableCallForCapitalDefense = v_cr_enableCallForCapitalDefense.isSelected();
		settings.EnableAILogging = v_enableAILogging.isSelected();
		if (v_logDepth.getSelectedIndex() == 0)
			settings.AILoggingDepth = Level.FINE;
		else if (v_logDepth.getSelectedIndex() == 1)
			settings.AILoggingDepth = Level.FINER;
		else if (v_logDepth.getSelectedIndex() == 2)
			settings.AILoggingDepth = Level.FINEST;
		settings.LimitLogHistory = v_limitLogHistoryCB.isSelected();
		settings.LimitLogHistoryTo = Integer.parseInt(v_limitLogHistoryToSpinner.getValue().toString());
		settings.AA_resourcePercentageThatMustExistForFactoryBuy = Integer.parseInt(v_aa_resourcePercentageThatMustExistForFactoryBuy.getValue().toString());
		settings.AA_maxUnitTypesForPurchaseMix = Integer.parseInt(v_aa_maxUnitTypesForPurchaseMix.getValue().toString());
		if (v_aa_noThreatInvalidation.isSelected())
			settings.AA_threatInvalidationType = ThreatInvalidationType.None;
		else if (v_aa_globalThreatInvalidation.isSelected())
			settings.AA_threatInvalidationType = ThreatInvalidationType.Global;
		else if (v_aa_hotspotInvalidation.isSelected())
			settings.AA_threatInvalidationType = ThreatInvalidationType.AroundHotspot;
		settings.AA_threatInvalidationAroundHotspotRadius = Integer.parseInt(v_aa_radiusOfHotspotThreatInvalidation.getValue().toString());
		settings.AA_percentageOfResistedThreatThatTasksInvalidate = Integer.parseInt(v_aa_percentageOfResistedThreatsThatTasksInvalidate.getValue().toString());
		settings.AA_survivalChanceOfLandingTerRequiredForPlaneRecruit = Integer.parseInt(v_aa_survivalChanceOfLandingTerRequiredForPlaneRecruit.getValue().toString());
		settings.AA_ignoreAlliedUnitsAsDefenses = v_aa_ignoreAlliedUnitsAsDefenses.isSelected();
		return settings;
	}
	
	private void v_restoreDefaultsButtonActionPerformed(final java.awt.event.ActionEvent evt)// GEN-FIRST:event_v_restoreDefaultsButtonActionPerformed
	{// GEN-HEADEREND:event_v_restoreDefaultsButtonActionPerformed
		final int result = JOptionPane.showConfirmDialog(rootPane, "Are you sure you want to reset all Dynamix AI settings?", "Reset Default Settings", JOptionPane.OK_CANCEL_OPTION,
					JOptionPane.QUESTION_MESSAGE);
		if (result == JOptionPane.OK_OPTION)
		{
			final DSettings defaultSettings = new DSettings(); // Default settings are already contained in a new DSettings instance
			LoadSettings(defaultSettings);
			JOptionPane.showMessageDialog(rootPane, "Default settings restored.\r\n\r\n(If you don't want to keep these default settings, just hit cancel)", "Default Settings Restored",
						JOptionPane.INFORMATION_MESSAGE);
		}
	}// GEN-LAST:event_v_restoreDefaultsButtonActionPerformed
	
	private void v_enableAILoggingStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_enableAILoggingStateChanged
	{// GEN-HEADEREND:event_v_enableAILoggingStateChanged
		v_logDepth.setEnabled(v_enableAILogging.isSelected());
		v_limitLogHistoryCB.setEnabled(v_enableAILogging.isSelected());
	}// GEN-LAST:event_v_enableAILoggingStateChanged
	
	private void v_limitLogHistoryCBStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_limitLogHistoryCBStateChanged
	{// GEN-HEADEREND:event_v_limitLogHistoryCBStateChanged
		v_limitLogHistoryToSpinner.setEnabled(v_limitLogHistoryCB.isSelected() && v_enableAILogging.isSelected());
	}// GEN-LAST:event_v_limitLogHistoryCBStateChanged
	
	private void formWindowClosing(final java.awt.event.WindowEvent evt)// GEN-FIRST:event_formWindowClosing
	{// GEN-HEADEREND:event_formWindowClosing
		v_cancelButtonActionPerformed(null);
	}// GEN-LAST:event_formWindowClosing
	
	private void v_resourceCollectionMultiplierStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_resourceCollectionMultiplierStateChanged
	{// GEN-HEADEREND:event_v_resourceCollectionMultiplierStateChanged
		v_resourceCollectionMultiplyPercent.setEnabled(v_resourceCollectionMultiplier.isSelected());
	}// GEN-LAST:event_v_resourceCollectionMultiplierStateChanged
	
	private void v_unitPlacementMultiplierStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_unitPlacementMultiplierStateChanged
	{// GEN-HEADEREND:event_v_unitPlacementMultiplierStateChanged
		v_unitPlacementMultiplyAmount.setEnabled(v_unitPlacementMultiplier.isSelected());
	}// GEN-LAST:event_v_unitPlacementMultiplierStateChanged
	
	private void v_okButtonActionPerformed(final java.awt.event.ActionEvent evt)// GEN-FIRST:event_v_okButtonActionPerformed
	{// GEN-HEADEREND:event_v_okButtonActionPerformed
		final DSettings settings = CreateSettings();
		DSettings.SaveSettings(settings);
		this.setVisible(false);
		v_pauseAIs.setSelected(false);
	}// GEN-LAST:event_v_okButtonActionPerformed
	
	private void v_cancelButtonActionPerformed(final java.awt.event.ActionEvent evt)// GEN-FIRST:event_v_cancelButtonActionPerformed
	{// GEN-HEADEREND:event_v_cancelButtonActionPerformed
		final DSettings settings = DSettings.LoadSettings();
		LoadSettings(settings);
		this.setVisible(false);
		v_pauseAIs.setSelected(false);
	}// GEN-LAST:event_v_cancelButtonActionPerformed
	
	private void v_settingsDetailsButtonActionPerformed(final java.awt.event.ActionEvent evt)// GEN-FIRST:event_v_settingsDetailsButtonActionPerformed
	{// GEN-HEADEREND:event_v_settingsDetailsButtonActionPerformed
		final JDialog dialog = new JDialog(this, "Dynamix AI - Settings Details");
		String message = "";
		if (v_tabPaneMain.getSelectedIndex() == 0) // General
		{
			message = "General\r\n"
						+ "\r\n"
						+ "Battle Calculation Method: This setting allows you to change how the AI determines if it will win a battle.\r\n"
						+ "The only option currently available is the 'Battle Calculator', which runs simulations of the actual battle and averages the results, thereby determinining its chances of winning.";
		}
		else if (v_tabPaneMain.getSelectedIndex() == 1) // Pausing
		{
			message = "Pausing\r\n"
						+ "\r\n"
						+ "When an action is taking longer than the time specified, reduce the calc'ing run count to X: This option lets the AI 'speed itself up' when it's taking longer than the time set earlier.\r\n"
						+ "It does this by reducing the number of times it simulates battles. This reduces the time spent, but also reduces the accuracy of its battle calculating.\r\n"
						+ "Note that it only starts this reduction of battle-simulation-counts *after* the current action is taking longer to calculate than the user wanted.\r\n"
						+ "Also, the reduction only lasts till the action has been performed, so the run count reduction does not get applied to the next action.";
		}
		else if (v_tabPaneMain.getSelectedIndex() == 2) // Cheating
		{
			message = "Cheating\r\n"
						+ "\r\n"
						+ "Resource Collection Multiplier: This cheat multiplies the number of resources collected at the end of the round by the percentage supplied.\r\n"
						+ "Example: The user turns the resource collection multipler cheat on, and sets the percentage to 150%. The AI now starts playing.\r\n"
						+ "It finishes its turn and collects its resources. Instead of collecting 10 PUs, though, it collects 15, as the resource collection cheat is turned on.\r\n"
						+ "Note that the actual resource multiplication is done at the start of the next turn. (Meaning it can get messed up by reloading or having complex game triggers)\r\n"
						+ "\r\n"
						+ "Resource Collection Increaser: This cheat increases the number of resources collected at the end of the round by the amount supplied.\r\n"
						+ "Example: The user turns the resource collection increaser cheat on, and sets the amount to 10. The AI now starts playing.\r\n"
						+ "It finishes its turn and collects its resources. Instead of collecting 10 PUs, though, it collects 20, as the resource collection cheat is turned on.\r\n"
						+ "\r\n"
						+ "Unit Placement Multiplier: This cheat multiplies the number of units placed down on each factory by the percentage supplied.\r\n"
						+ "Example: The user turns the unit placement modifier cheat on, and sets the percentage to 150%. The AI now starts playing.\r\n"
						+ "It finishes its purchase, combat, and non combat phases, and is going to place its units. It has ten infantry, all going to be placed on the cap.\r\n"
						+ "Instead of placing 10 infantry, though, it places 15, as the unit placement cheat is turned on.\r\n"
						+ "Note that the AI decides which extra units to place based on how high each possible unit's randomly generated number compares with the multiply percentage.\r\n"
						+ "\r\n"
						+ "Disable All Unit Purchases/Placements: Causes all Dynamix AI's to skip their purchase and placement phases, as well as destroy their own PU's at the end of each round.\r\n"
						+ "\r\n"
						+ "Disable All Unit Movements: Causes all Dynamix AI's to skip their cm and ncm movement phases.\r\n"
						+ "\r\n"
						+ "Note: These settings only affect Dynamix AI's. They have no effect on Moore N Able or EZ Fodder AI's.";
		}
		else if (v_tabPaneMain.getSelectedIndex() == 3) // Calculations
		{
			message = "Calculations\r\n"
						+ "\r\n"
						+ "The battle calculator is a tool in the TripleA Game menu, with which you can have TripleA simulate a battle many times, then tell you the chances you have of winning the battle, losing the battle, or having a draw.\r\n"
						+ "It can also be used to found out how many units will be left over from a battle on average, for both the attacker and defender.\r\n"
						+ "Dynamix incorporates this battle calculator into its code, using it to determine which unit is best at attacking, whether it has enough troops to attack an enemy territory, etc.\r\n"
						+ "\r\n"
						+ "These settings let you change how precise the calculation estimates are to be--the higher the number, the more accurate the averaged results; the lower the number, the shorter the wait.\r\n";
		}
		else if (v_tabPaneMain.getSelectedIndex() == 4) // Tasks
		{
			message = "Tasks\r\n"
						+ "\r\n"
						+ "Tasks are basically just 'wrapper classes' for attacks on the enemy and territory reinforcements; the checkboxes let you turn on and off the various types.\r\n"
						+ "These settings allow you control the AI's aggresiveness, defensiveness, etc., by directly manipulating the AI constants.\r\n";
		}
		else if (v_tabPaneMain.getSelectedIndex() == 5) // Calls
		{
			message = "Calls\r\n"
						+ "\r\n"
						+ "Calls are basically just 'wrapper classes' for moving units to weak defensive fronts, endangered capitals, and so on; the checkboxes let you turn on and off the various types.\r\n";
		}
		else if (v_tabPaneMain.getSelectedIndex() == 6) // Debugging
		{
			message = "Debugging\r\n"
						+ "\r\n"
						+ "AI Logging: When this is checked, the AI's will output their logs, as they come in, so you can see exactly what the AI is thinking.\r\n"
						+ "Note that if you check this on, you still have to press OK then reopen the settings window for the logs to actually start displaying.\r\n"
						+ "\r\n"
						+ "Log Depth: This setting lets you choose how deep you want the AI logging to be. Fine only displays the high-level events, like the start of a phase, etc.\r\n"
						+ "Finer displays medium-level events, such as attacks, reinforcements, etc.\r\n"
						+ "Finest displays all the AI logging available. Can be used for detailed ananlysis, but is a lot harder to read through it.\r\n"
						+ "\r\n"
						+ "Pause AI's: This checkbox pauses all the Dynamix AI's while it's checked, so you can look at the logs without the AI's outputing floods of information.\r\n"
						+ "\r\n"
						+ "Limit Log History To X Rounds: If this is checked, the AI log information will be limited to X rounds of information.\r\n";
		}
		else if (v_tabPaneMain.getSelectedIndex() == 7) // Advanced
		{
			message = "Advanced\r\n"
						+ "\r\n"
						+ "Percentage of resources that must exist after purchases for AI to buy factory: The percentage of the resources(PUs) that the AI had at the beginning of the purchase phase that must exist after all purchases for the AI to buy a factory.\r\n"
						+ "\r\n"
						+ "Max unit types to calculate for factory purchase mix: If you lower this, the AI will purchase faster, but there will also be less of a variety of units in each purchase mix.\r\n"
						+ "\r\n"
						+ "Threat Invalidation: Threat invalidation is a feature added to the AI that enables it to be more bold on a battle front when there are armies behind it or next to it, as a human would do.\r\n"
						+ "Without this feature, the AI will attempt to defend itself at every territory on a battle front.\r\n"
						+ "This feature partially fixes this issue by ignoring/invalidating threats on a battle front if a task is known to be able to defend against them.\r\n"
						+ "\r\n"
						+ "Threat Invalidation Types: None causes the AI to use no threat invalidation, Global causes the AI to invalidate threats for every one of our territories, meaning they will all ignore any threats that have been invalidated,\r\n"
						+ "and 'Hotspot, Radius X' causes the AI to invalidate threats only for the ters withing X ters of the ter that invalidated the threats.\r\n"
						+ "This option is probably the best, because it keeps the AI from ignoring powerful, far-off airplane stacks, while still mantaining some aggression on the front.\r\n"
						+ "\r\n"
						+ "Percentage of threats that become invalidated when a task is resistant to them: This setting allows the user to choose what percentage of the threats to invalidate when a task is successful.\r\n"
						+ "For example, this setting would determine what percentage of a far-off air stack would be ignored/invalidated, when the first successful movement was completed which was strong enough to defend from it.\r\n"
						+ "\r\n"
						+ "Survival shance that one of the landing ters must match for air unit to be recruitable: For an air unit to be considered 'recruitable', it must be able to reach a landing territory that has at least an X percent chance of survival.\r\n"
						+ "\r\n"
						+ "Ignore allied units when trying to reinforce territories: If this is enabled, the AI will completely ignore any allied units when checking for territory defenses.";
		}
		final JTextArea label = new JTextArea(message);
		label.setFont(new Font("Segoe UI", Font.PLAIN, 12));
		label.setEditable(false);
		label.setAutoscrolls(true);
		label.setLineWrap(false);
		label.setFocusable(false);
		label.setWrapStyleWord(true);
		label.setLocation(0, 0);
		dialog.setBackground(label.getBackground());
		dialog.setLayout(new BorderLayout());
		final JScrollPane pane = new JScrollPane();
		pane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		pane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
		pane.setViewportView(label);
		dialog.add(pane, BorderLayout.CENTER);
		final JButton button = new JButton(new AbstractAction()
		{
			private static final long serialVersionUID = -1367858475413936399L;
			
			public void actionPerformed(final ActionEvent e)
			{
				dialog.dispose();
			}
		});
		button.setText("Close");
		button.setMinimumSize(new Dimension(100, 30));
		dialog.add(button, BorderLayout.SOUTH);
		dialog.setMinimumSize(new Dimension(500, 300));
		dialog.setSize(new Dimension(800, 600));
		dialog.setResizable(true);
		dialog.setLocationRelativeTo(this);
		dialog.setDefaultCloseOperation(2);
		dialog.setVisible(true);
	}// GEN-LAST:event_v_settingsDetailsButtonActionPerformed
	
	private void v_cr_enableCallForLandGrabStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_cr_enableCallForLandGrabStateChanged
	{// GEN-HEADEREND:event_v_cr_enableCallForLandGrabStateChanged
		// TODO add your handling code here:
	}// GEN-LAST:event_v_cr_enableCallForLandGrabStateChanged
	
	private void v_cr_enableCallForDefensiveFrontStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_cr_enableCallForDefensiveFrontStateChanged
	{// GEN-HEADEREND:event_v_cr_enableCallForDefensiveFrontStateChanged
		// TODO add your handling code here:
	}// GEN-LAST:event_v_cr_enableCallForDefensiveFrontStateChanged
	
	private void v_cr_enableCallForCapitalDefenseStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_cr_enableCallForCapitalDefenseStateChanged
	{// GEN-HEADEREND:event_v_cr_enableCallForCapitalDefenseStateChanged
		// TODO add your handling code here:
	}// GEN-LAST:event_v_cr_enableCallForCapitalDefenseStateChanged
	
	private void v_resourceCollectionIncreaserStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_resourceCollectionIncreaserStateChanged
	{// GEN-HEADEREND:event_v_resourceCollectionIncreaserStateChanged
		v_resourceCollectionIncreaseAmount.setEnabled(v_resourceCollectionIncreaser.isSelected());
	}// GEN-LAST:event_v_resourceCollectionIncreaserStateChanged
	
	private void v_tr_enableAttackStabalizev_tr_enableAttackStabalizeStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_tr_enableAttackStabalizev_tr_enableAttackStabalizeStateChanged
	{// GEN-HEADEREND:event_v_tr_enableAttackStabalizev_tr_enableAttackStabalizeStateChanged
		v_tr_attackStabalize_takeoverChanceRequired.setEnabled(v_tr_enableAttackStabalize.isSelected());
		v_tr_attackStabalize_counterAttackSurvivalChanceRequired.setEnabled(v_tr_enableAttackStabalize.isSelected());
		v_tr_attackStabalize_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setEnabled(v_tr_enableAttackStabalize.isSelected());
	}// GEN-LAST:event_v_tr_enableAttackStabalizev_tr_enableAttackStabalizeStateChanged
	
	private void v_tr_enableAttackOffensivev_tr_enableAttackOffensiveStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_tr_enableAttackOffensivev_tr_enableAttackOffensiveStateChanged
	{// GEN-HEADEREND:event_v_tr_enableAttackOffensivev_tr_enableAttackOffensiveStateChanged
		v_tr_attackOffensive_takeoverChanceRequired.setEnabled(v_tr_enableAttackOffensive.isSelected());
		v_tr_attackOffensive_counterAttackSurvivalChanceRequired.setEnabled(v_tr_enableAttackOffensive.isSelected());
		v_tr_attackOffensive_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setEnabled(v_tr_enableAttackOffensive.isSelected());
		v_tr_attackOffensive_Capitals_takeoverChanceRequired.setEnabled(v_tr_enableAttackOffensive.isSelected());
		v_tr_attackOffensive_Capitals_counterAttackSurvivalChanceRequired.setEnabled(v_tr_enableAttackOffensive.isSelected());
		v_tr_attackOffensive_Capitals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setEnabled(v_tr_enableAttackOffensive.isSelected());
		v_tr_attackOffensive_Neutrals_takeoverChanceRequired.setEnabled(v_tr_enableAttackOffensive.isSelected());
		v_tr_attackOffensive_Neutrals_counterAttackSurvivalChanceRequired.setEnabled(v_tr_enableAttackOffensive.isSelected());
		v_tr_attackOffensive_Neutrals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement.setEnabled(v_tr_enableAttackOffensive.isSelected());
	}// GEN-LAST:event_v_tr_enableAttackOffensivev_tr_enableAttackOffensiveStateChanged
	
	private void v_tr_enableReinforceStabalizev_tr_enableReinforceStabalizeStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_tr_enableReinforceStabalizev_tr_enableReinforceStabalizeStateChanged
	{// GEN-HEADEREND:event_v_tr_enableReinforceStabalizev_tr_enableReinforceStabalizeStateChanged
		v_tr_reinforceStabalize_enemyAttackSurvivalChanceRequired.setEnabled(v_tr_enableReinforceStabalize.isSelected());
	}// GEN-LAST:event_v_tr_enableReinforceStabalizev_tr_enableReinforceStabalizeStateChanged
	
	private void v_tr_enableAttackTradev_tr_enableAttackTradeStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_tr_enableAttackTradev_tr_enableAttackTradeStateChanged
	{// GEN-HEADEREND:event_v_tr_enableAttackTradev_tr_enableAttackTradeStateChanged
		v_tr_attackTrade_totalTradeScore.setEnabled(v_tr_enableAttackTrade.isSelected());
		v_tr_attackTrade_certaintyOfReachingDesiredNumberOfLeftoverLandUnitsRequired.setEnabled(v_tr_enableAttackTrade.isSelected());
	}// GEN-LAST:event_v_tr_enableAttackTradev_tr_enableAttackTradeStateChanged
	
	private void v_tr_enableReinforceBlockv_tr_enableReinforceBlockStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_tr_enableReinforceBlockv_tr_enableReinforceBlockStateChanged
	{// GEN-HEADEREND:event_v_tr_enableReinforceBlockv_tr_enableReinforceBlockStateChanged
	}// GEN-LAST:event_v_tr_enableReinforceBlockv_tr_enableReinforceBlockStateChanged
	
	private void v_tr_enableAttackLandGrabv_tr_enableAttackLandGrabStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_tr_enableAttackLandGrabv_tr_enableAttackLandGrabStateChanged
	{// GEN-HEADEREND:event_v_tr_enableAttackLandGrabv_tr_enableAttackLandGrabStateChanged
		v_tr_attackLandGrab_onlyGrabLandIfWeCanBlitzIt.setEnabled(v_tr_enableAttackLandGrab.isSelected());
	}// GEN-LAST:event_v_tr_enableAttackLandGrabv_tr_enableAttackLandGrabStateChanged
	
	private void v_tr_enableReinforceFrontlinev_tr_enableReinforceFrontlineStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_tr_enableReinforceFrontlinev_tr_enableReinforceFrontlineStateChanged
	{// GEN-HEADEREND:event_v_tr_enableReinforceFrontlinev_tr_enableReinforceFrontlineStateChanged
		v_tr_reinforceFrontLine_enemyAttackSurvivalChanceRequired.setEnabled(v_tr_enableReinforceFrontline.isSelected());
		v_tr_reinforceFrontline_enemyAttackTradeScoreRequiredToBypassRequirements.setEnabled(v_tr_enableReinforceFrontline.isSelected());
	}// GEN-LAST:event_v_tr_enableReinforceFrontlinev_tr_enableReinforceFrontlineStateChanged
	
	private void v_allowCalcingDecreaseStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_allowCalcingDecreaseStateChanged
	{// GEN-HEADEREND:event_v_allowCalcingDecreaseStateChanged
		v_calcDecreaseToPercentage.setEnabled(v_allowCalcingDecrease.isSelected());
	}// GEN-LAST:event_v_allowCalcingDecreaseStateChanged
	
	private void v_aa_hotspotInvalidationStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_aa_hotspotInvalidationStateChanged
	{// GEN-HEADEREND:event_v_aa_hotspotInvalidationStateChanged
		v_aa_radiusOfHotspotThreatInvalidation.setEnabled(v_aa_hotspotInvalidation.isSelected());
	}// GEN-LAST:event_v_aa_hotspotInvalidationStateChanged
	
	private void v_pauseAIsStateChanged(final javax.swing.event.ChangeEvent evt)// GEN-FIRST:event_v_pauseAIsStateChanged
	{// GEN-HEADEREND:event_v_pauseAIsStateChanged
		if (v_pauseAIs.isSelected())
			GlobalCenter.IsPaused = true;
		else
		{
			GlobalCenter.IsPaused = false;
			synchronized (GlobalCenter.IsPaused_Object)
			{
				GlobalCenter.IsPaused_Object.notifyAll();
			}
		}
	}// GEN-LAST:event_v_pauseAIsStateChanged
	
	private JTextArea currentLogTextArea = null;
	
	public void addMessage(final Level level, final String message)
	{
		try
		{
			if (currentLogTextArea == null)
				currentLogTextArea = v_aiOutputLogArea;
			// currentLogTextArea.append(level.getName() + ": " + getIndentationCompensation(level));
			currentLogTextArea.append(message + "\r\n");
		} catch (final NullPointerException ex) // This is bad, but we don't want TripleA crashing because of this...
		{
			System.out.print("Error adding Dynamix log message! Level: " + level.getName() + " Message: " + message);
		}
	}
	
	/*private static String getIndentationCompensation(Level level)
	{
	    if (level.equals(Level.FINE))
	        return "  ";
	    else if (level.equals(Level.FINER))
	        return " ";
	    else
	        return " ";
	}*/
	public void notifyNewRound(final int roundNumber)
	{
		try
		{
			SwingUtilities.invokeAndWait(new Runnable()
			{
				public void run()
				{
					final JPanel newPanel = new JPanel();
					final JScrollPane newScrollPane = new JScrollPane();
					final JTextArea newTextArea = new JTextArea();
					newTextArea.setColumns(20);
					newTextArea.setRows(5);
					newTextArea.setFont(new java.awt.Font("Segoe UI", 0, 10));
					newTextArea.setEditable(false);
					newScrollPane.getHorizontalScrollBar().setEnabled(true);
					newScrollPane.setViewportView(newTextArea);
					newPanel.setLayout(new GridLayout());
					newPanel.add(newScrollPane);
					v_logHolderTabbedPane.addTab(Integer.toString(roundNumber), newPanel);
					currentLogTextArea = newTextArea;
				}
			});
		} catch (final Exception ex)
		{
			System.out.print("Error initializing Dynamix settings window: " + ex.toString() + "\r\n");
		}
		// Now remove round logging that has 'expired'.
		// Note that this method will also trim all but the first and last log panels if logging is turned off
		// (We always keep first round's log panel, and we keep last because the user might turn logging back on in the middle of the round)
		trimLogRoundPanels();
	}
	
	private void trimLogRoundPanels()
	{
		// If we're logging and we have trimming enabled, or if we have logging turned off
		if ((DSettings.LoadSettings().EnableAILogging && DSettings.LoadSettings().LimitLogHistory) || !DSettings.LoadSettings().EnableAILogging)
		{
			final int maxHistoryRounds;
			if (DSettings.LoadSettings().EnableAILogging)
				maxHistoryRounds = DSettings.LoadSettings().LimitLogHistoryTo;
			else
				maxHistoryRounds = 1; // If we're not logging, trim to 1
			try
			{
				final Runnable runner = new Runnable()
				{
					public void run()
					{
						for (int i = 0; i < v_logHolderTabbedPane.getTabCount(); i++)
						{
							// Remember, we never remove last tab, in case user turns logging back on in the middle of a round
							if (i != 0 && i < v_logHolderTabbedPane.getTabCount() - maxHistoryRounds)
							{
								// Remove the tab and decrease i by one, so the next component will be checked
								v_logHolderTabbedPane.removeTabAt(i);
								i--;
							}
						}
					}
				};
				SwingUtilities.invokeAndWait(runner);
			} catch (final Exception ex)
			{
			}
		}
	}
	
	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.ButtonGroup buttonGroup1;
	private javax.swing.ButtonGroup buttonGroup2;
	private javax.swing.JLabel jLabel1;
	private javax.swing.JLabel jLabel100;
	private javax.swing.JLabel jLabel101;
	private javax.swing.JLabel jLabel102;
	private javax.swing.JLabel jLabel103;
	private javax.swing.JLabel jLabel104;
	private javax.swing.JLabel jLabel105;
	private javax.swing.JLabel jLabel106;
	private javax.swing.JLabel jLabel107;
	private javax.swing.JLabel jLabel108;
	private javax.swing.JLabel jLabel109;
	private javax.swing.JLabel jLabel110;
	private javax.swing.JLabel jLabel111;
	private javax.swing.JLabel jLabel112;
	private javax.swing.JLabel jLabel113;
	private javax.swing.JLabel jLabel114;
	private javax.swing.JLabel jLabel115;
	private javax.swing.JLabel jLabel116;
	private javax.swing.JLabel jLabel117;
	private javax.swing.JLabel jLabel118;
	private javax.swing.JLabel jLabel119;
	private javax.swing.JLabel jLabel120;
	private javax.swing.JLabel jLabel121;
	private javax.swing.JLabel jLabel122;
	private javax.swing.JLabel jLabel123;
	private javax.swing.JLabel jLabel124;
	private javax.swing.JLabel jLabel13;
	private javax.swing.JLabel jLabel14;
	private javax.swing.JLabel jLabel15;
	private javax.swing.JLabel jLabel16;
	private javax.swing.JLabel jLabel17;
	private javax.swing.JLabel jLabel18;
	private javax.swing.JLabel jLabel19;
	private javax.swing.JLabel jLabel2;
	private javax.swing.JLabel jLabel20;
	private javax.swing.JLabel jLabel21;
	private javax.swing.JLabel jLabel22;
	private javax.swing.JLabel jLabel23;
	private javax.swing.JLabel jLabel24;
	private javax.swing.JLabel jLabel25;
	private javax.swing.JLabel jLabel26;
	private javax.swing.JLabel jLabel27;
	private javax.swing.JLabel jLabel28;
	private javax.swing.JLabel jLabel29;
	private javax.swing.JLabel jLabel3;
	private javax.swing.JLabel jLabel30;
	private javax.swing.JLabel jLabel31;
	private javax.swing.JLabel jLabel32;
	private javax.swing.JLabel jLabel33;
	private javax.swing.JLabel jLabel34;
	private javax.swing.JLabel jLabel35;
	private javax.swing.JLabel jLabel36;
	private javax.swing.JLabel jLabel37;
	private javax.swing.JLabel jLabel38;
	private javax.swing.JLabel jLabel39;
	private javax.swing.JLabel jLabel4;
	private javax.swing.JLabel jLabel40;
	private javax.swing.JLabel jLabel41;
	private javax.swing.JLabel jLabel42;
	private javax.swing.JLabel jLabel43;
	private javax.swing.JLabel jLabel44;
	private javax.swing.JLabel jLabel45;
	private javax.swing.JLabel jLabel46;
	private javax.swing.JLabel jLabel47;
	private javax.swing.JLabel jLabel48;
	private javax.swing.JLabel jLabel5;
	private javax.swing.JLabel jLabel50;
	private javax.swing.JLabel jLabel53;
	private javax.swing.JLabel jLabel54;
	private javax.swing.JLabel jLabel55;
	private javax.swing.JLabel jLabel57;
	private javax.swing.JLabel jLabel58;
	private javax.swing.JLabel jLabel6;
	private javax.swing.JLabel jLabel63;
	private javax.swing.JLabel jLabel64;
	private javax.swing.JLabel jLabel65;
	private javax.swing.JLabel jLabel66;
	private javax.swing.JLabel jLabel67;
	private javax.swing.JLabel jLabel68;
	private javax.swing.JLabel jLabel69;
	private javax.swing.JLabel jLabel7;
	private javax.swing.JLabel jLabel8;
	private javax.swing.JLabel jLabel82;
	private javax.swing.JLabel jLabel96;
	private javax.swing.JLabel jLabel97;
	private javax.swing.JLabel jLabel98;
	private javax.swing.JLabel jLabel99;
	private javax.swing.JPanel jPanel1;
	private javax.swing.JPanel jPanel10;
	private javax.swing.JPanel jPanel12;
	private javax.swing.JPanel jPanel13;
	private javax.swing.JPanel jPanel14;
	private javax.swing.JPanel jPanel15;
	private javax.swing.JPanel jPanel17;
	private javax.swing.JPanel jPanel18;
	private javax.swing.JPanel jPanel19;
	private javax.swing.JPanel jPanel2;
	private javax.swing.JPanel jPanel21;
	private javax.swing.JPanel jPanel22;
	private javax.swing.JPanel jPanel23;
	private javax.swing.JPanel jPanel24;
	private javax.swing.JPanel jPanel25;
	private javax.swing.JPanel jPanel26;
	private javax.swing.JPanel jPanel27;
	private javax.swing.JPanel jPanel28;
	private javax.swing.JPanel jPanel3;
	private javax.swing.JPanel jPanel4;
	private javax.swing.JPanel jPanel5;
	private javax.swing.JPanel jPanel7;
	private javax.swing.JPanel jPanel8;
	private javax.swing.JPanel jPanel9;
	private javax.swing.JRadioButton v_aa_globalThreatInvalidation;
	private javax.swing.JRadioButton v_aa_hotspotInvalidation;
	private javax.swing.JCheckBox v_aa_ignoreAlliedUnitsAsDefenses;
	private javax.swing.JSpinner v_aa_maxUnitTypesForPurchaseMix;
	private javax.swing.JRadioButton v_aa_noThreatInvalidation;
	private javax.swing.JSpinner v_aa_percentageOfResistedThreatsThatTasksInvalidate;
	private javax.swing.JSpinner v_aa_radiusOfHotspotThreatInvalidation;
	private javax.swing.JSpinner v_aa_resourcePercentageThatMustExistForFactoryBuy;
	private javax.swing.JScrollPane v_aa_scrollPane;
	private javax.swing.JScrollPane v_aa_scrollPane1;
	private javax.swing.JSpinner v_aa_survivalChanceOfLandingTerRequiredForPlaneRecruit;
	private javax.swing.JTextArea v_aiOutputLogArea;
	private javax.swing.JScrollPane v_aiOutputLogAreaScrollPane;
	private javax.swing.JCheckBox v_aic_disableAllUnitMovement;
	private javax.swing.JCheckBox v_aic_disableAllUnitPurchasesAndPlacements;
	private javax.swing.JCheckBox v_allowCalcingDecrease;
	private javax.swing.JRadioButton v_basicScoreEval;
	private javax.swing.JRadioButton v_basicStrengthEval;
	private javax.swing.JRadioButton v_battleCalculator;
	private javax.swing.JSpinner v_cacm_determinesAttackResultsToSeeIfTaskWorthwhile;
	private javax.swing.JSpinner v_cacm_determinesIfTaskCreationsWorthwhileBasedOnTakeoverChance;
	private javax.swing.JSpinner v_cacm_determinesIfTradeTasksRequirementsAreMetEnoughForRecruitingStop;
	private javax.swing.JSpinner v_cacmncm_determinesIfTaskEndangersCap;
	private javax.swing.JSpinner v_cacmncm_determinesIfTasksRequirementsAreMetEnoughForRecruitingStop;
	private javax.swing.JSpinner v_cacmncm_determinesResponseResultsToSeeIfTaskWorthwhile;
	private javax.swing.JSpinner v_cacmncm_determinesSurvivalChanceAfterTaskToSeeIfToInvalidateAttackers;
	private javax.swing.JSpinner v_cacmncm_sortsPossibleTaskRecruitsForOptimalAttackDefense;
	private javax.swing.JSpinner v_calcDecreaseToPercentage;
	private javax.swing.JPanel v_calcRunCountAssignmentsHolderPanel;
	private javax.swing.JScrollPane v_calcRunCountAssignmentsScrollPane;
	private javax.swing.JButton v_cancelButton;
	private javax.swing.JSpinner v_cancm_determinesSurvivalChanceOfFromTerAfterMoveToSeeIfToCancelMove;
	private javax.swing.JSpinner v_capurchase_determinesUnitThatWouldHelpTargetInvasionMost;
	private javax.swing.JSpinner v_caretreat_determinesIfAIShouldRetreat;
	private javax.swing.JSpinner v_combatMoveWait_AL;
	private javax.swing.JCheckBox v_cr_enableCallForCapitalDefense;
	private javax.swing.JCheckBox v_cr_enableCallForDefensiveFront;
	private javax.swing.JCheckBox v_cr_enableCallForLandGrab;
	private javax.swing.JCheckBox v_enableAILogging;
	private javax.swing.ButtonGroup v_invalidationTypeButtonGroup;
	private javax.swing.JCheckBox v_limitLogHistoryCB;
	private javax.swing.JSpinner v_limitLogHistoryToSpinner;
	private javax.swing.JComboBox v_logDepth;
	private javax.swing.JTabbedPane v_logHolderTabbedPane;
	private javax.swing.JSpinner v_nonCombatMoveWait_AL;
	private javax.swing.JButton v_okButton;
	private javax.swing.JCheckBox v_pauseAIs;
	private javax.swing.JPanel v_pausingPanel;
	private javax.swing.JSpinner v_placementWait_AL;
	private javax.swing.JSpinner v_purchaseWait_AL;
	private javax.swing.JRadioButton v_quickBattleCalculator;
	private javax.swing.JSpinner v_resourceCollectionIncreaseAmount;
	private javax.swing.JCheckBox v_resourceCollectionIncreaser;
	private javax.swing.JCheckBox v_resourceCollectionMultiplier;
	private javax.swing.JSpinner v_resourceCollectionMultiplyPercent;
	private javax.swing.JButton v_restoreDefaultsButton;
	private javax.swing.JButton v_settingsDetailsButton;
	private javax.swing.JTabbedPane v_tabPaneMain;
	private javax.swing.JPanel v_totalLengthGoalsPanel;
	private javax.swing.JCheckBox v_tr_attackLandGrab_onlyGrabLandIfWeCanBlitzIt;
	private javax.swing.JSpinner v_tr_attackOffensive_Capitals_counterAttackSurvivalChanceRequired;
	private javax.swing.JSpinner v_tr_attackOffensive_Capitals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement;
	private javax.swing.JSpinner v_tr_attackOffensive_Capitals_takeoverChanceRequired;
	private javax.swing.JSpinner v_tr_attackOffensive_Neutrals_counterAttackSurvivalChanceRequired;
	private javax.swing.JSpinner v_tr_attackOffensive_Neutrals_counterAttackTradeScoreRequiredToBypassSurvivalRequirement;
	private javax.swing.JSpinner v_tr_attackOffensive_Neutrals_takeoverChanceRequired;
	private javax.swing.JSpinner v_tr_attackOffensive_counterAttackSurvivalChanceRequired;
	private javax.swing.JSpinner v_tr_attackOffensive_counterAttackTradeScoreRequiredToBypassSurvivalRequirement;
	private javax.swing.JSpinner v_tr_attackOffensive_takeoverChanceRequired;
	private javax.swing.JSpinner v_tr_attackStabalize_counterAttackSurvivalChanceRequired;
	private javax.swing.JSpinner v_tr_attackStabalize_counterAttackTradeScoreRequiredToBypassSurvivalRequirement;
	private javax.swing.JSpinner v_tr_attackStabalize_takeoverChanceRequired;
	private javax.swing.JSpinner v_tr_attackTrade_certaintyOfReachingDesiredNumberOfLeftoverLandUnitsRequired;
	private javax.swing.JSpinner v_tr_attackTrade_totalTradeScore;
	private javax.swing.JCheckBox v_tr_enableAttackLandGrab;
	private javax.swing.JCheckBox v_tr_enableAttackOffensive;
	private javax.swing.JCheckBox v_tr_enableAttackStabalize;
	private javax.swing.JCheckBox v_tr_enableAttackTrade;
	private javax.swing.JCheckBox v_tr_enableReinforceBlock;
	private javax.swing.JCheckBox v_tr_enableReinforceFrontline;
	private javax.swing.JCheckBox v_tr_enableReinforceStabalize;
	private javax.swing.JSpinner v_tr_reinforceFrontLine_enemyAttackSurvivalChanceRequired;
	private javax.swing.JSpinner v_tr_reinforceFrontline_enemyAttackTradeScoreRequiredToBypassRequirements;
	private javax.swing.JSpinner v_tr_reinforceStabalize_enemyAttackSurvivalChanceRequired;
	private javax.swing.JCheckBox v_unitPlacementMultiplier;
	private javax.swing.JSpinner v_unitPlacementMultiplyAmount;
	// End of variables declaration//GEN-END:variables
}
