#include <linux/videodev2.h>

#include "trinity.h"
#include "ioctls.h"

static const struct ioctl videodev2_ioctls[] = {
	IOCTL(VIDIOC_QUERYCAP),
	IOCTL(VIDIOC_RESERVED),
	IOCTL(VIDIOC_ENUM_FMT),
	IOCTL(VIDIOC_G_FMT),
	IOCTL(VIDIOC_S_FMT),
	IOCTL(VIDIOC_REQBUFS),
	IOCTL(VIDIOC_QUERYBUF),
	IOCTL(VIDIOC_G_FBUF),
	IOCTL(VIDIOC_S_FBUF),
	IOCTL(VIDIOC_OVERLAY),
	IOCTL(VIDIOC_QBUF),
#ifdef VIDIOC_EXPBUF
	IOCTL(VIDIOC_EXPBUF),
#endif
	IOCTL(VIDIOC_DQBUF),
	IOCTL(VIDIOC_STREAMON),
	IOCTL(VIDIOC_STREAMOFF),
	IOCTL(VIDIOC_G_PARM),
	IOCTL(VIDIOC_S_PARM),
	IOCTL(VIDIOC_G_STD),
	IOCTL(VIDIOC_S_STD),
	IOCTL(VIDIOC_ENUMSTD),
	IOCTL(VIDIOC_ENUMINPUT),
	IOCTL(VIDIOC_G_CTRL),
	IOCTL(VIDIOC_S_CTRL),
	IOCTL(VIDIOC_G_TUNER),
	IOCTL(VIDIOC_S_TUNER),
	IOCTL(VIDIOC_G_AUDIO),
	IOCTL(VIDIOC_S_AUDIO),
	IOCTL(VIDIOC_QUERYCTRL),
	IOCTL(VIDIOC_QUERYMENU),
	IOCTL(VIDIOC_G_INPUT),
	IOCTL(VIDIOC_S_INPUT),
	IOCTL(VIDIOC_G_OUTPUT),
	IOCTL(VIDIOC_S_OUTPUT),
	IOCTL(VIDIOC_ENUMOUTPUT),
	IOCTL(VIDIOC_G_AUDOUT),
	IOCTL(VIDIOC_S_AUDOUT),
	IOCTL(VIDIOC_G_MODULATOR),
	IOCTL(VIDIOC_S_MODULATOR),
	IOCTL(VIDIOC_G_FREQUENCY),
	IOCTL(VIDIOC_S_FREQUENCY),
	IOCTL(VIDIOC_CROPCAP),
	IOCTL(VIDIOC_G_CROP),
	IOCTL(VIDIOC_S_CROP),
	IOCTL(VIDIOC_G_JPEGCOMP),
	IOCTL(VIDIOC_S_JPEGCOMP),
	IOCTL(VIDIOC_QUERYSTD),
	IOCTL(VIDIOC_TRY_FMT),
	IOCTL(VIDIOC_ENUMAUDIO),
	IOCTL(VIDIOC_ENUMAUDOUT),
	IOCTL(VIDIOC_G_PRIORITY),
	IOCTL(VIDIOC_S_PRIORITY),
	IOCTL(VIDIOC_G_SLICED_VBI_CAP),
	IOCTL(VIDIOC_LOG_STATUS),
	IOCTL(VIDIOC_G_EXT_CTRLS),
	IOCTL(VIDIOC_S_EXT_CTRLS),
	IOCTL(VIDIOC_TRY_EXT_CTRLS),
	IOCTL(VIDIOC_ENUM_FRAMESIZES),
	IOCTL(VIDIOC_ENUM_FRAMEINTERVALS),
	IOCTL(VIDIOC_G_ENC_INDEX),
	IOCTL(VIDIOC_ENCODER_CMD),
	IOCTL(VIDIOC_TRY_ENCODER_CMD),
	IOCTL(VIDIOC_DBG_S_REGISTER),
	IOCTL(VIDIOC_DBG_G_REGISTER),
	IOCTL(VIDIOC_DBG_G_CHIP_IDENT),
	IOCTL(VIDIOC_S_HW_FREQ_SEEK),
#ifdef VIDIOC_ENUM_DV_PRESETS
	IOCTL(VIDIOC_ENUM_DV_PRESETS),
#endif
#ifdef VIDIOC_S_DV_PRESET
	IOCTL(VIDIOC_S_DV_PRESET),
#endif
#ifdef VIDIOC_G_DV_PRESET
	IOCTL(VIDIOC_G_DV_PRESET),
#endif
#ifdef VIDIOC_QUERY_DV_PRESET
	IOCTL(VIDIOC_QUERY_DV_PRESET),
#endif
#ifdef VIDIOC_S_DV_TIMINGS
	IOCTL(VIDIOC_S_DV_TIMINGS),
#endif
#ifdef VIDIOC_G_DV_TIMINGS
	IOCTL(VIDIOC_G_DV_TIMINGS),
#endif
#ifdef VIDIOC_DQEVENT
	IOCTL(VIDIOC_DQEVENT),
#endif
#ifdef VIDIOC_SUBSCRIBE_EVENT
	IOCTL(VIDIOC_SUBSCRIBE_EVENT),
#endif
#ifdef VIDIOC_UNSUBSCRIBE_EVENT
	IOCTL(VIDIOC_UNSUBSCRIBE_EVENT),
#endif
#ifdef VIDIOC_CREATE_BUFS
	IOCTL(VIDIOC_CREATE_BUFS),
#endif
#ifdef VIDIOC_PREPARE_BUF
	IOCTL(VIDIOC_PREPARE_BUF),
#endif
#ifdef VIDIOC_G_SELECTION
	IOCTL(VIDIOC_G_SELECTION),
#endif
#ifdef VIDIOC_S_SELECTION
	IOCTL(VIDIOC_S_SELECTION),
#endif
#ifdef VIDIOC_DECODER_CMD
	IOCTL(VIDIOC_DECODER_CMD),
#endif
#ifdef VIDIOC_TRY_DECODER_CMD
	IOCTL(VIDIOC_TRY_DECODER_CMD),
#endif
#ifdef VIDIOC_ENUM_DV_TIMINGS
	IOCTL(VIDIOC_ENUM_DV_TIMINGS),
#endif
#ifdef VIDIOC_QUERY_DV_TIMINGS
	IOCTL(VIDIOC_QUERY_DV_TIMINGS),
#endif
#ifdef VIDIOC_DV_TIMINGS_CAP
	IOCTL(VIDIOC_DV_TIMINGS_CAP),
#endif
#ifdef VIDIOC_ENUM_FREQ_BANDS
	IOCTL(VIDIOC_ENUM_FREQ_BANDS),
#endif
};

static const char *const videodev2_devs[] = {
	"video4linux",
};

static const struct ioctl_group videodev2_grp = {
	.devtype = DEV_MISC,
	.devs = videodev2_devs,
	.devs_cnt = ARRAY_SIZE(videodev2_devs),
	.sanitise = pick_random_ioctl,
	.ioctls = videodev2_ioctls,
	.ioctls_cnt = ARRAY_SIZE(videodev2_ioctls),
};

REG_IOCTL_GROUP(videodev2_grp)
