#include <linux/firewire-cdev.h>

#include "trinity.h"
#include "ioctls.h"

static const struct ioctl firewire_ioctls[] = {
	IOCTL(FW_CDEV_IOC_GET_INFO),
	IOCTL(FW_CDEV_IOC_SEND_REQUEST),
	IOCTL(FW_CDEV_IOC_ALLOCATE),
	IOCTL(FW_CDEV_IOC_DEALLOCATE),
	IOCTL(FW_CDEV_IOC_SEND_RESPONSE),
	IOCTL(FW_CDEV_IOC_INITIATE_BUS_RESET),
	IOCTL(FW_CDEV_IOC_ADD_DESCRIPTOR),
	IOCTL(FW_CDEV_IOC_REMOVE_DESCRIPTOR),
	IOCTL(FW_CDEV_IOC_CREATE_ISO_CONTEXT),
	IOCTL(FW_CDEV_IOC_QUEUE_ISO),
	IOCTL(FW_CDEV_IOC_START_ISO),
	IOCTL(FW_CDEV_IOC_STOP_ISO),
	IOCTL(FW_CDEV_IOC_GET_CYCLE_TIMER),
	IOCTL(FW_CDEV_IOC_ALLOCATE_ISO_RESOURCE),
	IOCTL(FW_CDEV_IOC_DEALLOCATE_ISO_RESOURCE),
	IOCTL(FW_CDEV_IOC_ALLOCATE_ISO_RESOURCE_ONCE),
	IOCTL(FW_CDEV_IOC_DEALLOCATE_ISO_RESOURCE_ONCE),
	IOCTL(FW_CDEV_IOC_GET_SPEED),
	IOCTL(FW_CDEV_IOC_SEND_BROADCAST_REQUEST),
	IOCTL(FW_CDEV_IOC_SEND_STREAM_PACKET),
#ifdef FW_CDEV_IOC_GET_CYCLE_TIMER2
	IOCTL(FW_CDEV_IOC_GET_CYCLE_TIMER2),
#endif
#ifdef FW_CDEV_IOC_SEND_PHY_PACKET
	IOCTL(FW_CDEV_IOC_SEND_PHY_PACKET),
#endif
#ifdef FW_CDEV_IOC_RECEIVE_PHY_PACKETS
	IOCTL(FW_CDEV_IOC_RECEIVE_PHY_PACKETS),
#endif
#ifdef FW_CDEV_IOC_SET_ISO_CHANNELS
	IOCTL(FW_CDEV_IOC_SET_ISO_CHANNELS),
#endif
#ifdef FW_CDEV_IOC_FLUSH_ISO
	IOCTL(FW_CDEV_IOC_FLUSH_ISO),
#endif
};

static const char *const firewire_devs[] = {
	"firewire",
};

static const struct ioctl_group firewire_grp = {
	.devtype = DEV_MISC,
	.devs = firewire_devs,
	.devs_cnt = ARRAY_SIZE(firewire_devs),
	.sanitise = pick_random_ioctl,
	.ioctls = firewire_ioctls,
	.ioctls_cnt = ARRAY_SIZE(firewire_ioctls),
};

REG_IOCTL_GROUP(firewire_grp)
