#include <linux/cdrom.h>

#include "trinity.h"
#include "ioctls.h"

static const struct ioctl cdrom_ioctls[] = {
	IOCTL(CDROMPAUSE),
	IOCTL(CDROMRESUME),
	IOCTL(CDROMPLAYMSF),
	IOCTL(CDROMPLAYTRKIND),
	IOCTL(CDROMREADTOCHDR),
	IOCTL(CDROMREADTOCENTRY),
	IOCTL(CDROMSTOP),
	IOCTL(CDROMSTART),
	IOCTL(CDROMEJECT),
	IOCTL(CDROMVOLCTRL),
	IOCTL(CDROMSUBCHNL),
	IOCTL(CDROMREADMODE2),
	IOCTL(CDROMREADMODE1),
	IOCTL(CDROMREADAUDIO),
	IOCTL(CDROMEJECT_SW),
	IOCTL(CDROMMULTISESSION),
	IOCTL(CDROM_GET_MCN),
	IOCTL(CDROMRESET),
	IOCTL(CDROMVOLREAD),
	IOCTL(CDROMREADRAW),
	IOCTL(CDROMREADCOOKED),
	IOCTL(CDROMSEEK),
	IOCTL(CDROMPLAYBLK),
	IOCTL(CDROMREADALL),
	IOCTL(CDROMGETSPINDOWN),
	IOCTL(CDROMSETSPINDOWN),
	IOCTL(CDROMCLOSETRAY),
	IOCTL(CDROM_SET_OPTIONS),
	IOCTL(CDROM_CLEAR_OPTIONS),
	IOCTL(CDROM_SELECT_SPEED),
	IOCTL(CDROM_SELECT_DISC),
	IOCTL(CDROM_MEDIA_CHANGED),
	IOCTL(CDROM_DRIVE_STATUS),
	IOCTL(CDROM_DISC_STATUS),
	IOCTL(CDROM_CHANGER_NSLOTS),
	IOCTL(CDROM_LOCKDOOR),
	IOCTL(CDROM_DEBUG),
	IOCTL(CDROM_GET_CAPABILITY),
	IOCTL(CDROMAUDIOBUFSIZ),
	IOCTL(DVD_READ_STRUCT),
	IOCTL(DVD_WRITE_STRUCT),
	IOCTL(DVD_AUTH),
	IOCTL(CDROM_SEND_PACKET),
	IOCTL(CDROM_NEXT_WRITABLE),
	IOCTL(CDROM_LAST_WRITTEN),
};

static const char *const cdrom_devs[] = {
	"sr",
};

static const struct ioctl_group cdrom_grp = {
	.devtype = DEV_BLOCK,
	.devs = cdrom_devs,
	.devs_cnt = ARRAY_SIZE(cdrom_devs),
	.sanitise = pick_random_ioctl,
	.ioctls = cdrom_ioctls,
	.ioctls_cnt = ARRAY_SIZE(cdrom_ioctls),
};

REG_IOCTL_GROUP(cdrom_grp)
