/*****************************************************************************
 * CVS File Information :
 *    $RCSfile: SFC.h,v $
 *    $Author: kddevin $
 *    $Date: 2002/06/19 23:56:40 $
 *    $Revision: 1.2 $
 ****************************************************************************/

#ifndef __OCT_SFC_H
#define __OCT_SFC_H

#ifdef __cplusplus
/* if C++, define the rest of this header file as extern C */
extern "C" {
#endif

static int Hilbert3dIndexToMap[24][8] = {
    {0, 1, 3, 2, 6, 7, 5, 4},
    {0, 4, 6, 2, 3, 7, 5, 1},
    {0, 1, 5, 4, 6, 7, 3, 2},
    {5, 1, 0, 4, 6, 2, 3, 7},
    {3, 7, 6, 2, 0, 4, 5, 1},
    {6, 7, 3, 2, 0, 1, 5, 4},
    {5, 1, 3, 7, 6, 2, 0, 4},
    {0, 4, 5, 1, 3, 7, 6, 2},
    {5, 4, 0, 1, 3, 2, 6, 7},
    {5, 4, 6, 7, 3, 2, 0, 1},
    {0, 2, 3, 1, 5, 7, 6, 4},
    {6, 4, 0, 2, 3, 1, 5, 7},
    {5, 7, 3, 1, 0, 2, 6, 4},
    {3, 7, 5, 1, 0, 4, 6, 2},
    {6, 4, 5, 7, 3, 1, 0, 2},
    {0, 2, 6, 4, 5, 7, 3, 1},
    {6, 2, 0, 4, 5, 1, 3, 7},
    {6, 2, 3, 7, 5, 1, 0, 4},
    {3, 2, 0, 1, 5, 4, 6, 7},
    {6, 7, 5, 4, 0, 1, 3, 2},
    {5, 7, 6, 4, 0, 2, 3, 1},
    {3, 2, 6, 7, 5, 4, 0, 1},
    {3, 1, 0, 2, 6, 4, 5, 7},
    {3, 1, 5, 7, 6, 4, 0, 2}
};

static int Hilbert3dIndexFromMap[24][8] = {
    {0, 1, 3, 2, 7, 6, 4, 5},
    {0, 7, 3, 4, 1, 6, 2, 5},
    {0, 1, 7, 6, 3, 2, 4, 5},
    {2, 1, 5, 6, 3, 0, 4, 7},
    {4, 7, 3, 0, 5, 6, 2, 1},
    {4, 5, 3, 2, 7, 6, 0, 1},
    {6, 1, 5, 2, 7, 0, 4, 3},
    {0, 3, 7, 4, 1, 2, 6, 5},
    {2, 3, 5, 4, 1, 0, 6, 7},
    {6, 7, 5, 4, 1, 0, 2, 3},
    {0, 3, 1, 2, 7, 4, 6, 5},
    {2, 5, 3, 4, 1, 6, 0, 7},
    {4, 3, 5, 2, 7, 0, 6, 1},
    {4, 3, 7, 0, 5, 2, 6, 1},
    {6, 5, 7, 4, 1, 2, 0, 3},
    {0, 7, 1, 6, 3, 4, 2, 5},
    {2, 5, 1, 6, 3, 4, 0, 7},
    {6, 5, 1, 2, 7, 4, 0, 3},
    {2, 3, 1, 0, 5, 4, 6, 7},
    {4, 5, 7, 6, 3, 2, 0, 1},
    {4, 7, 5, 6, 3, 0, 2, 1},
    {6, 7, 1, 0, 5, 4, 2, 3},
    {2, 1, 3, 0, 5, 6, 4, 7},
    {6, 1, 7, 0, 5, 2, 4, 3}
};

static int Hilbert3dRuleMap[24][8] = {
    {1, 2, 0, 3, 4, 0, 5, 6},
    {0, 7, 1, 8, 5, 1, 4, 9},
    {15, 0, 2, 22, 20, 2, 19, 23},
    {20, 6, 3, 23, 15, 3, 16, 22},
    {22, 13, 4, 12, 11, 4, 1, 20},
    {11, 19, 5, 20, 22, 5, 0, 12},
    {9, 3, 6, 2, 21, 6, 17, 0},
    {10, 1, 7, 11, 12, 7, 13, 14},
    {12, 9, 8, 14, 10, 8, 18, 11},
    {6, 8, 9, 7, 17, 9, 21, 1},
    {7, 15, 10, 16, 13, 10, 12, 17},
    {5, 14, 11, 9, 0, 11, 22, 8},
    {8, 20, 12, 19, 18, 12, 10, 5},
    {18, 4, 13, 5, 8, 13, 7, 19},
    {17, 11, 14, 1, 6, 14, 23, 7},
    {2, 10, 15, 18, 19, 15, 20, 21},
    {19, 17, 16, 21, 2, 16, 3, 18},
    {14, 16, 17, 15, 23, 17, 6, 10},
    {13, 21, 18, 17, 7, 18, 8, 16},
    {16, 5, 19, 4, 3, 19, 2, 13},
    {3, 12, 20, 13, 16, 20, 15, 4},
    {23, 18, 21, 10, 14, 21, 9, 15},
    {4, 23, 22, 6, 1, 22, 11, 3},
    {21, 22, 23, 0, 9, 23, 14, 2}
};

static int Gray3dIndexToMap[4][8] = {
    {0, 1, 3, 2, 6, 7, 5, 4},
    {5, 4, 6, 7, 3, 2, 0, 1},
    {3, 2, 0, 1, 5, 4, 6, 7},
    {6, 7, 5, 4, 0, 1, 3, 2}
};

static int Gray3dIndexFromMap[4][8] = {
    {0, 1, 3, 2, 7, 6, 4, 5},
    {6, 7, 5, 4, 1, 0, 2, 3},
    {2, 3, 1, 0, 5, 4, 6, 7},
    {4, 5, 7, 6, 3, 2, 0, 1}
};

static int Gray3dRuleMap[4][8] = {
    {0, 1, 2, 3, 3, 2, 1, 0},
    {1, 0, 3, 2, 2, 3, 0, 1},
    {2, 3, 0, 1, 1, 0, 3, 2},
    {3, 2, 1, 0, 0, 1, 2, 3}
};

#ifdef KDDKDD
/* 
 * KDDKDD   These maps are currently unused in the code. 
 * KDDKDD   They have been "removed" to prevent compiler warnings.
 */
static int Morton3dIndexToMap[1][8] = {
    {0, 1, 2, 3, 4, 5, 6, 7}
};

static int Morton3dIndexFromMap[1][8] = {
    {0, 1, 2, 3, 4, 5, 6, 7}
};

static int Morton3dRuleMap[1][8] = {
    {0, 0, 0, 0, 0, 0, 0, 0}
};
#endif /* KDDKDD */

static int Hilbert2dIndexToMap[4][4] = {
    {0, 1, 3, 2},
    {0, 2, 3, 1},
    {3, 1, 0, 2},
    {3, 2, 0, 1}
};

static int Hilbert2dIndexFromMap[4][4] = {
    {0, 1, 3, 2},
    {0, 3, 1, 2},
    {2, 1, 3, 0},
    {2, 3, 1, 0}
};

static int Hilbert2dRuleMap[4][4] = {
    {1, 0, 0, 2},
    {0, 1, 1, 3},
    {3, 2, 2, 0},
    {2, 3, 3, 1}
};

static int Gray2dIndexToMap[2][4] = {
    {0, 1, 3, 2},
    {3, 2, 0, 1}
};

static int Gray2dIndexFromMap[2][4] = {
    {0, 1, 3, 2},
    {2, 3, 1, 0}
};

static int Gray2dRuleMap[2][4] = {
    {0, 1, 1, 0},
    {1, 0, 0, 1}
};

#ifdef KDDKDD
/* 
 * KDDKDD   These maps are currently unused in the code. 
 * KDDKDD   They have been "removed" to prevent compiler warnings.
 */
static int Morton2dIndexToMap[1][4] = {
    {0, 1, 2, 3}
};

static int Morton2dIndexFromMap[1][4] = {
    {0, 1, 2, 3}
};

static int Morton2dRuleMap[1][8] = {
    {0, 0, 0, 0}
};
#endif /* KDDKDD */

#ifdef __cplusplus
} /* closing bracket for extern "C" */
#endif

#endif
