// $Id: LOCA_MultiContinuation_AbstractGroup.C,v 1.6 2006/08/22 00:01:37 rppawlo Exp $
// $Source: /space/CVS/Trilinos/packages/nox/src-loca/src/LOCA_MultiContinuation_AbstractGroup.C,v $

//@HEADER
// ************************************************************************
// 
//            NOX: An Object-Oriented Nonlinear Solver Package
//                 Copyright (2002) Sandia Corporation
// 
//            LOCA: Library of Continuation Algorithms Package
//                 Copyright (2005) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
// 
// Questions? Contact Roger Pawlowski (rppawlo@sandia.gov) or 
// Eric Phipps (etphipp@sandia.gov), Sandia National Laboratories.
// ************************************************************************
//  CVS Information
//  $Source: /space/CVS/Trilinos/packages/nox/src-loca/src/LOCA_MultiContinuation_AbstractGroup.C,v $
//  $Author: rppawlo $
//  $Date: 2006/08/22 00:01:37 $
//  $Revision: 1.6 $
// ************************************************************************
//@HEADER

#include "LOCA_MultiContinuation_AbstractGroup.H"

void
LOCA::MultiContinuation::AbstractGroup::preProcessContinuationStep(
			     LOCA::Abstract::Iterator::StepStatus stepStatus)
{
}

void
LOCA::MultiContinuation::AbstractGroup::postProcessContinuationStep(
			     LOCA::Abstract::Iterator::StepStatus stepStatus)
{
}

void
LOCA::MultiContinuation::AbstractGroup::projectToDraw(
					      const NOX::Abstract::Vector& x,
					      double *px) const
{
  px[0] = x.norm(NOX::Abstract::Vector::MaxNorm);
}

int
LOCA::MultiContinuation::AbstractGroup::projectToDrawDimension() const
{
  return 1;
}

double
LOCA::MultiContinuation::AbstractGroup::computeScaledDotProduct(
					 const NOX::Abstract::Vector& a,
					 const NOX::Abstract::Vector& b) const
{
  return a.innerProduct(b);
}

void
LOCA::MultiContinuation::AbstractGroup::scaleVector(NOX::Abstract::Vector& x) const
{
}
