/* Copyright (C) 2007 Daiki Ueno <ueno@unixuser.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA */

typedef struct treil_tree {
  long size;
  char *name;
  short depth;
  struct treil_tree *sibling, *children, *parent;
} *treil_tree_t;

#if HAVE_EXPAT_H
treil_tree_t treil_tree_xml (int fd, const char *encoding);
#endif
void treil_tree_free (treil_tree_t data);

typedef struct treil_rect {
  double x, y, width, height;
  treil_tree_t tree;
  struct treil_rect *rect0, *rect1;
} *treil_rect_t;

treil_rect_t treil_rect_new (double x, double y, double width, double height);
void treil_rect_free (treil_rect_t rect);
int treil_rect_fill (treil_rect_t rect, treil_tree_t tree);
