#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"
#include <hildon/hildon-program.h>
#include <string.h>

extern char *pdf_to_kill;

gint dbus_callback (const gchar *interface, const gchar *method,
               GArray *arguments, gpointer data,
               osso_rpc_t *retval)
{
  if (!strcmp (method, "top_application"))
      gtk_window_present (GTK_WINDOW (data));

  retval->type = DBUS_TYPE_INVALID;
  return OSSO_OK;
}


int
main (int argc, char *argv[])
{
  GtkWidget *filechooserdialog1;
  HildonProgram *program;
  osso_context_t *osso;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");
  
  program = HILDON_PROGRAM(hildon_program_get_instance());
  g_set_application_name (_("Office Reader"));
    
  filechooserdialog1 = create_filechooserdialog1 ();
  hildon_program_add_window(program, HILDON_WINDOW(filechooserdialog1));

  osso = osso_initialize("ume.treb","1", FALSE, NULL);
  int ossores = osso_rpc_set_default_cb_f (osso, dbus_callback, filechooserdialog1);
  if (ossores != OSSO_OK)
  {
    fprintf (stderr, "osso_rpc_set_default_cb_f failed: %d.\n", ossores);
    return 1;
  }
  gtk_widget_show (filechooserdialog1);

  gtk_main ();
  wait (NULL);
  remove (pdf_to_kill);
  osso_deinitialize(osso);
  return 0;
}

