/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    http://www.travis-analyzer.de/

    Copyright (c) 2009-2013 Martin Brehm
                  2012-2013 Martin Thomas

    This file written by Martin Brehm.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#ifndef SDENGINE_H
#define SDENGINE_H

#include "xobject.h"
#include "xobarray.h"
#include "xlongarray.h"
#include "xdoublearray.h"
#include "df.h"


class CDF;


class CSDBlockSet : public CxObject
{
public:
	CSDBlockSet();
	~CSDBlockSet();

	int m_iCounter;
	CxDoubleArray m_faBlocks;
};


class CSDGroup : public CxObject
{
public:
	CSDGroup();
	~CSDGroup();

	CxObArray m_oaBlockSets;
	CxDoubleArray m_faBlockVari;
};


class CSDEngine : public CxObject
{
public:
	CSDEngine();
	~CSDEngine();

	void Init(int bins);
	void FinishStep();
	void DumpData(CDF *df, float timessigma, bool verbose);
	void FinishAnalysis();


	inline void AddToBin(int i, double f)
	{
		m_faTempBuffer[i] += f;
	}


	int m_iSteps;

	CxObArray m_oaGroups;
	CxLongArray m_iaBlockSizes;
	CxDoubleArray m_faTempBuffer;

	CxDoubleArray m_faSum;
	CxDoubleArray m_faSqSum;
	CxDoubleArray m_faMean;
	CxDoubleArray m_faVari;
	CxDoubleArray m_faCorLen;
};



#endif

