/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    http://www.travis-analyzer.de/

    Copyright (c) 2009-2013 Martin Brehm
                  2012-2013 Martin Thomas

    This file written by Martin Brehm.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#ifndef STRUCTUREFACTOR_H
#define STRUCTUREFACTOR_H


#include "xobject.h"
#include "xobarray.h"
#include "timestep.h"


class CStructureFactor : public CxObject
{
public:
	void TransformRDF(CDF *pin, CDF *pout);
	void Finish();
	void ProcessStep(CTimeStep *ts);
	void Parse();
	void Create();
	CStructureFactor();
	~CStructureFactor();

	bool m_bDumpTotalRDF;
	bool m_bDumpElementRDFs;
	bool m_bDumpElementSFac;
	CxObArray m_oaRDFs;
	CxObArray m_oaSFacs;
	int m_iRDFRes, m_iSQRes;
	double m_fRDFRange;
	double m_fSQRange;
};


#endif

