/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    http://www.travis-analyzer.de/

    Copyright (c) 2009-2013 Martin Brehm
                  2012-2013 Martin Thomas

    This file written by Martin Brehm.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#ifndef CLUSTER_H
#define CLUSTER_H

#include <math.h>
#include <stdio.h>
#include "xobarray.h"
#include "xvec3array.h"
#include "xfloatarray.h"
#include "xlongarray.h"
#include "df.h"
#include "timestep.h"
#include "random.h"

CxVector3 FoldVector(CxVector3 v);


class CClusterNode : public CxObject
{
public:
	CClusterNode();
	~CClusterNode();

	double m_fPosX;
	int m_iParent;
//	CxLongArray m_laChildren;
	int m_iChildren[2];
	CxVec3Array m_vaAtoms;
	CxIntArray m_iaAtoms;
	float m_fDistance;
	float m_fNNDistance;
	int m_iNextNeighbor;
	int m_iIndex;
	int m_iMonomers;
	CClusterNode *m_pParent;
};


class CClusterAnalysis : public CxObject
{
public:
	void WriteOutput(const char *multibuf);
	void BuildClusterDistribution();
	void BuildDistCache(CTimeStep *ts);
	void BinPoly();
	void CleanUp();
	void Process(CTimeStep *ts);
	void Create();
	void BinDistances(CTimeStep *ts);
	void REC_DumpPoints(CxFloatArray *fa, CClusterNode *n);
	void REC_AvgX(CClusterNode *n);
	void REC_SortX(double pos, int depth, CClusterNode *n);
	void DumpAgr(const char *s);
	void REC_DumpDot(FILE *a, CClusterNode *n);
	void DumpDot(const char *s);
	void FindNearestNeighbor(CClusterNode *n);
	void TraceNeighbors();
	void BuildTree();
	CClusterAnalysis();
	~CClusterAnalysis();
	void Parse();
	void AddCluster(int i);
	void AddParticle(float x, float y, float z);
	void AddParticle(int i);


	inline float Distance(CxVector3 *a, CxVector3 *b)
	{
		return FoldVector(*a - *b).GetLength();
	}


	inline float Distance_Cache(int a, int b)
	{
		return m_pDistCache[a*m_iAtomListSize+b];
	}


	int m_iCounter;
	int m_iMolecule;
	CxObArray m_oaAtomGroups;
	int m_iResX;
	int m_iResY;
	float m_fMaxDist;
	int m_iRes;
	bool m_bAnim;

	float *m_pDistCache;
	int *m_pAtomIndex;
	CxIntArray m_iaAtomList;
	int m_iAtomListSize;
	bool m_bDistCache;
	bool m_b2DPlots;
	bool m_bDiffPlot;
	float m_fDiffInterval;

	CDF *m_pClusterDistanceDF;
	CDF *m_pPolymerDF;
	CDF *m_pClusterCountDF;
	CDF *m_pClusterDistributionDF;
//	CDF *m_pClusterDistribution2DF;
	CDF *m_pClusterSizeDF;

	C2DF *m_pClusterDistance2D;
	C2DF *m_pClusterDistribution2D;
	C2DF *m_pClusterSize2D;
	C2DF *m_pClusterCount2D;
	C2DF *m_pClusterDiff2D;

	CxObArray *m_poaClusterPoly;
	int m_iMonomers;
	FILE *m_fAnim;
	CClusterNode *m_pTop;
	CxObArray m_oaClusters;
	CxObArray m_oaBaseClusters;
	CxObArray m_oaTopClusters;

	CxDoubleArray m_faMinDist;
	CxDoubleArray m_faMaxDist;
	CxDoubleArray m_faHetNumber;
	CxDoubleArray m_faIntHetNumber;
	CxDoubleArray m_faIntHetNumber2;
	CxDoubleArray m_faCenter;

	int m_i2DResX;
	int m_i2DResY;
	int m_i2DStride;

	bool m_bHetMeasure;
	bool m_bIdealGas;

	bool m_bCutClusters;
	int m_iCutClusterMaxSize;
	int *m_pCutClusterCounter;
	double *m_pCutClusterDifference;
	FILE **m_pCutClusterFiles;

	CRandom *m_pRandom;
};

#endif

