/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    http://www.travis-analyzer.de/

    Copyright (c) 2009-2013 Martin Brehm
                  2012-2013 Martin Thomas

    This file written by Martin Brehm.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#include "ffgen.h"


void CFFGen::InitFFParm()
{
	/********************************************/
	/*** Lennard-Jones parameters             ***/
	/*** Sigma (Angstrom), Epsilon (KJ/mol)   ***/
	/********************************************/

	// Liu's Force Field
	AddAtomParm("CR", 3.400f, 0.3598f );
	AddAtomParm("NA", 3.250f, 0.7113f );
	AddAtomParm("CW", 3.400f, 0.3598f );
	AddAtomParm("H4", 2.511f, 0.0628f );
	AddAtomParm("H5", 1.782f, 0.0628f );
	AddAtomParm("CT", 3.400f, 0.4577f );
	AddAtomParm("H1", 2.471f, 0.0657f );
	AddAtomParm("HC", 2.650f, 0.0657f );
	AddAtomParm("P",  3.742f, 0.8368f );
	AddAtomParm("B",  3.581f, 0.3975f );
	AddAtomParm("F",  3.118f, 0.2552f );
	AddAtomParm("Cl", 3.755f, 0.6849f );

	// Amber (parm99.dat)
	AddAtomParm("OH", 3.067f, 0.8803f );
	AddAtomParm("HO", 0.000f, 0.0000f );
	AddAtomParm("O",  2.960f, 0.8786f );
	AddAtomParm("O2", 2.960f, 0.8786f );
	AddAtomParm("C",  3.400f, 0.3598f );
	AddAtomParm("N3", 3.250f, 0.7113f );
	AddAtomParm("N",  3.250f, 0.7113f );
	AddAtomParm("H",  1.069f, 0.0657f );
	AddAtomParm("HA", 2.598f, 0.0629f );
	AddAtomParm("CA", 3.400f, 0.3603f );
	AddAtomParm("CZ", 3.400f, 0.3603f );
	AddAtomParm("HZ", 2.598f, 0.0629f );
	AddAtomParm("OM", 2.960f, 0.8786f ); // Molecular Oxygen
	AddAtomParm("S6", 3.564f, 1.0465f );


	/*****************************************************/
	/*** Bond parameters                               ***/
	/*** eq. Length (Angstrom), K (KJ*Angstrom^2/mol)  ***/
	/*****************************************************/

	// Liu's Force Field
	AddBondParm("CT", "CT", 1.526f, 1297.0f );
	AddBondParm("CT", "H1", 1.080f, 1423.0f );
	AddBondParm("CW", "H4", 1.070f, 1611.0f );
	AddBondParm("CR", "H5", 1.070f, 1590.0f );
	AddBondParm("CR", "NA", 1.325f, 1674.0f );
	AddBondParm("CW", "NA", 1.378f, 1506.0f );
	AddBondParm("CT", "NA", 1.472f, 1172.0f );
	AddBondParm("CW", "CW", 1.343f, 1715.0f );
	AddBondParm("CT", "HC", 1.090f, 1423.0f );
	AddBondParm("P",  "F",  1.600f,  795.0f );
	AddBondParm("B",  "F",  1.389f, 1213.0f );

	// Amber (parm99.dat)
	AddBondParm("C",  "O2", 1.250f, 2744.7f );
	AddBondParm("C",  "CT", 1.522f, 1326.3f );
	AddBondParm("OH", "HO", 0.960f, 2313.8f );
	AddBondParm("N3", "CT", 1.463f, 1410.0f );
	AddBondParm("N3", "H",  1.010f, 1815.9f );
	AddBondParm("CA", "CA", 1.400f, 1965.1f );
	AddBondParm("CA", "HA", 1.080f, 1537.7f );
	AddBondParm("CZ", "CZ", 1.206f, 2514.0f );
	AddBondParm("CZ", "HZ", 1.056f, 1676.0f );
	AddBondParm("OM", "OM", 1.210f,  700.0f );
	AddBondParm("CT", "F",  1.332f, 1536.3f );
	AddBondParm("CT", "S6", 1.774f, 1063.2f );
	AddBondParm("S6", "O",  1.436f, 2265.0f );


	/********************************************/
	/*** Angle parameters                     ***/
	/*** eq. Angle (deg), K (KJ*rad^2/mol)    ***/
	/********************************************/

	// Liu's Force Field
	AddAngleParm("CT", "CT", "CT", 109.5f, 167.0f );
	AddAngleParm("CT", "CT", "H1", 109.5f, 159.0f );
	AddAngleParm("CT", "CT", "HC", 109.5f, 155.0f );
	AddAngleParm("CT", "CT", "NA", 112.2f, 293.0f );
	AddAngleParm("H1", "CT", "H1", 109.5f, 146.0f );
	AddAngleParm("HC", "CT", "HC", 109.5f, 142.0f );
	AddAngleParm("H1", "CT", "NA", 109.5f, 230.0f );
	AddAngleParm("CW", "NA", "CT", 125.7f, 209.0f );
	AddAngleParm("CR", "NA", "CT", 126.3f, 209.0f );
	AddAngleParm("CW", "CW", "NA", 107.1f, 502.0f );
	AddAngleParm("CR", "NA", "CW", 108.0f, 502.0f );
	AddAngleParm("NA", "CR", "NA", 109.9f, 502.0f );
	AddAngleParm("H4", "CW", "NA", 122.1f, 126.0f );
	AddAngleParm("H5", "CR", "NA", 125.7f, 126.0f );
	AddAngleParm("CW", "CW", "H4", 130.7f, 126.0f );
	AddAngleParm("F",  "P",  "F",   90.0f, 335.0f );
	AddAngleParm("F",  "B",  "F",  109.5f, 209.0f );

	// Amber (parm99.dat)
	AddAngleParm("O2", "C",  "O2", 126.0f, 334.7f );
	AddAngleParm("CT", "C",  "O2", 120.4f, 334.7f );
	AddAngleParm("C",  "CT", "HC", 109.5f, 209.2f );
	AddAngleParm("HO", "OH", "HO", 104.5f, 418.4f );
	AddAngleParm("CT", "N3", "CT", 109.5f, 209.2f );
	AddAngleParm("CT", "N3", "H",  109.5f, 209.2f );
	AddAngleParm("H",  "N3", "H",  109.5f, 146.4f );
	AddAngleParm("N3", "CT", "H1", 109.5f, 209.2f );
	AddAngleParm("N3", "CT", "CT", 111.2f, 334.7f );
	AddAngleParm("CA", "CA", "CA", 120.0f, 264.0f );
	AddAngleParm("CA", "CA", "HA", 120.0f, 209.5f );
	AddAngleParm("CZ", "CZ", "HZ", 180.0f, 209.5f );
	AddAngleParm("F",  "CT", "F",  109.1f, 322.3f );
	AddAngleParm("F",  "CT", "S6", 109.7f, 340.0f );
	AddAngleParm("O",  "S6", "O",  119.7f, 195.3f );
	AddAngleParm("CT", "S6", "O",  108.3f, 174.4f );


	/**********************************************/
	/*** Dihedral parameters                    ***/
	/*** eq. Dihedral (deg), N, K/2 (KJ/mol)    ***/
	/**********************************************/

	// Liu's Force Field
	AddDihedralParm("NA", "CR", "NA", "CW", 180.0f, 2, 50.210f );
	AddDihedralParm("NA", "CR", "NA", "CT", 180.0f, 2,  8.368f );
	AddDihedralParm("H5", "CR", "NA", "CW", 180.0f, 2,  6.276f );
	AddDihedralParm("H5", "CR", "NA", "CT", 180.0f, 2,  6.276f );
	AddDihedralParm("CW", "CW", "NA", "CR", 180.0f, 2, 50.210f );
	AddDihedralParm("CW", "CW", "NA", "CT", 180.0f, 2,  8.368f );
	AddDihedralParm("H4", "CW", "NA", "CR", 180.0f, 2,  8.368f );
	AddDihedralParm("H4", "CW", "NA", "CT", 180.0f, 2,  6.276f );
	AddDihedralParm("NA", "CW", "CW", "H4", 180.0f, 2,  6.276f );
	AddDihedralParm("NA", "CW", "CW", "NA", 180.0f, 2, 50.210f );
	AddDihedralParm("H4", "CW", "CW", "H4", 180.0f, 2,  6.276f );
	AddDihedralParm("CT", "CT", "CT", "H1",   0.0f, 3,  0.669f );
	AddDihedralParm("CT", "CT", "CT", "CT",   0.0f, 3,  1.046f );
	AddDihedralParm("CT", "CT", "CT", "HC",   0.0f, 3,  0.669f );
	AddDihedralParm("NA", "CT", "CT", "CT",   0.0f, 3,  1.046f );
	AddDihedralParm("NA", "CT", "CT", "HC",   0.0f, 3,  0.669f );
	AddDihedralParm("H1", "CT", "CT", "HC",   0.0f, 3,  0.628f );
	AddDihedralParm("HC", "CT", "CT", "HC",   0.0f, 3,  0.628f );
	AddDihedralParm("H1", "CT", "NA", "CW",   0.0f, 3,  1.021f );
	AddDihedralParm("H1", "CT", "NA", "CR",   0.0f, 3,  0.686f );
	AddDihedralParm("CT", "CT", "NA", "CW",   0.0f, 1, -0.745f );
	AddDihedralParm("CT", "CT", "NA", "CR",   0.0f, 1, -0.987f );

	// Amber (parm99.dat)
	AddDihedralParm("HC", "CT", "C",  "O2",   0.0f, 1,  3.347f );
	AddDihedralParm("N3", "CT", "CT", "HC",   0.0f, 1,  0.628f );
	AddDihedralParm("N3", "CT", "CT", "H1",   0.0f, 1,  0.628f );
	AddDihedralParm("N3", "CT", "CT", "CT",   0.0f, 1,  0.628f );
	AddDihedralParm("CT", "N3", "CT", "CT",   0.0f, 1,  0.628f );
	AddDihedralParm("H1", "CT", "N3", "H",    0.0f, 1,  0.628f );
	AddDihedralParm("CT", "CT", "N3", "H",    0.0f, 1,  0.628f );

	AddDihedralParm("CA", "CA", "CA", "CA", 180.0f, 2,  1.255f );
	AddDihedralParm("HA", "CA", "CA", "HA", 180.0f, 2,  12.55f );
	AddDihedralParm("HA", "CA", "CA", "CA",   0.0f, 2,  125.5f );

	AddDihedralParm("O",  "S6", "CT", "F",    0.0f, 3,  5.442f );


	/**********************************************/
	/*** Improper parameters                    ***/
	/*** eq. Dihedral (deg), N, K/2 (KJ/mol)    ***/
	/**********************************************/

	// Liu's Force Field
	AddImproperParm("NA", "NA", "CR", "H5", 180.0f, 2,  4.602f );
	AddImproperParm("CW", "NA", "CW", "H4", 180.0f, 2,  4.602f );
	AddImproperParm("CR", "CW", "NA", "CT", 180.0f, 2,  8.368f );

	// Amber (parm99.dat)
	AddImproperParm("CT", "O2", "C",  "O2", 180.0f, 2, 43.900f );
	AddImproperParm("CA", "CA", "CA", "HA", 180.0f, 2,  4.609f );
}


