/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    http://www.travis-analyzer.de/

    Copyright (c) 2009-2013 Martin Brehm
                  2012-2013 Martin Thomas

    This file written by Martin Brehm.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/


#include "thermo.h"
#include "tools.h"
#include "moltools.h"
#include "globalvar.h"


CThermoAnalysis::CThermoAnalysis()
{
}


CThermoAnalysis::~CThermoAnalysis()
{
}


CThermoGroup::CThermoGroup()
{
}


CThermoGroup::~CThermoGroup()
{
}


void CThermoAnalysis::Parse()
{
	mprintf(WHITE,"\n>>> Thermodynamic Analysis >>>\n\n");

	mprintf("    No further questions at the moment :-)\n");

	g_bUseVelocities = true;

	mprintf(WHITE,"\n<<< End of Thermodynamic Analysis <<<\n\n");
}


void CThermoAnalysis::AnalyzeStep(CTimeStep *t)
{
	double *etotal, *erot, *etrans, *evib, etos, eros, etrs;
	double *ttotal, *trot, *ttrans, *tvib;
	double jx2, jy2, jz2, jxy, jxz, jyz;
	double e;
	int z, z2, z3, z4, ti, n, ng, nm, ns;
	CMolecule *m;
	CSingleMolecule *sm;
	CElement *el;
	CxVector3 mc, v, w, vmc, wt, wi;
	CxMatrix3 j, ji, mr;

	etotal = new double[g_oaMolecules.GetSize()+1];
	erot = new double[g_oaMolecules.GetSize()+1];
	etrans = new double[g_oaMolecules.GetSize()+1];
	evib = new double[g_oaMolecules.GetSize()+1];
	ttotal = new double[g_oaMolecules.GetSize()+1];
	trot = new double[g_oaMolecules.GetSize()+1];
	ttrans = new double[g_oaMolecules.GetSize()+1];
	tvib = new double[g_oaMolecules.GetSize()+1];

	etotal[0] = 0;
	erot[0] = 0;
	etrans[0] = 0;
	evib[0] = 0;
	ttotal[0] = 0;
	trot[0] = 0;
	ttrans[0] = 0;
	tvib[0] = 0;
	ng = 0;
	nm = 0;
	mc = 0;
	vmc = 0;
	ns = 0;

	for (z=0;z<g_oaMolecules.GetSize();z++)
	{
		m = (CMolecule*)g_oaMolecules[z];
		etotal[z+1] = 0;
		erot[z+1] = 0;
		etrans[z+1] = 0;
		evib[z+1] = 0;
		ttotal[z+1] = 0;
		trot[z+1] = 0;
		ttrans[z+1] = 0;
		tvib[z+1] = 0;
		n = 0;
		for (z2=0;z2<m->m_laSingleMolIndex.GetSize();z2++)
		{
			nm++;
			ns = 0;
			sm = (CSingleMolecule*)g_oaSingleMolecules[m->m_laSingleMolIndex[z2]];
			jx2 = 0;
			jy2 = 0;
			jz2 = 0;
			jxz = 0;
			jyz = 0;
			jxy = 0;
			w = CxVector3(0,0,0);
			etos = 0;
			etrs = 0;
			eros = 0;
			for (z3=0;z3<m->m_baAtomIndex.GetSize();z3++)
			{
				if (m->m_baAtomIndex[z3] == g_iVirtAtomType)
				{
					ti = ((CxIntArray*)sm->m_oaAtomOffset[z3])->GetAt(1);
					mc = t->m_vaCoords[ti];
					vmc = t->m_vaVelocities[ti];
					e = m->m_fMass/2.0 * t->m_vaVelocities[ti].GetLengthSqr();
					etrans[z+1] += e;
					etrans[0] += e;
					etrs += e;
					break;
				}
			}
			for (z3=0;z3<m->m_baAtomIndex.GetSize();z3++)
			{
				if (m->m_baAtomIndex[z3] == g_iVirtAtomType)
					continue;
				el = ((CAtom*)g_oaAtoms[m->m_baAtomIndex[z3]])->m_pElement;
				for (z4=0;z4<((CxIntArray*)sm->m_oaAtomOffset[z3])->GetSize();z4++)
				{
					ti = ((CxIntArray*)sm->m_oaAtomOffset[z3])->GetAt(z4);
					e = el->m_fMass/2.0 * t->m_vaVelocities[ti].GetLengthSqr();
					etotal[0] += e;
					etotal[z+1] += e;
					etos += e;
					n++;
					ng++;
					ns++;

					if (m->m_iAtomGesNoVirt > 1)
					{
						v = t->m_vaCoords[ti] - mc;
						jx2 += el->m_fMass*v[0]*v[0];
						jy2 += el->m_fMass*v[1]*v[1];
						jz2 += el->m_fMass*v[2]*v[2];
						jxy += el->m_fMass*v[0]*v[1];
						jxz += el->m_fMass*v[0]*v[2];
						jyz += el->m_fMass*v[1]*v[2];

						wt = CrossP(v,t->m_vaVelocities[ti]-vmc)/*/v.GetLengthSqr()*/*el->m_fMass;
						w += wt;
					}
//					mprintf("\n   %s%d: ( %g | %g | %g ) (%g)",el->m_sLabel,z4+1,wt[0],wt[1],wt[2],wt.GetLength());
//					mprintf("\n   %s%d: etot=%g, erot=%g.",el->m_sLabel,z4+1,e/1e6,0.5*(el->m_fMass*v.GetLengthSqr())*(CrossP(v,t->m_vaVelocities[ti]-vmc).GetLengthSqr()/v.GetLengthSqr()/v.GetLengthSqr()));
//					eros += 0.5*(el->m_fMass*v.GetLengthSqr())*(CrossP(v,t->m_vaVelocities[ti]-vmc).GetLengthSqr()/v.GetLengthSqr()/v.GetLengthSqr());
				}
			}

//			mprintf("\n   Drehimpuls: ( %g | %g | %g ) (%g)",w[0],w[1],w[2],w.GetLength());

//			w /= ns;

			if (m->m_iAtomGesNoVirt > 1)
			{
				j.GetAt(0,0) = jy2 + jz2;
				j.GetAt(0,1) = -jxy;
				j.GetAt(0,2) = -jxz;
				j.GetAt(1,0) = -jxy;
				j.GetAt(1,1) = jx2 + jz2;
				j.GetAt(1,2) = -jyz;
				j.GetAt(2,0) = -jxz;
				j.GetAt(2,1) = -jyz;
				j.GetAt(2,2) = jx2 + jy2;

				ji = j;
				ji.Invert();

	//			mr = j*ji;
	//			mr.Dump();

				wi = ji * w;

	//			mprintf("\n   Winkelgeschwindigkeit: ( %g | %g | %g ) (%g)",wi[0],wi[1],wi[2],wi.GetLength());

				eros = DotP(j*wi,wi) / 2.0;

				erot[0] += eros;
				erot[z+1] += eros;
			}
			evib[z+1] += etos - etrs - eros;
			evib[0] += etos - etrs - eros;
//			mprintf("\nx^2=%g, y^2=%g, z^2=%g, xy=%g, xz=%g, yz=%g, wx=%g, wy=%g, wz=%g, |w|=%g.\n",jx2,jy2,jz2,jxy,jxz,jyz,w[0],w[1],w[2],w.GetLength());
//			mprintf("\n%s[%d]: tot=%g, trans=%g, rot=%g, vib=%g.",m->m_sName,z2+1,etos/1e6,etrs/1e6,eros/1e6,(etos-etrs-eros)/1e6);
		} // END SingleMolecules

		ttotal[z+1] = 2.0/(3.0*n) * etotal[z+1] / 8.3144621 / 1000.0;
		ttrans[z+1] = 2.0/3.0 * etrans[z+1] / m->m_laSingleMolIndex.GetSize() / 8.3144621 / 1000.0;
		trot[z+1] = 2.0/3.0 * erot[z+1] / m->m_laSingleMolIndex.GetSize() / 8.3144621 / 1000.0;
		tvib[z+1] = 2.0/(3.0*ns-6.0) * evib[z+1] / m->m_laSingleMolIndex.GetSize() / 8.3144621 / 1000.0;
	} // END FOR g_oaMolecules

	evib[0] = etotal[0] - etrans[0] - erot[0];
	ttotal[0] = 2.0/(3.0*ng) * etotal[0] / 8.3144621 / 1000.0;
	ttrans[0] = 2.0/3.0 * etrans[0] / nm / 8.3144621 / 1000.0;
	trot[0] = 2.0/3.0 * erot[0] / nm / 8.3144621 / 1000.0;
	tvib[0] = 2.0/(3.0*ng-6*nm) * evib[0] / 8.3144621 / 1000.0;

	fprintf(m_fEner,"%lu;  %g;  %g;  %g;  %g;  ",g_iSteps,etotal[0]/1.0e6,etrans[0]/1.0e6,erot[0]/1.0e6,evib[0]/1.0e6);
	fprintf(m_fTemp,"%lu;  %g;  %g;  %g;  %g;  ",g_iSteps,ttotal[0],ttrans[0],trot[0],tvib[0]);

	for (z=0;z<g_oaMolecules.GetSize();z++)
	{
		fprintf(m_fEner,"%g;  %g;  %g;  %g;  ",etotal[z+1]/1.0e6,etrans[z+1]/1.0e6,erot[z+1]/1.0e6,evib[z+1]/1.0e6);
		fprintf(m_fTemp,"%g;  %g;  %g;  %g;  ",ttotal[z+1],ttrans[z+1],trot[z+1],tvib[z+1]);
	}

	fprintf(m_fEner,"\n");
	fprintf(m_fTemp,"\n");

	delete[] etotal;
	delete[] etrans;
	delete[] erot;
	delete[] evib;
	delete[] ttotal;
	delete[] ttrans;
	delete[] trot;
	delete[] tvib;
}


void CThermoAnalysis::Create()
{
	int z;
	CMolecule *m;

	m_fEner = OpenFileWrite("ener.csv",true);
	m_fTemp = OpenFileWrite("temp.csv",true);

	fprintf(m_fEner,"Step;  total;  trans;  rot;  vib;  ");
	fprintf(m_fTemp,"Step;  total;  trans;  rot;  vib;  ");

	for (z=0;z<g_oaMolecules.GetSize();z++)
	{
		m = (CMolecule*)g_oaMolecules[z];
		fprintf(m_fEner,"%s total;  %s trans;  %s rot;  %s vib;  ",m->m_sName,m->m_sName,m->m_sName,m->m_sName);
		fprintf(m_fTemp,"%s total;  %s trans;  %s rot;  %s vib;  ",m->m_sName,m->m_sName,m->m_sName,m->m_sName);
	}

	fprintf(m_fEner,"\n");
	fprintf(m_fTemp,"\n");
}
