/*
 *   Copyright (C) 2008 Schutz Sacha <istdasklar@gmail.com>
 *   AND lex newton http://qgoogletranslate.googlecode.com
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   or (at your option) any later version, as published by the Free
 *   Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
// Here we avoid loading the header multiple times
#ifndef KTRANSLATOR_HEADER
#define KTRANSLATOR_HEADER
// We need the Plasma Applet headers
#include <KIcon>
#include <KLineEdit>
#include <QGraphicsLinearLayout>
#include <QGraphicsWidget>
#include <QNetworkAccessManager>
#include <QHttp>
#include <QPixmap>

#include <Plasma/PopupApplet>
#include <plasma/widgets/textedit.h>
#include <plasma/widgets/pushbutton.h>
#include <plasma/widgets/toolbutton.h>
#include <plasma/widgets/combobox.h>
#include <plasma/widgets/label.h>
#include <plasma/widgets/meter.h>
#include <plasma/widgets/iconwidget.h>
#include <plasma/widgets/frame.h>
#include <plasma/animator.h>
#include <plasma/widgets/treeview.h>

#include "voiceform.h"
#include "languageform.h"
#include "languagemodel.h"

// Define our plasma Applet
class KTranslatoid : public Plasma::PopupApplet
{
    Q_OBJECT
public:
    // Basic Create/Destroy
    KTranslatoid(QObject *parent, const QVariantList &args);
    ~KTranslatoid();
    QGraphicsWidget *graphicsWidget();
    void constructForm();
    void popupEvent(bool show);
    void readData();
    void writeData();

public slots:
    void translate();
    void changeSens();
    void updateMeter(qint64, qint64);
    void changeButtonA();
    void changeButtonB();
    void copy();
    void paste();
    void tts();
    void configAccepted();
    void collapseLeft(const QModelIndex & index=QModelIndex());
    void setupPopupIcon();
    void updateLanguage(Language a, Language b);
    void done();


protected:
    void createConfigurationInterface(KConfigDialog *parent);
    bool eventFilter ( QObject * obj, QEvent * event ) ;
private:
    QHttp * m_http;

    Plasma::PushButton * m_buttonTranslate;
    Plasma::ToolButton * m_buttonChange;
    Plasma::Meter * m_meter;
    Plasma::TextEdit * m_textEditA;
    Plasma::TextEdit * m_textEditB;
    Plasma::Label * m_labelA;
    Plasma::Label * m_labelB;
    Plasma::ToolButton * m_buttonA;
    Plasma::ToolButton * m_buttonB;
    Plasma::TreeView * m_tree ;
    QGraphicsWidget *m_graphicsWidget;
    QGraphicsLinearLayout* bigLayout;
    LanguageModel * m_languageModel;

    Language m_languageA;
    Language m_languageB;

    VoiceForm * m_voiceForm;
    LanguageForm * m_languageForm;

    KIcon m_popupIcon;
    int m_animId;
    int m_currentButton;
    bool m_autoPaste;
    bool m_autoTranslate;
    QString m_command;


  
};

// This is the command that links your applet to the .desktop file
K_EXPORT_PLASMA_APPLET(translatoid, KTranslatoid)
#endif