/*
 * Copyright (C) 2007 Marylene Ysmal <wiidevel@stacktic.org>
 *
 * pageWiimote.c (TransferMii)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */ 

#include "pageWiimote.h"

static void onWiimoteMacCheck(void);
static void onWiiMacCheck(void);

static void onDownloadButton(void);
static void onUploadFileButton(void);
static void onDeleteButton(void);
static void onChangeMacButton(void);

static void onConnectButton(void);
static void onUpdateButton(void);
static void onDisconnectButton(void);

static void onSelectionChanged(void);

extern void updateStatusBar(char *msg);

static GtkWidget *wiimoteMacCheck;
static GtkWidget *wiimoteMacEntry;

static GtkWidget *wiiMacCheck;
static GtkWidget *wiiMacEntry;

static GtkWidget *nameEntry;
static GtkWidget *creatorEntry;
static GtkWidget *sexRadioMale;
static GtkWidget *sexRadioFemale;
static GtkWidget *macLabel;

static GtkWidget *connectButton;
static GtkWidget *updateButton;
static GtkWidget *disconnectButton;

static GtkWidget *view;

static GtkWidget *uploadFileButton;
static GtkWidget *downloadButton;
static GtkWidget *deleteButton;
static GtkWidget *changeMacButton;

static int old_slot = 0;

GtkWidget* createPageWiimote(){
	GtkWidget *frame;
	GtkWidget *label;

	GtkWidget *mainVBox;
	GtkWidget *HBox;
	GtkWidget *VBox;
	GtkWidget *ButtonBox;

	GtkWidget *table;

	GtkCellRenderer *renderer;
	GtkTreeModel *model;
	GtkListStore *store;
	GtkTreeIter tree_iter;

	GSList *group;
	
	GdkColor color;
	
	char bufferchar[1024];

	int i;
     
	/* Main vbox initialisation */
	mainVBox=gtk_vbox_new(FALSE, 0);

	/* Wiimote's MAC Address frame */
	frame=gtk_frame_new("Wiimote's MAC address");
    	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);

	HBox=gtk_hbox_new(FALSE,5);
    	gtk_container_set_border_width(GTK_CONTAINER(HBox), 5);
	gtk_container_add(GTK_CONTAINER(frame), HBox);

	wiimoteMacCheck=gtk_check_button_new_with_label("Automatic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wiimoteMacCheck), TRUE);
	g_signal_connect_swapped(G_OBJECT(wiimoteMacCheck), "toggled", G_CALLBACK(onWiimoteMacCheck), NULL);
	gtk_box_pack_start(GTK_BOX(HBox), wiimoteMacCheck, TRUE, TRUE, 5);

	label=gtk_label_new("00:19:1D:");
	gtk_box_pack_start(GTK_BOX(HBox), label, FALSE, FALSE, 0);
	
	wiimoteMacEntry=gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(wiimoteMacEntry), 8);
	gtk_box_pack_start(GTK_BOX(HBox), wiimoteMacEntry, TRUE, TRUE, 0);
	gtk_widget_set_sensitive(wiimoteMacEntry, FALSE);

	label=gtk_label_new("(XX:XX:XX)");
	gtk_box_pack_start(GTK_BOX(HBox), label, TRUE, TRUE, 5);

	gtk_box_pack_start(GTK_BOX(mainVBox), frame, TRUE, TRUE, 0);


	/* Wii's MAC Address frame */
	frame=gtk_frame_new("Wii's MAC address");
    	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	

	HBox=gtk_hbox_new(FALSE,5);
    	gtk_container_set_border_width(GTK_CONTAINER(HBox), 5);
	gtk_container_add(GTK_CONTAINER(frame), HBox);

	wiiMacCheck=gtk_check_button_new_with_label("Automatic");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wiiMacCheck), TRUE);
	g_signal_connect_swapped(G_OBJECT(wiiMacCheck), "toggled", G_CALLBACK(onWiiMacCheck), NULL);
	gtk_box_pack_start(GTK_BOX(HBox), wiiMacCheck, TRUE, TRUE, 5);
	
	label=gtk_label_new("00:17:AB:");
	gtk_box_pack_start(GTK_BOX(HBox), label, FALSE, FALSE, 0);

	wiiMacEntry=gtk_entry_new();
	gtk_entry_set_max_length(GTK_ENTRY(wiiMacEntry), 8);
	gtk_box_pack_start(GTK_BOX(HBox), wiiMacEntry, TRUE, TRUE, 0);
	gtk_widget_set_sensitive(wiiMacEntry, FALSE);

	label=gtk_label_new("(XX:XX:XX)");
	gtk_box_pack_start(GTK_BOX(HBox), label, TRUE, TRUE, 5);

	gtk_box_pack_start(GTK_BOX(mainVBox), frame, TRUE, TRUE, 0);


	/* Wiimote's Slots frame */
	frame=gtk_frame_new("Wiimote's Slots");
    	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);

	view=gtk_tree_view_new();
	gtk_widget_set_sensitive(view, FALSE);
	renderer=gtk_cell_renderer_text_new();
	gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view), -1, "Slots", renderer, "text", 0, NULL);
	store=gtk_list_store_new(1, G_TYPE_STRING);

	for(i=1;i<=10;i++){
		sprintf(bufferchar, "Slot %i", i);
		gtk_list_store_append(store, &tree_iter);
		gtk_list_store_set(store, &tree_iter, 0, bufferchar, -1);
  	}
	model=GTK_TREE_MODEL(store);
	gtk_tree_view_set_model(GTK_TREE_VIEW(view), model);
	g_object_unref(model);
	
	g_signal_connect_swapped(G_OBJECT(view), "cursor_changed", G_CALLBACK(onSelectionChanged), NULL);

	HBox=gtk_hbox_new(FALSE, 0);
    	gtk_container_set_border_width(GTK_CONTAINER(HBox), 5);
	gtk_box_pack_start(GTK_BOX(HBox), view, TRUE, TRUE, 0);

	VBox=gtk_vbox_new(FALSE, 0);

	table=gtk_table_new(3, 3, FALSE);
    	gtk_container_set_border_width(GTK_CONTAINER(table), 5);
	gtk_table_set_row_spacings(GTK_TABLE(table),5);
	gtk_table_set_col_spacings(GTK_TABLE(table),5);

	label=gtk_label_new("Name : ");
	nameEntry=gtk_entry_new();
	gtk_widget_set_sensitive(nameEntry, FALSE);
	gtk_entry_set_max_length(GTK_ENTRY(nameEntry), 10);
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), nameEntry, 1, 3, 0, 1);

	label=gtk_label_new("Sex : ");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);

	sexRadioMale=gtk_radio_button_new_with_label(NULL, "Male");
	gtk_table_attach_defaults(GTK_TABLE(table), sexRadioMale, 1, 2, 1, 2);
	group=gtk_radio_button_get_group(GTK_RADIO_BUTTON(sexRadioMale));
	gtk_widget_set_sensitive(sexRadioMale, FALSE);

	sexRadioFemale=gtk_radio_button_new_with_label(group, "Female");
	gtk_table_attach_defaults(GTK_TABLE(table), sexRadioFemale, 2, 3, 1, 2);
	gtk_widget_set_sensitive(sexRadioFemale, FALSE);

	
	label=gtk_label_new("Creator : ");
	creatorEntry=gtk_entry_new();
	gtk_widget_set_sensitive(creatorEntry, FALSE);
	gtk_entry_set_max_length(GTK_ENTRY(creatorEntry), 10);
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(table), creatorEntry, 1, 3, 2, 3);

	gtk_box_pack_start(GTK_BOX(VBox), table, TRUE, TRUE, 0);


	macLabel=gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(VBox), macLabel, TRUE, TRUE, 0);


	ButtonBox=gtk_vbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(ButtonBox),GTK_BUTTONBOX_SPREAD);

	downloadButton=gtk_button_new_with_label("Download");
	g_signal_connect_swapped(G_OBJECT(downloadButton), "clicked", G_CALLBACK(onDownloadButton), NULL);
	gtk_widget_set_sensitive(downloadButton, FALSE);
	gtk_container_add(GTK_CONTAINER(ButtonBox), downloadButton);
	
	uploadFileButton=gtk_button_new_with_label("Upload File");
	g_signal_connect_swapped(G_OBJECT(uploadFileButton), "clicked", G_CALLBACK(onUploadFileButton), NULL);
	gtk_widget_set_sensitive(uploadFileButton, FALSE);
	gtk_container_add(GTK_CONTAINER(ButtonBox), uploadFileButton);

	deleteButton=gtk_button_new_with_label("Delete");
	g_signal_connect_swapped(G_OBJECT(deleteButton), "clicked", G_CALLBACK(onDeleteButton), NULL);
	gtk_widget_set_sensitive(deleteButton, FALSE);
	gtk_container_add(GTK_CONTAINER(ButtonBox), deleteButton);

	changeMacButton=gtk_button_new_with_label("Change MAC");
	g_signal_connect_swapped(G_OBJECT(changeMacButton), "clicked", G_CALLBACK(onChangeMacButton), NULL);
	gtk_widget_set_sensitive(changeMacButton, FALSE);
	gtk_container_add(GTK_CONTAINER(ButtonBox), changeMacButton);

	gtk_box_pack_start(GTK_BOX(VBox), ButtonBox, TRUE, TRUE, 0);

	gtk_box_pack_start(GTK_BOX(HBox), VBox, TRUE, TRUE, 0);

	gtk_container_add(GTK_CONTAINER(frame), HBox);
	gtk_box_pack_start(GTK_BOX(mainVBox), frame, TRUE, TRUE, 0);
	
	/* Bluetooth frame */
	frame=gtk_frame_new("Bluetooth");
    	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);

	ButtonBox=gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(ButtonBox),GTK_BUTTONBOX_SPREAD);

    	gtk_container_set_border_width(GTK_CONTAINER(ButtonBox), 5);
  	gtk_button_box_set_layout(GTK_BUTTON_BOX(ButtonBox),GTK_BUTTONBOX_SPREAD);
	
	connectButton=gtk_button_new_with_label("Connect");
	g_signal_connect_swapped(G_OBJECT(connectButton), "clicked", G_CALLBACK(onConnectButton), NULL);
	gtk_container_add(GTK_CONTAINER(ButtonBox), connectButton);

	updateButton=gtk_button_new_with_label("Update");
	g_signal_connect_swapped(G_OBJECT(updateButton), "clicked", G_CALLBACK(onUpdateButton), NULL);
	gtk_container_add(GTK_CONTAINER(ButtonBox), updateButton);
	gtk_widget_set_sensitive(updateButton, FALSE);

	disconnectButton=gtk_button_new_with_label("Disconnect");
	g_signal_connect_swapped(G_OBJECT(disconnectButton), "clicked", G_CALLBACK(onDisconnectButton), NULL);
	gtk_container_add(GTK_CONTAINER(ButtonBox), disconnectButton);
	gtk_widget_set_sensitive(disconnectButton, FALSE);

	gtk_container_add(GTK_CONTAINER(frame), ButtonBox);

	color.pixel=32;
	color.green=color.blue=0x0000; color.red=0xFFFF;
	gtk_widget_modify_bg(connectButton, GTK_STATE_NORMAL, &color);
	gtk_widget_modify_bg(connectButton, GTK_STATE_PRELIGHT, &color);
	
    	gtk_box_pack_start(GTK_BOX(mainVBox), frame, TRUE, TRUE, 0);
    	    	
    	return mainVBox;
}

void onWiimoteMacCheck(void)
{
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wiimoteMacCheck)))
		gtk_widget_set_sensitive(wiimoteMacEntry, FALSE);
	else 
		gtk_widget_set_sensitive(wiimoteMacEntry, TRUE);
}

void onWiiMacCheck(void)
{
	GtkTreeSelection *selection;
	GtkTreeModel *model;
	GtkTreeIter selected_row;

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));

	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wiiMacCheck))) {
		gtk_widget_set_sensitive(wiiMacEntry, FALSE);
		gtk_widget_set_sensitive(changeMacButton, FALSE);			
	} else {
		gtk_widget_set_sensitive(wiiMacEntry, TRUE);
		if(wm_read && gtk_tree_selection_get_selected(selection, &model, &selected_row))
			gtk_widget_set_sensitive(changeMacButton, TRUE);
	}
}

void onDownloadButton(void)
{
	GtkTreeSelection *selection;
	GtkTreeModel *model;
	GtkTreeIter selected_row;
	int slot;

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	if(!wm_read || !gtk_tree_selection_get_selected(selection, &model, &selected_row))
		return;
	
	slot = (*gtk_tree_model_get_string_from_iter(model,&selected_row))-'0'+1;
	
	GtkWidget *chooserDialog = gtk_file_chooser_dialog_new("Download", NULL,
							       GTK_FILE_CHOOSER_ACTION_SAVE, 
							       GTK_STOCK_CANCEL, 
							       GTK_RESPONSE_CANCEL, 
							       GTK_STOCK_SAVE, 
							       GTK_RESPONSE_OK, 
							       NULL);
	gtk_window_set_modal(GTK_WINDOW(chooserDialog), TRUE);

	if(gtk_dialog_run(GTK_DIALOG(chooserDialog)) != GTK_RESPONSE_OK) {
		gtk_widget_destroy(chooserDialog); 
		return;
	}

	char *fname =  (char*)gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(chooserDialog));
	int size = strlen(fname)+strlen("Writing file ")+1;
	char *msg = malloc(size);
	snprintf(msg, size-1, "Writing file %s\n", fname);
	updateStatusBar(msg);
	free(msg);
	if(fileWrite(fname, slot))
		updateStatusBar("File written");
	else
		updateStatusBar("Writing error");
	gtk_widget_destroy(chooserDialog);
}

void onUploadFileButton(void)
{
	GtkTreeSelection *selection;
	GtkTreeModel *model;
	GtkTreeIter selected_row;
	int slot;
	
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	if(!wm_read || !gtk_tree_selection_get_selected(selection, &model, &selected_row))
		return;
	
	slot = (*gtk_tree_model_get_string_from_iter(model,&selected_row))-'0'+1;
	
	GtkWidget *chooserDialog = gtk_file_chooser_dialog_new("Upload", 
							       NULL, 
							       GTK_FILE_CHOOSER_ACTION_OPEN,
							       GTK_STOCK_CANCEL,
							       GTK_RESPONSE_CANCEL,
							       GTK_STOCK_OPEN,
							       GTK_RESPONSE_OK,
							       NULL);
	gtk_window_set_modal(GTK_WINDOW(chooserDialog), TRUE);

	if(gtk_dialog_run(GTK_DIALOG(chooserDialog)) != GTK_RESPONSE_OK) {
		gtk_widget_destroy(chooserDialog); 
		return;
	}

	char *fname =  (char*)gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(chooserDialog));
	int size = strlen(fname)+strlen("Reading file ")+1;
	char *msg = malloc(size);
	snprintf(msg, size-1, "Reading file %s\n", fname);
	updateStatusBar(msg);
	free(msg);
	if(addMii(fname, slot))
		updateStatusBar("mii added");
	else
		updateStatusBar("mii not added");
	gtk_widget_destroy(chooserDialog);
	onSelectionChanged();
}

void onDeleteButton(void)
{
	GtkTreeSelection *selection;
	GtkTreeModel *model;
	GtkTreeIter selected_row;
	int slot;

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	if(!wm_read || !gtk_tree_selection_get_selected(selection, &model, &selected_row))
		return;
	slot = (*gtk_tree_model_get_string_from_iter(model,&selected_row))-'0'+1;
	if(delMii(slot)) {
		char msg[] = "mii slot 0x deleted";
		if(slot == 10) {
			msg[9] = '1';
			msg[10] = '0';
		} else if(slot<10)
			msg[10] = slot+'0';
		updateStatusBar(msg);
		onSelectionChanged();
	}
}

void onChangeMacButton(void)
{
	GtkTreeSelection *selection;
	GtkTreeModel *model;
	GtkTreeIter selected_row;
	char tmp[11];
	tmp[10] = '\0';

	if(!wm_read || gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wiiMacCheck)))
		return;
	strncpy(tmp, (char*)gtk_entry_get_text(GTK_ENTRY(wiiMacEntry)), 10);
	if(!parseMacAddress(tmp)) {
		updateStatusBar("Mac address incorrect");
		return;
	}
	
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	if(!gtk_tree_selection_get_selected(selection, &model, &selected_row))
		return;
	setMacAddress((*gtk_tree_model_get_string_from_iter(model,&selected_row))-'0'+1);
	onSelectionChanged();
}

void onConnectButton(void)
{
	GdkColor color;
	color.pixel=32;
	color.red=color.blue=0x0000; color.green=0xFFFF;

	
	if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wiimoteMacCheck))) {
		char tmpmac[19];
		snprintf(tmpmac, 18, "00:19:1D:%s", 
			 gtk_entry_get_text(GTK_ENTRY(wiimoteMacEntry)));
		str2ba(tmpmac, &ba);
		printf("Connecting to the wiimote...\n");
	} else
		printf("Please press 1+2 on the wiimote\n");
	
	if(!wiimoteConnect()) {
		updateStatusBar("Could not connect to the wiimote");
		return;
	}
	if(!wiimoteRead()) {
		updateStatusBar("Could not read the wiimote");
		return;
	}

	updateStatusBar("Connected");
	gtk_widget_set_sensitive(view, TRUE);
	gtk_widget_set_sensitive(connectButton, FALSE);
	gtk_widget_set_sensitive(updateButton, TRUE);
	gtk_widget_set_sensitive(disconnectButton, TRUE);
	gtk_widget_modify_bg(connectButton, GTK_STATE_INSENSITIVE, &color);
}

void onUpdateButton(void)
{
	if(!wm_read)
		return;
	GtkWidget *msgDialog = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL,
						      GTK_MESSAGE_QUESTION,
						      GTK_BUTTONS_OK_CANCEL,
						      "Update the wiimote ?");
	if(gtk_dialog_run(GTK_DIALOG(msgDialog)) != GTK_RESPONSE_OK) {
		gtk_widget_destroy(msgDialog); 
		return;
	}
	wm_update=TRUE;
	wiimoteWrite();
	gtk_widget_destroy(msgDialog);
	updateStatusBar("Updating...");
	if(wiimoteWrite())
		updateStatusBar("Updated");
	else
		updateStatusBar("Update Error");
}

void onDisconnectButton(void)
{
	GdkColor color;
	color.pixel=32;
	color.green=color.blue=0x0000; color.red=0xFFFF;
	extern bool wm_auto_update;

	GtkWidget *msgDialog = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL, 
						      GTK_MESSAGE_QUESTION, 
						      GTK_BUTTONS_YES_NO, 
						      "Update the wiimote before disconnecting ?");
	if(gtk_dialog_run(GTK_DIALOG(msgDialog)) == GTK_RESPONSE_YES) {
		wm_auto_update=TRUE;
		GtkTreeSelection *selection;
		GtkTreeModel *model;
		GtkTreeIter selected_row;
		
		selection=gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
		if(gtk_tree_selection_get_selected(selection, &model, &selected_row)) {
		       	int slot =((*gtk_tree_model_get_string_from_iter(model,&selected_row))-'0')+1;
			char *name, buff[MII_NAME_LENGTH_CHAR+1];

			name = (char*)gtk_entry_get_text(GTK_ENTRY(nameEntry));
			getMiiNameAscii(buff, slot);
			if(*name && strcmp(buff, name)) {
				setMiiNameAscii(name, slot);
				wm_update = TRUE;
			}
			name = (char*)gtk_entry_get_text(GTK_ENTRY(creatorEntry));
			getMiiCreatorAscii(buff, slot);
			if(*name && strcmp(buff, name)) {
				setMiiCreatorAscii(name, slot);
				wm_update = TRUE;
			}
		
			if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(sexRadioMale)) && 
			   getMiiSex(slot)=='F') {
				setMiiSex('M', slot);
				wm_update = TRUE;
			} else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(sexRadioFemale)) &&
				getMiiSex(slot)=='M') {
				setMiiSex('F', slot);
				wm_update = TRUE;
			}
		}
	}
	gtk_widget_destroy(msgDialog);
	wiimoteDisconnect();

	gtk_widget_set_sensitive(view, FALSE);
	gtk_widget_set_sensitive(nameEntry, FALSE);
	gtk_widget_set_sensitive(creatorEntry, FALSE);
	gtk_widget_set_sensitive(sexRadioFemale, FALSE);
	gtk_widget_set_sensitive(sexRadioMale, FALSE);	
	gtk_widget_set_sensitive(downloadButton, FALSE);
	gtk_widget_set_sensitive(uploadFileButton, FALSE);
	gtk_widget_set_sensitive(deleteButton, FALSE);
	gtk_widget_set_sensitive(changeMacButton, FALSE);	
	gtk_widget_set_sensitive(connectButton, TRUE);
	gtk_widget_set_sensitive(updateButton, FALSE);
	gtk_widget_set_sensitive(disconnectButton, FALSE);
	
	gtk_widget_modify_bg(connectButton, GTK_STATE_INSENSITIVE, &color);
	
	gtk_label_set_text(GTK_LABEL(macLabel), "");
	gtk_entry_set_text(GTK_ENTRY(nameEntry), "");
	gtk_entry_set_text(GTK_ENTRY(creatorEntry), "");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sexRadioMale), TRUE);
	
	updateStatusBar("Disconnected");
}

void onSelectionChanged(void)
{
	int slot;
	char buffMiiName[MII_NAME_LENGTH_CHAR+1];
	char buffMiiCreator[MII_CREATOR_LENGTH_CHAR+1];
		
	GtkTreeSelection *selection;
	GtkTreeModel *model;
	GtkTreeIter selected_row;

	selection=gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	if(!wm_read || 
	   !gtk_tree_selection_get_selected(selection, &model, &selected_row))
		return;

	slot=((*gtk_tree_model_get_string_from_iter(model,&selected_row))-'0'+1);
	
	if(old_slot && !miiIsEmpty(slot)) {
		char *name, buff[MII_NAME_LENGTH_CHAR+1];
		
		name = (char*)gtk_entry_get_text(GTK_ENTRY(nameEntry));
		getMiiNameAscii(buff, old_slot);
		if(*name && strcmp(buff, name)) {
			setMiiNameAscii(name, old_slot);
			wm_update = TRUE;
		}
		name = (char*)gtk_entry_get_text(GTK_ENTRY(creatorEntry));
		getMiiCreatorAscii(buff, old_slot);
		if(*name && strcmp(buff, name)) {
			setMiiCreatorAscii(name, old_slot);
			wm_update = TRUE;
		}
		
		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(sexRadioMale)) && 
		   getMiiSex(old_slot)=='F') {
			setMiiSex('M', old_slot);
			wm_update = TRUE;
		} else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(sexRadioFemale)) &&
			getMiiSex(old_slot)=='M') {
			setMiiSex('F', old_slot);
			wm_update = TRUE;
		}
	}

	old_slot = slot;

	if(miiIsEmpty(slot)) {
		gtk_widget_set_sensitive(downloadButton, FALSE);
		gtk_widget_set_sensitive(uploadFileButton, TRUE);
		gtk_widget_set_sensitive(deleteButton, FALSE);
		gtk_widget_set_sensitive(changeMacButton, FALSE);

		gtk_widget_set_sensitive(nameEntry, FALSE);
		gtk_widget_set_sensitive(creatorEntry, FALSE);
		gtk_widget_set_sensitive(sexRadioFemale, FALSE);
		gtk_widget_set_sensitive(sexRadioMale, FALSE);
		gtk_label_set_text(GTK_LABEL(macLabel), "");
	} else {
		gtk_widget_set_sensitive(downloadButton, TRUE);
		gtk_widget_set_sensitive(uploadFileButton, TRUE);
		gtk_widget_set_sensitive(deleteButton, TRUE);

		gtk_widget_set_sensitive(nameEntry, TRUE);
		gtk_widget_set_sensitive(creatorEntry, TRUE);
		gtk_widget_set_sensitive(sexRadioFemale, TRUE);
		gtk_widget_set_sensitive(sexRadioMale, TRUE);	

		unsigned char mactmp[3];
		char labtmp[23+9+9];
		getMiiMacAddress(mactmp, slot);
		snprintf(labtmp, 40, "Current mac address : 00:17:ab:%2x:%2x:%2x", mactmp[0], mactmp[1], mactmp[2]);
		gtk_label_set_text(GTK_LABEL(macLabel), labtmp);
		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wiiMacCheck)))
			gtk_widget_set_sensitive(changeMacButton, FALSE);
		else
			gtk_widget_set_sensitive(changeMacButton, TRUE);
	}

	getMiiNameAscii(buffMiiName, slot);
	gtk_entry_set_text(GTK_ENTRY(nameEntry), buffMiiName);
	
	getMiiCreatorAscii(buffMiiCreator, slot);
	gtk_entry_set_text(GTK_ENTRY(creatorEntry), buffMiiCreator);	

	if(getMiiSex(slot) == 'F')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sexRadioFemale), TRUE);
	else
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sexRadioMale), TRUE);
}
