/*
 * Copyright (C) 2007 Marylene Ysmal <wiidevel@stacktic.org>
 *
 * pageLocal.c (TransferMii)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */ 

#include "pageLocal.h"

extern void updateStatusBar(char *msg);

static void onFileButton(void);
static void onUpdateButton(void);

static GtkWidget *fileButton;
static GtkWidget *nameEntry;
static GtkWidget *creatorEntry;
static GtkWidget *sexRadioMale;
static GtkWidget *sexRadioFemale;
static GtkWidget *updateButton;

GtkWidget* createPageLocal(void){
	GtkWidget *frame;
	GtkWidget *label;
	
	GtkWidget *mainVBox;
	GtkWidget *HBox;
	GtkWidget *VButtonBox;

	GtkWidget *table;

	GSList *group;

	/* Main vbox initialisation */
	mainVBox=gtk_vbox_new(FALSE, 0);
	
	
	/* File frame */
	frame=gtk_frame_new("Select a local file");
    	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);

	HBox=gtk_hbox_new(TRUE, 0);
    	gtk_container_set_border_width(GTK_CONTAINER(HBox), 5);
	fileButton=gtk_file_chooser_button_new("Choose a Mii file", GTK_FILE_CHOOSER_ACTION_OPEN);
	g_signal_connect_swapped(G_OBJECT(fileButton), "selection-changed", G_CALLBACK(onFileButton), NULL);
    	gtk_box_pack_start(GTK_BOX(HBox), fileButton, TRUE, TRUE, 0);

	gtk_container_add(GTK_CONTAINER(frame), HBox);
    	gtk_box_pack_start(GTK_BOX(mainVBox), frame, FALSE, FALSE, 0);
    	

	/* Details frame */
	frame=gtk_frame_new("Details");
    	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
    	
	HBox=gtk_hbox_new(FALSE, 0);

	table=gtk_table_new(3, 3, FALSE);
    	gtk_container_set_border_width(GTK_CONTAINER(table), 5);
	gtk_table_set_row_spacings(GTK_TABLE(table),5);
	gtk_table_set_col_spacings(GTK_TABLE(table),5);

	label=gtk_label_new("Name : ");
	nameEntry=gtk_entry_new();
	gtk_widget_set_sensitive(nameEntry, FALSE);
	gtk_entry_set_max_length(GTK_ENTRY(nameEntry), 10);
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), nameEntry, 1, 3, 0, 1);

	label=gtk_label_new("Sex : ");
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);
	sexRadioMale=gtk_radio_button_new_with_label (NULL, "Male");
	gtk_table_attach_defaults(GTK_TABLE(table), sexRadioMale, 1, 2, 1, 2);
	group=gtk_radio_button_get_group(GTK_RADIO_BUTTON (sexRadioMale));
	sexRadioFemale=gtk_radio_button_new_with_label(group, "Female");
	gtk_widget_set_sensitive(sexRadioFemale, FALSE);
	gtk_widget_set_sensitive(sexRadioMale, FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), sexRadioFemale, 2, 3, 1, 2);

	label=gtk_label_new("Creator : ");
	creatorEntry=gtk_entry_new();
	gtk_widget_set_sensitive(creatorEntry, FALSE);
	gtk_entry_set_max_length(GTK_ENTRY(creatorEntry), 10);
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(table), creatorEntry, 1, 3, 2, 3);

	gtk_box_pack_start(GTK_BOX(HBox), table, TRUE, TRUE, 0);

	VButtonBox=gtk_vbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(VButtonBox),GTK_BUTTONBOX_SPREAD);
	updateButton=gtk_button_new_with_label("Update");
	g_signal_connect_swapped(G_OBJECT(updateButton), "clicked", G_CALLBACK(onUpdateButton), NULL);
	gtk_widget_set_sensitive(updateButton, FALSE);
	gtk_container_add(GTK_CONTAINER(VButtonBox), updateButton);

	gtk_box_pack_start(GTK_BOX(HBox), VButtonBox, TRUE, TRUE, 0);
	gtk_container_add(GTK_CONTAINER(frame), HBox);
	gtk_box_pack_start(GTK_BOX(mainVBox), frame, FALSE, FALSE, 0);
	
	return mainVBox;
}

void onFileButton(void){
	if(fileRead(gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(fileButton)))){
		if(miiIsEmpty(0)) {
			gtk_widget_set_sensitive(nameEntry, FALSE);
			gtk_widget_set_sensitive(creatorEntry, FALSE);
			gtk_widget_set_sensitive(sexRadioFemale, FALSE);
			gtk_widget_set_sensitive(sexRadioMale, FALSE);
			gtk_widget_set_sensitive(updateButton, FALSE);
			updateStatusBar("mii empty");
			return;
		}
		else {
			gtk_widget_set_sensitive(nameEntry, TRUE);
			gtk_widget_set_sensitive(creatorEntry, TRUE);
			gtk_widget_set_sensitive(sexRadioFemale, TRUE);
			gtk_widget_set_sensitive(sexRadioMale, TRUE);
			gtk_widget_set_sensitive(updateButton, TRUE);
		}

		char buffMiiName[MII_NAME_LENGTH_CHAR+1];
		char buffMiiCreator[MII_CREATOR_LENGTH_CHAR+1];
		getMiiNameAscii(buffMiiName, 0);
		getMiiCreatorAscii(buffMiiCreator, 0);
		gtk_entry_set_text(GTK_ENTRY(nameEntry), buffMiiName);
		gtk_entry_set_text(GTK_ENTRY(creatorEntry), buffMiiCreator);
		if(getMiiSex(0) == 'F')
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sexRadioFemale), TRUE);
		else
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sexRadioMale), TRUE);
	} 
	else
		updateStatusBar("Error reading file");
	return;
}

void onUpdateButton(void){
	/*
	if(gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(fileButton)) == NULL){
		updateStatusBar("Please select a file\n");
		return;
	}
	*/

	if(!(setMiiNameAscii((char*) gtk_entry_get_text(GTK_ENTRY(nameEntry)),0))){
		updateStatusBar("Error setting name");
		return;
	}
	
	if(!(setMiiCreatorAscii((char *)gtk_entry_get_text(GTK_ENTRY(creatorEntry)),0))){
		updateStatusBar("Error setting creator");
		return;
	}
	
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(sexRadioFemale))){
		if(!(setMiiSex('F', 0))){
			updateStatusBar("Error setting sex");
			return;
		}
	} 
	else {
		if(!(setMiiSex('M', 0))){
			updateStatusBar("Error setting sex");
			return;
		}
	}
	fileWrite(gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(fileButton)), 0);
	return;
}
