/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

/* options.c by Gopal Narayanan
 * This file pops up the options menu choices
 */

#include <stdio.h>
#include <gtk/gtk.h>
#include <string.h>
#include <time.h>
#include "transcalc.h"
#include "options.h"

/*#include "units.h"*/

extern void transtype (gpointer );
extern char *get_config_filename (void);

GtkWidget *freq_combo, *length_combo, *res_combo, *ang_combo;


void
options_save ( GtkWidget *widget, 
	       gpointer data)
{
  char *config_filename = get_config_filename ();
  time_t date;
  FILE *fp;
  
  fp = fopen(config_filename, "w");
  g_free(config_filename);

  if (fp != NULL) {/* no problems opening file */
    /* write header */
    fprintf(fp, "# This config file was automatically generated\n");
    fprintf(fp, "#   by transcalc on %s", ctime(&date));
    fprintf(fp, "# Freq. unit: GHz(%1d), Hz(%1d), kHz(%1d), MHz(%1d).\n",
	    FREQ_GHZ, FREQ_HZ, FREQ_KHZ, FREQ_MHZ);
    fprintf(fp, "# Length unit: mil(%1d), cm(%1d), mm(%1d), m(%1d), um(%1d), in(%1d), ft(%1d).\n", 
	    LENGTH_MIL, LENGTH_CM, LENGTH_MM, LENGTH_M, LENGTH_UM, LENGTH_IN, LENGTH_FT);
    fprintf(fp, "# Resistance unit: Ohm(%1d), kOhm(%1d).\n", RES_OHM, RES_KOHM);
    fprintf(fp, "# Angle unit: Deg(%1d), Rad(%1d).\n", ANG_DEG, ANG_RAD);
    
    fprintf (fp, "Frequency %d\n", freq_unit);
    fprintf (fp, "Length %d\n", length_unit);
    fprintf (fp, "Resistance %d\n",res_unit);
    fprintf (fp, "Angle %d\n", ang_unit);
    fclose(fp);
  }
}

/* callback for when freq. options are changed */

void 
options_freq_combo_CB ( GtkWidget *widget,
			     gpointer data)
{
  gchar *text;

  if ((text = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO(freq_combo)->entry))) != NULL)
    {
      if ((strcmp(text,"GHz")) == 0) freq_unit = FREQ_GHZ;
      if ((strcmp(text,"Hz")) == 0) freq_unit = FREQ_HZ;
      if ((strcmp(text,"kHz")) == 0) freq_unit = FREQ_KHZ;
      if ((strcmp(text,"MHz")) == 0) freq_unit = FREQ_MHZ;
    }
  transtype(data);
}

/* callback for when length options are changed */

void 
options_length_combo_CB ( GtkWidget *widget,
			     gpointer data)
{
  gchar *text;

  if ((text = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO(length_combo)->entry))) != NULL)
    {
      if ((strcmp(text,"mil")) == 0) length_unit = LENGTH_MIL;
      if ((strcmp(text,"cm")) == 0) length_unit = LENGTH_CM;
      if ((strcmp(text,"mm")) == 0) length_unit = LENGTH_MM;
      if ((strcmp(text,"m")) == 0) length_unit = LENGTH_M;
      if ((strcmp(text,"um")) == 0) length_unit = LENGTH_UM;
      if ((strcmp(text,"in")) == 0) length_unit = LENGTH_IN;
      if ((strcmp(text,"ft")) == 0) length_unit = LENGTH_FT;
    }
    transtype(data);
}


/* callback for when resistance options are changed */

void 
options_res_combo_CB ( GtkWidget *widget,
			     gpointer data)
{
  gchar *text;

  if ((text = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO(res_combo)->entry))) != NULL)
    {
      if ((strcmp(text,"Ohm")) == 0) res_unit = RES_OHM;
      if ((strcmp(text,"kOhm")) == 0) res_unit = RES_KOHM;
    }
  transtype(data);
}

/* callback for when angle options are changed */

void 
options_ang_combo_CB ( GtkWidget *widget,
			     gpointer data)
{
  gchar *text;

  if ((text = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO(ang_combo)->entry))) != NULL)
    {
      if ((strcmp(text,"deg")) == 0) ang_unit = ANG_DEG;
      if ((strcmp(text,"rad")) == 0) ang_unit = ANG_RAD;
    }
  transtype(data);
}


/* pops up a new window with options for units */

void 
optionsCB (gpointer parent) 
{

  GtkWidget *optionwin;
  GList *glist = NULL;     /* list of options for freq., length, 
			      resistance and angle */ 
  GtkWidget *label;
  GtkWidget *table;
  GtkWidget *button;
  gchar *unittext;
  GList *widget_list;
  GtkWidget *vbox;
  

  optionwin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (optionwin), "Options");

  gtk_signal_connect (GTK_OBJECT (optionwin), "destroy",
		      GTK_SIGNAL_FUNC (gtk_widget_destroyed), &optionwin);

  gtk_container_border_width (GTK_CONTAINER (optionwin), 5);

  /* Get the real vbox where main body is packed */
  widget_list = gtk_container_children(GTK_CONTAINER (tgui->vertbox));
 
  if ( GTK_IS_VBOX(GTK_OBJECT(widget_list->data)) ) {
    vbox = GTK_WIDGET(widget_list->data);
  }


  /* Make a table of 5 rows and 2 cols to put the options into */
  table = gtk_table_new (5, 2, TRUE);

  /*  vbox = gtk_vbox_new (FALSE, 0); */
  gtk_container_add (GTK_CONTAINER (optionwin), table);
  /*  gtk_widget_show (vbox); */
  
  /* first row of table - freq information */

  label = gtk_label_new ("Freq.:");
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  gtk_widget_show (label);

  freq_combo = gtk_combo_new ();
  gtk_widget_set_usize (GTK_WIDGET (freq_combo), 100, -1);


  if ((unittext = (char *) malloc(10*sizeof(char)))  == NULL){
    perror("unit text error: malloc");
    return;
  }


  /* set the freq combo box */
  glist = g_list_append(glist, "GHz");
  glist = g_list_append(glist, "Hz");
  glist = g_list_append(glist, "kHz");
  glist = g_list_append(glist, "MHz");

  gtk_combo_set_popdown_strings (GTK_COMBO (freq_combo), glist);
  switch (freq_unit) {
  case FREQ_GHZ:
    strcpy(unittext,"GHz");
    break;
  case FREQ_HZ:
    strcpy(unittext,"Hz");
    break;    
  case FREQ_KHZ:
    strcpy(unittext,"kHz");
    break;
  case FREQ_MHZ:
    strcpy(unittext,"MHz");
    break;
  }
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (freq_combo)->entry), unittext);


  /* Now we can free the glist from memory */
  g_list_free (glist);

  /* make the combo entry box uneditable*/
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (freq_combo)->entry), FALSE);

  /* hook it upto a callback function to sense when a change has occured */
  gtk_signal_connect(GTK_OBJECT (GTK_COMBO (freq_combo)->entry), "changed",
                             GTK_SIGNAL_FUNC (options_freq_combo_CB),
                             parent);
  gtk_table_attach_defaults (GTK_TABLE (table), freq_combo, 1, 2, 0, 1);
  gtk_widget_show (freq_combo);

  /* Second row - length information */

  label = gtk_label_new ("Length:");
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
  gtk_widget_show (label);

  length_combo = gtk_combo_new ();
  gtk_widget_set_usize (GTK_WIDGET (length_combo), 100, -1);


  /* set the length combo box */
  glist = NULL;
  glist = g_list_append(glist, "mil");
  glist = g_list_append(glist, "cm");
  glist = g_list_append(glist, "mm");
  glist = g_list_append(glist, "m");
  glist = g_list_append(glist, "um");  
  glist = g_list_append(glist, "in");
  glist = g_list_append(glist, "ft");


  gtk_combo_set_popdown_strings (GTK_COMBO (length_combo), glist);
  switch(length_unit) {
  case LENGTH_MIL:
    strcpy(unittext,"mil");
    break;
  case LENGTH_CM:
    strcpy(unittext,"cm");
    break;
  case LENGTH_MM:
    strcpy(unittext,"mm");
    break;
  case LENGTH_M:
    strcpy(unittext,"m");
    break;
  case LENGTH_UM:
    strcpy(unittext,"um");
    break;
  case LENGTH_IN:
    strcpy(unittext,"in");
    break;
  case LENGTH_FT:
    strcpy(unittext,"ft");
    break;
  }

  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (length_combo)->entry), unittext);


  /* Now we can free the glist from memory */
  g_list_free (glist);

  /* make the combo entry box uneditable*/
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (length_combo)->entry), FALSE);

  /* hook it upto a callback function to sense when a change has occured */
  gtk_signal_connect(GTK_OBJECT (GTK_COMBO (length_combo)->entry), "changed",
                             GTK_SIGNAL_FUNC (options_length_combo_CB),
                             parent);
  gtk_table_attach_defaults (GTK_TABLE (table), length_combo, 1, 2, 1, 2); 
  gtk_widget_show (length_combo);


  /* Third row - resistance information */

  label = gtk_label_new ("Res.:");
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);
  gtk_widget_show (label);

  res_combo = gtk_combo_new ();
  gtk_widget_set_usize (GTK_WIDGET (res_combo), 100, -1);


  /* set the length combo box */
  glist = NULL;
  glist = g_list_append(glist, "Ohm");
  glist = g_list_append(glist, "kOhm");


  gtk_combo_set_popdown_strings (GTK_COMBO (res_combo), glist);
  switch (res_unit) {
  case RES_OHM:
    strcpy(unittext,"Ohm");
    break;
  case RES_KOHM:
    strcpy(unittext,"kOhm");
    break;
  }
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (res_combo)->entry), unittext);


  /* Now we can free the glist from memory */
  g_list_free (glist);

  /* make the combo entry box uneditable*/
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (res_combo)->entry), FALSE);

  /* hook it upto a callback function to sense when a change has occured */
  gtk_signal_connect(GTK_OBJECT (GTK_COMBO (res_combo)->entry), "changed",
                             GTK_SIGNAL_FUNC (options_res_combo_CB),
                             parent);
  gtk_table_attach_defaults (GTK_TABLE (table), res_combo, 1, 2, 2, 3); 
  gtk_widget_show (res_combo);

  /* Fourth row - angle information */

  label = gtk_label_new ("Angle:");
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 3, 4);
  gtk_widget_show (label);

  ang_combo = gtk_combo_new ();
  gtk_widget_set_usize (GTK_WIDGET (ang_combo), 100, -1);


  /* set the length combo box */
  glist = NULL;
  glist = g_list_append(glist, "deg");
  glist = g_list_append(glist, "rad");


  gtk_combo_set_popdown_strings (GTK_COMBO (ang_combo), glist);
  switch (ang_unit) {
  case ANG_DEG:
    strcpy(unittext,"deg");
    break;
  case ANG_RAD:
    strcpy(unittext,"rad");
    break;
  }
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (ang_combo)->entry), unittext);
  free(unittext);

  /* Now we can free the glist from memory */
  g_list_free (glist);

  /* make the combo entry box uneditable*/
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (ang_combo)->entry), FALSE);

  /* hook it upto a callback function to sense when a change has occured */
  gtk_signal_connect(GTK_OBJECT (GTK_COMBO (ang_combo)->entry), "changed",
                             GTK_SIGNAL_FUNC (options_ang_combo_CB),
                             parent);
  gtk_table_attach_defaults (GTK_TABLE (table), ang_combo, 1, 2, 3, 4); 
  gtk_widget_show (ang_combo);


  button = gtk_button_new_with_label ("Save As Default");
  gtk_table_attach_defaults (GTK_TABLE (table), button, 0, 1, 4, 5);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                             GTK_SIGNAL_FUNC (options_save), 
			     NULL);
  gtk_widget_show (button);  

  button = gtk_button_new_with_label ("Dismiss");
  gtk_table_attach_defaults (GTK_TABLE (table), button, 1, 2, 4, 5);
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (optionwin));
  gtk_widget_show (button);

  gtk_widget_show (table);
  gtk_widget_show (optionwin);

}
  



