/*
	**
	** util.h
	**
	** Miscellaneous utility routines
	**
	** Copyright 1998-1999 Damien Miller <dmiller@ilogic.com.au>
	**
	** This software is licensed under the terms of the GNU General 
	** Public License (GPL). Please see the file COPYING for details.
	** 
	** $Id: util.h,v 1.4 1999/02/10 12:29:20 dmiller Exp $
	**
 */

#ifndef _UTIL_H
#define _UTIL_H

#include <stdlib.h>

/* Allocates s bytes, checking for allocation errors */
void *util_malloc(size_t s);

/* Allocates s zero-filled bytes, checking for allocation errors */
void *util_zmalloc(size_t s);

/* Duplicates string s, checking for allocation errors */
void *util_strdup(const char *s);

/* Resizes allocation m to s bytes, checking for allocation errors */
void *util_realloc(void *m, size_t s);

/* Seeds RNG  */
void util_seed_rng(void);

/* Parses IP address and mask */
int parse_address_and_mask(const char *addrspec, u_int32_t *address, u_int32_t *mask);

#endif /* _UTIL_H */
