/* tracker-view.c generated by valac 0.14.2, the Vala compiler
 * generated from tracker-view.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define TRACKER_TYPE_VIEW (tracker_view_get_type ())
#define TRACKER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_VIEW, TrackerView))
#define TRACKER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_VIEW, TrackerViewClass))
#define TRACKER_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_VIEW))
#define TRACKER_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_VIEW))
#define TRACKER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_VIEW, TrackerViewClass))

typedef struct _TrackerView TrackerView;
typedef struct _TrackerViewClass TrackerViewClass;
typedef struct _TrackerViewPrivate TrackerViewPrivate;

#define TRACKER_VIEW_TYPE_DISPLAY (tracker_view_display_get_type ())

#define TRACKER_TYPE_RESULT_STORE (tracker_result_store_get_type ())
#define TRACKER_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStore))
#define TRACKER_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))
#define TRACKER_IS_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_IS_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_RESULT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))

typedef struct _TrackerResultStore TrackerResultStore;
typedef struct _TrackerResultStoreClass TrackerResultStoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define TRACKER_QUERY_TYPE_TYPE (tracker_query_type_get_type ())
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
typedef struct _Block5Data Block5Data;

#define TYPE_TRACKER_TAGS_VIEW (tracker_tags_view_get_type ())
#define TRACKER_TAGS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_TAGS_VIEW, TrackerTagsView))
#define TRACKER_TAGS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_TAGS_VIEW, TrackerTagsViewClass))
#define IS_TRACKER_TAGS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_TAGS_VIEW))
#define IS_TRACKER_TAGS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_TAGS_VIEW))
#define TRACKER_TAGS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_TAGS_VIEW, TrackerTagsViewClass))

typedef struct _TrackerTagsView TrackerTagsView;
typedef struct _TrackerTagsViewClass TrackerTagsViewClass;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

struct _TrackerView {
	GtkScrolledWindow parent_instance;
	TrackerViewPrivate * priv;
};

struct _TrackerViewClass {
	GtkScrolledWindowClass parent_class;
};

typedef enum  {
	TRACKER_VIEW_DISPLAY_NO_RESULTS,
	TRACKER_VIEW_DISPLAY_CATEGORIES,
	TRACKER_VIEW_DISPLAY_FILE_LIST,
	TRACKER_VIEW_DISPLAY_FILE_ICONS
} TrackerViewDisplay;

struct _TrackerViewPrivate {
	TrackerViewDisplay _display;
	TrackerResultStore* _store;
	GtkWidget* view;
	GtkMenu* context_menu;
};

typedef enum  {
	TRACKER_QUERY_TYPE_ALL,
	TRACKER_QUERY_TYPE_CONTACTS,
	TRACKER_QUERY_TYPE_APPLICATIONS,
	TRACKER_QUERY_TYPE_MUSIC,
	TRACKER_QUERY_TYPE_IMAGES,
	TRACKER_QUERY_TYPE_VIDEOS,
	TRACKER_QUERY_TYPE_DOCUMENTS,
	TRACKER_QUERY_TYPE_MAIL,
	TRACKER_QUERY_TYPE_CALENDAR,
	TRACKER_QUERY_TYPE_FOLDERS,
	TRACKER_QUERY_TYPE_BOOKMARKS
} TrackerQueryType;

struct _Block5Data {
	int _ref_count_;
	TrackerView * self;
	GtkDialog* dialog;
};


static gpointer tracker_view_parent_class = NULL;

GType tracker_view_get_type (void) G_GNUC_CONST;
GType tracker_view_display_get_type (void) G_GNUC_CONST;
GType tracker_result_store_get_type (void) G_GNUC_CONST;
#define TRACKER_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_VIEW, TrackerViewPrivate))
enum  {
	TRACKER_VIEW_DUMMY_PROPERTY,
	TRACKER_VIEW_DISPLAY,
	TRACKER_VIEW_STORE
};
static void tracker_view_store_row_changed (TrackerView* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter);
static gboolean tracker_view_row_selection_func (TrackerView* self, GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_selected);
static void tracker_view_real_unmap (GtkWidget* base);
TrackerResultStore* tracker_view_get_store (TrackerView* self);
void tracker_result_store_cancel_search (TrackerResultStore* self);
TrackerView* tracker_view_new (TrackerViewDisplay* _display, TrackerResultStore* store);
TrackerView* tracker_view_construct (GType object_type, TrackerViewDisplay* _display, TrackerResultStore* store);
static void tracker_view_set_display (TrackerView* self, TrackerViewDisplay value);
static void _tracker_view_store_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
TrackerViewDisplay tracker_view_get_display (TrackerView* self);
static void tracker_view_setup_model (TrackerView* self);
static void tracker_view_setup_menus (TrackerView* self);
static void tracker_view_background_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter);
static void _tracker_view_background_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void tracker_view_text_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter);
static void _tracker_view_text_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void tracker_view_file_date_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter);
static void _tracker_view_file_date_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void tracker_view_file_size_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter);
static void _tracker_view_file_size_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static gboolean _tracker_view_row_selection_func_gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self);
static void tracker_view_category_detail_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter);
static void _tracker_view_category_detail_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
GType tracker_query_type_get_type (void) G_GNUC_CONST;
gchar* tracker_time_format_from_iso8601 (const gchar* s);
gchar* tracker_time_format_from_seconds (const gchar* seconds_str);
static gboolean tracker_view_view_button_press_event (TrackerView* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _tracker_view_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void tracker_view_context_menu_directory_clicked (TrackerView* self);
static void _tracker_view_context_menu_directory_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void tracker_view_context_menu_tags_clicked (TrackerView* self);
static void _tracker_view_context_menu_tags_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static GtkTreePath* tracker_view_get_selected_path (TrackerView* self);
static GtkTreeModel* tracker_view_get_model (TrackerView* self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
void tracker_model_launch_selected_parent_dir (GtkTreeModel* model, GtkTreePath* path, gint col);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void __lambda3_ (Block5Data* _data5_);
static void ___lambda3__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
TrackerTagsView* tracker_tags_view_new (GList* _files);
TrackerTagsView* tracker_tags_view_construct (GType object_type, GList* _files);
GType tracker_tags_view_get_type (void) G_GNUC_CONST;
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
void tracker_view_set_store (TrackerView* self, TrackerResultStore* value);
static void tracker_view_finalize (GObject* obj);
static void _vala_tracker_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType tracker_view_display_get_type (void) {
	static volatile gsize tracker_view_display_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_view_display_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_VIEW_DISPLAY_NO_RESULTS, "TRACKER_VIEW_DISPLAY_NO_RESULTS", "no-results"}, {TRACKER_VIEW_DISPLAY_CATEGORIES, "TRACKER_VIEW_DISPLAY_CATEGORIES", "categories"}, {TRACKER_VIEW_DISPLAY_FILE_LIST, "TRACKER_VIEW_DISPLAY_FILE_LIST", "file-list"}, {TRACKER_VIEW_DISPLAY_FILE_ICONS, "TRACKER_VIEW_DISPLAY_FILE_ICONS", "file-icons"}, {0, NULL, NULL}};
		GType tracker_view_display_type_id;
		tracker_view_display_type_id = g_enum_register_static ("TrackerViewDisplay", values);
		g_once_init_leave (&tracker_view_display_type_id__volatile, tracker_view_display_type_id);
	}
	return tracker_view_display_type_id__volatile;
}


static void tracker_view_store_row_changed (TrackerView* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter) {
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	gint _tmp2_ = 0;
	gint n_children;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = model;
	_tmp1_ = *iter;
	_tmp2_ = gtk_tree_model_iter_n_children (_tmp0_, &_tmp1_);
	n_children = _tmp2_;
	_tmp3_ = n_children;
	if (_tmp3_ > 0) {
		GtkWidget* _tmp4_;
		GtkTreePath* _tmp5_;
		_tmp4_ = self->priv->view;
		_tmp5_ = path;
		gtk_tree_view_expand_row (GTK_TREE_VIEW (_tmp4_), _tmp5_, FALSE);
	}
}


static gboolean tracker_view_row_selection_func (TrackerView* self, GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_selected) {
	gboolean result = FALSE;
	GtkTreePath* _tmp0_;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (selection != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = path;
	_tmp1_ = gtk_tree_path_get_depth (_tmp0_);
	if (_tmp1_ == 1) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void tracker_view_real_unmap (GtkWidget* base) {
	TrackerView * self;
	TrackerResultStore* _tmp0_;
	TrackerResultStore* _tmp1_;
	self = (TrackerView*) base;
	_tmp0_ = tracker_view_get_store (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		TrackerResultStore* _tmp2_;
		TrackerResultStore* _tmp3_;
		_tmp2_ = tracker_view_get_store (self);
		_tmp3_ = _tmp2_;
		tracker_result_store_cancel_search (_tmp3_);
	}
	GTK_WIDGET_CLASS (tracker_view_parent_class)->unmap ((GtkWidget*) GTK_SCROLLED_WINDOW (self));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _tracker_view_store_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	tracker_view_store_row_changed (self, _sender, path, iter);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


TrackerView* tracker_view_construct (GType object_type, TrackerViewDisplay* _display, TrackerResultStore* store) {
	TrackerView * self = NULL;
	TrackerViewDisplay* _tmp0_;
	TrackerResultStore* _tmp1_;
	TrackerViewDisplay _tmp6_;
	TrackerViewDisplay _tmp32_;
	self = (TrackerView*) g_object_new (object_type, NULL);
	gtk_scrolled_window_set_policy ((GtkScrolledWindow*) self, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp0_ = _display;
	tracker_view_set_display (self, *_tmp0_);
	_tmp1_ = store;
	if (_tmp1_ != NULL) {
		TrackerResultStore* _tmp2_;
		TrackerResultStore* _tmp3_;
		TrackerResultStore* _tmp4_;
		TrackerResultStore* _tmp5_;
		_tmp2_ = store;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (self->priv->_store);
		self->priv->_store = _tmp3_;
		_tmp4_ = store;
		g_signal_connect_object ((GtkTreeModel*) _tmp4_, "row-changed", (GCallback) _tracker_view_store_row_changed_gtk_tree_model_row_changed, self, 0);
		_tmp5_ = store;
		g_debug ("tracker-view.vala:101: using store:%p", _tmp5_);
	}
	_tmp6_ = self->priv->_display;
	switch (_tmp6_) {
		case TRACKER_VIEW_DISPLAY_NO_RESULTS:
		{
			GtkLabel* l = NULL;
			GtkLabel* _tmp7_;
			GtkLabel* _tmp8_;
			GtkLabel* _tmp9_;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* results;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			gchar* help_views;
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			gchar* help_search;
			const gchar* _tmp16_;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_;
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* markup;
			GtkLabel* _tmp23_;
			GtkLabel* _tmp24_;
			const gchar* _tmp25_;
			GtkLabel* _tmp26_;
			GtkWidget* _tmp27_;
			_tmp7_ = (GtkLabel*) gtk_label_new ("");
			_tmp8_ = g_object_ref_sink (_tmp7_);
			_g_object_unref0 (l);
			l = _tmp8_;
			_tmp9_ = l;
			gtk_label_set_justify (_tmp9_, GTK_JUSTIFY_CENTER);
			_tmp10_ = _ ("No Search Results");
			_tmp11_ = g_strdup (_tmp10_);
			results = _tmp11_;
			_tmp12_ = _ ("Select the view on the toolbar for the content you want, e.g. everythi" \
"ng, files or just images");
			_tmp13_ = g_strdup (_tmp12_);
			help_views = _tmp13_;
			_tmp14_ = _ ("Start to search using the entry box above");
			_tmp15_ = g_strdup (_tmp14_);
			help_search = _tmp15_;
			_tmp16_ = results;
			_tmp17_ = string_to_string (_tmp16_);
			_tmp18_ = help_views;
			_tmp19_ = string_to_string (_tmp18_);
			_tmp20_ = help_search;
			_tmp21_ = string_to_string (_tmp20_);
			_tmp22_ = g_strconcat ("<big>", _tmp17_, "</big>\n\n", _tmp19_, "\n\n", _tmp21_, NULL);
			markup = _tmp22_;
			_tmp23_ = l;
			gtk_label_set_use_markup (_tmp23_, TRUE);
			_tmp24_ = l;
			_tmp25_ = markup;
			gtk_label_set_markup (_tmp24_, _tmp25_);
			_tmp26_ = l;
			_tmp27_ = _g_object_ref0 ((GtkWidget*) _tmp26_);
			_g_object_unref0 (self->priv->view);
			self->priv->view = _tmp27_;
			_g_free0 (markup);
			_g_free0 (help_search);
			_g_free0 (help_views);
			_g_free0 (results);
			_g_object_unref0 (l);
			break;
		}
		case TRACKER_VIEW_DISPLAY_CATEGORIES:
		case TRACKER_VIEW_DISPLAY_FILE_LIST:
		{
			GtkTreeView* _tmp28_;
			GtkWidget* _tmp29_;
			_tmp28_ = (GtkTreeView*) gtk_tree_view_new ();
			_tmp29_ = (GtkWidget*) g_object_ref_sink (_tmp28_);
			_g_object_unref0 (self->priv->view);
			self->priv->view = _tmp29_;
			break;
		}
		case TRACKER_VIEW_DISPLAY_FILE_ICONS:
		{
			GtkIconView* _tmp30_;
			GtkWidget* _tmp31_;
			_tmp30_ = (GtkIconView*) gtk_icon_view_new ();
			_tmp31_ = (GtkWidget*) g_object_ref_sink (_tmp30_);
			_g_object_unref0 (self->priv->view);
			self->priv->view = _tmp31_;
			break;
		}
		default:
		break;
	}
	_tmp32_ = self->priv->_display;
	if (_tmp32_ == TRACKER_VIEW_DISPLAY_NO_RESULTS) {
		GtkWidget* _tmp33_;
		_tmp33_ = self->priv->view;
		gtk_scrolled_window_add_with_viewport ((GtkScrolledWindow*) self, _tmp33_);
	} else {
		GtkWidget* _tmp34_;
		_tmp34_ = self->priv->view;
		gtk_container_add ((GtkContainer*) self, _tmp34_);
		tracker_view_setup_model (self);
		tracker_view_setup_menus (self);
	}
	GTK_WIDGET_CLASS (tracker_view_parent_class)->show_all ((GtkWidget*) GTK_SCROLLED_WINDOW (self));
	return self;
}


TrackerView* tracker_view_new (TrackerViewDisplay* _display, TrackerResultStore* store) {
	return tracker_view_construct (TRACKER_TYPE_VIEW, _display, store);
}


static void _tracker_view_background_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	tracker_view_background_renderer_func (self, cell_layout, cell, tree_model, iter);
}


static void _tracker_view_text_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	tracker_view_text_renderer_func (self, cell_layout, cell, tree_model, iter);
}


static void _tracker_view_file_date_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	tracker_view_file_date_renderer_func (self, cell_layout, cell, tree_model, iter);
}


static void _tracker_view_file_size_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	tracker_view_file_size_renderer_func (self, cell_layout, cell, tree_model, iter);
}


static gboolean _tracker_view_row_selection_func_gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self) {
	gboolean result;
	result = tracker_view_row_selection_func (self, selection, model, path, path_currently_selected);
	return result;
}


static void _tracker_view_category_detail_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	tracker_view_category_detail_renderer_func (self, cell_layout, cell, tree_model, iter);
}


static void tracker_view_setup_model (TrackerView* self) {
	TrackerViewDisplay _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_display;
	switch (_tmp0_) {
		case TRACKER_VIEW_DISPLAY_FILE_ICONS:
		{
			{
				GtkWidget* _tmp1_;
				GtkIconView* _tmp2_;
				GtkIconView* iv;
				GtkIconView* _tmp3_;
				TrackerResultStore* _tmp4_;
				TrackerResultStore* _tmp5_;
				GtkIconView* _tmp6_;
				GtkIconView* _tmp7_;
				GtkIconView* _tmp8_;
				GtkIconView* _tmp9_;
				GtkIconView* _tmp10_;
				GtkIconView* _tmp11_;
				GtkIconView* _tmp12_;
				GtkIconView* _tmp13_;
				_tmp1_ = self->priv->view;
				_tmp2_ = _g_object_ref0 (GTK_ICON_VIEW (_tmp1_));
				iv = _tmp2_;
				_tmp3_ = iv;
				_tmp4_ = tracker_view_get_store (self);
				_tmp5_ = _tmp4_;
				gtk_icon_view_set_model (_tmp3_, (GtkTreeModel*) _tmp5_);
				_tmp6_ = iv;
				gtk_icon_view_set_item_width (_tmp6_, 128);
				_tmp7_ = iv;
				gtk_icon_view_set_item_padding (_tmp7_, 1);
				_tmp8_ = iv;
				gtk_icon_view_set_row_spacing (_tmp8_, 2);
				_tmp9_ = iv;
				gtk_icon_view_set_column_spacing (_tmp9_, 2);
				_tmp10_ = iv;
				gtk_icon_view_set_selection_mode (_tmp10_, GTK_SELECTION_SINGLE);
				_tmp11_ = iv;
				gtk_icon_view_set_pixbuf_column (_tmp11_, 6);
				_tmp12_ = iv;
				gtk_icon_view_set_text_column (_tmp12_, -1);
				_tmp13_ = iv;
				gtk_icon_view_set_tooltip_column (_tmp13_, 5);
				_g_object_unref0 (iv);
				break;
			}
		}
		case TRACKER_VIEW_DISPLAY_FILE_LIST:
		{
			{
				GtkTreeViewColumn* col = NULL;
				GtkWidget* _tmp14_;
				GtkTreeView* _tmp15_;
				GtkTreeView* tv;
				GtkTreeView* _tmp16_;
				TrackerResultStore* _tmp17_;
				TrackerResultStore* _tmp18_;
				GtkTreeView* _tmp19_;
				GtkTreeView* _tmp20_;
				GtkTreeView* _tmp21_;
				GtkTreeView* _tmp22_;
				GtkCellRendererPixbuf* _tmp23_;
				GtkCellRendererPixbuf* _tmp24_;
				GtkCellRendererPixbuf* renderer1;
				GtkCellRendererText* _tmp25_;
				GtkCellRendererText* _tmp26_;
				GtkCellRendererText* renderer2;
				GtkTreeViewColumn* _tmp27_;
				GtkTreeViewColumn* _tmp28_;
				GtkTreeViewColumn* _tmp29_;
				GtkTreeViewColumn* _tmp30_;
				GtkCellRendererPixbuf* _tmp31_;
				GtkTreeViewColumn* _tmp32_;
				GtkCellRendererPixbuf* _tmp33_;
				GtkCellRendererPixbuf* _tmp34_;
				GtkCellRendererPixbuf* _tmp35_;
				GtkTreeViewColumn* _tmp36_;
				GtkCellRendererText* _tmp37_;
				GtkCellRendererText* _tmp38_;
				GtkCellRendererText* _tmp39_;
				GtkTreeViewColumn* _tmp40_;
				const gchar* _tmp41_ = NULL;
				GtkTreeViewColumn* _tmp42_;
				GtkTreeViewColumn* _tmp43_;
				GtkTreeViewColumn* _tmp44_;
				GtkCellRendererPixbuf* _tmp45_;
				GtkTreeViewColumn* _tmp46_;
				GtkCellRendererText* _tmp47_;
				GtkTreeView* _tmp48_;
				GtkTreeViewColumn* _tmp49_;
				GtkCellRendererText* _tmp50_;
				GtkCellRendererText* _tmp51_;
				GtkCellRendererText* renderer3;
				GtkCellRendererText* _tmp52_;
				GtkTreeViewColumn* _tmp53_;
				GtkTreeViewColumn* _tmp54_;
				GtkTreeViewColumn* _tmp55_;
				GtkTreeViewColumn* _tmp56_;
				GtkCellRendererText* _tmp57_;
				GtkTreeViewColumn* _tmp58_;
				const gchar* _tmp59_ = NULL;
				GtkTreeViewColumn* _tmp60_;
				GtkCellRendererText* _tmp61_;
				GtkTreeView* _tmp62_;
				GtkTreeViewColumn* _tmp63_;
				GtkCellRendererText* _tmp64_;
				GtkCellRendererText* _tmp65_;
				GtkCellRendererText* renderer4;
				GtkCellRendererText* _tmp66_;
				GtkTreeViewColumn* _tmp67_;
				GtkTreeViewColumn* _tmp68_;
				GtkTreeViewColumn* _tmp69_;
				GtkTreeViewColumn* _tmp70_;
				GtkCellRendererText* _tmp71_;
				GtkTreeViewColumn* _tmp72_;
				const gchar* _tmp73_ = NULL;
				GtkTreeViewColumn* _tmp74_;
				GtkCellRendererText* _tmp75_;
				GtkTreeView* _tmp76_;
				GtkTreeViewColumn* _tmp77_;
				_tmp14_ = self->priv->view;
				_tmp15_ = _g_object_ref0 (GTK_TREE_VIEW (_tmp14_));
				tv = _tmp15_;
				_tmp16_ = tv;
				_tmp17_ = tracker_view_get_store (self);
				_tmp18_ = _tmp17_;
				gtk_tree_view_set_model (_tmp16_, (GtkTreeModel*) _tmp18_);
				_tmp19_ = tv;
				gtk_tree_view_set_tooltip_column (_tmp19_, 6);
				_tmp20_ = tv;
				gtk_tree_view_set_rules_hint (_tmp20_, FALSE);
				_tmp21_ = tv;
				gtk_tree_view_set_grid_lines (_tmp21_, GTK_TREE_VIEW_GRID_LINES_VERTICAL);
				_tmp22_ = tv;
				gtk_tree_view_set_headers_visible (_tmp22_, TRUE);
				_tmp23_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
				_tmp24_ = g_object_ref_sink (_tmp23_);
				renderer1 = _tmp24_;
				_tmp25_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
				_tmp26_ = g_object_ref_sink (_tmp25_);
				renderer2 = _tmp26_;
				_tmp27_ = gtk_tree_view_column_new ();
				_tmp28_ = g_object_ref_sink (_tmp27_);
				_g_object_unref0 (col);
				col = _tmp28_;
				_tmp29_ = col;
				gtk_tree_view_column_set_sizing (_tmp29_, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
				_tmp30_ = col;
				_tmp31_ = renderer1;
				gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp30_, (GtkCellRenderer*) _tmp31_, FALSE);
				_tmp32_ = col;
				_tmp33_ = renderer1;
				gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp32_, (GtkCellRenderer*) _tmp33_, "pixbuf", 7);
				_tmp34_ = renderer1;
				g_object_set ((GtkCellRenderer*) _tmp34_, "xpad", (guint) 5, NULL);
				_tmp35_ = renderer1;
				g_object_set ((GtkCellRenderer*) _tmp35_, "ypad", (guint) 5, NULL);
				_tmp36_ = col;
				_tmp37_ = renderer2;
				gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp36_, (GtkCellRenderer*) _tmp37_, TRUE);
				_tmp38_ = renderer2;
				gtk_cell_renderer_text_set_fixed_height_from_font (_tmp38_, 2);
				_tmp39_ = renderer2;
				g_object_set (_tmp39_, "ellipsize", PANGO_ELLIPSIZE_MIDDLE, NULL);
				_tmp40_ = col;
				_tmp41_ = _ ("File");
				gtk_tree_view_column_set_title (_tmp40_, _tmp41_);
				_tmp42_ = col;
				gtk_tree_view_column_set_resizable (_tmp42_, TRUE);
				_tmp43_ = col;
				gtk_tree_view_column_set_expand (_tmp43_, TRUE);
				_tmp44_ = col;
				_tmp45_ = renderer1;
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp44_, (GtkCellRenderer*) _tmp45_, _tracker_view_background_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				_tmp46_ = col;
				_tmp47_ = renderer2;
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp46_, (GtkCellRenderer*) _tmp47_, _tracker_view_text_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				_tmp48_ = tv;
				_tmp49_ = col;
				gtk_tree_view_append_column (_tmp48_, _tmp49_);
				_tmp50_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
				_tmp51_ = g_object_ref_sink (_tmp50_);
				renderer3 = _tmp51_;
				_tmp52_ = renderer3;
				gtk_cell_renderer_text_set_fixed_height_from_font (_tmp52_, 2);
				_tmp53_ = gtk_tree_view_column_new ();
				_tmp54_ = g_object_ref_sink (_tmp53_);
				_g_object_unref0 (col);
				col = _tmp54_;
				_tmp55_ = col;
				gtk_tree_view_column_set_sizing (_tmp55_, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
				_tmp56_ = col;
				_tmp57_ = renderer3;
				gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp56_, (GtkCellRenderer*) _tmp57_, TRUE);
				_tmp58_ = col;
				_tmp59_ = _ ("Last Changed");
				gtk_tree_view_column_set_title (_tmp58_, _tmp59_);
				_tmp60_ = col;
				_tmp61_ = renderer3;
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp60_, (GtkCellRenderer*) _tmp61_, _tracker_view_file_date_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				_tmp62_ = tv;
				_tmp63_ = col;
				gtk_tree_view_append_column (_tmp62_, _tmp63_);
				_tmp64_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
				_tmp65_ = g_object_ref_sink (_tmp64_);
				renderer4 = _tmp65_;
				_tmp66_ = renderer4;
				gtk_cell_renderer_text_set_fixed_height_from_font (_tmp66_, 2);
				_tmp67_ = gtk_tree_view_column_new ();
				_tmp68_ = g_object_ref_sink (_tmp67_);
				_g_object_unref0 (col);
				col = _tmp68_;
				_tmp69_ = col;
				gtk_tree_view_column_set_sizing (_tmp69_, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
				_tmp70_ = col;
				_tmp71_ = renderer4;
				gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp70_, (GtkCellRenderer*) _tmp71_, TRUE);
				_tmp72_ = col;
				_tmp73_ = _ ("Size");
				gtk_tree_view_column_set_title (_tmp72_, _tmp73_);
				_tmp74_ = col;
				_tmp75_ = renderer4;
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp74_, (GtkCellRenderer*) _tmp75_, _tracker_view_file_size_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				_tmp76_ = tv;
				_tmp77_ = col;
				gtk_tree_view_append_column (_tmp76_, _tmp77_);
				_g_object_unref0 (renderer4);
				_g_object_unref0 (renderer3);
				_g_object_unref0 (renderer2);
				_g_object_unref0 (renderer1);
				_g_object_unref0 (tv);
				_g_object_unref0 (col);
				break;
			}
		}
		case TRACKER_VIEW_DISPLAY_CATEGORIES:
		{
			{
				GtkTreeViewColumn* col = NULL;
				GtkWidget* _tmp78_;
				GtkTreeView* _tmp79_;
				GtkTreeView* tv;
				GtkTreeSelection* selection = NULL;
				GtkTreeView* _tmp80_;
				TrackerResultStore* _tmp81_;
				TrackerResultStore* _tmp82_;
				GtkTreeView* _tmp83_;
				GtkTreeView* _tmp84_;
				GtkTreeView* _tmp85_;
				GtkTreeView* _tmp86_;
				GtkTreeView* _tmp87_;
				GtkTreeView* _tmp88_;
				GtkTreeSelection* _tmp89_ = NULL;
				GtkTreeSelection* _tmp90_;
				GtkTreeSelection* _tmp91_;
				GtkTreeViewColumn* _tmp92_;
				GtkTreeViewColumn* _tmp93_;
				GtkTreeViewColumn* _tmp94_;
				GtkTreeViewColumn* _tmp95_;
				GtkCellRendererPixbuf* _tmp96_;
				GtkCellRendererPixbuf* _tmp97_;
				GtkCellRendererPixbuf* renderer1;
				GtkTreeViewColumn* _tmp98_;
				GtkCellRendererPixbuf* _tmp99_;
				GtkTreeViewColumn* _tmp100_;
				GtkCellRendererPixbuf* _tmp101_;
				GtkTreeViewColumn* _tmp102_;
				GtkCellRendererPixbuf* _tmp103_;
				GtkCellRendererPixbuf* _tmp104_;
				GtkCellRendererPixbuf* _tmp105_;
				GtkCellRendererText* _tmp106_;
				GtkCellRendererText* _tmp107_;
				GtkCellRendererText* renderer2;
				GtkTreeViewColumn* _tmp108_;
				GtkCellRendererText* _tmp109_;
				GtkTreeViewColumn* _tmp110_;
				GtkCellRendererText* _tmp111_;
				GtkCellRendererText* _tmp112_;
				GtkCellRendererText* _tmp113_;
				GtkTreeView* _tmp114_;
				GtkTreeViewColumn* _tmp115_;
				GtkCellRendererText* _tmp116_;
				GtkCellRendererText* _tmp117_;
				GtkCellRendererText* renderer4;
				GtkCellRendererText* _tmp118_;
				GtkCellRendererText* _tmp119_;
				GtkCellRendererText* _tmp120_;
				GtkTreeViewColumn* _tmp121_;
				GtkTreeViewColumn* _tmp122_;
				GtkTreeViewColumn* _tmp123_;
				GtkTreeViewColumn* _tmp124_;
				GtkTreeViewColumn* _tmp125_;
				GtkCellRendererText* _tmp126_;
				GtkTreeViewColumn* _tmp127_;
				GtkCellRendererText* _tmp128_;
				GtkTreeView* _tmp129_;
				GtkTreeViewColumn* _tmp130_;
				_tmp78_ = self->priv->view;
				_tmp79_ = _g_object_ref0 (GTK_TREE_VIEW (_tmp78_));
				tv = _tmp79_;
				_tmp80_ = tv;
				_tmp81_ = tracker_view_get_store (self);
				_tmp82_ = _tmp81_;
				gtk_tree_view_set_model (_tmp80_, (GtkTreeModel*) _tmp82_);
				_tmp83_ = tv;
				gtk_tree_view_set_tooltip_column (_tmp83_, 5);
				_tmp84_ = tv;
				gtk_tree_view_set_rules_hint (_tmp84_, FALSE);
				_tmp85_ = tv;
				gtk_tree_view_set_grid_lines (_tmp85_, GTK_TREE_VIEW_GRID_LINES_NONE);
				_tmp86_ = tv;
				gtk_tree_view_set_headers_visible (_tmp86_, FALSE);
				_tmp87_ = tv;
				gtk_tree_view_set_show_expanders (_tmp87_, FALSE);
				_tmp88_ = tv;
				_tmp89_ = gtk_tree_view_get_selection (_tmp88_);
				_tmp90_ = _g_object_ref0 (_tmp89_);
				_g_object_unref0 (selection);
				selection = _tmp90_;
				_tmp91_ = selection;
				gtk_tree_selection_set_select_function (_tmp91_, _tracker_view_row_selection_func_gtk_tree_selection_func, g_object_ref (self), g_object_unref);
				_tmp92_ = gtk_tree_view_column_new ();
				_tmp93_ = g_object_ref_sink (_tmp92_);
				_g_object_unref0 (col);
				col = _tmp93_;
				_tmp94_ = col;
				gtk_tree_view_column_set_sizing (_tmp94_, GTK_TREE_VIEW_COLUMN_FIXED);
				_tmp95_ = col;
				gtk_tree_view_column_set_expand (_tmp95_, TRUE);
				_tmp96_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
				_tmp97_ = g_object_ref_sink (_tmp96_);
				renderer1 = _tmp97_;
				_tmp98_ = col;
				_tmp99_ = renderer1;
				gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp98_, (GtkCellRenderer*) _tmp99_, FALSE);
				_tmp100_ = col;
				_tmp101_ = renderer1;
				gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp100_, (GtkCellRenderer*) _tmp101_, "pixbuf", 6);
				_tmp102_ = col;
				_tmp103_ = renderer1;
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp102_, (GtkCellRenderer*) _tmp103_, _tracker_view_background_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				_tmp104_ = renderer1;
				g_object_set ((GtkCellRenderer*) _tmp104_, "xpad", (guint) 5, NULL);
				_tmp105_ = renderer1;
				g_object_set ((GtkCellRenderer*) _tmp105_, "ypad", (guint) 5, NULL);
				_tmp106_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
				_tmp107_ = g_object_ref_sink (_tmp106_);
				renderer2 = _tmp107_;
				_tmp108_ = col;
				_tmp109_ = renderer2;
				gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp108_, (GtkCellRenderer*) _tmp109_, TRUE);
				_tmp110_ = col;
				_tmp111_ = renderer2;
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp110_, (GtkCellRenderer*) _tmp111_, _tracker_view_text_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				_tmp112_ = renderer2;
				gtk_cell_renderer_text_set_fixed_height_from_font (_tmp112_, 2);
				_tmp113_ = renderer2;
				g_object_set (_tmp113_, "ellipsize", PANGO_ELLIPSIZE_MIDDLE, NULL);
				_tmp114_ = tv;
				_tmp115_ = col;
				gtk_tree_view_append_column (_tmp114_, _tmp115_);
				_tmp116_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
				_tmp117_ = g_object_ref_sink (_tmp116_);
				renderer4 = _tmp117_;
				_tmp118_ = renderer4;
				gtk_cell_renderer_text_set_fixed_height_from_font (_tmp118_, 2);
				_tmp119_ = renderer4;
				g_object_set (_tmp119_, "alignment", PANGO_ALIGN_RIGHT, NULL);
				_tmp120_ = renderer4;
				g_object_set ((GtkCellRenderer*) _tmp120_, "xalign", (gfloat) 1, NULL);
				_tmp121_ = gtk_tree_view_column_new ();
				_tmp122_ = g_object_ref_sink (_tmp121_);
				_g_object_unref0 (col);
				col = _tmp122_;
				_tmp123_ = col;
				gtk_tree_view_column_set_min_width (_tmp123_, 80);
				_tmp124_ = col;
				gtk_tree_view_column_set_sizing (_tmp124_, GTK_TREE_VIEW_COLUMN_FIXED);
				_tmp125_ = col;
				_tmp126_ = renderer4;
				gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp125_, (GtkCellRenderer*) _tmp126_, TRUE);
				_tmp127_ = col;
				_tmp128_ = renderer4;
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp127_, (GtkCellRenderer*) _tmp128_, _tracker_view_category_detail_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				_tmp129_ = tv;
				_tmp130_ = col;
				gtk_tree_view_append_column (_tmp129_, _tmp130_);
				_g_object_unref0 (renderer4);
				_g_object_unref0 (renderer2);
				_g_object_unref0 (renderer1);
				_g_object_unref0 (selection);
				_g_object_unref0 (tv);
				_g_object_unref0 (col);
				break;
			}
		}
		default:
		break;
	}
}


static void tracker_view_background_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter) {
	GdkColor color = {0};
	GtkStyle* style = NULL;
	GtkTreePath* path = NULL;
	GtkWidget* _tmp0_;
	GtkStyle* _tmp1_ = NULL;
	GtkStyle* _tmp2_;
	GtkStyle* _tmp3_;
	GdkColor* _tmp4_;
	gint _tmp4__length1;
	GdkColor _tmp5_;
	GdkColor _tmp6_;
	guint16 _tmp7_;
	GdkColor _tmp8_;
	guint16 _tmp9_;
	GdkColor _tmp10_;
	guint16 _tmp11_;
	gint sum_normal;
	GtkStyle* _tmp12_;
	GdkColor* _tmp13_;
	gint _tmp13__length1;
	GdkColor _tmp14_;
	GdkColor _tmp15_;
	guint16 _tmp16_;
	GdkColor _tmp17_;
	guint16 _tmp18_;
	GdkColor _tmp19_;
	guint16 _tmp20_;
	gint sum_selected;
	GtkStyle* _tmp21_;
	GdkColor* _tmp22_;
	gint _tmp22__length1;
	GdkColor _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GtkTreeModel* _tmp56_;
	GtkTreeIter _tmp57_;
	GtkTreePath* _tmp58_ = NULL;
	GtkTreePath* _tmp59_;
	gint _tmp60_ = 0;
	gint* _tmp61_ = NULL;
	gint _tmp62_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = gtk_widget_get_style (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (style);
	style = _tmp2_;
	_tmp3_ = style;
	_tmp4_ = _tmp3_->base;
	_tmp4__length1 = -1;
	_tmp5_ = _tmp4_[GTK_STATE_SELECTED];
	color = _tmp5_;
	_tmp6_ = color;
	_tmp7_ = _tmp6_.red;
	_tmp8_ = color;
	_tmp9_ = _tmp8_.green;
	_tmp10_ = color;
	_tmp11_ = _tmp10_.blue;
	sum_normal = (gint) ((_tmp7_ + _tmp9_) + _tmp11_);
	_tmp12_ = style;
	_tmp13_ = _tmp12_->base;
	_tmp13__length1 = -1;
	_tmp14_ = _tmp13_[GTK_STATE_NORMAL];
	color = _tmp14_;
	_tmp15_ = color;
	_tmp16_ = _tmp15_.red;
	_tmp17_ = color;
	_tmp18_ = _tmp17_.green;
	_tmp19_ = color;
	_tmp20_ = _tmp19_.blue;
	sum_selected = (gint) ((_tmp16_ + _tmp18_) + _tmp20_);
	_tmp21_ = style;
	_tmp22_ = _tmp21_->text_aa;
	_tmp22__length1 = -1;
	_tmp23_ = _tmp22_[GTK_STATE_INSENSITIVE];
	color = _tmp23_;
	_tmp24_ = sum_normal;
	_tmp25_ = sum_selected;
	if (_tmp24_ < _tmp25_) {
		GdkColor _tmp26_;
		guint16 _tmp27_;
		GtkStyle* _tmp28_;
		GdkColor _tmp29_;
		guint16 _tmp30_;
		GdkColor _tmp31_;
		guint16 _tmp32_;
		GtkStyle* _tmp33_;
		GdkColor _tmp34_;
		guint16 _tmp35_;
		GdkColor _tmp36_;
		guint16 _tmp37_;
		GtkStyle* _tmp38_;
		GdkColor _tmp39_;
		guint16 _tmp40_;
		_tmp26_ = color;
		_tmp27_ = _tmp26_.red;
		_tmp28_ = style;
		_tmp29_ = _tmp28_->white;
		_tmp30_ = _tmp29_.red;
		color.red = (guint16) ((_tmp27_ + _tmp30_) / 2);
		_tmp31_ = color;
		_tmp32_ = _tmp31_.green;
		_tmp33_ = style;
		_tmp34_ = _tmp33_->white;
		_tmp35_ = _tmp34_.green;
		color.green = (guint16) ((_tmp32_ + _tmp35_) / 2);
		_tmp36_ = color;
		_tmp37_ = _tmp36_.blue;
		_tmp38_ = style;
		_tmp39_ = _tmp38_->white;
		_tmp40_ = _tmp39_.blue;
		color.blue = (guint16) ((_tmp37_ + _tmp40_) / 2);
	} else {
		GdkColor _tmp41_;
		guint16 _tmp42_;
		GtkStyle* _tmp43_;
		GdkColor _tmp44_;
		guint16 _tmp45_;
		GdkColor _tmp46_;
		guint16 _tmp47_;
		GtkStyle* _tmp48_;
		GdkColor _tmp49_;
		guint16 _tmp50_;
		GdkColor _tmp51_;
		guint16 _tmp52_;
		GtkStyle* _tmp53_;
		GdkColor _tmp54_;
		guint16 _tmp55_;
		_tmp41_ = color;
		_tmp42_ = _tmp41_.red;
		_tmp43_ = style;
		_tmp44_ = _tmp43_->black;
		_tmp45_ = _tmp44_.red;
		color.red = (guint16) ((_tmp42_ + _tmp45_) / 2);
		_tmp46_ = color;
		_tmp47_ = _tmp46_.green;
		_tmp48_ = style;
		_tmp49_ = _tmp48_->black;
		_tmp50_ = _tmp49_.green;
		color.green = (guint16) ((_tmp47_ + _tmp50_) / 2);
		_tmp51_ = color;
		_tmp52_ = _tmp51_.blue;
		_tmp53_ = style;
		_tmp54_ = _tmp53_->black;
		_tmp55_ = _tmp54_.blue;
		color.blue = (guint16) ((_tmp52_ + _tmp55_) / 2);
	}
	_tmp56_ = tree_model;
	_tmp57_ = *iter;
	_tmp58_ = gtk_tree_model_get_path (_tmp56_, &_tmp57_);
	_gtk_tree_path_free0 (path);
	path = _tmp58_;
	_tmp59_ = path;
	_tmp61_ = gtk_tree_path_get_indices_with_depth (_tmp59_, &_tmp60_);
	_tmp62_ = _tmp61_[0];
	if ((_tmp62_ % 2) != 0) {
		GtkCellRenderer* _tmp63_;
		GdkColor _tmp64_;
		_tmp63_ = cell;
		_tmp64_ = color;
		g_object_set ((GObject*) _tmp63_, "cell-background-gdk", &_tmp64_, NULL);
	} else {
		GtkCellRenderer* _tmp65_;
		_tmp65_ = cell;
		g_object_set ((GObject*) _tmp65_, "cell-background-gdk", NULL, NULL);
	}
	_gtk_tree_path_free0 (path);
	_g_object_unref0 (style);
}


static void tracker_view_text_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter) {
	gchar* text = NULL;
	gchar* subtext = NULL;
	gchar* markup;
	gint n_children = 0;
	GtkCellLayout* _tmp0_;
	GtkCellRenderer* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_;
	GtkCellRenderer* _tmp46_;
	const gchar* _tmp47_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (iter != NULL);
	markup = NULL;
	_tmp0_ = cell_layout;
	_tmp1_ = cell;
	_tmp2_ = tree_model;
	_tmp3_ = *iter;
	tracker_view_background_renderer_func (self, _tmp0_, _tmp1_, _tmp2_, &_tmp3_);
	_tmp4_ = tree_model;
	_tmp5_ = *iter;
	_tmp6_ = gtk_tree_model_iter_n_children (_tmp4_, &_tmp5_);
	n_children = _tmp6_;
	_tmp7_ = n_children;
	if (_tmp7_ > 0) {
		TrackerQueryType type = 0;
		gchar* cat;
		GtkTreeModel* _tmp8_;
		GtkTreeIter _tmp9_;
		TrackerQueryType _tmp10_;
		const gchar* _tmp27_;
		gint _tmp28_;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		cat = NULL;
		_tmp8_ = tree_model;
		_tmp9_ = *iter;
		gtk_tree_model_get (_tmp8_, &_tmp9_, 7, &type, -1, -1);
		_tmp10_ = type;
		switch (_tmp10_) {
			case TRACKER_QUERY_TYPE_APPLICATIONS:
			{
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				_tmp11_ = _ ("Applications");
				_tmp12_ = g_strdup (_tmp11_);
				_g_free0 (cat);
				cat = _tmp12_;
				break;
			}
			case TRACKER_QUERY_TYPE_MUSIC:
			{
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				_tmp13_ = _ ("Music");
				_tmp14_ = g_strdup (_tmp13_);
				_g_free0 (cat);
				cat = _tmp14_;
				break;
			}
			case TRACKER_QUERY_TYPE_IMAGES:
			{
				const gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				_tmp15_ = _ ("Images");
				_tmp16_ = g_strdup (_tmp15_);
				_g_free0 (cat);
				cat = _tmp16_;
				break;
			}
			case TRACKER_QUERY_TYPE_VIDEOS:
			{
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				_tmp17_ = _ ("Videos");
				_tmp18_ = g_strdup (_tmp17_);
				_g_free0 (cat);
				cat = _tmp18_;
				break;
			}
			case TRACKER_QUERY_TYPE_DOCUMENTS:
			{
				const gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				_tmp19_ = _ ("Documents");
				_tmp20_ = g_strdup (_tmp19_);
				_g_free0 (cat);
				cat = _tmp20_;
				break;
			}
			case TRACKER_QUERY_TYPE_MAIL:
			{
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				_tmp21_ = _ ("Mail");
				_tmp22_ = g_strdup (_tmp21_);
				_g_free0 (cat);
				cat = _tmp22_;
				break;
			}
			case TRACKER_QUERY_TYPE_FOLDERS:
			{
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				_tmp23_ = _ ("Folders");
				_tmp24_ = g_strdup (_tmp23_);
				_g_free0 (cat);
				cat = _tmp24_;
				break;
			}
			case TRACKER_QUERY_TYPE_BOOKMARKS:
			{
				const gchar* _tmp25_ = NULL;
				gchar* _tmp26_;
				_tmp25_ = _ ("Bookmarks");
				_tmp26_ = g_strdup (_tmp25_);
				_g_free0 (cat);
				cat = _tmp26_;
				break;
			}
			default:
			break;
		}
		_tmp27_ = cat;
		_tmp28_ = n_children;
		_tmp29_ = _ ("Items");
		_tmp30_ = g_strdup_printf ("<b><big>%s</big></b> <small>(%d %s)</small>", _tmp27_, _tmp28_, _tmp29_);
		_g_free0 (markup);
		markup = _tmp30_;
		_g_free0 (cat);
	} else {
		GtkTreeModel* _tmp31_;
		GtkTreeIter _tmp32_;
		const gchar* _tmp33_;
		_tmp31_ = tree_model;
		_tmp32_ = *iter;
		gtk_tree_model_get (_tmp31_, &_tmp32_, 2, &text, 3, &subtext, -1, -1);
		_tmp33_ = text;
		if (_tmp33_ != NULL) {
			const gchar* _tmp34_;
			gchar* _tmp35_ = NULL;
			const gchar* _tmp36_;
			_tmp34_ = text;
			_tmp35_ = g_markup_escape_text (_tmp34_, (gssize) (-1));
			_g_free0 (markup);
			markup = _tmp35_;
			_tmp36_ = subtext;
			if (_tmp36_ != NULL) {
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_ = NULL;
				gchar* _tmp40_;
				gchar* _tmp41_ = NULL;
				gchar* _tmp42_;
				gchar* _tmp43_;
				_tmp37_ = markup;
				_tmp38_ = subtext;
				_tmp39_ = g_markup_escape_text (_tmp38_, (gssize) (-1));
				_tmp40_ = _tmp39_;
				_tmp41_ = g_strdup_printf ("\n<small><span color='grey'>%s</span></small>", _tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strconcat (_tmp37_, _tmp42_, NULL);
				_g_free0 (markup);
				markup = _tmp43_;
				_g_free0 (_tmp42_);
				_g_free0 (_tmp40_);
			}
		} else {
			const gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			_tmp44_ = _ ("Loading...");
			_tmp45_ = g_strdup_printf ("<span color='grey'>%s</span>\n", _tmp44_);
			_g_free0 (markup);
			markup = _tmp45_;
		}
	}
	_tmp46_ = cell;
	_tmp47_ = markup;
	g_object_set ((GObject*) _tmp46_, "markup", _tmp47_, NULL);
	_g_free0 (markup);
	_g_free0 (subtext);
	_g_free0 (text);
}


static void tracker_view_file_size_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter) {
	gchar* size = NULL;
	GtkCellLayout* _tmp0_;
	GtkCellRenderer* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	const gchar* _tmp6_;
	GtkCellRenderer* _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = cell_layout;
	_tmp1_ = cell;
	_tmp2_ = tree_model;
	_tmp3_ = *iter;
	tracker_view_background_renderer_func (self, _tmp0_, _tmp1_, _tmp2_, &_tmp3_);
	_tmp4_ = tree_model;
	_tmp5_ = *iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 4, &size, -1, -1);
	_tmp6_ = size;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		gint _tmp8_ = 0;
		gchar* _tmp9_ = NULL;
		_tmp7_ = size;
		_tmp8_ = atoi (_tmp7_);
		_tmp9_ = g_format_size_for_display ((gint64) _tmp8_);
		_g_free0 (size);
		size = _tmp9_;
	}
	_tmp10_ = cell;
	_tmp11_ = size;
	g_object_set ((GObject*) _tmp10_, "text", _tmp11_, NULL);
	_g_free0 (size);
}


static void tracker_view_file_date_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter) {
	gchar* date = NULL;
	GtkCellLayout* _tmp0_;
	GtkCellRenderer* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	const gchar* _tmp6_;
	GtkCellRenderer* _tmp9_;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = cell_layout;
	_tmp1_ = cell;
	_tmp2_ = tree_model;
	_tmp3_ = *iter;
	tracker_view_background_renderer_func (self, _tmp0_, _tmp1_, _tmp2_, &_tmp3_);
	_tmp4_ = tree_model;
	_tmp5_ = *iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 5, &date, -1, -1);
	_tmp6_ = date;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		_tmp7_ = date;
		_tmp8_ = tracker_time_format_from_iso8601 (_tmp7_);
		_g_free0 (date);
		date = _tmp8_;
	}
	_tmp9_ = cell;
	_tmp10_ = date;
	g_object_set ((GObject*) _tmp9_, "text", _tmp10_, NULL);
	_g_free0 (date);
}


static void tracker_view_category_detail_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter) {
	TrackerQueryType category = 0;
	gchar* markup;
	gchar* detail = NULL;
	GtkCellLayout* _tmp0_;
	GtkCellRenderer* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	const gchar* _tmp6_;
	TrackerQueryType _tmp8_;
	const gchar* _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	gchar* _tmp24_ = NULL;
	GtkCellRenderer* _tmp25_;
	const gchar* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (iter != NULL);
	markup = NULL;
	_tmp0_ = cell_layout;
	_tmp1_ = cell;
	_tmp2_ = tree_model;
	_tmp3_ = *iter;
	tracker_view_background_renderer_func (self, _tmp0_, _tmp1_, _tmp2_, &_tmp3_);
	_tmp4_ = tree_model;
	_tmp5_ = *iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 4, &detail, 7, &category, -1, -1);
	_tmp6_ = detail;
	if (_tmp6_ == NULL) {
		GtkCellRenderer* _tmp7_;
		_tmp7_ = cell;
		g_object_set ((GObject*) _tmp7_, "markup", NULL, NULL);
		_g_free0 (detail);
		_g_free0 (markup);
		return;
	}
	_tmp8_ = category;
	switch (_tmp8_) {
		case TRACKER_QUERY_TYPE_FOLDERS:
		case TRACKER_QUERY_TYPE_MAIL:
		case TRACKER_QUERY_TYPE_BOOKMARKS:
		{
			const gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			_tmp9_ = detail;
			_tmp10_ = tracker_time_format_from_iso8601 (_tmp9_);
			_g_free0 (detail);
			detail = _tmp10_;
			break;
		}
		case TRACKER_QUERY_TYPE_MUSIC:
		case TRACKER_QUERY_TYPE_VIDEOS:
		{
			const gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			_tmp11_ = detail;
			_tmp12_ = tracker_time_format_from_seconds (_tmp11_);
			_g_free0 (detail);
			detail = _tmp12_;
			break;
		}
		case TRACKER_QUERY_TYPE_DOCUMENTS:
		{
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			_tmp13_ = detail;
			_tmp14_ = g_strconcat (_tmp13_, " ", NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = _ ("Pages");
			_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
			_g_free0 (detail);
			detail = _tmp17_;
			_g_free0 (_tmp15_);
			break;
		}
		case TRACKER_QUERY_TYPE_IMAGES:
		{
			const gchar* _tmp18_;
			gint _tmp19_ = 0;
			gchar* _tmp20_ = NULL;
			_tmp18_ = detail;
			_tmp19_ = atoi (_tmp18_);
			_tmp20_ = g_format_size_for_display ((gint64) _tmp19_);
			_g_free0 (detail);
			detail = _tmp20_;
			break;
		}
		default:
		break;
	}
	_tmp21_ = detail;
	_tmp22_ = g_markup_escape_text (_tmp21_, (gssize) (-1));
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strdup_printf ("<span color='grey'><small>%s</small></span>", _tmp23_);
	_g_free0 (markup);
	markup = _tmp24_;
	_g_free0 (_tmp23_);
	_tmp25_ = cell;
	_tmp26_ = markup;
	g_object_set ((GObject*) _tmp25_, "markup", _tmp26_, NULL);
	_g_free0 (detail);
	_g_free0 (markup);
}


static gboolean _tracker_view_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = tracker_view_view_button_press_event (self, _sender, event);
	return result;
}


static void _tracker_view_context_menu_directory_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	tracker_view_context_menu_directory_clicked (self);
}


static void _tracker_view_context_menu_tags_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	tracker_view_context_menu_tags_clicked (self);
}


static void tracker_view_setup_menus (TrackerView* self) {
	GtkWidget* _tmp0_;
	GtkMenu* _tmp1_;
	GtkMenu* _tmp2_;
	const gchar* _tmp3_ = NULL;
	GtkMenuItem* _tmp4_;
	GtkMenuItem* _tmp5_;
	GtkMenuItem* item;
	GtkMenuItem* _tmp6_;
	GtkMenu* _tmp7_;
	GtkMenuItem* _tmp8_;
	GtkSeparatorMenuItem* _tmp9_;
	GtkSeparatorMenuItem* _tmp10_;
	GtkSeparatorMenuItem* separator;
	GtkMenu* _tmp11_;
	const gchar* _tmp12_ = NULL;
	GtkMenuItem* _tmp13_;
	GtkMenuItem* _tmp14_;
	GtkMenuItem* _tmp15_;
	GtkMenu* _tmp16_;
	GtkMenuItem* _tmp17_;
	GtkMenu* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	g_signal_connect_object (_tmp0_, "button-press-event", (GCallback) _tracker_view_view_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp1_ = (GtkMenu*) gtk_menu_new ();
	_tmp2_ = g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->context_menu);
	self->priv->context_menu = _tmp2_;
	_tmp3_ = _ ("_Show Parent Directory");
	_tmp4_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp3_);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	item = _tmp5_;
	_tmp6_ = item;
	g_signal_connect_object (_tmp6_, "activate", (GCallback) _tracker_view_context_menu_directory_clicked_gtk_menu_item_activate, self, 0);
	_tmp7_ = self->priv->context_menu;
	_tmp8_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	_tmp10_ = g_object_ref_sink (_tmp9_);
	separator = _tmp10_;
	_tmp11_ = self->priv->context_menu;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp11_, (GtkWidget*) ((GtkMenuItem*) separator));
	_tmp12_ = _ ("_Tags...");
	_tmp13_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp12_);
	_tmp14_ = g_object_ref_sink (_tmp13_);
	_g_object_unref0 (item);
	item = _tmp14_;
	_tmp15_ = item;
	g_signal_connect_object (_tmp15_, "activate", (GCallback) _tracker_view_context_menu_tags_clicked_gtk_menu_item_activate, self, 0);
	_tmp16_ = self->priv->context_menu;
	_tmp17_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->context_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp18_);
	_g_object_unref0 (separator);
	_g_object_unref0 (item);
}


static gboolean tracker_view_view_button_press_event (TrackerView* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	GdkEventButton _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.button;
	if (_tmp1_ == ((guint) 3)) {
		GtkTreePath* _tmp2_ = NULL;
		GtkTreePath* _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = tracker_view_get_selected_path (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_ != NULL;
		_gtk_tree_path_free0 (_tmp3_);
		if (_tmp4_) {
			GtkMenu* _tmp5_;
			GdkEventButton _tmp6_;
			guint _tmp7_;
			GdkEventButton _tmp8_;
			guint32 _tmp9_;
			_tmp5_ = self->priv->context_menu;
			_tmp6_ = *event;
			_tmp7_ = _tmp6_.button;
			_tmp8_ = *event;
			_tmp9_ = _tmp8_.time;
			gtk_menu_popup (_tmp5_, NULL, NULL, NULL, NULL, _tmp7_, _tmp9_);
		}
	}
	result = FALSE;
	return result;
}


static GtkTreeModel* tracker_view_get_model (TrackerView* self) {
	GtkTreeModel* result = NULL;
	TrackerViewDisplay _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	switch (_tmp0_) {
		case TRACKER_VIEW_DISPLAY_CATEGORIES:
		case TRACKER_VIEW_DISPLAY_FILE_LIST:
		{
			GtkWidget* _tmp1_;
			GtkTreeView* _tmp2_;
			GtkTreeView* v;
			GtkTreeView* _tmp3_;
			GtkTreeModel* _tmp4_ = NULL;
			GtkTreeModel* _tmp5_;
			_tmp1_ = self->priv->view;
			_tmp2_ = _g_object_ref0 (GTK_TREE_VIEW (_tmp1_));
			v = _tmp2_;
			_tmp3_ = v;
			_tmp4_ = gtk_tree_view_get_model (_tmp3_);
			_tmp5_ = _g_object_ref0 (_tmp4_);
			result = _tmp5_;
			_g_object_unref0 (v);
			return result;
		}
		case TRACKER_VIEW_DISPLAY_FILE_ICONS:
		{
			GtkWidget* _tmp6_;
			GtkIconView* _tmp7_;
			GtkIconView* v;
			GtkIconView* _tmp8_;
			GtkTreeModel* _tmp9_ = NULL;
			GtkTreeModel* _tmp10_;
			_tmp6_ = self->priv->view;
			_tmp7_ = _g_object_ref0 (GTK_ICON_VIEW (_tmp6_));
			v = _tmp7_;
			_tmp8_ = v;
			_tmp9_ = gtk_icon_view_get_model (_tmp8_);
			_tmp10_ = _g_object_ref0 (_tmp9_);
			result = _tmp10_;
			_g_object_unref0 (v);
			return result;
		}
		default:
		{
			break;
		}
	}
	result = NULL;
	return result;
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static GtkTreePath* tracker_view_get_selected_path (TrackerView* self) {
	GtkTreePath* result = NULL;
	TrackerViewDisplay _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	switch (_tmp0_) {
		case TRACKER_VIEW_DISPLAY_CATEGORIES:
		case TRACKER_VIEW_DISPLAY_FILE_LIST:
		{
			GtkWidget* _tmp1_;
			GtkTreeView* _tmp2_;
			GtkTreeView* v;
			GtkTreeView* _tmp3_;
			GtkTreeSelection* _tmp4_ = NULL;
			GtkTreeSelection* _tmp5_;
			GtkTreeSelection* s;
			GtkTreeSelection* _tmp6_;
			GList* _tmp7_ = NULL;
			GList* selected;
			GList* _tmp8_;
			gconstpointer _tmp9_ = NULL;
			GtkTreePath* _tmp10_;
			_tmp1_ = self->priv->view;
			_tmp2_ = _g_object_ref0 (GTK_TREE_VIEW (_tmp1_));
			v = _tmp2_;
			_tmp3_ = v;
			_tmp4_ = gtk_tree_view_get_selection (_tmp3_);
			_tmp5_ = _g_object_ref0 (_tmp4_);
			s = _tmp5_;
			_tmp6_ = s;
			_tmp7_ = gtk_tree_selection_get_selected_rows (_tmp6_, NULL);
			selected = _tmp7_;
			_tmp8_ = selected;
			_tmp9_ = g_list_nth_data (_tmp8_, (guint) 0);
			_tmp10_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp9_);
			result = _tmp10_;
			__g_list_free__gtk_tree_path_free0_0 (selected);
			_g_object_unref0 (s);
			_g_object_unref0 (v);
			return result;
		}
		case TRACKER_VIEW_DISPLAY_FILE_ICONS:
		{
			GtkWidget* _tmp11_;
			GtkIconView* _tmp12_;
			GtkIconView* v;
			GtkIconView* _tmp13_;
			GList* _tmp14_ = NULL;
			GList* selected;
			GList* _tmp15_;
			gconstpointer _tmp16_ = NULL;
			GtkTreePath* _tmp17_;
			_tmp11_ = self->priv->view;
			_tmp12_ = _g_object_ref0 (GTK_ICON_VIEW (_tmp11_));
			v = _tmp12_;
			_tmp13_ = v;
			_tmp14_ = gtk_icon_view_get_selected_items (_tmp13_);
			selected = _tmp14_;
			_tmp15_ = selected;
			_tmp16_ = g_list_nth_data (_tmp15_, (guint) 0);
			_tmp17_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp16_);
			result = _tmp17_;
			__g_list_free__gtk_tree_path_free0_0 (selected);
			_g_object_unref0 (v);
			return result;
		}
		default:
		{
			break;
		}
	}
	result = NULL;
	return result;
}


static void tracker_view_context_menu_directory_clicked (TrackerView* self) {
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* model;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreePath* path;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_view_get_model (self);
	model = _tmp0_;
	_tmp1_ = tracker_view_get_selected_path (self);
	path = _tmp1_;
	tracker_model_launch_selected_parent_dir (model, path, 1);
	_gtk_tree_path_free0 (path);
	_g_object_unref0 (model);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		_g_object_unref0 (_data5_->dialog);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda3_ (Block5Data* _data5_) {
	TrackerView * self;
	GtkDialog* _tmp0_;
	self = _data5_->self;
	_tmp0_ = _data5_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void ___lambda3__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda3_ (self);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void tracker_view_context_menu_tags_clicked (TrackerView* self) {
	Block5Data* _data5_;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* model;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreePath* path;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	const gchar* uri = NULL;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkDialog* _tmp11_;
	GtkDialog* _tmp12_;
	GtkDialog* _tmp13_;
	GtkDialog* _tmp14_;
	GtkDialog* _tmp15_;
	GList* files;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	GList* _tmp18_;
	TrackerTagsView* _tmp19_;
	GtkVBox* _tmp20_;
	GtkVBox* vbox;
	GtkDialog* _tmp21_;
	GtkBox* _tmp22_ = NULL;
	GtkBox* _tmp23_;
	GtkBox* content;
	GtkBox* _tmp24_;
	GtkVBox* _tmp25_;
	GtkBox* _tmp26_;
	GtkDialog* _tmp27_;
	GtkDialog* _tmp28_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = tracker_view_get_model (self);
	model = _tmp0_;
	_tmp1_ = tracker_view_get_selected_path (self);
	path = _tmp1_;
	_tmp2_ = model;
	_tmp3_ = path;
	gtk_tree_model_get_iter (_tmp2_, &_tmp4_, _tmp3_);
	iter = _tmp4_;
	_tmp5_ = model;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &uri, -1);
	_tmp7_ = uri;
	if (_tmp7_ == NULL) {
		_gtk_tree_path_free0 (path);
		_g_object_unref0 (model);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp8_ = uri;
	g_debug ("tracker-view.vala:535: Showing tags dialog for uri:'%s'", _tmp8_);
	_tmp9_ = _ ("Tags");
	_tmp10_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp11_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp9_, GTK_WINDOW (_tmp10_), GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL, NULL);
	_tmp12_ = g_object_ref_sink (_tmp11_);
	_data5_->dialog = _tmp12_;
	_tmp13_ = _data5_->dialog;
	gtk_window_set_default_size ((GtkWindow*) _tmp13_, 400, 300);
	_tmp14_ = _data5_->dialog;
	gtk_container_set_border_width ((GtkContainer*) _tmp14_, (guint) 12);
	_tmp15_ = _data5_->dialog;
	g_signal_connect_data (_tmp15_, "response", (GCallback) ___lambda3__gtk_dialog_response, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	files = NULL;
	_tmp16_ = uri;
	_tmp17_ = g_strdup (_tmp16_);
	files = g_list_prepend (files, _tmp17_);
	_tmp18_ = files;
	files = NULL;
	_tmp19_ = tracker_tags_view_new (_tmp18_);
	_tmp20_ = (GtkVBox*) g_object_ref_sink (_tmp19_);
	vbox = _tmp20_;
	_tmp21_ = _data5_->dialog;
	_tmp22_ = gtk_dialog_get_content_area (_tmp21_);
	_tmp23_ = _g_object_ref0 (GTK_IS_BOX (_tmp22_) ? ((GtkBox*) _tmp22_) : NULL);
	content = _tmp23_;
	_tmp24_ = content;
	_tmp25_ = vbox;
	gtk_box_pack_start (_tmp24_, (GtkWidget*) _tmp25_, TRUE, TRUE, (guint) 6);
	_tmp26_ = content;
	gtk_box_set_spacing (_tmp26_, 10);
	_tmp27_ = _data5_->dialog;
	gtk_widget_show_all (GTK_WIDGET (_tmp27_));
	_tmp28_ = _data5_->dialog;
	gtk_dialog_run (_tmp28_);
	_g_object_unref0 (content);
	_g_object_unref0 (vbox);
	__g_list_free__g_free0_0 (files);
	_gtk_tree_path_free0 (path);
	_g_object_unref0 (model);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


TrackerViewDisplay tracker_view_get_display (TrackerView* self) {
	TrackerViewDisplay result;
	TrackerViewDisplay _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}


static void tracker_view_set_display (TrackerView* self, TrackerViewDisplay value) {
	TrackerViewDisplay _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_display = _tmp0_;
	g_object_notify ((GObject *) self, "display");
}


TrackerResultStore* tracker_view_get_store (TrackerView* self) {
	TrackerResultStore* result;
	TrackerResultStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_store;
	result = _tmp0_;
	return result;
}


void tracker_view_set_store (TrackerView* self, TrackerResultStore* value) {
	TrackerResultStore* _tmp0_;
	TrackerResultStore* _tmp3_;
	TrackerResultStore* _tmp4_;
	TrackerResultStore* _tmp5_;
	TrackerViewDisplay _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_store;
	if (_tmp0_ != NULL) {
		TrackerResultStore* _tmp1_;
		guint _tmp2_ = 0U;
		_tmp1_ = self->priv->_store;
		g_signal_parse_name ("row-changed", GTK_TYPE_TREE_MODEL, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkTreeModel*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _tracker_view_store_row_changed_gtk_tree_model_row_changed, self);
	}
	_tmp3_ = value;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->_store);
	self->priv->_store = _tmp4_;
	_tmp5_ = self->priv->_store;
	if (_tmp5_ != NULL) {
		TrackerResultStore* _tmp6_;
		TrackerResultStore* _tmp7_;
		_tmp6_ = self->priv->_store;
		g_debug ("tracker-view.vala:48: using store:%p", _tmp6_);
		_tmp7_ = self->priv->_store;
		g_signal_connect_object ((GtkTreeModel*) _tmp7_, "row-changed", (GCallback) _tracker_view_store_row_changed_gtk_tree_model_row_changed, self, 0);
	}
	_tmp8_ = self->priv->_display;
	if (_tmp8_ != TRACKER_VIEW_DISPLAY_FILE_ICONS) {
		GtkWidget* _tmp9_;
		TrackerResultStore* _tmp10_;
		_tmp9_ = self->priv->view;
		_tmp10_ = self->priv->_store;
		gtk_tree_view_set_model (GTK_TREE_VIEW (_tmp9_), (GtkTreeModel*) _tmp10_);
	} else {
		GtkWidget* _tmp11_;
		TrackerResultStore* _tmp12_;
		_tmp11_ = self->priv->view;
		_tmp12_ = self->priv->_store;
		gtk_icon_view_set_model (GTK_ICON_VIEW (_tmp11_), (GtkTreeModel*) _tmp12_);
	}
	g_object_notify ((GObject *) self, "store");
}


static void tracker_view_class_init (TrackerViewClass * klass) {
	tracker_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerViewPrivate));
	GTK_WIDGET_CLASS (klass)->unmap = tracker_view_real_unmap;
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_VIEW_DISPLAY, g_param_spec_enum ("display", "display", "display", TRACKER_VIEW_TYPE_DISPLAY, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_VIEW_STORE, g_param_spec_object ("store", "store", "store", TRACKER_TYPE_RESULT_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void tracker_view_instance_init (TrackerView * self) {
	self->priv = TRACKER_VIEW_GET_PRIVATE (self);
	self->priv->view = NULL;
}


static void tracker_view_finalize (GObject* obj) {
	TrackerView * self;
	self = TRACKER_VIEW (obj);
	_g_object_unref0 (self->priv->_store);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->context_menu);
	G_OBJECT_CLASS (tracker_view_parent_class)->finalize (obj);
}


GType tracker_view_get_type (void) {
	static volatile gsize tracker_view_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerView), 0, (GInstanceInitFunc) tracker_view_instance_init, NULL };
		GType tracker_view_type_id;
		tracker_view_type_id = g_type_register_static (GTK_TYPE_SCROLLED_WINDOW, "TrackerView", &g_define_type_info, 0);
		g_once_init_leave (&tracker_view_type_id__volatile, tracker_view_type_id);
	}
	return tracker_view_type_id__volatile;
}


static void _vala_tracker_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerView * self;
	self = TRACKER_VIEW (object);
	switch (property_id) {
		case TRACKER_VIEW_DISPLAY:
		g_value_set_enum (value, tracker_view_get_display (self));
		break;
		case TRACKER_VIEW_STORE:
		g_value_set_object (value, tracker_view_get_store (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tracker_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerView * self;
	self = TRACKER_VIEW (object);
	switch (property_id) {
		case TRACKER_VIEW_DISPLAY:
		tracker_view_set_display (self, g_value_get_enum (value));
		break;
		case TRACKER_VIEW_STORE:
		tracker_view_set_store (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



