/* vim: set tabstop=4: */
/*
 * This file is part of TraceProto.
 * Copyright 2004-2005 Eric Hope and others; see the AUTHORS file for details.
 *
 * TraceProto is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * TraceProto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TraceProto; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*! \file tp_as.h
 *  \brief Routines to look up Autonomous Systems.
 *
 * These routines implement the lookup of the Autonomous System (AS) to which
 * an IP address belongs. Oversimplified, an AS is a network of IP addresses
 * that are under a single administration as far as routing is concerned.
 * For more information, see RFC 1930 (BCP-6),
 * J. Hawkinson [BBN Planet], T. Bates [MCI],
 * "Guidelines for creation, selection, and registration of an Autonomous
 * System (AS)", March 1996,
 * http://zvon.org/tmRFC/RFC1930/Output/index.html
 */
#ifndef TP_AS_H
#define TP_AS_H 1

char as_string[1024];

/*! Initialisation function for AS lookups; returns 0 iff successful. */
int setup_as(void);

/*! Try to look up the AS for an IPv4 (dotted quad) address; put it in
 *  as_string if found. Returns 0 iff succesful. */
int find_as(const char * dotted_quad);

/*
 * Short, isn't it?
 */
#endif /* TP_AS_H */
