from trac.core import *
from trac.perm import IPermissionPolicy, IPermissionRequestor

revision = "$Rev: 6669 $"
url = "$URL: file:///var/svn/trac/tags/trac-0.12.3/sample-plugins/permissions/vulnerability_tickets.py $"

class SecurityTicketsPolicy(Component):
    """Prevent public access to security sensitive tickets.
    
    Add the VULNERABILITY_VIEW permission as a pre-requisite for any
    other permission check done on tickets that have the words
    "security" or "vulnerability" in the summary or keywords fields.

    Once this plugin is enabled, you'll have to insert it at the appropriate
    place in your list of permission policies, e.g.
    {{{
    [trac]
    permission_policies = SecurityTicketsPolicy, AuthzPolicy, 
                          DefaultPermissionPolicy, LegacyAttachmentPolicy
    }}}
    """
    
    implements(IPermissionPolicy, IPermissionRequestor)

    # IPermissionPolicy methods

    def check_permission(self, action, username, resource, perm):
        # We add the 'VULNERABILITY_VIEW' pre-requisite for any action
        # other than 'VULNERABILITY_VIEW' itself, as this would lead
        # to recursion.
        if action == 'VULNERABILITY_VIEW':
            return
        
        # Check whether we're dealing with a ticket resource
        while resource:
            if resource.realm == 'ticket':
                break
            resource = resource.parent

        if resource and resource.realm == 'ticket' and resource.id is not None:
            db = self.env.get_db_cnx()
            cursor = db.cursor()
            cursor.execute("SELECT keywords, summary FROM ticket WHERE id=%s",
                           (resource.id,))
            for keywords, summary in cursor:
                fields = ''.join([f for f in (keywords, summary) if f]).lower()
                if 'security' in fields or 'vulnerability' in fields:
                    if 'VULNERABILITY_VIEW' not in perm:
                        return False

    # IPermissionRequestor methods

    def get_permission_actions(self):
        yield 'VULNERABILITY_VIEW'
