<?cs set:html.stylesheet = 'css/roadmap.css' ?>
<?cs include:"header.cs"?>
<?cs include:"macros.cs"?>

<div id="ctxtnav" class="nav">
 <ul>
  <?cs if:milestone.href.edit ?><li class="first"><a href="<?cs
    var:milestone.href.edit ?>">マイルストーン情報を編集</a></li><?cs /if ?>
  <?cs if:milestone.href.delete ?><li class="last"><a href="<?cs
    var:milestone.href.delete ?>">マイルストーンを削除</a></li><?cs /if ?>
 </ul>
</div>

<div id="content" class="milestone">
 <?cs if:milestone.mode == "new" ?>
 <h1>マイルストーンを登録</h1>
 <?cs elif:milestone.mode == "edit" ?>
 <h1>マイルストーン <?cs var:milestone.name ?> を編集</h1>
 <?cs elif:milestone.mode == "delete" ?>
 <h1>マイルストーン <?cs var:milestone.name ?> を削除</h1>
 <?cs else ?>
 <h1>マイルストーン <?cs var:milestone.name ?></h1>
 <form action="#stats" id="prefs" method="get">
  <div>
   <label for="by">進捗度をグルーピングする: </label>
   <select id="by" name="by"><?cs each:group = milestone.stats.available_groups ?>
    <option<?cs
      if:milestone.stats.grouped_by == group?> selected="selected"<?cs
      /if ?> value="<?cs var:group ?>"><?cs
        if:group == "component" ?>コンポーネント<?cs
        elif:group == "version" ?>バージョン<?cs
        elif:group == "severity" ?>重要度<?cs
        elif:group == "priority" ?>優先度<?cs
        elif:group == "owner" ?>担当者<?cs
        else ?><? var:group ?><?cs
        /if ?></option>
   <?cs /each ?></select>
   <div>
    <input name="showempty" id="showempty" type="checkbox"<?cs
       if:milestone.stats.show_empty ?> checked="checked"<?cs /if ?>>
    <label for="showempty">チケットが存在しないグループも表示する</label>
   </div>
   <div class="buttons">
    <input type="submit" value="更新" />
   </div>
  </div>
 </form>
 <?cs /if ?>

 <?cs if:milestone.mode == "edit" || milestone.mode == "new" ?>
  <script type="text/javascript">
    addEvent(window, 'load', function() {
      document.getElementById('name').focus() }
    );
  </script>
  <form id="edit" action="<?cs var:cgi_location ?>" method="post">
   <input type="hidden" name="mode" value="milestone" />
   <input type="hidden" name="id" value="<?cs var:milestone.name ?>" />
   <input type="hidden" name="action" value="commit_changes" />
   <div class="field">
    <label for="name">マイルストーン名称:</label><br />
    <input type="text" id="name" name="name" size="32" value="<?cs
      var:milestone.name ?>" />
   </div>
   <div class="field">
    <label for="datemode">完了期限:</label><br />
    <select name="datemode" id="datemode"
        onchange="enableControl('date',this.value=='manual');
                  if (this.value=='manual') document.getElementById('date').focus();">
     <option value="manual">手動で設定</option>
     <option value="now">直ちに完了に設定</option>
    </select>
    <input type="text" id="date" name="date" size="8" value="<?cs
      var:milestone.date ?>" title="Format: <?cs var:milestone.date_hint ?>" />
    <label for="date"><em>Format: <?cs var:milestone.date_hint ?></em></label>
   </div>
   <div class="field">
    <fieldset class="iefix">
     <label for="descr">マイルストーンについての説明 (<a tabindex="42" href="<?cs
       var:trac.href.wiki ?>/WikiFormatting">WikiFormatting</a>を使用できます):</label>
     <p><textarea id="descr" name="descr" rows="12" cols="80"><?cs
       var:milestone.descr_source ?></textarea></p>
     <?cs call:wiki_toolbar('descr') ?>
    </fieldset>
   </div>
   <div class="buttons">
    <?cs if:milestone.mode == "new"
     ?><input type="submit" name="save" value="登録" /><?cs
    else
     ?><input type="submit" name="save" value="保存" /><?cs
    /if ?>
    <input type="submit" name="cancel" value="取り消し" />
   </div>
  </form>
 <?cs elif:milestone.mode == "delete" ?>
  <form action="<?cs var:cgi_location ?>" method="post">
   <input type="hidden" name="mode" value="milestone" />
   <input type="hidden" name="id" value="<?cs var:milestone.name ?>" />
   <input type="hidden" name="action" value="confirm_delete" />
   <p><strong>このマイルストーンを本当に削除してもいいですか?</strong></p>
   <input type="checkbox" id="retarget" name="retarget" checked="checked"
       onclick="enableControl('target', this.checked)"/>
   <label for="target">このマイルストーンのチケットを他のマイルストーンに関連付ける</label>
   <select name="target" id="target">
    <option value="">None</option><?cs
     each:other = milestones ?><?cs if:other != milestone.name ?>
      <option><?cs var:other ?></option><?cs 
     /if ?><?cs /each ?>
   </select>
   <div class="buttons">
    <input type="submit" name="cancel" value="取り消し" />
    <input type="submit" name="delete" value="削除" />
   </div>
  </form>
 <?cs else ?>
  <em class="date"><?cs if:milestone.date ?>
   <?cs var:milestone.date ?><?cs else ?>完了期限が設定されていません<?cs /if ?>
  </em>
  <div class="descr"><?cs var:milestone.descr ?></div>
 <?cs /if ?>

 <?cs if:milestone.mode == "view" ?>
 <h2 class="stats"><?cs var:milestone.stats.grouped_by ?>別進捗度</h2>
 <table class="listing" id="stats"
   summary="<?cs
     var:milestone.stats.grouped_by ?>別に集計したマイルストーンの進捗度">
  <thead><tr>
   <th class="name" rowspan="2"><?cs var:milestone.stats.grouped_by ?></th>
   <th class="tickets" scope="col" colspan="2">チケット</th>
   <th class="progress" rowspan="2">解決済みチケットの割合</th>
  </tr><tr>
   <th class="open" scope="col">未解決</th>
   <th class="closed" scope="col">解決済み</th>
  </tr></thead>
  <?cs if:len(milestone.stats.groups) ?><tbody>
   <?cs each:group = milestone.stats.groups ?>
    <tr class="<?cs if:name(group) % 2 ?>odd<?cs else ?>even<?cs /if ?>">
     <th class="name" scope="row"><a href="<?cs
       var:group.queries.all_tickets ?>"><?cs var:group.name ?></a></th>
     <td class="open tickets"><a href="<?cs
       var:group.queries.active_tickets ?>"><?cs
       var:group.active_tickets ?></a></td>
     <td class="closed tickets"><a href="<?cs
       var:group.queries.closed_tickets ?>"><?cs
       var:group.closed_tickets ?></a></td>
     <td class="progress">
      <?cs if:#group.total_tickets ?>
       <div class="progress" style="width: <?cs
         var:#group.percent_total * #80 / #100 ?>%"><div style="width: <?cs
         var:#group.percent_complete ?>%"></div>
       </div>
       <p class="percent"><?cs var:#group.percent_complete ?>%</p>
      <?cs /if ?>
     </td>
    </tr>
   <?cs /each ?>
  </tbody><?cs /if ?>
  <tbody class="totals"><tr>
   <th class="name" scope="row"><a href="<?cs
     var:milestone.queries.all_tickets ?>">合計</a></th>
   <td class="open tickets"><a href="<?cs
     var:milestone.queries.active_tickets ?>"><?cs
     var:milestone.stats.active_tickets ?></a></td>
   <td class="closed tickets"><a href="<?cs
     var:milestone.queries.closed_tickets ?>"><?cs
     var:milestone.stats.closed_tickets ?></a></td>
   <td class="progress">
    <?cs if:#milestone.stats.total_tickets ?>
     <div class="progress" style="width: 80%">
      <div style="width: <?cs var:#milestone.stats.percent_complete ?>%"></div>
     </div>
     <p class="percent"><?cs var:#milestone.stats.percent_complete ?>%</p>
    <?cs /if ?>
   </td>
  </tr></tbody>
 </table><?cs /if ?>

 <div id="help">
  <strong>Note:</strong> ロードマップについてのヘルプは <a href="<?cs
    var:trac.href.wiki ?>/TracRoadmap">TracRoadmap</a> を参照してください。
 </div>

</div>
<?cs include:"footer.cs"?>
