#include "tra.h"

Replica *repl;

static Path*
strtopath(char *s)
{
	char *f[20];
	int i, nf;
	Path *p;

	nf = getfields(s, f, nelem(f), 1, "/");
	p = nil;
	for(i=0; i<nf; i++)
		p = mkpath(p, f[i]);
	return p;
}

void
usage(void)
{
	fprint(2, "usage: scan replica [path...]\n");
	exits("usage");
}

void
threadmain(int argc, char **argv)
{
	int i;
	Path *p;

	fmtinstall('H', encodefmt);
	fmtinstall('P', pathfmt);
	fmtinstall('R', rpcfmt);
	fmtinstall('$', statfmt);
	fmtinstall('V', vtimefmt);

	ARGBEGIN{
	case 'D':
		debug |= dbglevel(EARGF(usage()));
		break;
	case 'V':
		traversion();
	default:
		usage();
	}ARGEND

	if(argc < 1)
		usage();

	startclient();
	repl = dialreplica(argv[0]);
	if(clientbanner(repl, argv[0]) < 0)
		sysfatal("handshake %s: %r", argv[0]);

	threadcreate(replthread, repl);
	
	argc--;
	argv++;
	fprint(2, "scan...");
	if(argc == 0){
		fprint(2, "%P...", nil);
		if(rpcstat(repl, nil) == nil)
			sysfatal("rpcstat: %s", rpcerror());
	}else{
		for(i=0; i<argc; i++){
			p = strtopath(argv[i]);
			fprint(2, "%P...", p);
			if(rpcstat(repl, p) == nil)
				sysfatal("rpcstat: %s", rpcerror());
		}
	}
	fprint(2, "hangup...");
	rpchangup(repl);
	fprint(2, "close...");
	replclose(repl);
	fprint(2, "exit\n");
	exits(nil);
}

