/*
 *  TouchFreezeApp.h
 *
 *  Copyright (C) 2007, 2008  Stefan Kombrink
 *  Copyright (C) 2008 Pau Garcia i Quiles
 *
 *  This file is part of TouchFreeze.
 *
 *  TouchFreeze is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TouchFreeze is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with touchfreeze; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 *  On Debian GNU/Linux systems, the complete text of the GNU General
 *  Public License can be found in the /usr/share/common-licenses/GPL file.
 */


#ifndef TOUCHFREEZEAPP_H
#define TOUCHFREEZEAPP_H

#include <QApplication>

class SynDaemon;
class TouchFreezeUI;

class TouchFreezeApp: public QApplication
{
Q_OBJECT
public:
  TouchFreezeApp( int argc, char* argv[] );
  virtual ~TouchFreezeApp();

protected:

protected slots:
  void setTouchpad(bool);
  void enableTouchpad();
  void disableTouchpad();
  void onStartTyping();
  void onStopTyping();
  void onCancel();
  void onApply();

private:
  SynDaemon* mSynDaemon;
  TouchFreezeUI* mUI;
  QString mClientBin;
  int mInitialState;
};

#endif
