# topplot

<!-- see https://github.com/openhwgroup/cva6/blob/master/CONTRIBUTING.md for icon suggestions -->

## Release info

### 0.1.4
#### Bugs fixed

:bug: Handle requests for per core graphs when there's no per core data. 

:bug: Handle the case when a CPU core happens to have no POI data.

### 0.1.3

:clipboard: The Makefile now has simple testing. It checks that topplot runs
            properly when asked to produce PNG files for the Overview figure
            for any files following this pattern logs/top.*.log. No validation
            is performed other than topplot's exit status.

#### Bugs fixed

:bug: Log files with summary CPU info in the header, rather than split out by
      core, were not producing a required temporary POI data file. This was a
      refactoring brainfart. It also highlights the need for testing.

### 0.1.2

:clipboard: The Python package was called 'topplot_' to facilitate the wrapper
            script being called 'topplot', but now the script is auto-generated
            by setuptools, and the Python package is called 'topplot'.

#### Bugs fixed

:bug: Logo now accessible when installed from .whl (e.g. via pip)

### 0.1.0

#### New features

:sparkles: The '--graph' option now accepts multiple characters from
           [12340cCpPqQ], so you can specify more than one figure.
           The specifiers [pPqQ] are new. 'p' saves the most recently opened
           figure as a PNG file, 'P' saves all the open figures as PNG files.
           Similarly 'q' closes the most recently opened figure, 'Q' closes
           all the open figures.

:sparkles: To give reassurance of activity, especially for larger log files or
		   more complex plots, there's now a progress window at startup and
		   when loading new figures.

:sparkles: To improve clarity, only the grouped menu is displayed on the
		   overview figure's cpu data's graph. It now also has load average
		   line.

:clipboard: If [Yappi](https://github.com/sumerc/yappi) is detected, the 
		   `--profile` CLA becomes available. If this is option is passed to
		   topplot, both callgrind format profiling data and Yappi func stats
		   files are emitted.

#### Bugs fixed

:bug: Displaying core markers on the lines of the CPU graph is slow,
	  so now never happens on the overview window, and only on the separate CPU
	  figure if the commandline contains the `--display-cpu-markers` flag.

### 0.0.5

#### New features

:sparkles: Run on Windows as well as Linux. May run on other platforms too, but I've
           no way to test this. Please report results on other platforms.

:sparkles: Handle 'Threads' column when `top` is run with `-H`.

:sparkles: Handle explicit '[KMGTPE]iB' for mem and swap scales. Warns if it
           looks like the scale has been set too high.

:memo: Add documentation on how to configure **top** to output the data for various
       purposes, and in the correct format.

:clipboard: Add `--tmpfile DIR` CLA to enable inspection of temporary files
            which are otherwise automatically cleared away.

:clipboard: Add `--nowrite` CLA to disable writing to temporary files. Works
		    with `--tmpfile DIR` to allow interfering with test data.

#### Bugs fixed

:bug: Despite being written to output utf-8, `top` will spit out whatever /proc
      gives as commands. Now handling as ISO-8859-1. Not good for unicode, but
      an improvement on crashing.

:bug: Final process data was being skipped. Especially tricky when a filter
      reduces to a single process. No longer goes **BANG**!! or skips process.

:bug: CPU Steal data was only partially implemented. Now works if
      '--with-cpu-steal' CLA is given.

:bug: Issue https://gitlab.com/eBardie/topplot/-/issues/9 Displaying per core CPU info no longer flakey.

:bug: Issue https://gitlab.com/eBardie/topplot/-/issues/17 Toggling menus on POI per CPU core now works as expected.
