# !!! AUTOGENERATED FILE !!!
# Update with: src/toil/utils/toilUpdateEC2Instances.py
#
# Copyright (C) 2015-2019 UCSC Computational Genomics Lab
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
from six import iteritems
from toil.lib.ec2nodes import InstanceType


# 196 Instance Types.  Generated 2019-06-06 19:04:30.223730.
E2Instances = {
    'a1.2xlarge': InstanceType(name='a1.2xlarge', cores=8, memory=16.0, disks=0, disk_capacity=0),
    'a1.4xlarge': InstanceType(name='a1.4xlarge', cores=16, memory=32.0, disks=0, disk_capacity=0),
    'a1.large': InstanceType(name='a1.large', cores=2, memory=4.0, disks=0, disk_capacity=0),
    'a1.medium': InstanceType(name='a1.medium', cores=1, memory=2.0, disks=0, disk_capacity=0),
    'a1.xlarge': InstanceType(name='a1.xlarge', cores=4, memory=8.0, disks=0, disk_capacity=0),
    'c1.medium': InstanceType(name='c1.medium', cores=2, memory=1.7, disks=1.0, disk_capacity=350.0),
    'c1.xlarge': InstanceType(name='c1.xlarge', cores=8, memory=7.0, disks=4.0, disk_capacity=420.0),
    'c3.2xlarge': InstanceType(name='c3.2xlarge', cores=8, memory=15.0, disks=2.0, disk_capacity=80.0),
    'c3.4xlarge': InstanceType(name='c3.4xlarge', cores=16, memory=30.0, disks=2.0, disk_capacity=160.0),
    'c3.8xlarge': InstanceType(name='c3.8xlarge', cores=32, memory=60.0, disks=2.0, disk_capacity=320.0),
    'c3.large': InstanceType(name='c3.large', cores=2, memory=3.75, disks=2.0, disk_capacity=16.0),
    'c3.xlarge': InstanceType(name='c3.xlarge', cores=4, memory=7.5, disks=2.0, disk_capacity=40.0),
    'c4.2xlarge': InstanceType(name='c4.2xlarge', cores=8, memory=15.0, disks=0, disk_capacity=0),
    'c4.4xlarge': InstanceType(name='c4.4xlarge', cores=16, memory=30.0, disks=0, disk_capacity=0),
    'c4.8xlarge': InstanceType(name='c4.8xlarge', cores=36, memory=60.0, disks=0, disk_capacity=0),
    'c4.large': InstanceType(name='c4.large', cores=2, memory=3.75, disks=0, disk_capacity=0),
    'c4.xlarge': InstanceType(name='c4.xlarge', cores=4, memory=7.5, disks=0, disk_capacity=0),
    'c5.18xlarge': InstanceType(name='c5.18xlarge', cores=72, memory=144.0, disks=0, disk_capacity=0),
    'c5.2xlarge': InstanceType(name='c5.2xlarge', cores=8, memory=16.0, disks=0, disk_capacity=0),
    'c5.4xlarge': InstanceType(name='c5.4xlarge', cores=16, memory=32.0, disks=0, disk_capacity=0),
    'c5.9xlarge': InstanceType(name='c5.9xlarge', cores=36, memory=72.0, disks=0, disk_capacity=0),
    'c5.large': InstanceType(name='c5.large', cores=2, memory=4.0, disks=0, disk_capacity=0),
    'c5.xlarge': InstanceType(name='c5.xlarge', cores=4, memory=8.0, disks=0, disk_capacity=0),
    'c5d.18xlarge': InstanceType(name='c5d.18xlarge', cores=72, memory=144.0, disks=2.0, disk_capacity=900.0),
    'c5d.2xlarge': InstanceType(name='c5d.2xlarge', cores=8, memory=16.0, disks=1.0, disk_capacity=200.0),
    'c5d.4xlarge': InstanceType(name='c5d.4xlarge', cores=16, memory=32.0, disks=1.0, disk_capacity=400.0),
    'c5d.9xlarge': InstanceType(name='c5d.9xlarge', cores=36, memory=72.0, disks=1.0, disk_capacity=900.0),
    'c5d.large': InstanceType(name='c5d.large', cores=2, memory=4.0, disks=1.0, disk_capacity=50.0),
    'c5d.xlarge': InstanceType(name='c5d.xlarge', cores=4, memory=8.0, disks=1.0, disk_capacity=100.0),
    'c5n.18xlarge': InstanceType(name='c5n.18xlarge', cores=72, memory=192.0, disks=0, disk_capacity=0),
    'c5n.2xlarge': InstanceType(name='c5n.2xlarge', cores=8, memory=21.0, disks=0, disk_capacity=0),
    'c5n.4xlarge': InstanceType(name='c5n.4xlarge', cores=16, memory=42.0, disks=0, disk_capacity=0),
    'c5n.9xlarge': InstanceType(name='c5n.9xlarge', cores=36, memory=96.0, disks=0, disk_capacity=0),
    'c5n.large': InstanceType(name='c5n.large', cores=2, memory=5.25, disks=0, disk_capacity=0),
    'c5n.xlarge': InstanceType(name='c5n.xlarge', cores=4, memory=10.5, disks=0, disk_capacity=0),
    'cc2.8xlarge': InstanceType(name='cc2.8xlarge', cores=32, memory=60.5, disks=4.0, disk_capacity=840.0),
    'cr1.8xlarge': InstanceType(name='cr1.8xlarge', cores=32, memory=244.0, disks=2.0, disk_capacity=120.0),
    'd2.2xlarge': InstanceType(name='d2.2xlarge', cores=8, memory=61.0, disks=6.0, disk_capacity=2000.0),
    'd2.4xlarge': InstanceType(name='d2.4xlarge', cores=16, memory=122.0, disks=12.0, disk_capacity=2000.0),
    'd2.8xlarge': InstanceType(name='d2.8xlarge', cores=36, memory=244.0, disks=24.0, disk_capacity=2000.0),
    'd2.xlarge': InstanceType(name='d2.xlarge', cores=4, memory=30.5, disks=3.0, disk_capacity=2000.0),
    'f1.16xlarge': InstanceType(name='f1.16xlarge', cores=64, memory=976.0, disks=0, disk_capacity=0),
    'f1.2xlarge': InstanceType(name='f1.2xlarge', cores=8, memory=122.0, disks=0, disk_capacity=0),
    'f1.4xlarge': InstanceType(name='f1.4xlarge', cores=16, memory=244.0, disks=1.0, disk_capacity=940.0),
    'g2.2xlarge': InstanceType(name='g2.2xlarge', cores=8, memory=15.0, disks=1.0, disk_capacity=60.0),
    'g2.8xlarge': InstanceType(name='g2.8xlarge', cores=32, memory=60.0, disks=2.0, disk_capacity=120.0),
    'g3.16xlarge': InstanceType(name='g3.16xlarge', cores=64, memory=488.0, disks=0, disk_capacity=0),
    'g3.4xlarge': InstanceType(name='g3.4xlarge', cores=16, memory=122.0, disks=0, disk_capacity=0),
    'g3.8xlarge': InstanceType(name='g3.8xlarge', cores=32, memory=244.0, disks=0, disk_capacity=0),
    'g3s.xlarge': InstanceType(name='g3s.xlarge', cores=4, memory=30.5, disks=0, disk_capacity=0),
    'h1.16xlarge': InstanceType(name='h1.16xlarge', cores=64, memory=256.0, disks=8.0, disk_capacity=2000.0),
    'h1.2xlarge': InstanceType(name='h1.2xlarge', cores=8, memory=32.0, disks=1.0, disk_capacity=2000.0),
    'h1.4xlarge': InstanceType(name='h1.4xlarge', cores=16, memory=64.0, disks=2.0, disk_capacity=2000.0),
    'h1.8xlarge': InstanceType(name='h1.8xlarge', cores=32, memory=128.0, disks=4.0, disk_capacity=2000.0),
    'hs1.8xlarge': InstanceType(name='hs1.8xlarge', cores=17, memory=117.0, disks=24.0, disk_capacity=2000.0),
    'i2.2xlarge': InstanceType(name='i2.2xlarge', cores=8, memory=61.0, disks=2.0, disk_capacity=800.0),
    'i2.4xlarge': InstanceType(name='i2.4xlarge', cores=16, memory=122.0, disks=4.0, disk_capacity=800.0),
    'i2.8xlarge': InstanceType(name='i2.8xlarge', cores=32, memory=244.0, disks=8.0, disk_capacity=800.0),
    'i2.xlarge': InstanceType(name='i2.xlarge', cores=4, memory=30.5, disks=1.0, disk_capacity=800.0),
    'i3.16xlarge': InstanceType(name='i3.16xlarge', cores=64, memory=488.0, disks=8.0, disk_capacity=1900.0),
    'i3.2xlarge': InstanceType(name='i3.2xlarge', cores=8, memory=61.0, disks=1.0, disk_capacity=1900.0),
    'i3.4xlarge': InstanceType(name='i3.4xlarge', cores=16, memory=122.0, disks=2.0, disk_capacity=1900.0),
    'i3.8xlarge': InstanceType(name='i3.8xlarge', cores=32, memory=244.0, disks=4.0, disk_capacity=1900.0),
    'i3.large': InstanceType(name='i3.large', cores=2, memory=15.25, disks=1.0, disk_capacity=475.0),
    'i3.metal': InstanceType(name='i3.metal', cores=72, memory=512.0, disks=8.0, disk_capacity=1900.0),
    'i3.xlarge': InstanceType(name='i3.xlarge', cores=4, memory=30.5, disks=1.0, disk_capacity=950.0),
    'i3en.12xlarge': InstanceType(name='i3en.12xlarge', cores=48, memory=384.0, disks=4.0, disk_capacity=7500.0),
    'i3en.24xlarge': InstanceType(name='i3en.24xlarge', cores=96, memory=768.0, disks=8.0, disk_capacity=7500.0),
    'i3en.2xlarge': InstanceType(name='i3en.2xlarge', cores=8, memory=64.0, disks=2.0, disk_capacity=2500.0),
    'i3en.3xlarge': InstanceType(name='i3en.3xlarge', cores=12, memory=96.0, disks=1.0, disk_capacity=7500.0),
    'i3en.6xlarge': InstanceType(name='i3en.6xlarge', cores=24, memory=192.0, disks=2.0, disk_capacity=7500.0),
    'i3en.large': InstanceType(name='i3en.large', cores=2, memory=16.0, disks=1.0, disk_capacity=1250.0),
    'i3en.xlarge': InstanceType(name='i3en.xlarge', cores=4, memory=32.0, disks=1.0, disk_capacity=2500.0),
    'm1.large': InstanceType(name='m1.large', cores=2, memory=7.5, disks=2.0, disk_capacity=420.0),
    'm1.medium': InstanceType(name='m1.medium', cores=1, memory=3.75, disks=1.0, disk_capacity=410.0),
    'm1.xlarge': InstanceType(name='m1.xlarge', cores=4, memory=15.0, disks=4.0, disk_capacity=420.0),
    'm2.2xlarge': InstanceType(name='m2.2xlarge', cores=4, memory=34.2, disks=1.0, disk_capacity=850.0),
    'm2.4xlarge': InstanceType(name='m2.4xlarge', cores=8, memory=68.4, disks=2.0, disk_capacity=840.0),
    'm2.xlarge': InstanceType(name='m2.xlarge', cores=2, memory=17.1, disks=1.0, disk_capacity=420.0),
    'm3.2xlarge': InstanceType(name='m3.2xlarge', cores=8, memory=30.0, disks=2.0, disk_capacity=80.0),
    'm3.large': InstanceType(name='m3.large', cores=2, memory=7.5, disks=1.0, disk_capacity=32.0),
    'm3.medium': InstanceType(name='m3.medium', cores=1, memory=3.75, disks=1.0, disk_capacity=4.0),
    'm3.xlarge': InstanceType(name='m3.xlarge', cores=4, memory=15.0, disks=2.0, disk_capacity=40.0),
    'm4.10xlarge': InstanceType(name='m4.10xlarge', cores=40, memory=160.0, disks=0, disk_capacity=0),
    'm4.16xlarge': InstanceType(name='m4.16xlarge', cores=64, memory=256.0, disks=0, disk_capacity=0),
    'm4.2xlarge': InstanceType(name='m4.2xlarge', cores=8, memory=32.0, disks=0, disk_capacity=0),
    'm4.4xlarge': InstanceType(name='m4.4xlarge', cores=16, memory=64.0, disks=0, disk_capacity=0),
    'm4.large': InstanceType(name='m4.large', cores=2, memory=8.0, disks=0, disk_capacity=0),
    'm4.xlarge': InstanceType(name='m4.xlarge', cores=4, memory=16.0, disks=0, disk_capacity=0),
    'm5.12xlarge': InstanceType(name='m5.12xlarge', cores=48, memory=192.0, disks=0, disk_capacity=0),
    'm5.24xlarge': InstanceType(name='m5.24xlarge', cores=96, memory=384.0, disks=0, disk_capacity=0),
    'm5.2xlarge': InstanceType(name='m5.2xlarge', cores=8, memory=32.0, disks=0, disk_capacity=0),
    'm5.4xlarge': InstanceType(name='m5.4xlarge', cores=16, memory=64.0, disks=0, disk_capacity=0),
    'm5.large': InstanceType(name='m5.large', cores=2, memory=8.0, disks=0, disk_capacity=0),
    'm5.metal': InstanceType(name='m5.metal', cores=96, memory=384.0, disks=0, disk_capacity=0),
    'm5.xlarge': InstanceType(name='m5.xlarge', cores=4, memory=16.0, disks=0, disk_capacity=0),
    'm5a.12xlarge': InstanceType(name='m5a.12xlarge', cores=48, memory=192.0, disks=0, disk_capacity=0),
    'm5a.24xlarge': InstanceType(name='m5a.24xlarge', cores=96, memory=384.0, disks=0, disk_capacity=0),
    'm5a.2xlarge': InstanceType(name='m5a.2xlarge', cores=8, memory=32.0, disks=0, disk_capacity=0),
    'm5a.4xlarge': InstanceType(name='m5a.4xlarge', cores=16, memory=64.0, disks=0, disk_capacity=0),
    'm5a.large': InstanceType(name='m5a.large', cores=2, memory=8.0, disks=0, disk_capacity=0),
    'm5a.xlarge': InstanceType(name='m5a.xlarge', cores=4, memory=16.0, disks=0, disk_capacity=0),
    'm5ad.12xlarge': InstanceType(name='m5ad.12xlarge', cores=48, memory=192.0, disks=2.0, disk_capacity=900.0),
    'm5ad.24xlarge': InstanceType(name='m5ad.24xlarge', cores=96, memory=384.0, disks=4.0, disk_capacity=900.0),
    'm5ad.2xlarge': InstanceType(name='m5ad.2xlarge', cores=8, memory=32.0, disks=1.0, disk_capacity=300.0),
    'm5ad.4xlarge': InstanceType(name='m5ad.4xlarge', cores=16, memory=64.0, disks=2.0, disk_capacity=300.0),
    'm5ad.large': InstanceType(name='m5ad.large', cores=2, memory=8.0, disks=1.0, disk_capacity=75.0),
    'm5ad.xlarge': InstanceType(name='m5ad.xlarge', cores=4, memory=16.0, disks=1.0, disk_capacity=150.0),
    'm5d.12xlarge': InstanceType(name='m5d.12xlarge', cores=48, memory=192.0, disks=2.0, disk_capacity=900.0),
    'm5d.24xlarge': InstanceType(name='m5d.24xlarge', cores=96, memory=384.0, disks=4.0, disk_capacity=900.0),
    'm5d.2xlarge': InstanceType(name='m5d.2xlarge', cores=8, memory=32.0, disks=1.0, disk_capacity=300.0),
    'm5d.4xlarge': InstanceType(name='m5d.4xlarge', cores=16, memory=64.0, disks=2.0, disk_capacity=300.0),
    'm5d.large': InstanceType(name='m5d.large', cores=2, memory=8.0, disks=1.0, disk_capacity=75.0),
    'm5d.metal': InstanceType(name='m5d.metal', cores=96, memory=384.0, disks=4.0, disk_capacity=900.0),
    'm5d.xlarge': InstanceType(name='m5d.xlarge', cores=4, memory=16.0, disks=1.0, disk_capacity=150.0),
    'p2.16xlarge': InstanceType(name='p2.16xlarge', cores=64, memory=768.0, disks=0, disk_capacity=0),
    'p2.8xlarge': InstanceType(name='p2.8xlarge', cores=32, memory=488.0, disks=0, disk_capacity=0),
    'p2.xlarge': InstanceType(name='p2.xlarge', cores=4, memory=61.0, disks=0, disk_capacity=0),
    'p3.16xlarge': InstanceType(name='p3.16xlarge', cores=64, memory=488.0, disks=0, disk_capacity=0),
    'p3.2xlarge': InstanceType(name='p3.2xlarge', cores=8, memory=61.0, disks=0, disk_capacity=0),
    'p3.8xlarge': InstanceType(name='p3.8xlarge', cores=32, memory=244.0, disks=0, disk_capacity=0),
    'p3dn.24xlarge': InstanceType(name='p3dn.24xlarge', cores=96, memory=768.0, disks=2.0, disk_capacity=900.0),
    'r3.2xlarge': InstanceType(name='r3.2xlarge', cores=8, memory=61.0, disks=1.0, disk_capacity=160.0),
    'r3.4xlarge': InstanceType(name='r3.4xlarge', cores=16, memory=122.0, disks=1.0, disk_capacity=320.0),
    'r3.8xlarge': InstanceType(name='r3.8xlarge', cores=32, memory=244.0, disks=2.0, disk_capacity=320.0),
    'r3.large': InstanceType(name='r3.large', cores=2, memory=15.25, disks=1.0, disk_capacity=32.0),
    'r3.xlarge': InstanceType(name='r3.xlarge', cores=4, memory=30.5, disks=1.0, disk_capacity=80.0),
    'r4.16xlarge': InstanceType(name='r4.16xlarge', cores=64, memory=488.0, disks=0, disk_capacity=0),
    'r4.2xlarge': InstanceType(name='r4.2xlarge', cores=8, memory=61.0, disks=0, disk_capacity=0),
    'r4.4xlarge': InstanceType(name='r4.4xlarge', cores=16, memory=122.0, disks=0, disk_capacity=0),
    'r4.8xlarge': InstanceType(name='r4.8xlarge', cores=32, memory=244.0, disks=0, disk_capacity=0),
    'r4.large': InstanceType(name='r4.large', cores=2, memory=15.25, disks=0, disk_capacity=0),
    'r4.xlarge': InstanceType(name='r4.xlarge', cores=4, memory=30.5, disks=0, disk_capacity=0),
    'r5.12xlarge': InstanceType(name='r5.12xlarge', cores=48, memory=384.0, disks=0, disk_capacity=0),
    'r5.24xlarge': InstanceType(name='r5.24xlarge', cores=96, memory=768.0, disks=0, disk_capacity=0),
    'r5.2xlarge': InstanceType(name='r5.2xlarge', cores=8, memory=64.0, disks=0, disk_capacity=0),
    'r5.4xlarge': InstanceType(name='r5.4xlarge', cores=16, memory=128.0, disks=0, disk_capacity=0),
    'r5.large': InstanceType(name='r5.large', cores=2, memory=16.0, disks=0, disk_capacity=0),
    'r5.metal': InstanceType(name='r5.metal', cores=96, memory=768.0, disks=0, disk_capacity=0),
    'r5.xlarge': InstanceType(name='r5.xlarge', cores=4, memory=32.0, disks=0, disk_capacity=0),
    'r5a.12xlarge': InstanceType(name='r5a.12xlarge', cores=48, memory=384.0, disks=0, disk_capacity=0),
    'r5a.24xlarge': InstanceType(name='r5a.24xlarge', cores=96, memory=768.0, disks=0, disk_capacity=0),
    'r5a.2xlarge': InstanceType(name='r5a.2xlarge', cores=8, memory=64.0, disks=0, disk_capacity=0),
    'r5a.4xlarge': InstanceType(name='r5a.4xlarge', cores=16, memory=128.0, disks=0, disk_capacity=0),
    'r5a.large': InstanceType(name='r5a.large', cores=2, memory=16.0, disks=0, disk_capacity=0),
    'r5a.xlarge': InstanceType(name='r5a.xlarge', cores=4, memory=32.0, disks=0, disk_capacity=0),
    'r5ad.12xlarge': InstanceType(name='r5ad.12xlarge', cores=48, memory=384.0, disks=2.0, disk_capacity=900.0),
    'r5ad.24xlarge': InstanceType(name='r5ad.24xlarge', cores=96, memory=768.0, disks=4.0, disk_capacity=900.0),
    'r5ad.2xlarge': InstanceType(name='r5ad.2xlarge', cores=8, memory=64.0, disks=1.0, disk_capacity=300.0),
    'r5ad.4xlarge': InstanceType(name='r5ad.4xlarge', cores=16, memory=128.0, disks=2.0, disk_capacity=300.0),
    'r5ad.large': InstanceType(name='r5ad.large', cores=2, memory=16.0, disks=1.0, disk_capacity=75.0),
    'r5ad.xlarge': InstanceType(name='r5ad.xlarge', cores=4, memory=32.0, disks=1.0, disk_capacity=150.0),
    'r5d.12xlarge': InstanceType(name='r5d.12xlarge', cores=48, memory=384.0, disks=2.0, disk_capacity=900.0),
    'r5d.24xlarge': InstanceType(name='r5d.24xlarge', cores=96, memory=768.0, disks=4.0, disk_capacity=900.0),
    'r5d.2xlarge': InstanceType(name='r5d.2xlarge', cores=8, memory=64.0, disks=1.0, disk_capacity=300.0),
    'r5d.4xlarge': InstanceType(name='r5d.4xlarge', cores=16, memory=128.0, disks=2.0, disk_capacity=300.0),
    'r5d.large': InstanceType(name='r5d.large', cores=2, memory=16.0, disks=1.0, disk_capacity=75.0),
    'r5d.metal': InstanceType(name='r5d.metal', cores=96, memory=768.0, disks=4.0, disk_capacity=900.0),
    'r5d.xlarge': InstanceType(name='r5d.xlarge', cores=4, memory=32.0, disks=1.0, disk_capacity=150.0),
    't1.micro': InstanceType(name='t1.micro', cores=1, memory=0.613, disks=0, disk_capacity=0),
    't2.2xlarge': InstanceType(name='t2.2xlarge', cores=8, memory=32.0, disks=0, disk_capacity=0),
    't2.large': InstanceType(name='t2.large', cores=2, memory=8.0, disks=0, disk_capacity=0),
    't2.medium': InstanceType(name='t2.medium', cores=2, memory=4.0, disks=0, disk_capacity=0),
    't2.micro': InstanceType(name='t2.micro', cores=1, memory=1.0, disks=0, disk_capacity=0),
    't2.nano': InstanceType(name='t2.nano', cores=1, memory=0.5, disks=0, disk_capacity=0),
    't2.small': InstanceType(name='t2.small', cores=1, memory=2.0, disks=0, disk_capacity=0),
    't2.xlarge': InstanceType(name='t2.xlarge', cores=4, memory=16.0, disks=0, disk_capacity=0),
    't3.2xlarge': InstanceType(name='t3.2xlarge', cores=8, memory=32.0, disks=0, disk_capacity=0),
    't3.large': InstanceType(name='t3.large', cores=2, memory=8.0, disks=0, disk_capacity=0),
    't3.medium': InstanceType(name='t3.medium', cores=2, memory=4.0, disks=0, disk_capacity=0),
    't3.micro': InstanceType(name='t3.micro', cores=2, memory=1.0, disks=0, disk_capacity=0),
    't3.nano': InstanceType(name='t3.nano', cores=2, memory=0.5, disks=0, disk_capacity=0),
    't3.small': InstanceType(name='t3.small', cores=2, memory=2.0, disks=0, disk_capacity=0),
    't3.xlarge': InstanceType(name='t3.xlarge', cores=4, memory=16.0, disks=0, disk_capacity=0),
    't3a.2xlarge': InstanceType(name='t3a.2xlarge', cores=8, memory=32.0, disks=0, disk_capacity=0),
    't3a.large': InstanceType(name='t3a.large', cores=2, memory=8.0, disks=0, disk_capacity=0),
    't3a.medium': InstanceType(name='t3a.medium', cores=2, memory=4.0, disks=0, disk_capacity=0),
    't3a.micro': InstanceType(name='t3a.micro', cores=2, memory=1.0, disks=0, disk_capacity=0),
    't3a.nano': InstanceType(name='t3a.nano', cores=2, memory=0.5, disks=0, disk_capacity=0),
    't3a.small': InstanceType(name='t3a.small', cores=2, memory=2.0, disks=0, disk_capacity=0),
    't3a.xlarge': InstanceType(name='t3a.xlarge', cores=4, memory=16.0, disks=0, disk_capacity=0),
    'x1.16xlarge': InstanceType(name='x1.16xlarge', cores=64, memory=976.0, disks=1.0, disk_capacity=1920.0),
    'x1.32xlarge': InstanceType(name='x1.32xlarge', cores=128, memory=1952.0, disks=2.0, disk_capacity=1920.0),
    'x1e.16xlarge': InstanceType(name='x1e.16xlarge', cores=64, memory=1952.0, disks=1.0, disk_capacity=1920.0),
    'x1e.2xlarge': InstanceType(name='x1e.2xlarge', cores=8, memory=244.0, disks=1.0, disk_capacity=240.0),
    'x1e.32xlarge': InstanceType(name='x1e.32xlarge', cores=128, memory=3904.0, disks=2.0, disk_capacity=1920.0),
    'x1e.4xlarge': InstanceType(name='x1e.4xlarge', cores=16, memory=488.0, disks=1.0, disk_capacity=480.0),
    'x1e.8xlarge': InstanceType(name='x1e.8xlarge', cores=32, memory=976.0, disks=1.0, disk_capacity=960.0),
    'x1e.xlarge': InstanceType(name='x1e.xlarge', cores=4, memory=122.0, disks=1.0, disk_capacity=120.0),
    'z1d.12xlarge': InstanceType(name='z1d.12xlarge', cores=48, memory=384.0, disks=2.0, disk_capacity=900.0),
    'z1d.2xlarge': InstanceType(name='z1d.2xlarge', cores=8, memory=64.0, disks=1.0, disk_capacity=300.0),
    'z1d.3xlarge': InstanceType(name='z1d.3xlarge', cores=12, memory=96.0, disks=1.0, disk_capacity=450.0),
    'z1d.6xlarge': InstanceType(name='z1d.6xlarge', cores=24, memory=192.0, disks=1.0, disk_capacity=900.0),
    'z1d.large': InstanceType(name='z1d.large', cores=2, memory=16.0, disks=1.0, disk_capacity=75.0),
    'z1d.metal': InstanceType(name='z1d.metal', cores=48, memory=384.0, disks=2.0, disk_capacity=900.0),
    'z1d.xlarge': InstanceType(name='z1d.xlarge', cores=4, memory=32.0, disks=1.0, disk_capacity=150.0),
}

regionDict = {
              'us-west-1': ['c1.medium', 'c1.xlarge', 'c3.2xlarge', 'c3.4xlarge', 'c3.8xlarge', 'c3.large', 'c3.xlarge', 'c4.2xlarge', 'c4.4xlarge', 'c4.8xlarge', 'c4.large', 'c4.xlarge', 'c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'c5d.18xlarge', 'c5d.2xlarge', 'c5d.4xlarge', 'c5d.9xlarge', 'c5d.large', 'c5d.xlarge', 'd2.2xlarge', 'd2.4xlarge', 'd2.8xlarge', 'd2.xlarge', 'f1.16xlarge', 'f1.2xlarge', 'f1.4xlarge', 'g2.2xlarge', 'g2.8xlarge', 'g3.16xlarge', 'g3.4xlarge', 'g3.8xlarge', 'g3s.xlarge', 'i2.2xlarge', 'i2.4xlarge', 'i2.8xlarge', 'i2.xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.metal', 'i3.xlarge', 'm1.large', 'm1.medium', 'm1.xlarge', 'm2.2xlarge', 'm2.4xlarge', 'm2.xlarge', 'm3.2xlarge', 'm3.large', 'm3.medium', 'm3.xlarge', 'm4.10xlarge', 'm4.16xlarge', 'm4.2xlarge', 'm4.4xlarge', 'm4.large', 'm4.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.metal', 'm5.xlarge', 'm5d.12xlarge', 'm5d.24xlarge', 'm5d.2xlarge', 'm5d.4xlarge', 'm5d.large', 'm5d.metal', 'm5d.xlarge', 'r3.2xlarge', 'r3.4xlarge', 'r3.8xlarge', 'r3.large', 'r3.xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 'r5.12xlarge', 'r5.24xlarge', 'r5.2xlarge', 'r5.4xlarge', 'r5.large', 'r5.metal', 'r5.xlarge', 'r5d.12xlarge', 'r5d.24xlarge', 'r5d.2xlarge', 'r5d.4xlarge', 'r5d.large', 'r5d.metal', 'r5d.xlarge', 't1.micro', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge', 'z1d.12xlarge', 'z1d.2xlarge', 'z1d.3xlarge', 'z1d.6xlarge', 'z1d.large', 'z1d.metal', 'z1d.xlarge'],
              'ap-northeast-3': ['c4.2xlarge', 'c4.4xlarge', 'c4.8xlarge', 'c4.large', 'c4.xlarge', 'c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'c5d.18xlarge', 'c5d.2xlarge', 'c5d.4xlarge', 'c5d.9xlarge', 'c5d.large', 'c5d.xlarge', 'd2.2xlarge', 'd2.4xlarge', 'd2.8xlarge', 'd2.xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.xlarge', 'm4.10xlarge', 'm4.16xlarge', 'm4.2xlarge', 'm4.4xlarge', 'm4.large', 'm4.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.metal', 'm5.xlarge', 'm5d.12xlarge', 'm5d.24xlarge', 'm5d.2xlarge', 'm5d.4xlarge', 'm5d.large', 'm5d.metal', 'm5d.xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 'r5.12xlarge', 'r5.24xlarge', 'r5.2xlarge', 'r5.4xlarge', 'r5.large', 'r5.metal', 'r5.xlarge', 'r5d.12xlarge', 'r5d.24xlarge', 'r5d.2xlarge', 'r5d.4xlarge', 'r5d.large', 'r5d.metal', 'r5d.xlarge', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge'],
              'us-east-1': ['a1.2xlarge', 'a1.4xlarge', 'a1.large', 'a1.medium', 'a1.xlarge', 'c1.medium', 'c1.xlarge', 'c3.2xlarge', 'c3.4xlarge', 'c3.8xlarge', 'c3.large', 'c3.xlarge', 'c4.2xlarge', 'c4.4xlarge', 'c4.8xlarge', 'c4.large', 'c4.xlarge', 'c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'c5d.18xlarge', 'c5d.2xlarge', 'c5d.4xlarge', 'c5d.9xlarge', 'c5d.large', 'c5d.xlarge', 'c5n.18xlarge', 'c5n.2xlarge', 'c5n.4xlarge', 'c5n.9xlarge', 'c5n.large', 'c5n.xlarge', 'cc2.8xlarge', 'cr1.8xlarge', 'd2.2xlarge', 'd2.4xlarge', 'd2.8xlarge', 'd2.xlarge', 'f1.16xlarge', 'f1.2xlarge', 'f1.4xlarge', 'g2.2xlarge', 'g2.8xlarge', 'g3.16xlarge', 'g3.4xlarge', 'g3.8xlarge', 'g3s.xlarge', 'h1.16xlarge', 'h1.2xlarge', 'h1.4xlarge', 'h1.8xlarge', 'hs1.8xlarge', 'i2.2xlarge', 'i2.4xlarge', 'i2.8xlarge', 'i2.xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.metal', 'i3.xlarge', 'i3en.12xlarge', 'i3en.24xlarge', 'i3en.2xlarge', 'i3en.3xlarge', 'i3en.6xlarge', 'i3en.large', 'i3en.xlarge', 'm1.large', 'm1.medium', 'm1.xlarge', 'm2.2xlarge', 'm2.4xlarge', 'm2.xlarge', 'm3.2xlarge', 'm3.large', 'm3.medium', 'm3.xlarge', 'm4.10xlarge', 'm4.16xlarge', 'm4.2xlarge', 'm4.4xlarge', 'm4.large', 'm4.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.metal', 'm5.xlarge', 'm5a.12xlarge', 'm5a.24xlarge', 'm5a.2xlarge', 'm5a.4xlarge', 'm5a.large', 'm5a.xlarge', 'm5ad.12xlarge', 'm5ad.24xlarge', 'm5ad.2xlarge', 'm5ad.4xlarge', 'm5ad.large', 'm5ad.xlarge', 'm5d.12xlarge', 'm5d.24xlarge', 'm5d.2xlarge', 'm5d.4xlarge', 'm5d.large', 'm5d.metal', 'm5d.xlarge', 'p2.16xlarge', 'p2.8xlarge', 'p2.xlarge', 'p3.16xlarge', 'p3.2xlarge', 'p3.8xlarge', 'p3dn.24xlarge', 'r3.2xlarge', 'r3.4xlarge', 'r3.8xlarge', 'r3.large', 'r3.xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 'r5.12xlarge', 'r5.24xlarge', 'r5.2xlarge', 'r5.4xlarge', 'r5.large', 'r5.metal', 'r5.xlarge', 'r5a.12xlarge', 'r5a.24xlarge', 'r5a.2xlarge', 'r5a.4xlarge', 'r5a.large', 'r5a.xlarge', 'r5ad.12xlarge', 'r5ad.24xlarge', 'r5ad.2xlarge', 'r5ad.4xlarge', 'r5ad.large', 'r5ad.xlarge', 'r5d.12xlarge', 'r5d.24xlarge', 'r5d.2xlarge', 'r5d.4xlarge', 'r5d.large', 'r5d.metal', 'r5d.xlarge', 't1.micro', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge', 't3a.2xlarge', 't3a.large', 't3a.medium', 't3a.micro', 't3a.nano', 't3a.small', 't3a.xlarge', 'x1.16xlarge', 'x1.32xlarge', 'x1e.16xlarge', 'x1e.2xlarge', 'x1e.32xlarge', 'x1e.4xlarge', 'x1e.8xlarge', 'x1e.xlarge', 'z1d.12xlarge', 'z1d.2xlarge', 'z1d.3xlarge', 'z1d.6xlarge', 'z1d.large', 'z1d.metal', 'z1d.xlarge'],
              'us-east-2': ['a1.2xlarge', 'a1.4xlarge', 'a1.large', 'a1.medium', 'a1.xlarge', 'c4.2xlarge', 'c4.4xlarge', 'c4.8xlarge', 'c4.large', 'c4.xlarge', 'c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'c5d.18xlarge', 'c5d.2xlarge', 'c5d.4xlarge', 'c5d.9xlarge', 'c5d.large', 'c5d.xlarge', 'c5n.18xlarge', 'c5n.2xlarge', 'c5n.4xlarge', 'c5n.9xlarge', 'c5n.large', 'c5n.xlarge', 'd2.2xlarge', 'd2.4xlarge', 'd2.8xlarge', 'd2.xlarge', 'g3.16xlarge', 'g3.4xlarge', 'g3.8xlarge', 'g3s.xlarge', 'h1.16xlarge', 'h1.2xlarge', 'h1.4xlarge', 'h1.8xlarge', 'i2.2xlarge', 'i2.4xlarge', 'i2.8xlarge', 'i2.xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.metal', 'i3.xlarge', 'i3en.12xlarge', 'i3en.24xlarge', 'i3en.2xlarge', 'i3en.3xlarge', 'i3en.6xlarge', 'i3en.large', 'i3en.xlarge', 'm4.10xlarge', 'm4.16xlarge', 'm4.2xlarge', 'm4.4xlarge', 'm4.large', 'm4.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.metal', 'm5.xlarge', 'm5a.12xlarge', 'm5a.24xlarge', 'm5a.2xlarge', 'm5a.4xlarge', 'm5a.large', 'm5a.xlarge', 'm5ad.12xlarge', 'm5ad.24xlarge', 'm5ad.2xlarge', 'm5ad.4xlarge', 'm5ad.large', 'm5ad.xlarge', 'm5d.12xlarge', 'm5d.24xlarge', 'm5d.2xlarge', 'm5d.4xlarge', 'm5d.large', 'm5d.metal', 'm5d.xlarge', 'p2.16xlarge', 'p2.8xlarge', 'p2.xlarge', 'p3.16xlarge', 'p3.2xlarge', 'p3.8xlarge', 'r3.2xlarge', 'r3.4xlarge', 'r3.8xlarge', 'r3.large', 'r3.xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 'r5.12xlarge', 'r5.24xlarge', 'r5.2xlarge', 'r5.4xlarge', 'r5.large', 'r5.metal', 'r5.xlarge', 'r5a.12xlarge', 'r5a.24xlarge', 'r5a.2xlarge', 'r5a.4xlarge', 'r5a.large', 'r5a.xlarge', 'r5ad.12xlarge', 'r5ad.24xlarge', 'r5ad.2xlarge', 'r5ad.4xlarge', 'r5ad.large', 'r5ad.xlarge', 'r5d.12xlarge', 'r5d.24xlarge', 'r5d.2xlarge', 'r5d.4xlarge', 'r5d.large', 'r5d.metal', 'r5d.xlarge', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge', 't3a.2xlarge', 't3a.large', 't3a.medium', 't3a.micro', 't3a.nano', 't3a.small', 't3a.xlarge', 'x1.16xlarge', 'x1.32xlarge', 'x1e.16xlarge', 'x1e.2xlarge', 'x1e.32xlarge', 'x1e.4xlarge', 'x1e.8xlarge', 'x1e.xlarge'],
              'ap-northeast-1': ['c1.medium', 'c1.xlarge', 'c3.2xlarge', 'c3.4xlarge', 'c3.8xlarge', 'c3.large', 'c3.xlarge', 'c4.2xlarge', 'c4.4xlarge', 'c4.8xlarge', 'c4.large', 'c4.xlarge', 'c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'c5d.18xlarge', 'c5d.2xlarge', 'c5d.4xlarge', 'c5d.9xlarge', 'c5d.large', 'c5d.xlarge', 'c5n.18xlarge', 'c5n.2xlarge', 'c5n.4xlarge', 'c5n.9xlarge', 'c5n.large', 'c5n.xlarge', 'cc2.8xlarge', 'cr1.8xlarge', 'd2.2xlarge', 'd2.4xlarge', 'd2.8xlarge', 'd2.xlarge', 'g2.2xlarge', 'g2.8xlarge', 'g3.16xlarge', 'g3.4xlarge', 'g3.8xlarge', 'g3s.xlarge', 'hs1.8xlarge', 'i2.2xlarge', 'i2.4xlarge', 'i2.8xlarge', 'i2.xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.metal', 'i3.xlarge', 'i3en.12xlarge', 'i3en.24xlarge', 'i3en.2xlarge', 'i3en.3xlarge', 'i3en.6xlarge', 'i3en.large', 'i3en.xlarge', 'm1.large', 'm1.medium', 'm1.xlarge', 'm2.2xlarge', 'm2.4xlarge', 'm2.xlarge', 'm3.2xlarge', 'm3.large', 'm3.medium', 'm3.xlarge', 'm4.10xlarge', 'm4.16xlarge', 'm4.2xlarge', 'm4.4xlarge', 'm4.large', 'm4.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.metal', 'm5.xlarge', 'm5a.12xlarge', 'm5a.24xlarge', 'm5a.2xlarge', 'm5a.4xlarge', 'm5a.large', 'm5a.xlarge', 'm5d.12xlarge', 'm5d.24xlarge', 'm5d.2xlarge', 'm5d.4xlarge', 'm5d.large', 'm5d.metal', 'm5d.xlarge', 'p2.16xlarge', 'p2.8xlarge', 'p2.xlarge', 'p3.16xlarge', 'p3.2xlarge', 'p3.8xlarge', 'p3dn.24xlarge', 'r3.2xlarge', 'r3.4xlarge', 'r3.8xlarge', 'r3.large', 'r3.xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 'r5.12xlarge', 'r5.24xlarge', 'r5.2xlarge', 'r5.4xlarge', 'r5.large', 'r5.metal', 'r5.xlarge', 'r5a.12xlarge', 'r5a.24xlarge', 'r5a.2xlarge', 'r5a.4xlarge', 'r5a.large', 'r5a.xlarge', 'r5d.12xlarge', 'r5d.24xlarge', 'r5d.2xlarge', 'r5d.4xlarge', 'r5d.large', 'r5d.metal', 'r5d.xlarge', 't1.micro', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge', 'x1.16xlarge', 'x1.32xlarge', 'x1e.16xlarge', 'x1e.2xlarge', 'x1e.32xlarge', 'x1e.4xlarge', 'x1e.8xlarge', 'x1e.xlarge', 'z1d.12xlarge', 'z1d.2xlarge', 'z1d.3xlarge', 'z1d.6xlarge', 'z1d.large', 'z1d.metal', 'z1d.xlarge'],
              'sa-east-1': ['c1.medium', 'c1.xlarge', 'c3.2xlarge', 'c3.4xlarge', 'c3.8xlarge', 'c3.large', 'c3.xlarge', 'c4.2xlarge', 'c4.4xlarge', 'c4.8xlarge', 'c4.large', 'c4.xlarge', 'c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.xlarge', 'm1.large', 'm1.medium', 'm1.xlarge', 'm2.2xlarge', 'm2.4xlarge', 'm2.xlarge', 'm3.2xlarge', 'm3.large', 'm3.medium', 'm3.xlarge', 'm4.10xlarge', 'm4.16xlarge', 'm4.2xlarge', 'm4.4xlarge', 'm4.large', 'm4.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.xlarge', 'r3.2xlarge', 'r3.4xlarge', 'r3.8xlarge', 'r3.large', 'r3.xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 't1.micro', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge', 'x1.16xlarge', 'x1.32xlarge'],
              'ap-northeast-2': ['c3.2xlarge', 'c3.4xlarge', 'c3.8xlarge', 'c3.large', 'c3.xlarge', 'c4.2xlarge', 'c4.4xlarge', 'c4.8xlarge', 'c4.large', 'c4.xlarge', 'c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'c5d.18xlarge', 'c5d.2xlarge', 'c5d.4xlarge', 'c5d.9xlarge', 'c5d.large', 'c5d.xlarge', 'd2.2xlarge', 'd2.4xlarge', 'd2.8xlarge', 'd2.xlarge', 'g2.2xlarge', 'g2.8xlarge', 'g3.16xlarge', 'g3.4xlarge', 'g3.8xlarge', 'g3s.xlarge', 'i2.2xlarge', 'i2.4xlarge', 'i2.8xlarge', 'i2.xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.xlarge', 'm3.2xlarge', 'm3.large', 'm3.medium', 'm3.xlarge', 'm4.10xlarge', 'm4.16xlarge', 'm4.2xlarge', 'm4.4xlarge', 'm4.large', 'm4.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.metal', 'm5.xlarge', 'm5d.12xlarge', 'm5d.24xlarge', 'm5d.2xlarge', 'm5d.4xlarge', 'm5d.large', 'm5d.metal', 'm5d.xlarge', 'p2.16xlarge', 'p2.8xlarge', 'p2.xlarge', 'p3.16xlarge', 'p3.2xlarge', 'p3.8xlarge', 'r3.2xlarge', 'r3.4xlarge', 'r3.8xlarge', 'r3.large', 'r3.xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 'r5.12xlarge', 'r5.24xlarge', 'r5.2xlarge', 'r5.4xlarge', 'r5.large', 'r5.metal', 'r5.xlarge', 'r5d.12xlarge', 'r5d.24xlarge', 'r5d.2xlarge', 'r5d.4xlarge', 'r5d.large', 'r5d.metal', 'r5d.xlarge', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge', 'x1.16xlarge', 'x1.32xlarge', 'x1e.16xlarge', 'x1e.2xlarge', 'x1e.32xlarge', 'x1e.4xlarge', 'x1e.8xlarge', 'x1e.xlarge'],
              'ap-southeast-1': ['c1.medium', 'c1.xlarge', 'c3.2xlarge', 'c3.4xlarge', 'c3.8xlarge', 'c3.large', 'c3.xlarge', 'c4.2xlarge', 'c4.4xlarge', 'c4.8xlarge', 'c4.large', 'c4.xlarge', 'c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'c5d.18xlarge', 'c5d.2xlarge', 'c5d.4xlarge', 'c5d.9xlarge', 'c5d.large', 'c5d.xlarge', 'd2.2xlarge', 'd2.4xlarge', 'd2.8xlarge', 'd2.xlarge', 'g2.2xlarge', 'g2.8xlarge', 'g3.16xlarge', 'g3.4xlarge', 'g3.8xlarge', 'hs1.8xlarge', 'i2.2xlarge', 'i2.4xlarge', 'i2.8xlarge', 'i2.xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.xlarge', 'm1.large', 'm1.medium', 'm1.xlarge', 'm2.2xlarge', 'm2.4xlarge', 'm2.xlarge', 'm3.2xlarge', 'm3.large', 'm3.medium', 'm3.xlarge', 'm4.10xlarge', 'm4.16xlarge', 'm4.2xlarge', 'm4.4xlarge', 'm4.large', 'm4.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.metal', 'm5.xlarge', 'm5a.12xlarge', 'm5a.24xlarge', 'm5a.2xlarge', 'm5a.4xlarge', 'm5a.large', 'm5a.xlarge', 'm5ad.12xlarge', 'm5ad.24xlarge', 'm5ad.2xlarge', 'm5ad.4xlarge', 'm5ad.large', 'm5ad.xlarge', 'm5d.12xlarge', 'm5d.24xlarge', 'm5d.2xlarge', 'm5d.4xlarge', 'm5d.large', 'm5d.metal', 'm5d.xlarge', 'p2.16xlarge', 'p2.8xlarge', 'p2.xlarge', 'p3.16xlarge', 'p3.2xlarge', 'p3.8xlarge', 'r3.2xlarge', 'r3.4xlarge', 'r3.8xlarge', 'r3.large', 'r3.xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 'r5.12xlarge', 'r5.24xlarge', 'r5.2xlarge', 'r5.4xlarge', 'r5.large', 'r5.metal', 'r5.xlarge', 'r5a.12xlarge', 'r5a.24xlarge', 'r5a.2xlarge', 'r5a.4xlarge', 'r5a.large', 'r5a.xlarge', 'r5ad.12xlarge', 'r5ad.24xlarge', 'r5ad.2xlarge', 'r5ad.4xlarge', 'r5ad.large', 'r5ad.xlarge', 'r5d.12xlarge', 'r5d.24xlarge', 'r5d.2xlarge', 'r5d.4xlarge', 'r5d.large', 'r5d.metal', 'r5d.xlarge', 't1.micro', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge', 't3a.2xlarge', 't3a.large', 't3a.medium', 't3a.micro', 't3a.nano', 't3a.small', 't3a.xlarge', 'x1.16xlarge', 'x1.32xlarge', 'x1e.16xlarge', 'x1e.2xlarge', 'x1e.32xlarge', 'x1e.4xlarge', 'x1e.8xlarge', 'x1e.xlarge', 'z1d.12xlarge', 'z1d.2xlarge', 'z1d.3xlarge', 'z1d.6xlarge', 'z1d.large', 'z1d.metal', 'z1d.xlarge'],
              'ca-central-1': ['c4.2xlarge', 'c4.4xlarge', 'c4.8xlarge', 'c4.large', 'c4.xlarge', 'c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'c5d.18xlarge', 'c5d.2xlarge', 'c5d.4xlarge', 'c5d.9xlarge', 'c5d.large', 'c5d.xlarge', 'd2.2xlarge', 'd2.4xlarge', 'd2.8xlarge', 'd2.xlarge', 'g3.16xlarge', 'g3.4xlarge', 'g3.8xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.xlarge', 'm4.10xlarge', 'm4.16xlarge', 'm4.2xlarge', 'm4.4xlarge', 'm4.large', 'm4.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.metal', 'm5.xlarge', 'm5d.12xlarge', 'm5d.24xlarge', 'm5d.2xlarge', 'm5d.4xlarge', 'm5d.large', 'm5d.metal', 'm5d.xlarge', 'p3.16xlarge', 'p3.2xlarge', 'p3.8xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 'r5.12xlarge', 'r5.24xlarge', 'r5.2xlarge', 'r5.4xlarge', 'r5.large', 'r5.metal', 'r5.xlarge', 'r5d.12xlarge', 'r5d.24xlarge', 'r5d.2xlarge', 'r5d.4xlarge', 'r5d.large', 'r5d.metal', 'r5d.xlarge', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge', 'x1.16xlarge', 'x1.32xlarge'],
              'ap-southeast-2': ['c1.medium', 'c1.xlarge', 'c3.2xlarge', 'c3.4xlarge', 'c3.8xlarge', 'c3.large', 'c3.xlarge', 'c4.2xlarge', 'c4.4xlarge', 'c4.8xlarge', 'c4.large', 'c4.xlarge', 'c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'c5d.18xlarge', 'c5d.2xlarge', 'c5d.4xlarge', 'c5d.9xlarge', 'c5d.large', 'c5d.xlarge', 'd2.2xlarge', 'd2.4xlarge', 'd2.8xlarge', 'd2.xlarge', 'g2.2xlarge', 'g2.8xlarge', 'g3.16xlarge', 'g3.4xlarge', 'g3.8xlarge', 'g3s.xlarge', 'hs1.8xlarge', 'i2.2xlarge', 'i2.4xlarge', 'i2.8xlarge', 'i2.xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.xlarge', 'm1.large', 'm1.medium', 'm1.xlarge', 'm2.2xlarge', 'm2.4xlarge', 'm2.xlarge', 'm3.2xlarge', 'm3.large', 'm3.medium', 'm3.xlarge', 'm4.10xlarge', 'm4.16xlarge', 'm4.2xlarge', 'm4.4xlarge', 'm4.large', 'm4.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.metal', 'm5.xlarge', 'm5a.12xlarge', 'm5a.24xlarge', 'm5a.2xlarge', 'm5a.4xlarge', 'm5a.large', 'm5a.xlarge', 'm5d.12xlarge', 'm5d.24xlarge', 'm5d.2xlarge', 'm5d.4xlarge', 'm5d.large', 'm5d.metal', 'm5d.xlarge', 'p2.16xlarge', 'p2.8xlarge', 'p2.xlarge', 'p3.16xlarge', 'p3.2xlarge', 'p3.8xlarge', 'r3.2xlarge', 'r3.4xlarge', 'r3.8xlarge', 'r3.large', 'r3.xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 'r5.12xlarge', 'r5.24xlarge', 'r5.2xlarge', 'r5.4xlarge', 'r5.large', 'r5.metal', 'r5.xlarge', 'r5a.12xlarge', 'r5a.24xlarge', 'r5a.2xlarge', 'r5a.4xlarge', 'r5a.large', 'r5a.xlarge', 'r5d.12xlarge', 'r5d.24xlarge', 'r5d.2xlarge', 'r5d.4xlarge', 'r5d.large', 'r5d.metal', 'r5d.xlarge', 't1.micro', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge', 'x1.16xlarge', 'x1.32xlarge', 'x1e.16xlarge', 'x1e.2xlarge', 'x1e.32xlarge', 'x1e.4xlarge', 'x1e.8xlarge', 'x1e.xlarge', 'z1d.12xlarge', 'z1d.2xlarge', 'z1d.3xlarge', 'z1d.6xlarge', 'z1d.large', 'z1d.metal', 'z1d.xlarge'],
              'us-west-2': ['a1.2xlarge', 'a1.4xlarge', 'a1.large', 'a1.medium', 'a1.xlarge', 'c1.medium', 'c1.xlarge', 'c3.2xlarge', 'c3.4xlarge', 'c3.8xlarge', 'c3.large', 'c3.xlarge', 'c4.2xlarge', 'c4.4xlarge', 'c4.8xlarge', 'c4.large', 'c4.xlarge', 'c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'c5d.18xlarge', 'c5d.2xlarge', 'c5d.4xlarge', 'c5d.9xlarge', 'c5d.large', 'c5d.xlarge', 'c5n.18xlarge', 'c5n.2xlarge', 'c5n.4xlarge', 'c5n.9xlarge', 'c5n.large', 'c5n.xlarge', 'cc2.8xlarge', 'cr1.8xlarge', 'd2.2xlarge', 'd2.4xlarge', 'd2.8xlarge', 'd2.xlarge', 'f1.16xlarge', 'f1.2xlarge', 'f1.4xlarge', 'g2.2xlarge', 'g2.8xlarge', 'g3.16xlarge', 'g3.4xlarge', 'g3.8xlarge', 'g3s.xlarge', 'h1.16xlarge', 'h1.2xlarge', 'h1.4xlarge', 'h1.8xlarge', 'hs1.8xlarge', 'i2.2xlarge', 'i2.4xlarge', 'i2.8xlarge', 'i2.xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.metal', 'i3.xlarge', 'i3en.12xlarge', 'i3en.24xlarge', 'i3en.2xlarge', 'i3en.3xlarge', 'i3en.6xlarge', 'i3en.large', 'i3en.xlarge', 'm1.large', 'm1.medium', 'm1.xlarge', 'm2.2xlarge', 'm2.4xlarge', 'm2.xlarge', 'm3.2xlarge', 'm3.large', 'm3.medium', 'm3.xlarge', 'm4.10xlarge', 'm4.16xlarge', 'm4.2xlarge', 'm4.4xlarge', 'm4.large', 'm4.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.metal', 'm5.xlarge', 'm5a.12xlarge', 'm5a.24xlarge', 'm5a.2xlarge', 'm5a.4xlarge', 'm5a.large', 'm5a.xlarge', 'm5ad.12xlarge', 'm5ad.24xlarge', 'm5ad.2xlarge', 'm5ad.4xlarge', 'm5ad.large', 'm5ad.xlarge', 'm5d.12xlarge', 'm5d.24xlarge', 'm5d.2xlarge', 'm5d.4xlarge', 'm5d.large', 'm5d.metal', 'm5d.xlarge', 'p2.16xlarge', 'p2.8xlarge', 'p2.xlarge', 'p3.16xlarge', 'p3.2xlarge', 'p3.8xlarge', 'p3dn.24xlarge', 'r3.2xlarge', 'r3.4xlarge', 'r3.8xlarge', 'r3.large', 'r3.xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 'r5.12xlarge', 'r5.24xlarge', 'r5.2xlarge', 'r5.4xlarge', 'r5.large', 'r5.metal', 'r5.xlarge', 'r5a.12xlarge', 'r5a.24xlarge', 'r5a.2xlarge', 'r5a.4xlarge', 'r5a.large', 'r5a.xlarge', 'r5ad.12xlarge', 'r5ad.24xlarge', 'r5ad.2xlarge', 'r5ad.4xlarge', 'r5ad.large', 'r5ad.xlarge', 'r5d.12xlarge', 'r5d.24xlarge', 'r5d.2xlarge', 'r5d.4xlarge', 'r5d.large', 'r5d.metal', 'r5d.xlarge', 't1.micro', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge', 't3a.2xlarge', 't3a.large', 't3a.medium', 't3a.micro', 't3a.nano', 't3a.small', 't3a.xlarge', 'x1.16xlarge', 'x1.32xlarge', 'x1e.16xlarge', 'x1e.2xlarge', 'x1e.32xlarge', 'x1e.4xlarge', 'x1e.8xlarge', 'x1e.xlarge', 'z1d.12xlarge', 'z1d.2xlarge', 'z1d.3xlarge', 'z1d.6xlarge', 'z1d.large', 'z1d.metal', 'z1d.xlarge'],
              'us-gov-west-1': ['c1.medium', 'c1.xlarge', 'c3.2xlarge', 'c3.4xlarge', 'c3.8xlarge', 'c3.large', 'c3.xlarge', 'c4.2xlarge', 'c4.4xlarge', 'c4.8xlarge', 'c4.large', 'c4.xlarge', 'c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'c5d.18xlarge', 'c5d.2xlarge', 'c5d.4xlarge', 'c5d.9xlarge', 'c5d.large', 'c5d.xlarge', 'c5n.18xlarge', 'c5n.2xlarge', 'c5n.4xlarge', 'c5n.9xlarge', 'c5n.large', 'c5n.xlarge', 'cc2.8xlarge', 'd2.2xlarge', 'd2.4xlarge', 'd2.8xlarge', 'd2.xlarge', 'f1.16xlarge', 'f1.2xlarge', 'f1.4xlarge', 'g3.16xlarge', 'g3.4xlarge', 'g3.8xlarge', 'hs1.8xlarge', 'i2.2xlarge', 'i2.4xlarge', 'i2.8xlarge', 'i2.xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.metal', 'i3.xlarge', 'm1.large', 'm1.medium', 'm1.xlarge', 'm2.2xlarge', 'm2.4xlarge', 'm2.xlarge', 'm3.2xlarge', 'm3.large', 'm3.medium', 'm3.xlarge', 'm4.10xlarge', 'm4.16xlarge', 'm4.2xlarge', 'm4.4xlarge', 'm4.large', 'm4.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.metal', 'm5.xlarge', 'm5d.12xlarge', 'm5d.24xlarge', 'm5d.2xlarge', 'm5d.4xlarge', 'm5d.large', 'm5d.metal', 'm5d.xlarge', 'p2.16xlarge', 'p2.8xlarge', 'p2.xlarge', 'p3.16xlarge', 'p3.2xlarge', 'p3.8xlarge', 'r3.2xlarge', 'r3.4xlarge', 'r3.8xlarge', 'r3.large', 'r3.xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 'r5.12xlarge', 'r5.24xlarge', 'r5.2xlarge', 'r5.4xlarge', 'r5.large', 'r5.metal', 'r5.xlarge', 'r5d.12xlarge', 'r5d.24xlarge', 'r5d.2xlarge', 'r5d.4xlarge', 'r5d.large', 'r5d.metal', 'r5d.xlarge', 't1.micro', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge', 'x1.16xlarge', 'x1.32xlarge', 'x1e.16xlarge', 'x1e.2xlarge', 'x1e.32xlarge', 'x1e.4xlarge', 'x1e.8xlarge', 'x1e.xlarge'],
              'ap-south-1': ['c4.2xlarge', 'c4.4xlarge', 'c4.8xlarge', 'c4.large', 'c4.xlarge', 'c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'c5d.18xlarge', 'c5d.2xlarge', 'c5d.4xlarge', 'c5d.9xlarge', 'c5d.large', 'c5d.xlarge', 'd2.2xlarge', 'd2.4xlarge', 'd2.8xlarge', 'd2.xlarge', 'i2.2xlarge', 'i2.4xlarge', 'i2.8xlarge', 'i2.xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.xlarge', 'm4.10xlarge', 'm4.16xlarge', 'm4.2xlarge', 'm4.4xlarge', 'm4.large', 'm4.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.metal', 'm5.xlarge', 'm5d.12xlarge', 'm5d.24xlarge', 'm5d.2xlarge', 'm5d.4xlarge', 'm5d.large', 'm5d.metal', 'm5d.xlarge', 'p2.16xlarge', 'p2.8xlarge', 'p2.xlarge', 'r3.2xlarge', 'r3.4xlarge', 'r3.8xlarge', 'r3.large', 'r3.xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 'r5.12xlarge', 'r5.24xlarge', 'r5.2xlarge', 'r5.4xlarge', 'r5.large', 'r5.metal', 'r5.xlarge', 'r5d.12xlarge', 'r5d.24xlarge', 'r5d.2xlarge', 'r5d.4xlarge', 'r5d.large', 'r5d.metal', 'r5d.xlarge', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge', 'x1.16xlarge', 'x1.32xlarge'],
              'eu-central-1': ['c3.2xlarge', 'c3.4xlarge', 'c3.8xlarge', 'c3.large', 'c3.xlarge', 'c4.2xlarge', 'c4.4xlarge', 'c4.8xlarge', 'c4.large', 'c4.xlarge', 'c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'c5d.18xlarge', 'c5d.2xlarge', 'c5d.4xlarge', 'c5d.9xlarge', 'c5d.large', 'c5d.xlarge', 'c5n.18xlarge', 'c5n.2xlarge', 'c5n.4xlarge', 'c5n.9xlarge', 'c5n.large', 'c5n.xlarge', 'd2.2xlarge', 'd2.4xlarge', 'd2.8xlarge', 'd2.xlarge', 'g2.2xlarge', 'g2.8xlarge', 'g3.16xlarge', 'g3.4xlarge', 'g3.8xlarge', 'g3s.xlarge', 'i2.2xlarge', 'i2.4xlarge', 'i2.8xlarge', 'i2.xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.metal', 'i3.xlarge', 'i3en.12xlarge', 'i3en.24xlarge', 'i3en.2xlarge', 'i3en.3xlarge', 'i3en.6xlarge', 'i3en.large', 'i3en.xlarge', 'm3.2xlarge', 'm3.large', 'm3.medium', 'm3.xlarge', 'm4.10xlarge', 'm4.16xlarge', 'm4.2xlarge', 'm4.4xlarge', 'm4.large', 'm4.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.metal', 'm5.xlarge', 'm5a.12xlarge', 'm5a.24xlarge', 'm5a.2xlarge', 'm5a.4xlarge', 'm5a.large', 'm5a.xlarge', 'm5d.12xlarge', 'm5d.24xlarge', 'm5d.2xlarge', 'm5d.4xlarge', 'm5d.large', 'm5d.metal', 'm5d.xlarge', 'p2.16xlarge', 'p2.8xlarge', 'p2.xlarge', 'p3.16xlarge', 'p3.2xlarge', 'p3.8xlarge', 'r3.2xlarge', 'r3.4xlarge', 'r3.8xlarge', 'r3.large', 'r3.xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 'r5.12xlarge', 'r5.24xlarge', 'r5.2xlarge', 'r5.4xlarge', 'r5.large', 'r5.metal', 'r5.xlarge', 'r5a.12xlarge', 'r5a.24xlarge', 'r5a.2xlarge', 'r5a.4xlarge', 'r5a.large', 'r5a.xlarge', 'r5d.12xlarge', 'r5d.24xlarge', 'r5d.2xlarge', 'r5d.4xlarge', 'r5d.large', 'r5d.metal', 'r5d.xlarge', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge', 'x1.16xlarge', 'x1.32xlarge', 'x1e.16xlarge', 'x1e.2xlarge', 'x1e.32xlarge', 'x1e.4xlarge', 'x1e.8xlarge', 'x1e.xlarge', 'z1d.12xlarge', 'z1d.2xlarge', 'z1d.3xlarge', 'z1d.6xlarge', 'z1d.large', 'z1d.metal', 'z1d.xlarge'],
              'eu-west-1': ['a1.2xlarge', 'a1.4xlarge', 'a1.large', 'a1.medium', 'a1.xlarge', 'c1.medium', 'c1.xlarge', 'c3.2xlarge', 'c3.4xlarge', 'c3.8xlarge', 'c3.large', 'c3.xlarge', 'c4.2xlarge', 'c4.4xlarge', 'c4.8xlarge', 'c4.large', 'c4.xlarge', 'c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'c5d.18xlarge', 'c5d.2xlarge', 'c5d.4xlarge', 'c5d.9xlarge', 'c5d.large', 'c5d.xlarge', 'c5n.18xlarge', 'c5n.2xlarge', 'c5n.4xlarge', 'c5n.9xlarge', 'c5n.large', 'c5n.xlarge', 'cc2.8xlarge', 'cr1.8xlarge', 'd2.2xlarge', 'd2.4xlarge', 'd2.8xlarge', 'd2.xlarge', 'f1.16xlarge', 'f1.2xlarge', 'f1.4xlarge', 'g2.2xlarge', 'g2.8xlarge', 'g3.16xlarge', 'g3.4xlarge', 'g3.8xlarge', 'g3s.xlarge', 'h1.16xlarge', 'h1.2xlarge', 'h1.4xlarge', 'h1.8xlarge', 'hs1.8xlarge', 'i2.2xlarge', 'i2.4xlarge', 'i2.8xlarge', 'i2.xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.metal', 'i3.xlarge', 'i3en.12xlarge', 'i3en.24xlarge', 'i3en.2xlarge', 'i3en.3xlarge', 'i3en.6xlarge', 'i3en.large', 'i3en.xlarge', 'm1.large', 'm1.medium', 'm1.xlarge', 'm2.2xlarge', 'm2.4xlarge', 'm2.xlarge', 'm3.2xlarge', 'm3.large', 'm3.medium', 'm3.xlarge', 'm4.10xlarge', 'm4.16xlarge', 'm4.2xlarge', 'm4.4xlarge', 'm4.large', 'm4.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.metal', 'm5.xlarge', 'm5a.12xlarge', 'm5a.24xlarge', 'm5a.2xlarge', 'm5a.4xlarge', 'm5a.large', 'm5a.xlarge', 'm5d.12xlarge', 'm5d.24xlarge', 'm5d.2xlarge', 'm5d.4xlarge', 'm5d.large', 'm5d.metal', 'm5d.xlarge', 'p2.16xlarge', 'p2.8xlarge', 'p2.xlarge', 'p3.16xlarge', 'p3.2xlarge', 'p3.8xlarge', 'p3dn.24xlarge', 'r3.2xlarge', 'r3.4xlarge', 'r3.8xlarge', 'r3.large', 'r3.xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 'r5.12xlarge', 'r5.24xlarge', 'r5.2xlarge', 'r5.4xlarge', 'r5.large', 'r5.metal', 'r5.xlarge', 'r5a.12xlarge', 'r5a.24xlarge', 'r5a.2xlarge', 'r5a.4xlarge', 'r5a.large', 'r5a.xlarge', 'r5d.12xlarge', 'r5d.24xlarge', 'r5d.2xlarge', 'r5d.4xlarge', 'r5d.large', 'r5d.metal', 'r5d.xlarge', 't1.micro', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge', 't3a.2xlarge', 't3a.large', 't3a.medium', 't3a.micro', 't3a.nano', 't3a.small', 't3a.xlarge', 'x1.16xlarge', 'x1.32xlarge', 'x1e.16xlarge', 'x1e.2xlarge', 'x1e.32xlarge', 'x1e.4xlarge', 'x1e.8xlarge', 'x1e.xlarge', 'z1d.12xlarge', 'z1d.2xlarge', 'z1d.3xlarge', 'z1d.6xlarge', 'z1d.large', 'z1d.metal', 'z1d.xlarge'],
              'eu-west-2': ['c4.2xlarge', 'c4.4xlarge', 'c4.8xlarge', 'c4.large', 'c4.xlarge', 'c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'c5d.18xlarge', 'c5d.2xlarge', 'c5d.4xlarge', 'c5d.9xlarge', 'c5d.large', 'c5d.xlarge', 'd2.2xlarge', 'd2.4xlarge', 'd2.8xlarge', 'd2.xlarge', 'g3.16xlarge', 'g3.4xlarge', 'g3.8xlarge', 'g3s.xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.xlarge', 'm4.10xlarge', 'm4.16xlarge', 'm4.2xlarge', 'm4.4xlarge', 'm4.large', 'm4.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.metal', 'm5.xlarge', 'm5d.12xlarge', 'm5d.24xlarge', 'm5d.2xlarge', 'm5d.4xlarge', 'm5d.large', 'm5d.metal', 'm5d.xlarge', 'p3.16xlarge', 'p3.2xlarge', 'p3.8xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 'r5.12xlarge', 'r5.24xlarge', 'r5.2xlarge', 'r5.4xlarge', 'r5.large', 'r5.metal', 'r5.xlarge', 'r5d.12xlarge', 'r5d.24xlarge', 'r5d.2xlarge', 'r5d.4xlarge', 'r5d.large', 'r5d.metal', 'r5d.xlarge', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge', 'x1.16xlarge', 'x1.32xlarge', 'z1d.12xlarge', 'z1d.2xlarge', 'z1d.3xlarge', 'z1d.6xlarge', 'z1d.large', 'z1d.metal', 'z1d.xlarge'],
              'eu-west-3': ['c5.18xlarge', 'c5.2xlarge', 'c5.4xlarge', 'c5.9xlarge', 'c5.large', 'c5.xlarge', 'c5d.18xlarge', 'c5d.2xlarge', 'c5d.4xlarge', 'c5d.9xlarge', 'c5d.large', 'c5d.xlarge', 'd2.2xlarge', 'd2.4xlarge', 'd2.8xlarge', 'd2.xlarge', 'i3.16xlarge', 'i3.2xlarge', 'i3.4xlarge', 'i3.8xlarge', 'i3.large', 'i3.xlarge', 'm5.12xlarge', 'm5.24xlarge', 'm5.2xlarge', 'm5.4xlarge', 'm5.large', 'm5.metal', 'm5.xlarge', 'm5d.12xlarge', 'm5d.24xlarge', 'm5d.2xlarge', 'm5d.4xlarge', 'm5d.large', 'm5d.metal', 'm5d.xlarge', 'r4.16xlarge', 'r4.2xlarge', 'r4.4xlarge', 'r4.8xlarge', 'r4.large', 'r4.xlarge', 'r5.12xlarge', 'r5.24xlarge', 'r5.2xlarge', 'r5.4xlarge', 'r5.large', 'r5.metal', 'r5.xlarge', 'r5d.12xlarge', 'r5d.24xlarge', 'r5d.2xlarge', 'r5d.4xlarge', 'r5d.large', 'r5d.metal', 'r5d.xlarge', 't2.2xlarge', 't2.large', 't2.medium', 't2.micro', 't2.nano', 't2.small', 't2.xlarge', 't3.2xlarge', 't3.large', 't3.medium', 't3.micro', 't3.nano', 't3.small', 't3.xlarge', 'x1.16xlarge', 'x1.32xlarge']}

ec2InstancesByRegion = dict((region, [E2Instances[i] for i in instances]) for region, instances in iteritems(regionDict))
