/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/

#include "main.h"
#include "messages.h"
#include "chat.h"
#include "conffile.h"
#include "windows.h"
#include "utils.h"

#include <time.h>

//nowa wiadomosc, typ podajemy uzywajac stalych z libtlen
void message_show(gchar *jid, gchar *body, gchar *stamp, gint type)
{
  gchar *from;
  gint utype;

  if(!body)
    return;
  from = strdup(jid);
  from = user_del_res(from);
  utype = get_type(from);
  if((utype == USER_JABBER) || (utype == USER_WP) || (utype == USER_GG)
     || (utype == USER_AGENT))
    body = fromutf(body);
  else
    body = g_strdup(body);
  if (!body)
    body = g_strdup("Unknown characters in the string");
  if(type == TLEN_CHAT)
  {
    struct talk *talk=get_talk(from);
    gchar *s;
    gchar *stmp;

    tleenx_print(DEBUG, "new chat\n");

    if(stamp)
    {
      stmp=g_strdup(stamp);
      s=strchr(stmp,'T');
      *s=' ';
    }
    else
      stmp=get_localtime(NULL);

    queue_chat(from, body, 1);
    if(!talk)
    {
      if(preferences & PREF_BEEPONM)
        play_sound(SOUNDM);
      my_create_window_chat(from);
      talk=get_talk(from);
    }
    else
    {
      if(preferences & PREF_BEEPONT)
        play_sound(SOUNDT);
      if(!GTK_WIDGET_VISIBLE(talk->window))
        gtk_widget_show(talk->window);
    }
    chat_append(talk,body,stmp,0);
    g_free(stmp);
    chat_set_title(talk, '+');
  }
  else
  {
    gchar *s=NULL;

    if(preferences & PREF_BEEPONM)
      play_sound(SOUNDM);
    save_message(from, body,1);
    if(stamp)
    {
      gchar *stmp;

      stmp=g_strdup(stamp);
      s=strchr(stmp,'T');
      *s=' ';
      s=g_strdup(stmp);
      g_free(stmp);
    }
    message_add(from,
                body, s, TLEN_MESSAGE);
    g_free(s);
    if(!window_message)
      my_create_window_message();
    else
      window_message_update_count();
  }
  g_free(from);
  g_free(body);
}

void messages_save()
{
  //FIXME zapisz nieprzeczytane wiadomosci do pliku
}

gboolean messages_unread()
{
  GList *l;
  struct message *m;

  for(l = messages_list; l; l = l->next)
  {
    m = (struct message*) l->data;
    if(!(m->read))
      return TRUE;
  }
  return FALSE;
}

gint messages_count()
{
  GList *l;
  gint num = 0;

  for(l = messages_list; l; l = l->next)
    num++;
  return num;
}

struct message *message_prev(gint num)
{
  struct message *m, *prev = NULL;
  GList *l = messages_list;

  while(l)
  {
    m = (struct message*) l->data;
    num--;
    if(!num)
      return prev;
    prev = m;
    l = l->next;
  }
  return NULL;
}

struct message *message_next(gint num)
{
  struct message *m;
  GList *l = messages_list;

  while(l)
  {
    m = (struct message*) l->data;
    if(!num)
      return m;
    else
      num--;
    l = l->next;
  }
  return NULL;
}

void message_free(struct message *m)
{
  g_free(m->id);
  g_free(m->message);
  g_free(m->stamp);
}

void message_add(gchar *id, gchar *message, gchar *stamp,
                            gint type)
{
  struct message *m;

  m = (struct message*)g_malloc(sizeof(*m));
  m->id = g_strdup(id);
  m->message = g_strdup(message);
  m->stamp = g_strdup(stamp);
  m->type = type;
  m->read = FALSE;
  messages_list = g_list_append(messages_list, (gpointer) m);
}

void messages_list_clear()
{
  struct message *m;
  GList *l = messages_list;

  while(l)
  {
    m = (struct message*) l->data;
    message_free(m);
    l = l->next;
  }
  g_list_free(messages_list);
  messages_list = NULL;
}
