/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/




#include "main.h"
#include "interface.h"
#include "conffile.h"
#include "support.h"
#include "utils.h"
#include "users.h"
#include "search.h"
#include "messages.h"
#include "menu.h"
#include "windows.h"
#include "archive.h"
#include "callbacks.h"
#include "lista.h"
#include "chat.h"
#include "gg.h"
#include "jabber.h"
#include "jabby.h"
#include "xmms-info.h"
#include "groups.h"
#include <gdk/gdkkeysyms.h>

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

GtkTooltips *status_tooltips; //tooltips list for status icons

static gchar *search_tc_columns[SEARCH_TC_COLUMNS] =
{
  "Status", "ID", "Wiek", "Pe", "Miasto", "Imi", "Nazwisko", "Nick", "Email",
  "Poszukuje", "Szkoa", "Zawd", "Gosowe", "Plany"
};//tytuly kolumn w treeview window_search



void window_gg_talk()
{
  if(!jabber_registered_to_gg())
  {
    info("Musisz najpierw zarejestrowa swj numer.");
    return;
  }
  if(!get_talk(profile->ggserver))
  {
    my_create_window_chat(profile->ggserver);
  }
}

void window_gg_apply()
{
  GtkWidget *widget;
//  gboolean fo, iv;

  if(!jabber_registered_to_gg())
  {
    info("Musisz najpierw zarejestrowa swj numer.");
    return;
  }
  widget = lookup_widget(window_gg, "checkbutton_fo");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)))
    jabber_gg_agent("fo on");
  else
    jabber_gg_agent("fo off");
  widget = lookup_widget(window_gg, "checkbutton_iv");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)))
    jabber_gg_agent("iv on");
  else
    jabber_gg_agent("iv off");
}

void window_gg_register_sms()
{
  GtkWidget *widget;
  gchar *number, *password;

  widget = lookup_widget(window_gg, "entry_sms_id");
  number = (gchar*)gtk_entry_get_text(GTK_ENTRY(widget));
  if(!strlen(number))
  {
    info("Musisz poda swj ID bramki w ustawieniach profilu.");
    return;
  }
  widget = lookup_widget(window_gg, "entry_sms_password");
  password = (gchar*)gtk_entry_get_text(GTK_ENTRY(widget));
  if(!strlen(password))
  {
    info("Nie podae hasa.");
    return;
  }
//  if(jabber_registered_to_sms())
//  {
//    info("Wyrejestruj najpierw stary numer.");
//    return;
//  }
  if(!profile->sms)
  {
    info("Serwer jabbera nie posiada bramki SMS.");
    return;
  }
  jabber_register_sms();
}

void window_gg_register()
{
  GtkWidget *widget;
  gchar *number, *password;

  widget = lookup_widget(window_gg, "entry_username");
  number = (gchar*)gtk_entry_get_text(GTK_ENTRY(widget));
  if(!strlen(number))
  {
    info("Musisz poda swj numer w ustawieniach profilu.");
    return;
  }
  widget = lookup_widget(window_gg, "entry_password");
  password = (gchar*)gtk_entry_get_text(GTK_ENTRY(widget));
  if(!strlen(password))
  {
    info("Nie podae hasa.");
    return;
  }
  if(!(profile->ggserver))
  {
    info("Serwer jabbera nie posiada bramki GG.");
    return;
  }
  g_free(profile->ggnumber);
  profile->ggnumber = g_strdup(number);
  g_free(profile->ggpassword);
  profile->ggpassword = g_strdup(password);
  if(jabber_registered_to_gg())
  {
    info("Wyrejestruj najpierw stary numer.");
    return;
  }
  jabber_register_gg();
}

void window_sms_send()
{
  GtkWidget *widget;
  gchar *number, *s, *body;

  widget = lookup_widget(window_sms, "entry_number");
  s = (gchar*) gtk_entry_get_text(GTK_ENTRY(widget));
  if(strlen(s)<=3)
  {
    info("Wprowad poprawny numer telefonu.");
    return;
  }
  if(!jabber_logged())
  {
    info("Brak poczenia z jabberem.");
    return;
  }
  if(!jabber_registered_to_sms())
  {
    info("Musisz si najpierw zarejestrowa, sprawd ustawienia SMS.");
    return;
  }
  widget = lookup_widget(window_sms, "textview_sms");
  body = (gchar *)textview_get_text(widget);
  if(!body)
  {
    info("Wiadomo jest pusta.");
    return;
  }
  number = g_strdup_printf("%s@%s", s, profile->sms);
  jabber_message(number, body, JABBY_MESSAGE_CHAT);
  g_free(number);
  gtk_widget_destroy(window_sms);
  window_sms=NULL;
}

GtkWidget *create_window_pic(GtkWidget *window_chat)
{
  GtkWidget *window;
  GtkWidget *button1;
  GtkWidget *emots_table;
  gint max_x;
  gint max_y;
  gint i, x, y, stri;
  GtkTooltips *tooltips;
  gchar *s;


  tooltips = gtk_tooltips_new ();
  max_x = 5;
  max_y = EMOTS_END/max_x;


  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Wstaw obrazek");
  g_signal_connect ((gpointer) window, "delete_event",
                    G_CALLBACK (on_window_pic_delete_event),
                    window);
  gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);

  emots_table = gtk_table_new(max_x, max_y, FALSE);
  gtk_widget_show (emots_table);
  gtk_container_add (GTK_CONTAINER (window), emots_table);
  gtk_container_set_border_width (GTK_CONTAINER (emots_table), 4);
  gtk_table_set_row_spacings (GTK_TABLE (emots_table), 2);
  gtk_table_set_col_spacings (GTK_TABLE (emots_table), 4);

  x = y = 0;
  stri = 0;
  for(i=0; i < EMOTS_END; i++)
  {
    button1 = gtk_button_new ();
    gtk_widget_show (button1);
    gtk_table_attach (GTK_TABLE (emots_table), button1, x, x+1, y, y+1,
                      (GtkAttachOptions) (GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    GTK_WIDGET_UNSET_FLAGS (button1, GTK_CAN_FOCUS);
    s = utf(emots_str[stri]);
    gtk_tooltips_set_tip (tooltips, button1, s, NULL);
    g_free(s);
    gtk_button_set_relief (GTK_BUTTON (button1), GTK_RELIEF_NONE);
    gtk_container_add(GTK_CONTAINER (button1), emots_pics[i]);


    g_signal_connect ((gpointer) button1, "clicked",
                      G_CALLBACK (on_emots_button1_clicked),
                      emots_str[stri]);
    GLADE_HOOKUP_OBJECT (window, button1, "button1");
    if(++x >= max_x)
    {
      x = 0;
      y++;
    }
    stri++;
    while(emots_num[stri] == emots_num[stri-1])
    {
      stri++;
    }
  }

  /* Store pointers to all widgets, for use by lookup_widget(). */
//  GLADE_HOOKUP_OBJECT_NO_REF (window2, window2, "window2");
  GLADE_HOOKUP_OBJECT (window, emots_table, "emots_table");
  GLADE_HOOKUP_OBJECT_NO_REF (window, tooltips, "tooltips");

  return window;
}

void my_create_window_sms()
{
//  GtkWidget *widget;

  window_sms = create_window_sms();
  gtk_widget_show(window_sms);
}

void my_create_window_gg()
{
  GtkWidget *widget;

  window_gg = create_window_gg();
  if((profile->ggnumber) && (profile->ggpassword))
  {
    widget = lookup_widget(window_gg, "entry_username");
    gtk_entry_set_text(GTK_ENTRY(widget), profile->ggnumber);
    widget = lookup_widget(window_gg, "entry_password");
    gtk_entry_set_text(GTK_ENTRY(widget), profile->ggpassword);
  }
  if((profile->smsid) && (profile->smspassword))
  {
    widget = lookup_widget(window_gg, "entry_sms_id");
    gtk_entry_set_text(GTK_ENTRY(widget), profile->smsid);
    widget = lookup_widget(window_gg, "entry_sms_password");
    gtk_entry_set_text(GTK_ENTRY(widget), profile->smspassword);
  }
  gtk_widget_show(window_gg);
}


void my_create_window_desc()
{
  GtkWidget *combo;
  GList *l = NULL, *l2;

  window_desc = create_window_desc();
  combo = lookup_widget(window_desc, "combo_desc");
  l2 = desc_list;
  while(l2)
  {
    l = g_list_append(l, utf((gchar*) (l2->data)));
    l2 = l2->next;
  }
  if(!desc)
    l = g_list_prepend(l, NULL);
  gtk_combo_set_popdown_strings (GTK_COMBO(combo), l);
  g_list_foreach(l, frees, NULL);
  g_list_free(l);
  gtk_widget_show(window_desc);
}

void window1_open()
{
  my_create_window1();
  gtk_window_set_icon(GTK_WINDOW(window1),
            gtk_image_get_pixbuf(GTK_IMAGE(icons[TLEN_STATUS_UNAVAILABLE])));
  profile = get_profile(pname);
//  profiles_list_clear();
  status=TLEN_STATUS_AVAILABLE;
  read_preferences();
  file_load_expanded_groups();
  
  if(!datefg)
    datefg = g_strdup("#808080");
  if(!nickfg)
    nickfg = g_strdup("#FF6600");
  if(!textfg)
    textfg = g_strdup("#000000");
  if(!textbg)
    textbg = g_strdup("#DCDAD5");
  if(preferences & PREF_DEBUGON)
    tlen_setdebug(1);
  if(status != TLEN_STATUS_UNAVAILABLE)
    work_online();
  //    else
  //      work_offline();
  status_button_set(TLEN_STATUS_UNAVAILABLE);
  status_gg_button_set(JABBY_PRESENCE_UNAVAILABLE);
  status_jabber_button_set(JABBY_PRESENCE_UNAVAILABLE);
  if((!width) && (!height))
  {
    width=150;
    height=250;
  }
  gtk_window_set_default_size(GTK_WINDOW(window1),width,height);
  if((posx>0) && (posy>0))
    gtk_window_move(GTK_WINDOW(window1), posx, posy);

  gtk_widget_show(window1);
}

void my_create_window1()
{
  GtkWidget *image, *widget;
  GtkWidget *menuitem, *button;
  gchar *s;
//  GtkTreeView *treeview;
//  GtkTreeModel *model;
  //menuglowne
  GtkWidget *tlen1_menu;
  //menu statusow
  GtkWidget *menu_status;
  GtkWidget *wyszukiwanie1;
  GtkWidget *wyslij_wiadomosc;
  GtkWidget *wyslij_sms;
  GtkWidget *wizytowka;
  GtkWidget *image29;
  GtkWidget *dodaj_kontakt1;
  GtkWidget *image30;
  GtkWidget *separator1;
  GtkWidget *archiwum1;
  GtkWidget *image31;
  GtkWidget *ustawienia1;
  GtkWidget *ustawienia_gg;
  GtkWidget *image32;
#ifndef DISABLE_DOCKLET
  GtkWidget *menu_show_docklet;
#endif
  GtkWidget *separator2;
  GtkWidget *o_programie1;
  GtkWidget *image33;
  GtkWidget *separator3;
  GtkWidget *wyloguj_profil1;
  GtkWidget *image34;
  GtkWidget *wyj__cie1;
  GtkWidget *image35;
  //menuglowne
  GtkAccelGroup *accel_group;


  accel_group = gtk_accel_group_new ();
  window1 = create_window1();

  menu_status=gtk_menu_new();
  GLADE_HOOKUP_OBJECT(window1, menu_status, "menu_status");

  status_tooltips = gtk_tooltips_new(); //init. tooltips list for status icons

  //menu glowne
  tlen1_menu = gtk_menu_new ();
  GLADE_HOOKUP_OBJECT(window1, tlen1_menu, "menu_tlen");

  s = utf("Wy_lij wiadomo...");
  wyslij_wiadomosc = gtk_image_menu_item_new_with_mnemonic (s);
  g_free(s);
  gtk_widget_show (wyslij_wiadomosc);
  gtk_container_add (GTK_CONTAINER (tlen1_menu), wyslij_wiadomosc);
  image = create_pixmap (window1, "sendmsg.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "sendmsg.png");
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(wyslij_wiadomosc), image);

  s = utf("Wylij sms...");
  wyslij_sms = gtk_image_menu_item_new_with_mnemonic (s);
  g_free(s);
  gtk_widget_show (wyslij_sms);
  gtk_container_add (GTK_CONTAINER (tlen1_menu), wyslij_sms);
  image = create_pixmap (window1, "sms.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "sms.png");
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(wyslij_sms), image);

  s = utf("Mo_ja wizytwka...");
  wizytowka = gtk_image_menu_item_new_with_mnemonic (s);
  g_free(s);
  gtk_widget_show (wizytowka);
  gtk_container_add (GTK_CONTAINER (tlen1_menu), wizytowka);
  image = create_pixmap (window1, "wizytowka.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "wizytowka.png");
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(wizytowka), image);

  wyszukiwanie1 = gtk_image_menu_item_new_with_mnemonic ("Wy_szukiwanie...");
  gtk_widget_show (wyszukiwanie1);
  gtk_container_add (GTK_CONTAINER (tlen1_menu), wyszukiwanie1);
  gtk_widget_add_accelerator (wyszukiwanie1, "activate", accel_group,
                              GDK_S, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  image29 = gtk_image_new_from_stock ("gtk-find", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image29);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (wyszukiwanie1), image29);

  dodaj_kontakt1 = gtk_image_menu_item_new_with_mnemonic ("_Dodaj kontakt...");
  gtk_widget_show (dodaj_kontakt1);
  gtk_container_add (GTK_CONTAINER (tlen1_menu), dodaj_kontakt1);
  gtk_widget_add_accelerator (dodaj_kontakt1, "activate", accel_group,
                              GDK_A, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  image30 = gtk_image_new_from_stock ("gtk-add", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image30);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (dodaj_kontakt1), image30);

  separator1 = gtk_menu_item_new ();
  gtk_widget_show (separator1);
  gtk_container_add (GTK_CONTAINER (tlen1_menu), separator1);
  gtk_widget_set_sensitive (separator1, FALSE);

  archiwum1 = gtk_image_menu_item_new_with_mnemonic ("_Archiwum...");
  gtk_widget_show (archiwum1);
  gtk_container_add (GTK_CONTAINER (tlen1_menu), archiwum1);
  gtk_widget_add_accelerator (archiwum1, "activate", accel_group,
                              GDK_R, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  image31 = gtk_image_new_from_stock ("gtk-index", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image31);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (archiwum1), image31);

  ustawienia1 = gtk_image_menu_item_new_with_mnemonic ("_Ustawienia...");
  gtk_widget_show (ustawienia1);
  gtk_container_add (GTK_CONTAINER (tlen1_menu), ustawienia1);
  gtk_widget_add_accelerator (ustawienia1, "activate", accel_group,
                              GDK_P, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  ustawienia_gg = gtk_image_menu_item_new_with_mnemonic
          ("Ustawienia Gadu-Gadu/SMS...");
  gtk_widget_show (ustawienia_gg);
  gtk_container_add (GTK_CONTAINER (tlen1_menu), ustawienia_gg);
  image = create_pixmap (window1, "gg_offline.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "gg_offline.png");
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(ustawienia_gg), image);

  image32 = gtk_image_new_from_stock ("gtk-preferences", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image32);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (ustawienia1), image32);


#ifndef DISABLE_DOCKLET
  menu_show_docklet = gtk_image_menu_item_new_with_mnemonic(
      "Pokaż/ukryj docklet.");
  gtk_widget_show(menu_show_docklet);
  gtk_container_add(GTK_CONTAINER(tlen1_menu), menu_show_docklet);
  image = create_pixmap(window1, "online.png");
  gtk_widget_show(image);
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menu_show_docklet), image);
  g_signal_connect(G_OBJECT(menu_show_docklet), "activate",
      G_CALLBACK(on_menu_show_docklet_activate), NULL);
#endif

  separator2 = gtk_menu_item_new ();
  gtk_widget_show (separator2);
  gtk_container_add (GTK_CONTAINER (tlen1_menu), separator2);
  gtk_widget_set_sensitive (separator2, FALSE);

  o_programie1 = gtk_image_menu_item_new_with_mnemonic ("_O programie...");
  gtk_widget_show (o_programie1);
  gtk_container_add (GTK_CONTAINER (tlen1_menu), o_programie1);

  image33 = gtk_image_new_from_stock ("gtk-dialog-info", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image33);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (o_programie1), image33);

  separator3 = gtk_menu_item_new ();
  gtk_widget_show (separator3);
  gtk_container_add (GTK_CONTAINER (tlen1_menu), separator3);
  gtk_widget_set_sensitive (separator3, FALSE);

  wyloguj_profil1 = gtk_image_menu_item_new_with_mnemonic ("_Wyloguj profil...");
  gtk_widget_show (wyloguj_profil1);
  gtk_container_add (GTK_CONTAINER (tlen1_menu), wyloguj_profil1);
  gtk_widget_add_accelerator (wyloguj_profil1, "activate", accel_group,
                              GDK_W, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  image34 = gtk_image_new_from_stock ("gtk-jump-to", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image34);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (wyloguj_profil1), image34);

  wyj__cie1 = gtk_image_menu_item_new_with_mnemonic ("W_yj\233cie");
  gtk_widget_show (wyj__cie1);
  gtk_container_add (GTK_CONTAINER (tlen1_menu), wyj__cie1);
  gtk_widget_add_accelerator (wyj__cie1, "activate", accel_group,
                              GDK_Q, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  image35 = gtk_image_new_from_stock ("gtk-quit", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image35);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (wyj__cie1), image35);

  //ikonki statusow gg i jabbera
  image = create_pixmap (window1, "gg_online.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "gg_online");

  image = create_pixmap (window1, "gg_offline.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "gg_offline");

  image = create_pixmap (window1, "gg_away.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "gg_away");

  image = create_pixmap (window1, "gg_invisible.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "gg_invisible");

  image = create_pixmap (window1, "j_invisible.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "j_invisible");

  image = create_pixmap (window1, "j_away.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "j_away");

  image = create_pixmap (window1, "j_dnd.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "j_dnd");

  image = create_pixmap (window1, "j_na.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "j_na");

  image = create_pixmap (window1, "j_online.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "j_online");

  image = create_pixmap (window1, "j_offline.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "j_offline");

  image = create_pixmap (window1, "j_chatty.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "j_chatty");

  //menu statusu


  image = create_pixmap (window1, "online.png");
  s=utf("_Dostpny");
  menuitem=gtk_image_menu_item_new_with_mnemonic(s);
  g_free(s);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_status),menuitem);
  g_signal_connect_swapped (G_OBJECT (menuitem), "activate",
                             G_CALLBACK (menu_status_response),
                             "1");
  gtk_widget_show (menuitem);
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem),image);
  gtk_widget_show (image);
  image = create_pixmap (window1, "online.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "im_online");

  image = create_pixmap (window1, "chat.png");
  s=utf("_Porozmawiajmy");
  menuitem=gtk_image_menu_item_new_with_mnemonic(s);
  g_free(s);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_status),menuitem);
  g_signal_connect_swapped (G_OBJECT (menuitem), "activate",
                             G_CALLBACK (menu_status_response),
                             "2");
  gtk_widget_show (menuitem);
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem),image);
  gtk_widget_show (image);
  image = create_pixmap (window1, "chat.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "im_chat");

  image = create_pixmap (window1, "occupied.png");
  s=utf("_Jestem zajty");
  menuitem=gtk_image_menu_item_new_with_mnemonic(s);
  g_free(s);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_status),menuitem);
  g_signal_connect_swapped (G_OBJECT (menuitem), "activate",
                             G_CALLBACK (menu_status_response),
                             "3");
  gtk_widget_show (menuitem);
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem),image);
  gtk_widget_show (image);
  image = create_pixmap (window1, "occupied.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "im_occupied");

  image = create_pixmap (window1, "away.png");
  s=utf("_Zaraz wracam");
  menuitem=gtk_image_menu_item_new_with_mnemonic(s);
  g_free(s);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_status),menuitem);
  g_signal_connect_swapped (G_OBJECT (menuitem), "activate",
                             G_CALLBACK (menu_status_response),
                             "4");
  gtk_widget_show (menuitem);
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem),image);
  gtk_widget_show (image);
  image = create_pixmap (window1, "away.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "im_away");

  image = create_pixmap (window1, "beback.png");
  s=utf("_Wrc pniej");
  menuitem=gtk_image_menu_item_new_with_mnemonic(s);
  g_free(s);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_status),menuitem);
  g_signal_connect_swapped (G_OBJECT (menuitem), "activate",
                             G_CALLBACK (menu_status_response),
                             "5");
  gtk_widget_show (menuitem);
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem),image);
  gtk_widget_show (image);
  image = create_pixmap (window1, "beback.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "im_beback");

  image = create_pixmap (window1, "invisible.png");
  s=utf("N_iewidoczny");
  menuitem=gtk_image_menu_item_new_with_mnemonic(s);
  g_free(s);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_status),menuitem);
  g_signal_connect_swapped (G_OBJECT (menuitem), "activate",
                             G_CALLBACK (menu_status_response),
                             "6");
  gtk_widget_show (menuitem);
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem),image);
  gtk_widget_show (image);
  image = create_pixmap (window1, "invisible.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "im_invisible");

  image = create_pixmap (window1, "offline.png");
  s=utf("_Niedostpny");
  menuitem=gtk_image_menu_item_new_with_mnemonic(s);
  g_free(s);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_status),menuitem);
  g_signal_connect_swapped (G_OBJECT (menuitem), "activate",
                             G_CALLBACK (menu_status_response),
                             "7");
  gtk_widget_show (menuitem);
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem),image);
  gtk_widget_show (image);
  image = create_pixmap (window1, "offline.png");
  gtk_widget_show (image);
  GLADE_HOOKUP_OBJECT (window1, image, "im_offline");

  menuitem = gtk_menu_item_new ();
  gtk_widget_show (menuitem);
  gtk_container_add (GTK_CONTAINER (menu_status), menuitem);
  gtk_widget_set_sensitive (menuitem, FALSE);
  s=utf("Wasny opis...");
  menuitem = gtk_image_menu_item_new_with_label (s);
  g_free(s);
  gtk_widget_show (menuitem);
  gtk_container_add (GTK_CONTAINER (menu_status), menuitem);
  g_signal_connect_swapped (G_OBJECT (menuitem), "activate",
                             G_CALLBACK (menu_status_response),
                             "8");
  image = create_pixmap (window1, "info.png");
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem),image);
  gtk_widget_show (image);

  status_button_set(TLEN_STATUS_AVAILABLE);
  button=lookup_widget(window1, "button_status");
  g_signal_connect_swapped (G_OBJECT (button), "event",
                            G_CALLBACK (menu_show),
                            menu_status);
  button=lookup_widget(window1, "button_tlenpl");
  g_signal_connect_swapped (G_OBJECT (button), "event",
                            G_CALLBACK (menu_show),
                            tlen1_menu);
//  button=lookup_widget(window1, "button1");
//  g_signal_connect_swapped (G_OBJECT (button), "clicked",
//                            G_CALLBACK (my_create_dialog13),
//                            NULL);
  g_signal_connect (G_OBJECT (wyszukiwanie1), "activate",
                      G_CALLBACK (on_wyszukiwanie1_activate),
                      NULL);
  g_signal_connect (G_OBJECT (wyslij_wiadomosc), "activate",
                      G_CALLBACK (on_wyslij_wiadomosc_activate),
                      NULL);
  g_signal_connect (G_OBJECT (wyslij_sms), "activate",
                    G_CALLBACK (on_wyslij_sms_activate),
                    NULL);
  g_signal_connect (G_OBJECT (wizytowka), "activate",
                      G_CALLBACK (on_wizytowka_activate),
                      NULL);
  g_signal_connect (G_OBJECT (dodaj_kontakt1), "activate",
                      G_CALLBACK (on_dodaj_kontakt1_activate),
                      NULL);
  g_signal_connect (G_OBJECT (archiwum1), "activate",
                      G_CALLBACK (on_archiwum1_activate),
                      NULL);
  g_signal_connect (G_OBJECT (ustawienia1), "activate",
                      G_CALLBACK (on_ustawienia1_activate),
                      NULL);
  g_signal_connect (G_OBJECT (ustawienia_gg), "activate",
                      G_CALLBACK (on_ustawienia_gg_activate),
                      NULL);
  g_signal_connect (G_OBJECT (o_programie1), "activate",
                      G_CALLBACK (on_o_programie1_activate),
                      NULL);
  g_signal_connect (G_OBJECT (wyloguj_profil1), "activate",
                      G_CALLBACK (on_wyloguj_profil1_activate),
                      NULL);
  g_signal_connect (G_OBJECT (wyj__cie1), "activate",
                      G_CALLBACK (on_wyj__cie1_activate),
                      NULL);

  gtk_window_add_accel_group (GTK_WINDOW (window1), accel_group);
  widget=lookup_widget(window1,"label_info");
  gtk_widget_hide(widget);
//  gtk_widget_show (window1);
}

void window_unauth_delete(GtkWidget *window)
{
  gtk_widget_destroy(window);
  wyloguj();
  my_create_window_login();
}

void my_create_window_unauth()
{
  GtkWidget *window;

  window = create_window_unauth();
  gtk_widget_show(window);
}

void my_create_window_authorize(const gchar *jid)
{
  GtkWidget *window, *button;

  cant_stop=TRUE;
  window=create_window_authorize();
  g_signal_connect (G_OBJECT (window), "delete_event",
                      G_CALLBACK (on_window_authorize_delete_event),
                      (gpointer) jid);
  button=lookup_widget(window,"label_jid");
  gtk_label_set_text(GTK_LABEL(button),jid);
  button=lookup_widget(window,"button_authorize_cancel");
  g_signal_connect (G_OBJECT (button), "clicked",
                      G_CALLBACK (on_button_authorize_cancel_clicked),
                      (gpointer) window);
  button=lookup_widget(window,"button_authorize_ok");
  g_signal_connect (G_OBJECT (button), "clicked",
                      G_CALLBACK (on_button_authorize_ok_clicked),
                      (gpointer) window);
  gtk_widget_show(window);
}



void newmail(const gchar *from, const gchar *subject)
{
  GtkWidget *window, *widget;
  gchar *s;

  window=create_window_newmail();
  widget=lookup_widget(window,"label_from");
  s=utf(from);
  gtk_label_set_text(GTK_LABEL(widget),s);
  g_free(s);
  widget=lookup_widget(window,"label_subject");
  if(subject)
  {
    s=utf(subject);
    gtk_label_set_text(GTK_LABEL(widget),s);
    g_free(s);
  }
  else
    gtk_label_set_text(GTK_LABEL(widget),"<brak tematu>");
  gtk_widget_show(window);
}

void my_create_window_webmsg(gchar *from, gchar *email, gchar *site, gchar
                             *message)
{
  GtkWidget *window, *widget;
  gchar *s;

  window = create_window_webmsg();

  widget=lookup_widget(window,"label_from");
  s=utf(from);
  gtk_label_set_text(GTK_LABEL(widget),s);
  g_free(s);
  widget=lookup_widget(window,"label_email");
  s=utf(email);
  gtk_label_set_text(GTK_LABEL(widget),s);
  g_free(s);
  widget=lookup_widget(window,"label_site");
  s=utf(site);
  gtk_label_set_text(GTK_LABEL(widget),s);
  g_free(s);
  widget=lookup_widget(window,"textview");
  s=utf(message);
  textview_append(widget,s,0,NULL, NULL);
  g_free(s);
  gtk_widget_show(window);
}


void window_card_gotdata(struct tlen_event *event)
{
  GtkWidget *widget;
  gchar *s;

  widget = lookup_widget(window_card, "entry_name");
  s = event->pubdir->firstname;
  if(s)
  {
    s = utf(s);
    gtk_entry_set_text(GTK_ENTRY(widget), s);
    g_free(s);
  }
  widget = lookup_widget(window_card, "entry_surname");
  s = event->pubdir->lastname;
  if(s)
  {
    s = utf(s);
    gtk_entry_set_text(GTK_ENTRY(widget), s);
    g_free(s);
  }
  widget = lookup_widget(window_card, "entry_nick");
  s = event->pubdir->nick;
  if(s)
  {
    s = utf(s);
    gtk_entry_set_text(GTK_ENTRY(widget), s);
    g_free(s);
  }
  widget = lookup_widget(window_card, "entry_gender");
  switch(event->pubdir->gender)
  {
    case TLEN_PUBDIR_GENDER_NONE:
      s="";
      break;
    case TLEN_PUBDIR_GENDER_FEMALE:
      s="kobieta";
      break;
    case TLEN_PUBDIR_GENDER_MALE:
      s="mczyzna";
      break;
  }
  if(s)
  {
    s=utf(s);
    gtk_entry_set_text(GTK_ENTRY(widget),s);
    g_free(s);
  }
  widget=lookup_widget(window_card, "entry_city");
  s=event->pubdir->city;
  if(s)
  {
    s=utf(s);
    gtk_entry_set_text(GTK_ENTRY(widget),s);
    g_free(s);
  }
  widget=lookup_widget(window_card, "entry_email");
  s=event->pubdir->email;
  if(s)
  {
    s=utf(s);
    gtk_entry_set_text(GTK_ENTRY(widget),s);
    g_free(s);
  }
  widget=lookup_widget(window_card, "spinbutton");
  if(event->pubdir->birthyear >= 1900)
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget),
                              event->pubdir->birthyear);
  widget=lookup_widget(window_card, "entry_status");
  if(event->pubdir->visible == TLEN_PUBDIR_VISIBLE_NO)
    gtk_entry_set_text(GTK_ENTRY(widget),"nie");
  else
    gtk_entry_set_text(GTK_ENTRY(widget),"tak");
  widget=lookup_widget(window_card, "entry_look");
  switch(event->pubdir->look_for)
  {
    case TLEN_PUBDIR_LOOK_NONE:
      s="";
      break;
    case TLEN_PUBDIR_LOOK_TALK:
      s="rozmowa";
      break;
    case TLEN_PUBDIR_LOOK_FRIEND:
      s="przyjan";
      break;
    case TLEN_PUBDIR_LOOK_FLIRT:
      s="romans";
      break;
    case TLEN_PUBDIR_LOOK_LOVE:
      s="mio";
      break;
    default:
      s="";
  }
  s=utf(s);
  gtk_entry_set_text(GTK_ENTRY(widget),s);
  g_free(s);
  widget=lookup_widget(window_card, "entry_school");
  s=event->pubdir->school;
  if(s)
  {
    s=utf(s);
    gtk_entry_set_text(GTK_ENTRY(widget),s);
    g_free(s);
  }
  widget=lookup_widget(window_card, "entry_job");
  switch(event->pubdir->job)
  {
    case TLEN_PUBDIR_JOB_NONE:
      s="";
      break;
    case TLEN_PUBDIR_JOB_UCZEN:
      s="ucze";
      break;
    case TLEN_PUBDIR_JOB_STUDENT:
      s="student";
      break;
    case TLEN_PUBDIR_JOB_ROLNIK:
      s="rolnik";
      break;
    case TLEN_PUBDIR_JOB_MENEDZER:
      s="meneder";
      break;
    case TLEN_PUBDIR_JOB_SPEC_WOL:
      s="specjalista";
      break;
    case TLEN_PUBDIR_JOB_UUA:
      s="urzdnik";
      break;
    case TLEN_PUBDIR_JOB_BEZROBOTNY:
      s="bezrobotny";
      break;
    case TLEN_PUBDIR_JOB_EMERYT:
      s="emeryt,rencista";
      break;
    case TLEN_PUBDIR_JOB_GOSPODYNI:
      s="gospodyni";
      break;
    case TLEN_PUBDIR_JOB_NAUCZYCIEL:
      s="nauczyciel";
      break;
    case TLEN_PUBDIR_JOB_LEKARZ:
      s="lekarz";
      break;
    case TLEN_PUBDIR_JOB_INNY:
      s="inny";
      break;
    default:
      s="";
  }
  if(s)
  {
    s=utf(s);
    gtk_entry_set_text(GTK_ENTRY(widget),s);
    g_free(s);
  }
  widget=lookup_widget(window_card, "entry_voice");
  if(event->pubdir->voice == TLEN_PUBDIR_VOICE_DISABLED)
    gtk_entry_set_text(GTK_ENTRY(widget),"nie");
  else
    gtk_entry_set_text(GTK_ENTRY(widget),"tak");
  widget=lookup_widget(window_card, "entry_plans");
  switch(event->pubdir->plans)
  {
    case TLEN_PUBDIR_WANT_NONE:
      s="";
      break;
    case TLEN_PUBDIR_WANT_CINEMA:
      s="kino";
      break;
    default:
      s="";
  }
  if(s)
  {
    s=utf(s);
    gtk_entry_set_text(GTK_ENTRY(widget),s);
    g_free(s);
  }

}

void window_card_hide_thobber()
{
  GtkWidget *image;

  image = lookup_widget(window_card, "thobber");
  gtk_widget_hide(image);
}

void window_card_show_thobber()
{
  GtkWidget *image;

  image = lookup_widget(window_card, "thobber");
  gtk_widget_show(image);
}

void window_card_export()
{
  struct tlen_pubdir *pubdir;
  GtkWidget *widget;
  gchar *s;


  pubdir = tlen_new_pubdir ();
  widget = lookup_widget(window_card, "entry_name");
  s = (gchar*) fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
  if(strlen(s)>0)
    pubdir->firstname = strdup(s);
  g_free(s);
  widget = lookup_widget(window_card,"entry_surname");
  s = (gchar*) fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
  if(strlen(s)>0)
    pubdir->lastname = strdup(s);
  g_free(s);
  widget = lookup_widget(window_card, "entry_nick");
  s = (gchar*) fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
  if(strlen(s)>0)
    pubdir->nick = strdup(s);
  g_free(s);
  widget = lookup_widget(window_card, "entry_gender");
  s = (gchar*) fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
  if(!strcmp(s,"kobieta"))
    pubdir->gender = TLEN_PUBDIR_GENDER_FEMALE;
  else if(!strcmp(s,"mczyzna"))
    pubdir->gender = TLEN_PUBDIR_GENDER_MALE;
  else
    pubdir->gender = TLEN_PUBDIR_GENDER_NONE;
  g_free(s);
  widget = lookup_widget(window_card, "entry_city");
  s = (gchar*) fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
  if(strlen(s)>0)
    pubdir->city = strdup(s);
  widget = lookup_widget(window_card, "entry_email");
  g_free(s);
  s = (gchar*) fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
  if(strlen(s)>0)
    pubdir->email = strdup(s);
  widget = lookup_widget(window_card, "spinbutton");
  pubdir->birthyear = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  widget = lookup_widget(window_card,"entry_status");
  g_free(s);
  s = (gchar*) fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
  if(!strcmp(s,"nie"))
    pubdir->visible = TLEN_PUBDIR_VISIBLE_NO;
  else
    pubdir->visible = TLEN_PUBDIR_VISIBLE_YES;
  widget = lookup_widget(window_card, "entry_look");
  g_free(s);
  s = (gchar*) fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
  if(!strcmp(s,""))
    pubdir->look_for = TLEN_PUBDIR_LOOK_NONE;
  else if(!strcmp(s,"rozmowa"))
    pubdir->look_for = TLEN_PUBDIR_LOOK_TALK;
  else if(!strcmp(s,"przyja"))
    pubdir->look_for = TLEN_PUBDIR_LOOK_FRIEND;
  else if(!strcmp(s,"romans"))
    pubdir->look_for = TLEN_PUBDIR_LOOK_FLIRT;
  else if(!strcmp(s,"mio"))
    pubdir->look_for = TLEN_PUBDIR_LOOK_LOVE;
  widget = lookup_widget(window_card, "entry_school");
  g_free(s);
  s = (gchar*) fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
  if(strlen(s)>0)
    pubdir->school = strdup(s);
  widget = lookup_widget(window_card, "entry_job");
  g_free(s);
  s = (gchar*) fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
  if(!strcmp(s,""))
    pubdir->job = TLEN_PUBDIR_JOB_NONE;
  else if(!strcmp(s,"ucze"))
    pubdir->job = TLEN_PUBDIR_JOB_UCZEN;
  else if(!strcmp(s,"student"))
    pubdir->job = TLEN_PUBDIR_JOB_STUDENT;
  else if(!strcmp(s,"rolnik"))
    pubdir->job = TLEN_PUBDIR_JOB_ROLNIK;
  else if(!strcmp(s,"meneder"))
    pubdir->job = TLEN_PUBDIR_JOB_MENEDZER;
  else if(!strcmp(s,"specjalista"))
    pubdir->job = TLEN_PUBDIR_JOB_SPEC_WOL;
  else if(!strcmp(s,"urzdnik"))
    pubdir->job = TLEN_PUBDIR_JOB_UUA;
  else if(!strcmp(s,"emeryt,rencista"))
    pubdir->job = TLEN_PUBDIR_JOB_EMERYT;
  else if(!strcmp(s,"gospodyni"))
    pubdir->job = TLEN_PUBDIR_JOB_GOSPODYNI;
  else if(!strcmp(s,"nauczyciel"))
    pubdir->job = TLEN_PUBDIR_JOB_NAUCZYCIEL;
  else if(!strcmp(s,"lekarz"))
    pubdir->job = TLEN_PUBDIR_JOB_LEKARZ;
  else if(!strcmp(s,"inny"))
    pubdir->job = TLEN_PUBDIR_JOB_INNY;
  else if(!strcmp(s,"bezrobotny"))
    pubdir->job = TLEN_PUBDIR_JOB_BEZROBOTNY;
  widget = lookup_widget(window_card, "entry_voice");
  g_free(s);
  s = (gchar*) fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
  if(!strcmp(s,"nie"))
    pubdir->voice = TLEN_PUBDIR_VOICE_DISABLED;
  else
    pubdir->voice = TLEN_PUBDIR_VOICE_ENABLED;
  widget = lookup_widget(window_card, "entry_plans");
  g_free(s);
  s = (gchar*) fromutf(gtk_entry_get_text(GTK_ENTRY(widget)));
  if(!strcmp(s,""))
    pubdir->plans = TLEN_PUBDIR_WANT_NONE;
  else if(!strcmp(s,"kino"))
    pubdir->plans = TLEN_PUBDIR_WANT_CINEMA;
  g_free(s);

  tlen_change_pubdir(session, pubdir);
  tlen_free_pubdir(pubdir);
  window_card_show_thobber();
}

void window_card_import()
{
  tlen_get_pubdir(session);
  window_card_show_thobber();
}

void my_create_window_card()
{
  window_card = create_window_card();
  gtk_widget_show(window_card);
}

void colorselection_getcolor(GtkWidget *entry)
{
  GtkWidget *button;

  colorselection = create_colorselection();
  button = lookup_widget(colorselection, "button_colorselection_ok");
  g_signal_connect_swapped (G_OBJECT (button), "clicked",
                            G_CALLBACK (on_button_colorselection_ok_clicked),
                            entry);

  gtk_widget_show(colorselection);
}

void fileselection_getfile(GtkWidget *entry)
{
  GtkWidget *button;
  static gulong handler_id = 0;

  if(!fileselection)
    fileselection = create_fileselection();
  button = lookup_widget(fileselection, "button_fileselection_ok");
  if(handler_id)
    g_signal_handler_disconnect(G_OBJECT(button), handler_id);
  handler_id = g_signal_connect_swapped(G_OBJECT(button), "clicked",
                           G_CALLBACK(on_button_fileselection_ok_clicked),
                           entry);
  gtk_widget_show(fileselection);
}

void window_prefs_apply()
{
  GtkWidget *entry, *button;
  gchar *s;
  struct talk *talk;
  GList *l=talks_list;
  GtkTextBuffer *buffer;
  GtkTextTag *tag;
  GtkTextTagTable *table;


  //ogolne
  preferences = 0;
  button = lookup_widget(window_prefs,"checkbutton_newmail");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
    preferences |= PREF_NEWMAIL;
  button = lookup_widget(window_prefs,"checkbutton_savestat");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
    preferences |= PREF_SAVESTAT;
  button = lookup_widget(window_prefs,"checkbutton_infomenu");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
    preferences |= PREF_INFO_MENU;
  button = lookup_widget(window_prefs,"checkbutton_enteron");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
    preferences |= PREF_ENTERON;
  button = lookup_widget(window_prefs,"checkbutton_debugon");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
  {
    preferences |= PREF_DEBUGON;
    tlen_setdebug(1);
  }
  else
    tlen_setdebug(0);
  button = lookup_widget(window_prefs,"checkbutton_list_expanded");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
    preferences |= PREF_LIST_EXPANDED;
  button = lookup_widget(window_prefs,"checkbutton_emots");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
    preferences |= PREF_EMOTS;
  button = lookup_widget(window_prefs,"checkbutton_lastlogin");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
    preferences |= PREF_LASTLOGIN;
  button = lookup_widget(window_prefs,"checkbutton_status");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
  {
    preferences |= PREF_AUTOAWAY;
    button = lookup_widget(window_prefs,"spinbutton_away_min");
    away_min = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(button));
    button = lookup_widget(window_prefs,"spinbutton_away_sec");
    away_sec = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(button));
    button = lookup_widget(window_prefs,"spinbutton_ext_away_min");
    ext_away_min = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(button));
    button = lookup_widget(window_prefs,"spinbutton_ext_away_sec");
    ext_away_sec = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(button));
  }
  button = lookup_widget(window_prefs,"checkbutton_xmms");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
  {
    preferences |= PREF_XMMS_INFO;
    xmms_info_enable(TRUE, 0);
  }
  else
    xmms_info_enable(FALSE, 0);
  button = lookup_widget(window_prefs,"spinbutton_desc");
  desc_num = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(button));
  button = lookup_widget(window_prefs, "checkbutton_hide_offline");
  entry = lookup_widget(window1, "togglebutton_hide");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
  {
    preferences |= PREF_HIDE_OFFLINE;
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(entry),TRUE);
  }
  else
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(entry),FALSE);
  }

  button = lookup_widget(window_prefs,"checkbutton_groups");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
    preferences |= PREF_GROUPS_NONE;
  else
    preferences |= PREF_GROUPS_LIST;
  
  list_reload_all();

  //dzwieki
  button = lookup_widget(window_prefs,"checkbutton_beeponm");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
    preferences |= PREF_BEEPONM;
  button = lookup_widget(window_prefs,"checkbutton_beepont");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
    preferences |= PREF_BEEPONT;
  button = lookup_widget(window_prefs,"checkbutton_beepons");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
    preferences |= PREF_BEEPONS;
  button = lookup_widget(window_prefs,"checkbutton_beepona");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
    preferences |= PREF_BEEPONA;
  button = lookup_widget(window_prefs,"checkbutton_beeponn");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
    preferences |= PREF_BEEPONN;
  button = lookup_widget(window_prefs,"checkbutton_beeponw");
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
    preferences |= PREF_BEEPONW;
  entry = lookup_widget(window_prefs,"entry_beeponm");
  s = (gchar*)gtk_entry_get_text(GTK_ENTRY(entry));
  g_free(sounds[SOUNDM]);
  sounds[SOUNDM] = NULL;
  if(strlen(s))
    sounds[SOUNDM] = filenamefromutf(s);
  entry = lookup_widget(window_prefs,"entry_beepont");
  s = (gchar*)gtk_entry_get_text(GTK_ENTRY(entry));
  g_free(sounds[SOUNDT]);
  sounds[SOUNDT] = NULL;
  if(strlen(s))
    sounds[SOUNDT] = filenamefromutf(s);
  entry = lookup_widget(window_prefs,"entry_beepons");
  s = (gchar*)gtk_entry_get_text(GTK_ENTRY(entry));
  g_free(sounds[SOUNDS]);
  sounds[SOUNDS] = NULL;
  if(strlen(s))
    sounds[SOUNDS] = filenamefromutf(s);
  entry = lookup_widget(window_prefs,"entry_beepona");
  s = (gchar*)gtk_entry_get_text(GTK_ENTRY(entry));
  g_free(sounds[SOUNDA]);
  sounds[SOUNDA] = NULL;
  if(strlen(s))
    sounds[SOUNDA] = filenamefromutf(s);
  entry = lookup_widget(window_prefs,"entry_beeponn");
  s = (gchar*)gtk_entry_get_text(GTK_ENTRY(entry));
  g_free(sounds[SOUNDN]);
  sounds[SOUNDN] = NULL;
  if(strlen(s))
    sounds[SOUNDN] = filenamefromutf(s);
  entry = lookup_widget(window_prefs,"entry_beeponw");
  s = (gchar*)gtk_entry_get_text(GTK_ENTRY(entry));
  g_free(sounds[SOUNDW]);
  sounds[SOUNDW] = NULL;
  if(strlen(s))
    sounds[SOUNDW] = filenamefromutf(s);
  entry = lookup_widget(window_prefs,"entry_playpath");
  s = (gchar*)gtk_entry_get_text(GTK_ENTRY(entry));
  g_free(playpath);
  playpath = NULL;
  if(strlen(s))
    playpath = filenamefromutf(s);

  //kolory
  entry = lookup_widget(window_prefs,"entry_date");
  s = (gchar *)gtk_entry_get_text(GTK_ENTRY(entry));
  g_free(datefg);
  datefg = NULL;
  if(strlen(s)>0)
    datefg = g_strdup(s);
  entry = lookup_widget(window_prefs,"entry_nick");
  s = (gchar *)gtk_entry_get_text(GTK_ENTRY(entry));
  g_free(nickfg);
  nickfg = NULL;
  if(strlen(s)>0)
    nickfg = g_strdup(s);
  entry = lookup_widget(window_prefs,"entry_message");
  s = (gchar *)gtk_entry_get_text(GTK_ENTRY(entry));
  g_free(textfg);
  textfg = NULL;
  if(strlen(s)>0)
    textfg = g_strdup(s);

  entry = lookup_widget(window_prefs,"entry_message_bg");
  s = (gchar *)gtk_entry_get_text(GTK_ENTRY(entry));
  g_free(textbg);
  textbg = NULL;
  if(strlen(s)>0)
    textbg = g_strdup(s);

  while(l)
  {
    talk = (struct talk*)l->data;
    entry = lookup_widget(talk->window,"textview_top");
    buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(entry));
    table = gtk_text_buffer_get_tag_table(buffer);
    if(datefg)
    {
      tag = gtk_text_tag_table_lookup(table, "datefg");
      g_object_set(tag,"foreground", datefg, NULL);
    }
    if(nickfg)
    {
      tag = gtk_text_tag_table_lookup(table, "nickfg");
      g_object_set(tag,"foreground", nickfg, NULL);
    }
    if(textfg)
    {
      tag=gtk_text_tag_table_lookup(table, "textfg");
      g_object_set(tag,
                   "foreground", textfg,
                   NULL);
    }
    if(textbg)
    {
      tag=gtk_text_tag_table_lookup(table, "textbg");
      g_object_set(tag,
                   "background", textbg,
                   "foreground", textfg,
                   NULL);
    }
    l = l->next;
  }
  save_preferences();

}

void my_create_window_prefs()
{
  GtkWidget *entry, *button;
  gchar *s;

  window_prefs = create_window_prefs();
  button = lookup_widget(window_prefs,"checkbutton_newmail");
  if(preferences & PREF_NEWMAIL)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
  button = lookup_widget(window_prefs,"checkbutton_savestat");
  if(preferences & PREF_SAVESTAT)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
  button = lookup_widget(window_prefs,"checkbutton_infomenu");
  if(preferences & PREF_INFO_MENU)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
  button = lookup_widget(window_prefs,"checkbutton_enteron");
  if(preferences & PREF_ENTERON)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
  button = lookup_widget(window_prefs,"checkbutton_debugon");
  if(preferences & PREF_DEBUGON)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
  button = lookup_widget(window_prefs,"checkbutton_list_expanded");
  if(preferences & PREF_LIST_EXPANDED)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
  button = lookup_widget(window_prefs,"checkbutton_hide_offline");
  if(preferences & PREF_HIDE_OFFLINE)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
  button = lookup_widget(window_prefs,"checkbutton_emots");
  if(preferences & PREF_EMOTS)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
  button = lookup_widget(window_prefs,"checkbutton_lastlogin");
  if(preferences & PREF_LASTLOGIN)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
  button = lookup_widget(window_prefs,"checkbutton_status");
  if(preferences & PREF_AUTOAWAY)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
    button = lookup_widget(window_prefs,"spinbutton_away_min");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(button), away_min);
    button = lookup_widget(window_prefs,"spinbutton_away_sec");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(button), away_sec);
    button = lookup_widget(window_prefs,"spinbutton_ext_away_min");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(button), ext_away_min);
    button = lookup_widget(window_prefs,"spinbutton_ext_away_sec");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(button), ext_away_sec);
  }
  button = lookup_widget(window_prefs,"checkbutton_xmms");
  if(preferences & PREF_XMMS_INFO)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
  }
  button = lookup_widget(window_prefs,"spinbutton_desc");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(button), desc_num);

  button = lookup_widget(window_prefs,"checkbutton_beeponm");
  if(preferences & PREF_BEEPONM)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
  button = lookup_widget(window_prefs,"checkbutton_beepont");
  if(preferences & PREF_BEEPONT)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
  button = lookup_widget(window_prefs,"checkbutton_beepons");
  if(preferences & PREF_BEEPONS)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
  button = lookup_widget(window_prefs,"checkbutton_beepona");
  if(preferences & PREF_BEEPONA)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
  button = lookup_widget(window_prefs,"checkbutton_beeponn");
  if(preferences & PREF_BEEPONN)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
  button = lookup_widget(window_prefs,"checkbutton_beeponw");
  if(preferences & PREF_BEEPONW)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);

  button = lookup_widget(window_prefs,"checkbutton_groups");
  if(preferences & PREF_GROUPS_NONE)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
  else
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),FALSE);

  entry = lookup_widget(window_prefs,"entry_date");
  if(datefg)
    gtk_entry_set_text(GTK_ENTRY(entry),datefg);
  entry = lookup_widget(window_prefs,"entry_nick");
  if(nickfg)
    gtk_entry_set_text(GTK_ENTRY(entry),nickfg);
  entry = lookup_widget(window_prefs,"entry_message");
  if(textfg)
    gtk_entry_set_text(GTK_ENTRY(entry),textfg);

  entry = lookup_widget(window_prefs,"entry_message_bg");
  if(textbg)
    gtk_entry_set_text(GTK_ENTRY(entry),textbg);

  entry = lookup_widget(window_prefs,"entry_beeponm");
  if(sounds[SOUNDM])
  {
    s = filenameutf(sounds[SOUNDM]);
    if(s)
    {
      gtk_entry_set_text(GTK_ENTRY(entry), s);
      g_free(s);
    }
  }
  entry = lookup_widget(window_prefs,"entry_beepons");
  if(sounds[SOUNDS])
  {
    s = filenameutf(sounds[SOUNDS]);
    if(s)
    {
      gtk_entry_set_text(GTK_ENTRY(entry), s);
      g_free(s);
    }
  }
  entry = lookup_widget(window_prefs,"entry_beepona");
  if(sounds[SOUNDA])
  {
    s = filenameutf(sounds[SOUNDA]);
    if(s)
    {
      gtk_entry_set_text(GTK_ENTRY(entry),s);
      g_free(s);
    }
  }
  entry = lookup_widget(window_prefs,"entry_beeponn");
  if(sounds[SOUNDN])
  {
    s = filenameutf(sounds[SOUNDN]);
    if(s)
    {
      gtk_entry_set_text(GTK_ENTRY(entry),s);
      g_free(s);
    }
  }
  entry = lookup_widget(window_prefs,"entry_beeponw");
  if(sounds[SOUNDW])
  {
    s = filenameutf(sounds[SOUNDW]);
    if(s)
    {
      gtk_entry_set_text(GTK_ENTRY(entry),s);
      g_free(s);
    }
  }
  entry = lookup_widget(window_prefs,"entry_beepont");
  if(sounds[SOUNDT])
  {
    s = filenameutf(sounds[SOUNDT]);
    if(s)
    {
      gtk_entry_set_text(GTK_ENTRY(entry),s);
      g_free(s);
    }
  }
  entry = lookup_widget(window_prefs,"entry_playpath");
  if(playpath)
  {
    s = filenameutf(playpath);
    gtk_entry_set_text(GTK_ENTRY(entry),s);
    g_free(s);
  }

  gtk_widget_show(window_prefs);
}

void window_archive_save()
{
}

void window_archive_delete()
{
  GtkWidget *widget;
  gint page;
  GtkTreeSelection *selection;
  GtkTreeModel *model;
  GtkTreeIter iter;
  gchar *jid, *date;

  widget = lookup_widget(window_archive, "notebook");
  page = gtk_notebook_get_current_page(GTK_NOTEBOOK(widget));
  switch(page)
  {
    case 0:
      widget = lookup_widget(window_archive, "treeview_sent");
      selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (widget));
      if (gtk_tree_selection_get_selected (selection, &model, &iter))
      {
        gtk_tree_model_get (model, &iter,
                            1, &jid,
                            2, &date,
                            -1);
        tleenx_print(DEBUG, "deleting %s %s \n", jid, date);
        mesgsent_delete(jid, date);
        mesgsent_sort_by_date();
        widget = lookup_widget(window_archive, "radiobutton_archive_date");
          treeview_sent_sort_by_name();
          treeview_sent_sort_by_date();
        if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)))
          treeview_sent_sort_by_name();
        else
        {
          treeview_sent_sort_by_date();
        }
      }
      break;
    case 1:
      break;
    case 2:
      break;
    default:
      return;
  }
}

void window_archive_cancel()
{
  gtk_widget_destroy(window_archive);
  window_archive = NULL;
  clean_archive();
}

void my_create_window_archive()
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  GtkWidget *treeview2;
  GtkTreeSelection *selection;
  GtkWidget *widget;
  GtkTextBuffer *buffer;
  gchar *s;

  window_archive = create_window_archive();
  widget = lookup_widget(window_archive, "textview_chat");
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(widget));
  gtk_text_buffer_create_tag (buffer, "date","foreground",
                              "blue",
                              NULL);
  gtk_text_buffer_create_tag (buffer, "text","foreground",
                              "#808080",
                              NULL);
  treeview2 = lookup_widget(window_archive,"treeview_archives");
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes ("Nazwa archiwum",
                                                     renderer,
                                                     "text",
                                                     0,
                                                     NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW(treeview2), column);
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes ("Data ostatniego wpisu",
                                                     renderer,
                                                     "text",
                                                     1,
                                                     NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW(treeview2), column);
  treeview2 = lookup_widget(window_archive,"treeview_chat");
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (NULL,
                                                     renderer,
                                                     "text",
                                                     0,
                                                     NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW(treeview2), column);
  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview2));
  g_signal_connect (selection, "changed",
                    G_CALLBACK (treeview_chat_selection_cb), NULL);

  treeview2 = lookup_widget(window_archive,"treeview_sent");
  renderer = gtk_cell_renderer_text_new ();
  s = utf("Data wysania");
  column = gtk_tree_view_column_new_with_attributes (s,
                                                     renderer,
                                                     "text",
                                                     2,
                                                     NULL);
  g_free(s);
  gtk_tree_view_append_column (GTK_TREE_VIEW(treeview2), column);
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes ("ID",
                                                     renderer,
                                                     "text",
                                                     1,
                                                     NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW(treeview2), column);

  treeview2 = lookup_widget(window_archive,"treeview_received");
  renderer = gtk_cell_renderer_text_new ();
  s = utf("Data wysania");
  column = gtk_tree_view_column_new_with_attributes (s,
                                                     renderer,
                                                     "text",
                                                     2,
                                                     NULL);
  g_free(s);
  gtk_tree_view_append_column (GTK_TREE_VIEW(treeview2), column);
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes ("ID",
                                                     renderer,
                                                     "text",
                                                     1,
                                                     NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW(treeview2), column);

  arch_list_load();
  archive_read_mesgsent();
  treeview_sent_sort_by_name();
  treeview_received_sort_by_name();
  treeview_archives_refresh();

  gtk_widget_show(window_archive);
}

void window_message_update_count()
{
  gint num = messages_count();
  GtkWidget *widget;
  gchar *s;

  widget = lookup_widget(window_message, "label_all");
  s = g_strdup_printf("%d", num);
  gtk_label_set_text(GTK_LABEL(widget), s);
  g_free(s);
  widget = lookup_widget(window_message, "button_message_next");
  gtk_widget_set_sensitive(widget, TRUE);
}

//num - numer wiadomosci do wyswietlenia w oknie
void window_message_update(gint num)
{
  GtkWidget *label, *textview, *button;
  struct message *m;
  gchar *s, *name;

  m = message_next(num-1);
  label = lookup_widget(window_message, "label_id");
  gtk_label_set_text(GTK_LABEL(label), m->id);
  label = lookup_widget(window_message, "label_from");
  if(get_user(m->id))
  {
    name = get_user_name(m->id);
    if(strncmp(name, m->id, strlen(name)))
    {
      s = g_strdup_printf("(%s)", name);
      g_free(name);
      name = utf(s);
      g_free(s);
      gtk_label_set_text(GTK_LABEL(label), name);
    }
    else
      gtk_label_set_text(GTK_LABEL(label), "");
    g_free(name);
  }
  else
    gtk_label_set_text(GTK_LABEL(label), "");
  label = lookup_widget(window_message, "label_counter");
  s = g_strdup_printf("%d", num);
  gtk_label_set_text(GTK_LABEL(label), s);
  g_free(s);
  window_message_update_count();
  m->read = TRUE;
  label = lookup_widget(window_message, "label_ifhasstamp");
  gtk_label_set_text(GTK_LABEL(label), "");
  label = lookup_widget(window_message, "label_stamp");
  gtk_label_set_text(GTK_LABEL(label), "");
  if(m->stamp)
  {
    s = utf("Data wysania: ");
    label = lookup_widget(window_message, "label_ifhasstamp");
    gtk_label_set_text(GTK_LABEL(label), s);
    g_free(s);
    label = lookup_widget(window_message, "label_stamp");
    gtk_label_set_text(GTK_LABEL(label), m->stamp);
  }
  button = lookup_widget(window_message, "button_message_prev");
  if(message_prev(num))
    gtk_widget_set_sensitive(button, TRUE);
  else
    gtk_widget_set_sensitive(button, FALSE);
  button = lookup_widget(window_message, "button_message_next");
  if(message_next(num))
    gtk_widget_set_sensitive(button, TRUE);
  else
    gtk_widget_set_sensitive(button, FALSE);
  textview = lookup_widget(window_message, "textview");
  s = utf(m->message);
  textview_clear(textview);
  textview_append(textview, s, 0, NULL, NULL);
  g_free(s);
}

void my_create_window_message()
{
  window_message = create_window_message();
  window_message_update(1);
  gtk_widget_show(window_message);
}

void message_send(gchar *id, gchar *message)
{
  GtkWidget *window, *entry, *textview;
  GtkTextBuffer *buffer;
  GtkTextIter start;
  gchar *s;

  window = create_window_message_send();
  if(id)
  {
    entry = lookup_widget(window,"entry_id");
    gtk_entry_set_text(GTK_ENTRY(entry), id);
  }
  textview = lookup_widget(window, "textview");
  if(message)
  {
    s = utf("\n\n\n---- Twoja wiadomo ----\n");
    textview_append(textview, s, 0, NULL, NULL);
    g_free(s);
    s = utf(message);
    textview_append(textview, s, 0, NULL, NULL);
    g_free(s);
    buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview));
    gtk_text_buffer_get_start_iter(buffer, &start);
    gtk_text_buffer_place_cursor(buffer, &start);
  }
  gtk_widget_show(window);

}

void  window_contact_add_type_changed(GtkWidget *window)
{
//  GtkWidget *widget;
//  const gchar *s;

//  widget = lookup_widget(window, "combo_entry_type");
//  s = gtk_entry_get_text(GTK_ENTRY(widget));
//  widget = lookup_widget(window, "label_star2");
//  if(!strcmp(s, "Tlen"))
//    gtk_label_set_text(GTK_LABEL(widget), "");
//  if(!strcmp(s, "Jabber"))
//    gtk_label_set_text(GTK_LABEL(widget), "*");

}

void contact_add(gchar *jid, gint type)
{
  GtkWidget *entry = NULL, *window = NULL, *combo = NULL;
  struct user *u = NULL;
  struct group *g = NULL;
  gchar *s = NULL;
  GList *combo_group_items = NULL, *groups = NULL;

  window = create_window_contact_add();
  
  if( (combo = lookup_widget(window, "addcontact_combo_group")) ) {
	  for(groups=groups_list; groups; groups=groups->next) {
		  g = (struct group *)groups->data;
		  combo_group_items = g_list_append(combo_group_items, (gpointer)g->name);
		  g = NULL;
	  }
	  gtk_combo_set_popdown_strings(GTK_COMBO(combo), combo_group_items);
	  g_list_free(combo_group_items);
  }
  
  entry = lookup_widget(window, "entry_id");
  if(jid)
  {
    s = NULL;
    if(type == USER_GG)
    {
      if((s = strchr(jid, '@')))
      {
        *s = '\0';
      }
    }
    gtk_entry_set_text(GTK_ENTRY(entry), jid);
    if(s)
      *s = '@';
    u = get_user(jid);
  }
  entry = lookup_widget(window, "combo_entry_type");
  switch(type)
  {
    case USER_TLEN:
      break;
    case USER_JABBER:
      gtk_entry_set_text(GTK_ENTRY(entry), "Jabber");
      break;
    case USER_WP:
      gtk_entry_set_text(GTK_ENTRY(entry), "WPKontakt");
      break;
    case USER_GG:
      gtk_entry_set_text(GTK_ENTRY(entry), "GG");
      break;
  }
  if(u)
  {
    gtk_window_set_title(GTK_WINDOW(window),"Edycja danych");
    if(u->name)
    {
      entry = lookup_widget(window, "entry_name");
      s = utf(u->name);
      gtk_entry_set_text(GTK_ENTRY(entry), s);
      g_free(s);
    }
    if(u->group)
    {
      entry = lookup_widget(window, "addcontact_entry_group");
      s = utf(u->group);
      gtk_entry_set_text(GTK_ENTRY(entry), s);
      g_free(s);
    }
  }
  gtk_widget_show(window);
}

static
void search_window_pixbuf(GtkTreeViewColumn *tree_column,
                          GtkCellRenderer   *cell,
                          GtkTreeModel      *model,
                          GtkTreeIter       *iter,
                          gpointer           data)
{
  guint status;

  gtk_tree_model_get (model, iter,
                      0, &status,
                      -1);
  g_object_set (GTK_CELL_RENDERER (cell),
                "pixbuf", gtk_image_get_pixbuf(GTK_IMAGE(icons[status])),
                NULL);
}

static
void search_window_text (GtkTreeViewColumn *tree_column,
                         GtkCellRenderer   *cell,
                         GtkTreeModel      *model,
                         GtkTreeIter       *iter,
                         gpointer           data)
{
  gchar *jid;

  gtk_tree_model_get (model, iter,
                      1, &jid,
                      -1);
  if(get_user(jid))
    g_object_set (GTK_CELL_RENDERER (cell),
                  "font", "bold",
                  NULL);
  else
    g_object_set (GTK_CELL_RENDERER (cell),
                  "font", "normal",
                  NULL);
  g_object_set (GTK_CELL_RENDERER (cell),
                "text", jid,
                NULL);
  g_free(jid);
}

void window_search_close()
{
  pubdir_list_clear();
  gtk_widget_destroy(window_search);
  window_search = NULL;
}
void window_search_check(gchar *id, int user_type)
{
  GtkWidget *widget;
  gchar *s = NULL;

  if((s = strchr(id, '@')))
    *s = '\0';
  widget = lookup_widget(window_search,"entry_name");
  gtk_entry_set_text(GTK_ENTRY(widget), "");

  widget = lookup_widget(window_search,"entry_surname");
  gtk_entry_set_text(GTK_ENTRY(widget), "");

  widget = lookup_widget(window_search,"entry_nick");
  gtk_entry_set_text(GTK_ENTRY(widget), "");

  widget = lookup_widget(window_search,"entry_gender");
  gtk_entry_set_text(GTK_ENTRY(widget), "");

  widget = lookup_widget(window_search,"entry_city");
  gtk_entry_set_text(GTK_ENTRY(widget), "");

  widget = lookup_widget(window_search,"entry_email");
  gtk_entry_set_text(GTK_ENTRY(widget), "");

  widget = lookup_widget(window_search,"spinbutton_agefrom");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 0);
  widget = lookup_widget(window_search,"spinbutton_ageto");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), 0);

  widget = lookup_widget(window_search,"entry_status");
  gtk_entry_set_text(GTK_ENTRY(widget), "");

  widget = lookup_widget(window_search,"entry_look");
  gtk_entry_set_text(GTK_ENTRY(widget), "");

  widget = lookup_widget(window_search,"entry_school");
  gtk_entry_set_text(GTK_ENTRY(widget), "");

  widget = lookup_widget(window_search,"entry_job");
  gtk_entry_set_text(GTK_ENTRY(widget), "");

  widget = lookup_widget(window_search,"entry_voice");
  gtk_entry_set_text(GTK_ENTRY(widget), "nie");

  widget = lookup_widget(window_search,"entry_plans");
  gtk_entry_set_text(GTK_ENTRY(widget), "");

  widget = lookup_widget(window_search,"entry_id");
  gtk_entry_set_text(GTK_ENTRY(widget), id);

  if (user_type == USER_TLEN)
    {
      struct tlen_pubdir *pubdir;

      widget = lookup_widget(window_search,"radiobutton_search_tlen_pl");
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);

      pubdir = tlen_new_pubdir();
      pubdir->id = g_strdup(id);

      tlen_search(session,pubdir);
      tlen_free_pubdir(pubdir);
    }
  else
    if (user_type == USER_GG)
      {
        jabby_search_set *search;

        widget = lookup_widget(window_search,"radiobutton_search_gg");
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);

        search = jabby_search_set_new();
        search->id = g_strdup(id);

        jabber_gg_search_start(search);
        jabby_search_set_free(search);
      }
  if(s)
    *s = '@';
  widget = lookup_widget(window_search,"thobber");
  gtk_widget_show(widget);
}

void my_create_window_search()
{
  GtkTreeView *treeview;
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  gchar *s;
  gint i;
  GtkWidget *image;

  window_search = create_window_search();
  treeview = (GtkTreeView*) lookup_widget(window_search, "treeview");

  renderer = gtk_cell_renderer_pixbuf_new();
  column = gtk_tree_view_column_new();
  gtk_tree_view_column_set_title(column,"ID");
  gtk_tree_view_column_pack_start(column, renderer, FALSE);
  gtk_tree_view_column_set_cell_data_func (column, renderer,
                                           search_window_pixbuf, NULL, NULL);

  renderer = gtk_cell_renderer_text_new ();
  gtk_tree_view_column_pack_start(column, renderer, FALSE);
  gtk_tree_view_column_set_cell_data_func (column, renderer,
                                           search_window_text, NULL, NULL);
  gtk_tree_view_append_column (treeview, column);

  for(i = SEARCH_TC_AGE; i < SEARCH_TC_COLUMNS; i++)
  {
    renderer = gtk_cell_renderer_text_new ();
    s = utf(search_tc_columns[i]);
    g_object_set_data (G_OBJECT (renderer), "column", (gint *)i);
    gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
                                                 -1, s, renderer,
                                                 "text", i,
                                                 NULL);
    g_free(s);
  }

  image = lookup_widget(window_search,"thobber");
  gtk_widget_hide(image);
  search_update();
  gtk_widget_show(window_search);
}

void my_create_window_chat(const gchar *jid)
{
  GtkWidget *window, *widget;
  struct talk *talk;
  struct user *user;
  gchar *status=NULL, *name, *s;
  GtkTextBuffer *buffer;

  name = get_user_name(jid);
  window = create_window_chat();
  talk = (struct talk*) g_malloc(sizeof(struct talk));
  talk->jid = g_strdup(jid);
  talk->window = window;
  talks_list = g_list_append(talks_list,(gpointer)talk);
  widget=lookup_widget(window,"textview_bottom");
//  gtk_signal_connect (GTK_OBJECT (widget), "key_press_event",
//                      GTK_SIGNAL_FUNC (on_textview_chat_bottom_key_press_event),
//                      (gpointer)window);
  user = get_user(jid);
  if(user)
  {
    switch(user->type)
    {
	  case USER_VIRTUAL:
      case USER_TLEN:
        status = statusy[user->status - 2];
        break;
      case USER_JABBER:
      case USER_WP:
      case USER_AGENT:
      case USER_GG:
        status = j_statusy[get_status(user)];
        break;
    }
    window_set_icon(window, user);
  }
  else
  {
    status = statusy[TLEN_STATUS_UNAVAILABLE - 2];
    window_set_icon(window, NULL);
  }
  widget = lookup_widget(window,"label_name");
  s = utf(name);
  gtk_label_set_text(GTK_LABEL(widget), s);
  g_free(s);
  widget = lookup_widget(window,"label_status");
  s = utf(status);
  gtk_label_set_text(GTK_LABEL(widget), s);
  g_free(s);
  g_free(name);
  widget=lookup_widget(window,"textview_top");
  buffer= gtk_text_view_get_buffer (GTK_TEXT_VIEW(widget));
  gtk_text_buffer_create_tag (buffer, "fontbold","font",
                              "bold", NULL);
  gtk_text_buffer_create_tag (buffer, "datefg","foreground",
                              datefg, NULL);
  gtk_text_buffer_create_tag (buffer, "nickfg","foreground",
                              nickfg, NULL);
  gtk_text_buffer_create_tag (buffer, "textfg",
                              "foreground", textfg,
                              NULL);
  gtk_text_buffer_create_tag (buffer, "textbg",
                              "background", textbg,
                              "foreground", textfg,
//                              "background-full-height", TRUE,
//                              "background-full-height-set", TRUE,
//                              "font", "bold",
                              NULL);
  widget=lookup_widget(window,"togglebutton_chat");
  if(preferences & PREF_ENTERON)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),TRUE);
  gtk_widget_show(window);
}

void my_create_window_login()
{
  window_login = create_window_login();
  load_profiles();
  load_combo();
  gtk_widget_show(window_login);
}

static
void add_columns(GtkTreeView *treeview)
{
  GtkCellRenderer *text;
  GtkTreeViewColumn *column;

  text = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes (NULL, text,
                                                     "text",0,
                                                     NULL);
  gtk_tree_view_append_column(treeview, column);
}

GtkTreeModel *window_profiles_create_model()
{
  GtkTreeStore *model;
  GtkTreeIter iter;
  GList *l = profiles_list;
  struct profile *p;
  gchar *s;

  model = gtk_tree_store_new(1, G_TYPE_STRING);
  for(;l;l=l->next)
  {
    p = (struct profile*) l->data;
    gtk_tree_store_append(model, &iter, NULL);
    s = utf(p->pname);
    gtk_tree_store_set(model, &iter,
                       0, s,
                       -1);
    g_free(s);
  }
  return GTK_TREE_MODEL(model);
}

void my_create_window_profiles()
{
  GtkWidget *treeview;
  GtkTreeModel *model;

  window_profiles = create_window_profiles();
  treeview = lookup_widget(window_profiles,"treeview");
  add_columns(GTK_TREE_VIEW(treeview));
  model = window_profiles_create_model();
  gtk_tree_view_set_model(GTK_TREE_VIEW(treeview), model);
  g_object_unref (G_OBJECT (model));
}

void window_profile_read_gg()
{
  gchar *s;
  GtkWidget *entry;

  entry = lookup_widget(window_profile, "entry_gg_number");
  s = gg_read_conf(GG_CONF_NUMBER);
  if(s)
  {
    gtk_entry_set_text(GTK_ENTRY(entry), s);
    g_free(s);
  }
  entry = lookup_widget(window_profile, "entry_gg_password");
  s = gg_read_conf(GG_CONF_PASSWORD);
  if(s)
  {
    gtk_entry_set_text(GTK_ENTRY(entry), s);
    g_free(s);
  }
}

void my_create_window_profile(gchar *pname)
{
  GtkWidget *entry;
  gchar *s;
  struct profile *p;

  window_profile = create_window_profile();
  if(pname)
  {
    entry = lookup_widget(window_profile,"entry_name");
    s = utf(pname);
    gtk_entry_set_text(GTK_ENTRY(entry),s);
    g_free(s);
    p = get_profile(pname);
    if(p)
    {
      entry = lookup_widget(window_profile,"entry_tlen_login");
      gtk_entry_set_text(GTK_ENTRY(entry),p->login);
      entry = lookup_widget(window_profile,"entry_tlen_password");
      gtk_entry_set_text(GTK_ENTRY(entry),p->password);
      if(p->smsid)
      {
        entry = lookup_widget(window_profile,"entry_sms_id");
        gtk_entry_set_text(GTK_ENTRY(entry),p->smsid);
      }
      if(p->smspassword)
      {
        entry = lookup_widget(window_profile,"entry_sms_password");
        gtk_entry_set_text(GTK_ENTRY(entry),p->smspassword);
      }
      if(p->ggnumber)
      {
        entry = lookup_widget(window_profile,"entry_gg_number");
        gtk_entry_set_text(GTK_ENTRY(entry),p->ggnumber);
      }
      if(p->ggpassword)
      {
        entry = lookup_widget(window_profile,"entry_gg_password");
        gtk_entry_set_text(GTK_ENTRY(entry),p->ggpassword);
      }
      if(p->jserver)
      {
        entry = lookup_widget(window_profile,"entry_jabber_server");
        gtk_entry_set_text(GTK_ENTRY(entry),p->jserver);
      }
      if(p->jlogin)
      {
        entry = lookup_widget(window_profile,"entry_jabber_jid");
        gtk_entry_set_text(GTK_ENTRY(entry),p->jlogin);
      }
      if(p->jpassword)
      {
        entry = lookup_widget(window_profile,"entry_jabber_password");
        gtk_entry_set_text(GTK_ENTRY(entry),p->jpassword);
      }
      if(p->jresource)
      {
        entry = lookup_widget(window_profile,"entry_jabber_resource");
        gtk_entry_set_text(GTK_ENTRY(entry),p->jresource);
      }
    }
  }
}

void my_create_window_about()
{
  GtkWidget *window, *label;

  window = create_window_about();
  label = lookup_widget(window, "label");
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_CENTER);
  gtk_widget_show(window);
}
