/****************************************************************************
    Copyright (C) 1987-2005 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "gsim.h"

#define LED_I	0

#define LED_DELAY 0

static void Led_initGate(EvQueue *Q,SGate *g);
static void Led_processEvent(SGate*,EvQueue*,SEvent*);

static SGateInfo led_info = {
  0,
  "led",0x0,
  1,{{"I",GIO_IN,PF_CUT}},
  {{0}},

  Generic_copyGate,
  Led_processEvent,
  Nop_checkGate,
  Led_initGate,
};

struct led_data {
  int		report;		/* Is reporting enabled? */
};

static void Led_initGate(EvQueue *Q,SGate *g)
{
  struct led_data *rd = (struct led_data*) malloc(sizeof(struct led_data));

  g->g_data = rd;
  rd->report = 0;
}

void init_led()
{
  SGateInfo_register(&led_info,0);
}

static void Led_reportValue(SGate *g)
{
  SState *I = SGate_allocPortState(g,LED_I);
  char buf[STRMAX],*p;

  p = buf;
  p += sprintf(p,"ledvalue %s ",g->g_name);
  p += SState_getstr(I,p);
  *p = 0;
  sendMsg("%s",buf);

  free_SState(I);
}


static void Led_processEvent(SGate *g,EvQueue *Q,SEvent *E)
{
  struct led_data *rd = (struct led_data*) g->g_data;

  if (rd->report)
    Led_reportValue(g);
}

void Led_enableMonitor(SGate *g,EvQueue *Q)
{
  struct led_data *rd = (struct led_data*) g->g_data;

  rd->report = 1;
  Led_reportValue(g);

}

void Led_disableMonitor(SGate *g,EvQueue *Q)
{
  struct led_data *rd = (struct led_data*) g->g_data;
  rd->report = 0;
}

