# $Id: systray.tcl,v 1.5 2005/03/27 20:31:12 aleksey Exp $

# Tray icon support.
# Requires Tray package (ftp://ftp.atmsk.ru/pub/tkabber/tksystray.tar.gz)

if {![cequal $::interface tk]} return

if {![info exists ::systray] || !$::systray} {
    return
}

if {[catch { package require Tray }]} {
    return
}

namespace eval systray {
    variable saved_state
    variable saved_geometry 
    variable show_hide_menu_index
    variable balloon ""
    variable tray    ""

    variable icon    ""
    variable pos     0
    variable pixmap_list
    array set pixmap_list {}
  
    variable options
    custom::defvar options(tray_blinks) 0 \
	[::msgcat::mc "When you have unread messages the systray icon will start to blink."] \
	-group IFace -type boolean

#    custom::defvar options(close_to_tray) 0 \
#	[::msgcat::mc "When you close main window, it'n hide to systray"] \
#	-group IFace -type boolean
}

namespace eval ::ifacetk {
    custom::add_radio_options options(closebuttonaction) \
	[list systray [::msgcat::mc "Minimize to systray"]]
}

proc systray::load {} {
    global   curuserstatus
    variable show_hide_menu_index

    variable pixmap_list
    variable tray
    variable m

    variable icon
    variable pos
    variable s2p
    variable saved_state [wm state .]

    foreach {k v} [list available   available      \
                        away        available-away \
                        chat        available-chat \
                        dnd         available-dnd  \
                        xa          available-xa   \
                        unavailable unavailable    \
                        invisible   invisible      \
			blank       blank          \
			message1    message-server \
			message2    message        \
			message3    message-personal] {
        set pixmap_list($k) [pixmap docking ${v}.gif]
    }

    set icon .si

    newti $icon -pixmap $pixmap_list(unavailable)

    set m .traymenu
    menu $m -title "Tkabber" -tearoff $ifacetk::options(show_tearoffs) \
	-postcommand [list [namespace current]::post $m]
	
    if {$ifacetk::options(show_tearoffs)} {
	set i 1
    } else {
	set i 0
    }

    for {} {$i <= [[set p .presence.button.menu] index end]} {incr i} {
        $m add command -label [lindex [$p entryconfigure $i -label] 4] \
                        -command  [lindex [$p entryconfigure $i -command] 4]
    }
    $m add separator
    $m add command -label [::msgcat::mc "Show Main Window"]  -command  [namespace code win_iconify]
    set show_hide_menu_index [$m index [::msgcat::mc "Show Main Window"]]
#    $m add command -label [::msgcat::mc "Log in/out..."] -command [namespace code tkabber_on_off]
    $m add command -label [::msgcat::mc "Quit"]  -command quit

    set tray ""

    foreach var [list curuserstatus tabcolors] {
        trace variable ::$var w [namespace current]::update
    }


    bind $icon <Button1-ButtonRelease>  [namespace code win_iconify]
    bind $icon <Button3-ButtonRelease>  [namespace code [list tk_popup $m %X %Y]]
#    bind $icon <Double-Button-1> 	[namespace code login_logout]

    bind $icon <Any-Enter>  [list [namespace code wrap_balloon] enter %X %Y]
    bind $icon <Any-Motion> [list [namespace code wrap_balloon] motion %X %Y]
    bind $icon <Any-Leave>  [list balloon::default_balloon .si leave  %X %Y]

    hook::add quit_hook [namespace current]::quit
}

hook::add finload_hook [namespace current]::systray::load

proc systray::win_iconify {} {
    variable saved_state
    variable saved_geometry

    switch -- [wm state .] {
	zoomed -
        normal {
            set saved_state [wm state .]
            set saved_geometry [wm geometry .]
            wm state . withdrawn
        }

	iconic {
            wm state . withdrawn
	    if {[info exists saved_geometry]} {wm geometry . $saved_geometry}
	    wm state . normal
            wm deiconify .
	}

	default {
	    if {[info exists saved_geometry]} {wm geometry . $saved_geometry}
	    if {[info exists saved_state]} {wm state . $saved_state}
            wm deiconify .
        }
    }
}

proc systray::wm_win_iconify {} {
    if {$::ifacetk::options(closebuttonaction) == "systray"} {
	win_iconify
	return stop
    }
}

hook::add protocol_wm_delete_window_hook \
    [namespace current]::systray::wm_win_iconify 40

#proc systray::tkabber_on_off {} {
#    global  curuserstatus
#    switch -- $curuserstatus {
#	unavailable  {ifacetk::login_dialog}
#	default {show_logout_dialog}
#    }
#}

proc systray::quit {} {
    variable icon

    if {![cequal $icon ""]} {
	removeti $icon  
    }
    destroy $icon
    set icon ""
}

proc systray::wrap_balloon {ev x y} {
    ::balloon::default_balloon .si $ev $x $y [balloon_text]
}

proc systray::balloon_text {} {
    global userstatusdesc textstatus

    if {![cequal $textstatus ""]} {
	return $textstatus
    }
    return $userstatusdesc
}

proc systray::post {m} {
    variable show_hide_menu_index
    
    switch -- [wm state .] {
	zoomed -
	normal {
	    $m entryconfigure $show_hide_menu_index \
		-label [::msgcat::mc "Hide Main Window"]
	}

	default {
	    $m entryconfigure $show_hide_menu_index \
		-label [::msgcat::mc "Show Main Window"]
	}
    }
}

proc systray::update {name1 {name2 ""} {op ""}} {
    global curuserstatus
    variable pixmap_list
    variable tray
    variable icon

    switch -- [string trimleft $name1 :] {
	curuserstatus {
	    if {[cequal $tray ""]} {
		configureti $icon -pixmap $pixmap_list($curuserstatus)
	    }
	}

	tabcolors {
	    toggle 0 1
	}
    }
}

proc systray::toggle {ff {firstP 0}} {
    global curuserstatus tabcolors
    variable options
    variable tray
    variable icon
    variable pixmap_list

    if {![cequal $tray ""]} {
	after cancel $tray
	set tray ""
    }

    set hitP 0
    foreach {k v} [array get tabcolors] {
	if {![winfo exists .nb.f$k]} {
	    continue
	}
	if {(![cequal $v ""]) && ($v > $hitP)} {
	    set hitP $v
	}
    }

    if {$hitP == 0} {
	update ::curuserstatus
	return
    }

    if {$options(tray_blinks)} {
	set tray [after 500 [list [namespace current]::toggle [expr {!$ff}]]]
	if {$ff} {
	    configureti $icon -pixmap $pixmap_list(message$hitP)
	} else {
	    configureti $icon -pixmap $pixmap_list(blank)
	}
    } else {
	set tray message
	configureti $icon  -pixmap $pixmap_list(message$hitP)
    }
}

proc systray::set_status {text} {
    variable balloon
    variable icon

    switch -- [wm state .] {
        normal { }
        default {
            if {![cequal $balloon ""]} {
                after cancel $balloon
            }
	    
	    if {![winfo exists $icon]} {
		return
	    }
	    balloon::set_text $text
	    balloon::show [winfo rootx $icon] \
                          [winfo rooty $icon]
	    set balloon [after 15000 balloon::destroy]
        }
    }
}

hook::add set_status_hook [namespace current]::systray::set_status

proc systray::clear_status {} {
    variable balloon

    if {![cequal $balloon ""]} {
        after cancel $balloon
    }
    balloon::destroy
}

hook::add clear_status_hook [namespace current]::systray::clear_status

