# Allows to open new chat window without using mouse and roster pane :)
# Just type "/open NickName (hisjid)" and press enter.
# Command and nick could be completed in the usual way.
# 
# $Id: open_chat.tcl,v 1.2 2005/03/12 22:03:04 aleksey Exp $

proc handle_open_chat {chatid user body type} {
    if {[string equal -length 6 $body "/open "]} {
	    set user [crange $body 6 end]
        regexp {.* \(([^ ]*)\)} $user temp jid
        chat::open_to_user [chat::get_connid $chatid] $jid
	    return stop
    }
}
hook::add chat_send_message_hook [namespace current]::handle_open_chat 15

proc roster_completions {chatid compsvar wordstart line} {
    #if {![chat::is_groupchat $chatid]} return

    variable options
    #global grouproster
    upvar 0 $compsvar comps
    #debugmsg plugins "COMPLETION N: $comps"

    if {!$wordstart} {
	    lappend comps {/open }
    }

    if {[string equal -length 6 $line "/open "]} {
        set nickcomps {}
	set connid [chat::get_connid $chatid]
        foreach jid [roster::get_jids $connid] {
	        lappend nickcomps "[chat::get_nick $connid $jid chat] ($jid)"
        }
        set nickcomps [lsort -dictionary -unique $nickcomps]
        set comps [concat $nickcomps $comps]
        debugmsg plugins "COMPLETION from roster: $comps"
    }
}

hook::add generate_completions_hook \
    [namespace current]::roster_completions 93
