# $Id: draw_xhtml_message.tcl,v 1.5 2005/03/27 20:31:12 aleksey Exp $

namespace eval xhtml {
    set statevars {
	color
	lmargin1 lmargin2
	weight slant size
	list_style list_counter
    }
    #set font [option get . font Tkabber]
    set urlid 0

    custom::defvar options(enable) 0 \
	[::msgcat::mc "Enable rendering of XHTML messages."] \
	-type boolean -group Chat

}

proc xhtml::draw_xhtml_message {chatid from type plainbody x} {
    variable options

    if {!$options(enable)} return

    foreach xelem $x {
	jlib::wrapper:splitxml $xelem tag vars isempty chdata children
	
	if {[cequal [jlib::wrapper:getattr $vars xmlns] \
		 http://jabber.org/protocol/xhtml-im]} {
	    set xhtml $children
	}
    }

    if {![info exists xhtml]} return

    foreach el $xhtml {
	jlib::wrapper:splitxml $el tag vars isempty chdata children
	
	if {$tag == "body"} {
	    set body $el
	}
    }

    if {![info exists body]} return

    if {[chat::is_our_jid $chatid $from]} {
	set tag me
    } else {
	set tag they
    }

    set connid [chat::get_connid $chatid]

    set chatw [chat::chat_win $chatid]
    set nick [chat::get_nick $connid $from $type]


    set cw [chat::winid $chatid]
    if {[cequal $type groupchat]} {
	return
	# TODO
	$chatw insert end "<$nick>" $tag " "
	set myjid [chat::our_jid $chatid]
	set mynick [chat::get_nick $connid $myjid $type]

	if {[crange $body 0 [expr [clength $mynick] + 1]] == "${mynick}: "} {
	    $chatw insert end $mynick me
	    chat::add_emoteiconed_text [::chat::chat_win $chatid] \
		[crange $body [clength $mynick] end] ""
	    tab_set_updated $cw 1 mesg_to_user
	} else {
	    chat::add_emoteiconed_text [::chat::chat_win $chatid] $body ""
	    tab_set_updated $cw 1 message
	}
    } else {
	$chatw insert end "<$nick>" $tag " "
	init [::chat::chat_win $chatid]
	add_xhtml [::chat::chat_win $chatid] $body
	tab_set_updated $cw 1 mesg_to_user
    }

    return stop
}
hook::add draw_message_hook [namespace current]::xhtml::draw_xhtml_message 85


proc xhtml::init {cw} {
    variable font
    variable state
    variable stack

    array unset stack
    array unset state
    set state(color) [$cw cget -foreground]
    set stack(color) {}
    set state(lmargin1) 0
    set stack(lmargin1) {}
    set state(lmargin2) 0
    set stack(lmargin2) {}
    set state(weight) 0
    set stack(weight) {}
    set state(slant) 0
    set stack(slant) {}
    # TODO
    #set state(size) [font actual $font -size]
    set state(size) 12
    set stack(size) {}
    set state(list_style) ul
    set stack(list_style) {}
    set state(list_counter) 0
    set stack(list_counter) {}


    set state(afterspace) 1
    set state(lastnl) 2
}

proc xhtml::add_xhtml {cw xhtml} {
    variable state

    jlib::wrapper:splitxml $xhtml name vars isempty chdata childrens
    set nextchdata [jlib::wrapper:get_subchdata $xhtml]

    push

    set tag ""
    set prefix ""
    set suffix ""
    set pre 0

    parse_style [jlib::wrapper:getattr $vars style]

    switch -- $name {
	h1 -
	h2 -
	h3 -
	blockquote -
	p {
	    set prefix [string repeat "\n" [expr {2 - $state(lastnl)}]]
	    set suffix "\n\n"
	    set state(afterspace) 1
	}
	pre -
	li {
	    set prefix [string repeat "\n" [expr {1 - $state(lastnl)}]]
	    set suffix "\n"
	    set state(afterspace) 1
	}
    }

    switch -- $name {
	h1 {
	    incr state(size) 6
	    set state(weight) 1
	}
	h2 {
	    incr state(size) 4
	    set state(weight) 1
	}
	h3 {
	    incr state(size) 2
	    set state(weight) 1
	}
	p {
	}
	br {
	    set prefix "\n"
	    set state(afterspace) 1
	}
	strong {
	    set state(weight) 1
	}
	em {
	    set state(slant) [expr {!$state(slant)}]
	}
	a {
	    set url [jlib::wrapper:getattr $vars href]
	    lappend tag [get_url_tag $cw $url]
	}
	img {
	    set imgsrc [jlib::wrapper:getattr $vars src]
	    set imgalt [jlib::wrapper:getattr $vars alt]
	    set nextchdata "\[$imgalt\]"
	    lappend tag [get_url_tag $cw $imgsrc]
	}
	span {}
	blockquote {
	    incr state(lmargin1) 32
	    incr state(lmargin2) 32
	}
	q {
	    #set nextchdata "\"[string trim $chdata]\""
	    #set childrens {}
	    set prefix \"
	    set suffix \"
	}
	pre {
	    set nextchdata $chdata
	    set childrens {}
	    set pre 1
	}

	li {
	    chat::add_emoteiconed_text $cw $prefix ""
	    set prefix ""
	    switch -- $state(list_style) {
		ul {
		    set item_prefix "\u2022 "
		}
		ol {
		    variable stack
		    set item_prefix "[incr state(list_counter)]. "
		    set stack(list_counter) \
			[lreplace $stack(list_counter) 0 0 \
			     $state(list_counter)]
		}
	    }
	    chat::add_emoteiconed_text $cw $item_prefix \
		[concat xhtml_symb [get_tags $cw]]
	}
	ul {
	    incr state(lmargin1) 32
	    incr state(lmargin2) 32
	    set state(list_style) ul
	}
	ol {
	    incr state(lmargin1) 32
	    incr state(lmargin2) 32
	    set state(list_style) ol
	    set state(list_counter) 0
	}


    }

    # TODO
    set tag [concat $tag [get_tags $cw]]

    if {!$pre} {
	regsub -all {[[:space:]]+} $nextchdata " " formated
    } else {
	set formated [string trim $nextchdata "\n"]
    }
    if {$state(afterspace) && [string index $formated 0] == " "} {
	set formated [crange $formated 1 end]
    }

    if {$formated != ""} {
	set state(afterspace) [expr {[string index $formated end] == " "}]
    }

    chat::add_emoteiconed_text $cw $prefix $tag
    chat::add_emoteiconed_text $cw $formated $tag

    if {$formated != ""} {
	set state(lastnl) 0
    }

    foreach xelem $childrens {
	add_xhtml $cw $xelem
	set nextchdata [jlib::wrapper:get_fchdata $xelem]

	regsub -all {[[:space:]]+} $nextchdata " " formated
	if {$state(afterspace) && [string index $formated 0] == " "} {
	    set formated [crange $formated 1 end]
	}

	if {$formated != ""} {
	    set state(afterspace) [expr {[string index $formated end] == " "}]
	}

	chat::add_emoteiconed_text $cw $formated $tag
	if {$formated != ""} {
	    set state(lastnl) 0
	}
    }

    # messy
    set state(lastnl) 0
    if {[$cw get "end - 2c"] == "\n"} {
	incr state(lastnl)
	set state(afterspace) 1
	if {[$cw get "end - 3c"] == "\n"} {
	    incr state(lastnl)
	}
    }
    if {$suffix == "\n\n"} {
	chat::add_emoteiconed_text $cw \
	    [string repeat "\n" [expr {2 - $state(lastnl)}]] ""
    } elseif {$suffix == "\n"} {
	chat::add_emoteiconed_text $cw \
	    [string repeat "\n" [expr {1 - $state(lastnl)}]] ""
    } else {
	chat::add_emoteiconed_text $cw $suffix $tag
    }
    set state(lastnl) 0
    if {[$cw get "end - 2c"] == "\n"} {
	incr state(lastnl)
	set state(afterspace) 1
	if {[$cw get "end - 3c"] == "\n"} {
	    incr state(lastnl)
	}
    }
    pop
}


proc xhtml::push {} {
    variable state
    variable stack
    variable statevars

    foreach name $statevars {
	set stack($name) [linsert $stack($name) 0 $state($name)]
    }
}

proc xhtml::pop {} {
    variable state
    variable stack
    variable statevars

    foreach name $statevars {
	if {[info exists stack($name)]} {
	    set stack($name) [lassign $stack($name) state($name)]
	}
    }
}

proc xhtml::parse_style {style} {
    variable state

    set optlist [split $style ";"]

    foreach opt $optlist {
	lassign [split $opt ":"] arg val
	set val [string trim $val]

	switch -- $arg {
	    color {
		set state(color) $val
	    }
	}
    }
}

proc xhtml::get_tags {chatw} {
    variable font
    variable state

    set tags {}

    set color_tag tag_color_$state(color)
    $chatw tag configure $color_tag -foreground $state(color)
    lappend tags $color_tag

    set indent_tag tag_indent_$state(lmargin1)_$state(lmargin2)
    $chatw tag configure $indent_tag \
	-lmargin1 $state(lmargin1) -lmargin2 $state(lmargin2)
    lappend tags $indent_tag

    #set customfont [eval font create [font actual $font]]
    if {$state(weight)} {
	set fweight bold
    } else {
	set fweight medium
    }
    if {$state(slant)} {
	set fslant i
    } else {
	set fslant r
    }
    # TODO
    set fsize $state(size)
    #font configure $customfont -size $fsize -slant $fslant -weight $fweight
    set font_tag tag_font_${fsize}_${fslant}_${fweight}
    set customfont -*-helvetica-${fweight}-${fslant}-*-*-${fsize}-*-*-*-*-*-*-*
    $chatw tag configure $font_tag -font $customfont
    lappend tags $font_tag
    $chatw tag lower $font_tag xhtml_symb
    


    return $tags
}


proc xhtml::get_url_tag {chatw url} {
    variable urlid
    set tag xhtmlurl[incr urlid]
    set urlfg    [option get $chatw urlforeground       Text]
    set urlactfg [option get $chatw urlactiveforeground Text]
    $chatw tag configure $tag -foreground $urlfg -underline 1
    $chatw tag bind $tag <1> [list browseurl [double% $url]]
    $chatw tag bind $tag <Any-Enter> \
	[list chat::highlighttext $chatw $tag $urlactfg hand2]
    $chatw tag bind $tag <Any-Leave> \
	[list chat::highlighttext $chatw $tag $urlfg xterm]
    $chatw tag raise $tag
    return $tag
}

proc xhtml::setup_xhtml_tags {chatid type} {
    global font

    set cw [::chat::chat_win $chatid]

    $cw tag configure xhtml_symb -font $font
    $cw tag raise xhtml_symb
}

hook::add open_chat_post_hook [namespace current]::xhtml::setup_xhtml_tags

