# $Id: itemedit.tcl,v 1.13 2005/08/14 16:25:27 aleksey Exp $

namespace eval itemedit {}

proc itemedit::show_dialog {connid jid} {
    variable gra_name
    variable gra_nick
    variable gra_password
    variable gra_autojoin

    set allowed_name [jid_to_tag $jid]
    set w .gredit_${connid}_$allowed_name

    if {[winfo exists $w]} {
	destroy $w
    }

    Dialog $w -title [format [::msgcat::mc "Edit properties for %s"] $jid] \
	-separator 1 -anchor e \
	-default 0 -cancel 1

    set f [$w getframe]

    if {[roster::itemconfig $connid $jid -subsc] == "bookmark"} {
	set tf [TitleFrame $f.prop -text [format [::msgcat::mc "Edit properties for %s"] $jid]]
	pack $tf -side top -expand yes -fill both
	set g [$tf getframe]

	set gra_name $::plugins::conferences::bookmarks($connid,name,$jid)
	set gra_autojoin $::plugins::conferences::bookmarks($connid,autojoin,$jid)
	if {[info exists ::plugins::conferences::bookmarks($connid,nick,$jid)]} {
	    set gra_nick $::plugins::conferences::bookmarks($connid,nick,$jid)
	} else {
	    set gra_nick ""
	}
	if {[info exists ::plugins::conferences::bookmarks($connid,password,$jid)]} {
	    set gra_password $::plugins::conferences::bookmarks($connid,password,$jid)
	} else {
	    set gra_password ""
	}

	label $g.lname -text [string trim [::msgcat::mc "Name: "]]
	entry $g.name -textvariable [namespace current]::gra_name
	label $g.lnick -text [::msgcat::mc "Nick:"]
	entry $g.nick -textvariable [namespace current]::gra_nick
	label $g.lpassword -text [::msgcat::mc "Password:"]
	entry $g.password -show * -textvariable [namespace current]::gra_password
	checkbutton $g.autojoin -text [::msgcat::mc "Automatically join conference upon connect"] \
	    -variable [namespace current]::gra_autojoin
	grid columnconfigure $g 0 -weight 0
	grid columnconfigure $g 1 -weight 1

	grid $g.lname  -row 0 -column 0 -sticky e
	grid $g.name   -row 0 -column 1 -sticky ew
	grid $g.lnick -row 1 -column 0 -sticky e
	grid $g.nick  -row 1 -column 1 -sticky ew
	grid $g.lpassword -row 2 -column 0 -sticky e
	grid $g.password  -row 2 -column 1 -sticky ew
	grid $g.autojoin -row 3 -column 0 -sticky w -columnspan 2
    } else {
	set tf [TitleFrame $f.name -text [format [::msgcat::mc "Edit nickname for %s"] $jid]]
	pack $tf -side top -expand yes -fill both
	set g [$tf getframe]

	label $g.lname -text [::msgcat::mc "Nickname:"]
	set gn [entry $g.name]

	set name [roster::itemconfig $connid $jid -name]
	if {$name == ""} {
	    if {[info exists userinfo::userinfo(nickname,$jid)] && \
		    ![cequal $userinfo::userinfo(nickname,$jid) ""]} {
		set name $userinfo::userinfo(nickname,$jid)
	    } else {
		set name [node_from_jid $jid]
		jlib::send_iq get \
		    [jlib::wrapper:createtag vCard \
			 -vars [list xmlns vcard-temp]] \
		    -to [node_and_server_from_jid [get_jid_of_user $connid $jid]] \
		    -connection $connid \
		    -command [list [namespace current]::fetch_nickname $gn $name $jid]
	    }
	}
	$g.name insert 0 $name

	pack $g.lname -side left
	pack $g.name -side left -expand yes -fill x
    }

    set g [[TitleFrame $f.gr -text [format [::msgcat::mc "Edit groups for %s"] $jid]] getframe]
    pack $f.gr -side top -expand yes -fill both


    TitleFrame $g.available -text [::msgcat::mc "Available groups"]
    pack $g.available -side left -expand yes -fill both
    set ga [$g.available getframe]

    frame $ga.gr
    label $ga.gr.lab -text [::msgcat::mc "Group:"]
    set gae [entry $ga.gr.oup]
    pack $ga.gr.lab -side left
    pack $ga.gr.oup -side left -fill x -expand yes
    pack $ga.gr -side top -fill x

    set gasw [ScrolledWindow $ga.grouplist_sw]
    set gal [listbox $ga.grouplist]
    $gasw setwidget $gal
    pack $gasw -side top -expand yes -fill both



    TitleFrame $g.current -text [::msgcat::mc "Current groups"]
    pack $g.current -side right -expand yes -fill both
    set gc [$g.current getframe]

    set gcsw [ScrolledWindow $gc.grouplist_sw]
    set gcl [listbox $gc.grouplist]
    $gcsw setwidget $gcl
    pack $gcsw -side top -expand yes -fill both

    frame $g.buttons
    button $g.buttons.add -text [::msgcat::mc "Add ->"] \
	-command "itemedit::add_group $gcl \[$ga.gr.oup get\]"
    button $g.buttons.remove -text [::msgcat::mc "<- Remove"] \
	-command [list itemedit::remove_current_group $gcl]
    pack $g.buttons.add $g.buttons.remove -side top -fill x -anchor c
    pack $g.buttons -side left


    if {[roster::itemconfig $connid $jid -subsc] == "bookmark"} {
	$w add -text [::msgcat::mc "OK"] \
	    -command [list itemedit::commit_bookmark_changes $gcl $connid $jid]
    } else {
	$w add -text [::msgcat::mc "OK"] \
	    -command [list itemedit::commit_changes $gn $gcl $connid $jid]
    }
    $w add -text [::msgcat::mc "Cancel"] -command [list destroy $w]


    foreach group [roster::get_groups $connid \
		       -nested $::ifacetk::roster::options(nested) \
		       -delimiter $::ifacetk::roster::options(nested_delimiter)] {
	$gal insert end $group
    }

    foreach group [roster::itemconfig $connid $jid -group] {
	$gcl insert end $group
    }


    bindtags $gal [list Listbox $gal . all]
    bind $gal <1> [list itemedit::select_available_group $gal $gae]

    $w draw
}

proc itemedit::prefs_user_menu {m connid jid} {
    global curuser

    if {[cequal $jid "\$curuser"]} {
	set jid $curuser
    }
    $m add command -label [::msgcat::mc "Edit item..."] \
	-command [list [namespace current]::show_dialog $connid $jid]
}

hook::add roster_create_user_menu_edit_hook \
    [namespace current]::itemedit::prefs_user_menu 30

proc itemedit::add_group {grlist group} {
    set group [string trim $group]

    if {![cequal $group ""]} {
	set groups [$grlist get 0 end]

	lappend groups $group

	set groups [lrmdups $groups]

	$grlist delete 0 end
	eval $grlist insert end $groups
    }
}

proc itemedit::select_available_group {grlist grentry} {
    if {![lempty [$grlist curselection]]} {
	set group [$grlist get [$grlist curselection]]
	$grentry delete 0 end
	$grentry insert 0 $group
    }
}

proc itemedit::remove_current_group {grlist} {
    if {![lempty [$grlist curselection]]} {
	$grlist delete [$grlist curselection]
    }
}


proc itemedit::commit_changes {name_entry grlist connid jid} {
    roster::itemconfig $connid $jid \
	-group [$grlist get 0 end] \
	-name [$name_entry get]
    roster::send_item $connid $jid
    destroy [winfo toplevel $grlist]
}

proc itemedit::fetch_nickname {name_entry name jid res child} {
    if {![winfo exists $name_entry] || ![cequal $res OK]} {
	return
    }

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    foreach item $children {
	userinfo::parse_vcard_item $jid $item
    }
    if {[info exists userinfo::userinfo(nickname,$jid)] && \
	    ![cequal $userinfo::userinfo(nickname,$jid) ""] && \
	    [winfo exists $name_entry] && \
	    [cequal [$name_entry get] $name]} {
	$name_entry delete 0 end
	$name_entry insert 0 $userinfo::userinfo(nickname,$jid)
    }

}

proc itemedit::commit_bookmark_changes {grlist connid jid} {
    variable gra_name
    variable gra_nick
    variable gra_password
    variable gra_autojoin

    plugins::conferences::update_bookmark $connid $jid \
	-name $gra_name -nick $gra_nick -password $gra_password \
	-autojoin $gra_autojoin -groups [$grlist get 0 end]

    destroy [winfo toplevel $grlist]
}

