#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>

static unsigned char port[2] = {0, 22};
static unsigned char ip[4] = {127, 0, 0, 1};

static int s;

void sshconnect(void) {

    struct sockaddr_in sa;

    s = socket(PF_INET, SOCK_STREAM, 0);
    if (s == -1) {
        perror("unable to create tcp socket");
        exit(111);
    }

    memset(&sa, 0, sizeof sa);
    sa.sin_family = PF_INET;
    memcpy(&sa.sin_addr, ip, 4);
    memcpy(&sa.sin_port, port, 2);
    if (connect(s, (struct sockaddr *)&sa, sizeof sa) == -1) {
        perror("unable to connect to 127.0.0.1:22");
        exit(111);
    }
}

void oneread(char *exp) {
    char ch;
    int r;

    errno = EPROTO;
    r = read(s, &ch, 1);
    if (r == 0) errno = ECONNRESET;
    if (r <= 0 || ch != exp[0]) {
        perror("unable to read SSH- string from 127.0.0.1:22");
        exit(111);
    }
}

int main(void){

    alarm(60);

    sshconnect();

    oneread("S");
    oneread("S");
    oneread("H");
    oneread("-");

    return 0;
}
