##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import netsvc
import copy
from tools.misc import UpdateableStr

import ir
import sql_db

class except_wizard(Exception):
	def __init__(self, name, value):
		self.name = name
		self.value = value

class interface(netsvc.Service):
	states = {}
	def __init__(self, name):
		netsvc.Service.__init__(self, 'wizard.'+name)
		self.exportMethod(self.execute)
		self.wiz_name = name

	def execute(self, uid, datas, state='init'):
		try:
			res = {}
			# iterate through the list of actions defined for this state and execute them
			# these actions are methods of the form: method(self, uid, datas)
			for act in self.states[state].get('actions', []):
				res2 = act(self, uid, datas)
				if res2 == True:
					return self.states[state].get('result', {})
				res.update( res2 )
				
			st = self.states[state]['result']
			st['datas'] = res
			resultat = copy.copy(st)
			
			if st['type'] == 'action':
				resultat['action'] = st['action'](uid, datas)

			elif st['type'] == 'choice':
				method = st.get('next_state', None)
				if method:
					next_state = method(self, uid, datas)
				else:
					next_state = 'end'
				return self.execute(uid, datas, next_state)
			
			if 'fields' in st:
				result = copy.copy(st['fields'])
				cr = sql_db.db.cursor()
				res = ir.ir_get(cr, uid, 'default', False, [('wizard.'+self.wiz_name,False)])
				cr.close()
				defaults = dict([(x[1],x[2]) for x in res])
				for val in result.keys():
					if 'default' in result[val]:
						result[val]['value'] = result[val]['default'](uid,datas,state)
						del result[val]['default']
					else:
						if val in defaults:
							result[val]['value']= defaults[val]
				resultat['fields'] = result

			if 'arch' in st and isinstance(st['arch'], UpdateableStr):
				resultat['arch'] = st['arch'].string
			return resultat
		except except_wizard, e:
			self.abortResponse(2, e.name, 'warning', e.value)

