##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: wizard_partial_picking.py 1825 2005-12-13 11:04:20Z nicoe $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import time
import sql_db
import netsvc
from tools.misc import UpdateableStr

import wizard
from osv import osv

_moves_arch = UpdateableStr()
_moves_fields = {}

def make_default(val):
	def fct(obj, cr, uid):
		return val
	return fct

def _get_moves(wizard, uid, datas):
	cr = sql_db.db.cursor()
	pick_obj = osv.osv_pools.get('stock.picking')
	pick = pick_obj.browse(cr, uid, [datas['id']])[0]
	res = {}
	_moves_fields.clear()
	_moves_arch_lst = ['<?xml version="1.0"?>', '<form string="Make picking">']
	for m in [line for line in pick.move_lines if line.state == 'assigned']:
		_moves_arch_lst.append('<field name="move%s" /><field name="track%s" />\n<newline />' % (m.id, m.id))
		_moves_fields['move%s' % m.id] = {'string' : m.product_id.name, 'type' : 'float', 'required' : True, 'default' : make_default(m.product_qty)}
		_moves_fields['track%s' % m.id] = {'string' : 'Tracking', 'type' : 'many2one', 'relation': 'stock.tracking', 'required' : False}
		res.setdefault('moves', []).append(m.id)
	_moves_arch_lst.append('</form>')
	_moves_arch.string = '\n'.join(_moves_arch_lst)
	cr.close()
	return res

def _do_split(wizard, uid, datas):
	cr = sql_db.db.cursor()
	move_obj = osv.osv_pools.get('stock.move')
	pick_obj = osv.osv_pools.get('stock.picking')
	pick = pick_obj.browse(cr, uid, [datas['id']])[0]
	new_moves = []
	# Iterate on the moves, copying them if necessary and setting them to the
	# right quantity
	for move in move_obj.browse(cr, uid, datas['form']['moves']):
		# Check the number of product received/sent
		if move.product_qty != datas['form']['move%s' % move.id]:
			new_obj = move_obj.copy(cr, uid, move.id, {'product_qty' : move.product_qty - datas['form']['move%s' % move.id], 'state' : 'confirmed'})
			new_moves.append(new_obj)
			move_obj.write(cr, uid, [move.id], {'product_qty' : datas['form']['move%s' % move.id]})
	# We process the picking list
	pick_obj.action_move(cr, uid, [pick.id])
	# If there is new moves must set them in the assigned state to be processed later
	# If not the picking list is completed
	if new_moves:
		move_obj.write(cr, uid, new_moves, {'state' : 'assigned'})
	else:
		wf_service = netsvc.LocalService("workflow")
		wf_service.trg_validate(uid, 'stock.picking', pick.id, 'button_done', cr)
	cr.commit()
	cr.close()
	return {}

class partial_picking(wizard.interface):
	
	states = {
		'init' : {
			'actions' : [ _get_moves ],
			'result' : { 'type' : 'form', 'arch' : _moves_arch, 'fields' : _moves_fields, 'state' : (('split', 'Make Picking'), ('end', 'Cancel'))},
		},
		'split' : {
			'actions' : [ _do_split ],
			'result' : { 'type' : 'state', 'state' : 'end' },
		},
	}

partial_picking('stock.partial_picking')

# vim:noexpandtab:
