##############################################################################
#
# Copyright (c) 2005 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id$
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import sql_db
import time
from mx import DateTime
import netsvc
from osv import osv

def _procure_confirm(self, uid, datas):
	cr = sql_db.db.cursor()

	wf_service = netsvc.LocalService("workflow")

	cr.execute('select id from mrp_procurement where state=%s order by date_planned', ('exception',))
	ids = map(lambda x:x[0], cr.fetchall())
	for id in ids:
		print 'check id', id
		wf_service.trg_validate(uid, 'mrp.procurement', id, 'button_restart', cr)
	cr.commit()

	po_time = (datas['form']['po_cycle'] or 0.0) + (datas['form']['po_lead'] or 0.0)
	maxdate = DateTime.now() + DateTime.RelativeDateTime(days=(datas['form']['schedule_cycle'] or 0.0) + (datas['form']['security_lead'] or 0.0))
	start_date = time.strftime('%Y-%m-%d, %Hh %Mm %Ss')
	offset = 0
	report = []
	report_total = 0
	report_except = 0
	report_later = 0
	ids = [1]
	while len(ids):
		cr.execute('select id from mrp_procurement where state=%s and procure_method=%s order by date_planned limit 500 offset %d', ('confirmed','make_to_order',offset))
		ids = map(lambda x:x[0], cr.fetchall())
		for proc in osv.osv_pools.get('mrp.procurement').browse(cr, uid, ids):
			if proc.product_id.supply_method=='produce':
				wf_service.trg_validate(uid, 'mrp.procurement', proc.id, 'button_check', cr)
			else:
				if (maxdate + DateTime.RelativeDateTime(days=(proc.product_id.seller_delay or 0 + po_time))).strftime('%Y-%m-%d')>=proc.date_planned:
					wf_service.trg_validate(uid, 'mrp.procurement', proc.id, 'button_check', cr)
				else:
					offset+=1
					report_later += 1
			cr.execute('select name,state from mrp_procurement where id=%d', (proc.id,))
			name,state = cr.fetchone()
			if state=='exception':
				report.append('PROC %d: Make to Order exception' % (proc.id,))
				report_except += 1
			report_total +=1
	cr.commit()

	offset = 0
	ids = [1]
	while len(ids):
		ids = osv.osv_pools.get('mrp.procurement').search(cr, uid, [('state','=','confirmed'),('procure_method','=','make_to_stock')], offset=offset)
		for proc in osv.osv_pools.get('mrp.procurement').browse(cr, uid, ids):
			if (maxdate + DateTime.RelativeDateTime(days=datas['form']['picking_lead'])).strftime('%Y-%m-%d') >= proc.date_planned:
				wf_service.trg_validate(uid, 'mrp.procurement', proc.id, 'button_check', cr)
				cr.execute('select name,state from mrp_procurement where id=%d', (proc.id,))
				name,state = cr.fetchone()
				if state=='exception':
					report.append('PROC %d: %3d %-5s - %s' % (proc.id,proc.product_qty,proc.product_uom.name, proc.product_id.name,))
					report_except +=1
			else:
				report_later +=1
			report_total +=1
		offset += len(ids)
	end_date = time.strftime('%Y-%m-%d, %Hh %Mm %Ss')
	if 'user_id' in datas['form'] and datas['form']['user_id']:
		request = osv.osv_pools.get('res.request')
		summary = '''Here is the procurement scheduling report.

Computation Started; %s
Computation Finnished; %s

Total procurement: %d
Exception procurement: %d
Not run now procurement: %d

Exceptions;
'''% (start_date,end_date,report_total, report_except,report_later)
		summary += '\n'.join(report)
		request.create(cr, uid, 
			  {'name' : "Procurement calculation report.",
			   'act_from' : datas['form']['user_id'],
			   'act_to' : datas['form']['user_id'],
			   'body': summary,
			   })
	cr.commit()
	cr.close()
	return {}


def _procure_orderpoint_confirm(self, uid, datas):
	cr = sql_db.db.cursor()
	wf_service = netsvc.LocalService("workflow")
	offset = 0
	ids = [1]
	while len(ids):
		cr.execute('select id from stock_warehouse_orderpoint where active offset %d limit 100', (offset,))
		ids = map(lambda x: x[0], cr.fetchall())
		for op in osv.osv_pools.get('stock.warehouse.orderpoint').browse(cr, uid, ids):
			# TODO: improve this test
			if op.procurement_id and op.procurement_id.purchase_id and (op.procurement_id.purchase_id.state in ('draft','confirmed')):
				continue
			prods = osv.osv_pools.get('stock.location')._product_virtual_get(cr, uid, op.warehouse_id.lot_stock_id.id, [op.product_id.id], {'uom': op.product_uom.id})[op.product_id.id]
			if prods<op.product_min_qty:
				qty = op.product_max_qty-prods
				reste = qty % op.qty_multiple
				if reste>0:
					qty += op.qty_multiple-reste
				newdate = DateTime.now() + DateTime.RelativeDateTime(days=op.product_id.seller_delay)
				proc_id = osv.osv_pools.get('mrp.procurement').create(cr, uid, {
					'name': 'OP:'+str(op.id),
					'date_planned': newdate.strftime('%Y-%m-%d'),
					'product_id': op.product_id.id,
					'product_qty': qty,
					'product_uom': op.product_uom.id,
					'location_id': op.warehouse_id.lot_input_id.id,
					'procure_method': 'make_to_order',
					'origin': 'OP:'+str(op.id)+':'+op.name
				})
				wf_service = netsvc.LocalService("workflow")
				wf_service.trg_validate(uid, 'mrp.procurement', proc_id, 'button_confirm', cr)
				wf_service.trg_validate(uid, 'mrp.procurement', proc_id, 'button_check', cr)
				osv.osv_pools.get('stock.warehouse.orderpoint').write(cr, uid, [op.id], {'procurement_id':proc_id})
		offset+=len(ids)
		cr.commit()
	cr.close()
	return {}


