##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# $Id: wizard_campaign_sms.py 918 2005-07-11 18:34:55Z ged $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import wizard
import netsvc

sms_send_form = '''<?xml version="1.0"?>
<form string="Send an SMS">
	<separator string="Header" colspan="4"/>
	<field name="campaign_id" colspan="3"/>
	<newline/>
	<field name="campaign_step_id"/>
	<field name="priority"/>
</form>'''

sms_send_fields = {
	'from': {'string':'From', 'type':'char', 'required':True},
	'on_error': {'string':'Error Return To', 'type':'char', 'required':True},
	'campaign_step_id': {'string':'Subject', 'type':'char', 'required':True},
	'priority': {'string':'Priority', 'type':'text', 'required':True}
}

#FIXME: ARGL... This is supposed to send a SMS, not an email... use sms_send method from tools
class wizard_send_sms(wizard.interface):
	def _sms_send(self, uid, datas):
		service = netsvc.LocalService("object_proxy")
		res = service.execute(uid, 'campaign.partner', 'read', datas['ids'], ['partner_id'])
		partners_id = map(lambda r: r['partner_id'][0], res)
		form = datas['form']
		nbr = service.execute(uid, 'res.partner', 'email_send', partners_id, form['from'], form['subject'], form['body'], form['on_error'])
		return {'sms_sent':nbr}

	states = {
		'init': {
			'actions': [],
			'result': {'type':'form', 'arch':sms_send_form, 'fields':sms_send_fields, 'state':[('send','Send SMS'), ('end','Cancel')]}
		},
		'send': {
			'actions': [_sms_send],
			'result': {'type':'state', 'state':'end'}
		}
	}
wizard_send_sms('campaign.partner.sms_send')


