##############################################################################
#
# Copyright (c) 2005 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: make_invoice.py 1070 2005-07-29 12:41:24Z nicoe $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import time
import wizard
import sql_db
import ir
from osv.osv import osv_pools, except_osv

delivery_form = """<?xml version="1.0"?>
<form string="Create deliveries">
	<separator colspan="4" string="Delivery Method" />
	<field name="carrier_id" />
</form>
"""

delivery_fields = {
	'carrier_id' : {'string':'Delivery Method', 'type':'many2one', 'relation': 'delivery.carrier','required':True}
}

def _delivery_default(wizard, uid, datas):
	cr = sql_db.db.cursor()
	order_obj = osv_pools.get('sale.order')
	order = order_obj.browse(cr, uid, datas['ids'])[0]
	if not order.state in ('draft'):
		raise except_osv('Order not in draft state !', 'The order state have to be draft to add delivery lines.')
	carrier_id = ir.ir_get(cr,uid,'meta','delivery.carrier',[('res.partner',order.partner_id.id)])[0][2]
	cr.commit()
	cr.close()
	return {'carrier_id':carrier_id}

def _delivery_set(wizard, uid, datas):
	cr = sql_db.db.cursor()
	order_obj = osv_pools.get('sale.order')
	line_obj = osv_pools.get('sale.order.line')
	order_objs = order_obj.browse(cr, uid, datas['ids'])
	for order in order_objs:
		total = 0
		weight = 0
		volume = 0
		dt = time.strftime('%Y-%m-%d')
		for line in order.order_line:
			total += line.price_subtotal or 0.0
			weight += (line.product_id.weight or 0.0) * line.product_qty
			volume += (line.product_id.volume or 0.0) * line.product_qty
			if line.date_planned > dt:
				dt = line.date_planned
		price = 0.0
		ok = False
		grid_id = osv_pools.get('delivery.carrier').grid_get(cr, uid, [datas['form']['carrier_id']],order.partner_shipping_id.id)
		if not grid_id:
			raise except_osv('No grid avaible !', 'No grid matching for this carrier !')
		grid = osv_pools.get('delivery.grid').browse(cr, uid, [grid_id])[0]
		for line in grid.line_ids:
			price_dict = {'price': total, 'volume':volume, 'weight': weight, 'wv':volume*weight}
			test = eval(line.type+line.operator+str(line.max_value), price_dict)
			if test:
				if line.price_type=='variable':
					price = line.list_price * price_dict[line.variable_factor]
				else:
					price = line.list_price
				ok = True
				break
		if not ok:
			raise except_osv('No price avaible !', 'No line matched this order in the choosed delivery grids !')
		line_obj.create(cr, uid, {
			'order_id': order.id,
			'name': grid.carrier_id.name,
			'product_qty': 1,
			'product_uom': grid.carrier_id.product_id.uom_id.id,
			'product_id': grid.carrier_id.product_id.id,
			'price_unit': price,
			'date_planned': dt,
			'tax_id': [lambda x: x.id for x in grid.carrier_id.product_id.taxes_id ],
			'type': 'make_to_stock'
		})

	cr.commit()
	cr.close()
	return {}

class make_delivery(wizard.interface):
	states = {
		'init' : {
			'actions' : [_delivery_default],
			'result' : {'type' : 'form', 'arch' : delivery_form, 'fields' : delivery_fields, 'state' : [('delivery', 'Create delivery line'), ('end', 'Cancel')]}
		},
		'delivery' : {
			'actions' : [_delivery_set],
			'result' : {'type' : 'state', 'state' : 'end'}
		},
	}
make_delivery("delivery.sale.order")
