##############################################################################
#
# Copyright (c) 2005 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: wizard_intracom.py 933 2005-07-13 07:09:26Z nicoe $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import wizard
import netsvc
import time

_journal_form = '''<?xml version="1.0"?>
<form string="IntraCom">
	<separator string="IntraCom" colspan="4"/>
	<field name="init_date"/>
	<newline/>
	<field name="end_date"/>
</form>'''

_journal_fields = {
	'init_date': {'string':'Starting Date', 'type':'date','default':lambda x,y,z: time.strftime('%Y-%m-%d'),'required':True},
	'end_date': {'string':'Ending Date', 'type':'date','default':lambda x,y,z: time.strftime('%Y-%m-%d'),'required':True}
}

class wiz_intracom(wizard.interface):
	states = {
		'init': {
			'actions': [],
			'result': {'type': 'form', 'arch':_journal_form, 'fields':_journal_fields, 'state':[('print','Print IntraCom'),('end','Cancel')]}
		},
		'print': {
			'actions': [],
			'result': {'type': 'print', 'report': 'account.intracom','state':'end'}
		}
	}
wiz_intracom('account.intracom');

