##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import os, time

import ir, netsvc, sql_db

from report.interface import report_rml

class report_custom(report_rml):
	def __init__(self, name, table, tmpl, xsl):
		report_rml.__init__(self, name, table, tmpl, xsl)

	def create(self, uid, ids, datas, context={}):
		service = netsvc.LocalService("object_proxy")
		cr = sql_db.db.cursor()
		new_ids = []
		for id in ids:
			lst_rec = ir.ir_get(cr, uid, 'meta', 'account.receivable', [('res.partner',id)], False, context)
			account_id = lst_rec[0][2]    # Result: [(id,name,value)]
			new_ids += service.execute(uid, 'account.move.line', 'search', [('account_id','=',account_id), ('partner_id','=',id), ('reconcile_id','=',False)])
		cr.close()
		
		return super(report_custom, self).create(uid, new_ids, datas, context)

report_custom('report.account.recall.receivable', 'account.move.line', 'addons/account/report/partner_receivable.xml', 'addons/account/report/partner_receivable.xsl')

