##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import time, os

import netsvc, sql_db

from report.interface import report_rml

#TODO: doesn't work with multiple print
class report_custom(report_rml):
	def __init__(self, name, table, tmpl, xsl):
		report_rml.__init__(self, name, table, tmpl, xsl)

	def create(self, uid, ids, datas, context):
		datas.setdefault('form', {})
		datas['form'].setdefault('init_amount', 0)
		datas['form'].setdefault('end_amount', 0)
		datas['form'].setdefault('init_date', time.strftime('%Y-%m-%d'))
		datas['form'].setdefault('end_date', time.strftime('%Y-%m-%d'))
		datas['form'].setdefault('title', 'Journal de caisse')

		service = netsvc.LocalService("object_proxy")

		cr = sql_db.db.cursor()
		cr.execute('select sum(amount) from account_move_line where account_id=%d and date<%s', (ids[0],datas['form']['init_date']))
		res = cr.fetchone()
		balance = 0
		if res:
			balance = res[0] or 0.0
		cr.close()
		
		datas['form']['balance'] = balance

		new_ids = service.execute(uid, 'account.move.line','search', [('date','>=', datas['form']['init_date']), ('date','<=',datas['form']['end_date']),('account_id','in',ids)])

		datas['model'] = 'account.move.line'
		datas['ids'] = new_ids
		del datas['id']

		return super(report_custom, self).create(uid, new_ids, datas, context)

report_custom('report.account.journal', 'account.move.line', 'addons/account/report/journal_caisse.xml', 'addons/account/report/journal_caisse.xsl')

