<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:import href="../../custom/corporate_defaults.xsl"/>
	<xsl:import href="../../base/report/rml_template.xsl"/>

	<xsl:template match="/">
		<xsl:call-template name="rml"/>
	</xsl:template>
	
	<!-- report specific "graphics" -->
	
	<xsl:template name="first_page_graphics_report">
		<setFont name="Helvetica" size="16"/>
		<drawCentredString x="105mm" y="28cm" t="1">COMPTE CLIENT - RAPPEL</drawCentredString>
	</xsl:template>
	
	<!-- stylesheet -->

	<xsl:template name="stylesheet">
		<paraStyle name="conditions" fontName="Helvetica" fontSize="8" alignment="justify"/>
		<paraStyle name="name" fontName="Helvetica-Bold"/>
		<blockTableStyle id="products">
			 <blockFont name="Helvetica-BoldOblique" size="13" start="0,0" stop="-1,0"/>
			 <blockBackground colorName="grey" start="0,0" stop="-1,0"/>
			 <blockTextColor colorName="white" start="0,0" stop="-1,0"/>
			 <blockValign value="TOP"/>
			 <blockAlignment value="LEFT" start="1,0" stop="1,-1"/>		<!-- desc (title included) aligned left -->
			 <blockAlignment value="RIGHT" start="-1,0" stop="-1,-1"/>	<!-- amounts (title included) aligned right -->
			 <blockAlignment value="RIGHT" start="1,-1" stop="1,-1"/>	<!-- solde aligned right -->
			 <lineStyle kind="LINEABOVE" colorName="black" start="0,-1" stop="-1,-1"/>
		</blockTableStyle>
	</xsl:template>

	<xsl:template name="story">
		<xsl:choose>
			<xsl:when test="count(//account-receivable)=0">
				<nextFrame/>
				<para t="1">Ce client ne necessite aucun rappel !</para>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="root"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="root">
		<xsl:apply-templates select="account-receivable"/>
	</xsl:template>

	<xsl:template match="account-receivable">
		<xsl:apply-templates select="account-receivable-to"/>
		<nextFrame/>

		<setNextTemplate name="other_pages"/>
		<para>
		<b t="1">Document</b>: <i t="1">Releve de Compte Client.</i>
		</para><para>
		<b t="1">Date</b>: <i><xsl:value-of select="date"/></i>
		</para>
		<spacer length="1cm" width="1mm"/>
		<para t="1">
			Cher client,
		</para>
		<spacer length="5mm" width="1mm"/>
		<xsl:if test="sum(account-receivable-body/transfer/trans-amount)&lt;0">
			<para t="1">
				Voici une sitation detaillee de votre compte. Il y a un solde
				de <xsl:value-of select="-total"/> EUR en votre faveur.
			</para>
		</xsl:if>
		<xsl:if test="sum(account-receivable-body/transfer/trans-amount)&gt;0">
			<para t="1">
				Voici le releve de votre compte en notre faveur.
				Pourriez-vous regulariser votre compte par un paiement de 
				<xsl:value-of select="format-number(sum(account-receivable-body/transfer/trans-amount), '#,##0.00')"/>
				EUR en notre faveur, dans les 7 jours ouvrables suivant la date de la presente.
				Merci de nous contacter en cas de litiges. Un non paiement
				peut entrainer la suspension de nos services.
			</para>
			<spacer length="0.2cm" width="1mm"/>
			<para t="1">
				Best regards,
			</para>
			<spacer length="0.2cm" width="1mm"/>
			<para>
				Caroline De Vuyst, Tiny sprl.
			</para><para>
				Tel: (+32).10.68.94.39
			</para>
		</xsl:if>
		<spacer length="1cm" width="1mm"/>
		<xsl:apply-templates select="account-receivable-body"/>
		<spacer length="0.5cm" width="1mm"/>
		<para style="conditions">
			<b t="1">Tout contrat conclu avec notre societe est exclusivement regi par nos
			conditions generales telles que libellees au verso du present document
			et/ou sur notre site internet.</b>
		</para>
		<setNextTemplate name="first_page"/>
		<pageBreak/>
	</xsl:template>

	<xsl:template match="account-receivable-to">
		<para style="name"><xsl:value-of select="contact/title"/><xsl:text> </xsl:text><xsl:value-of select="contact/name"/></para>
		<para><xsl:value-of select="corporation/name"/><xsl:text> </xsl:text><xsl:value-of select="corporation/type"/></para>
		<para><xsl:value-of select="contact/street"/></para>
		<para><xsl:value-of select="contact/street2"/></para>
		<para><xsl:value-of select="contact/zip"/><xsl:text> </xsl:text><xsl:value-of select="contact/city"/></para>
		<para><xsl:value-of select="contact/state"/></para>
		<para><xsl:value-of select="contact/country"/></para>
		<spacer length="0.4cm" width="1mm"/>
		<para><b t="1">VAT</b>: <xsl:value-of select="corporation/vat"/></para>
	</xsl:template>

	<xsl:template match="account-receivable-body">
		<blockTable colWidths="3cm,10.8cm,3.0cm" style="products">
		<tr>
			<td t="1">Date</td>
			<td t="1">Description</td>
			<td t="1">Amount</td>
		</tr>
		<xsl:apply-templates select="transfer"/>
		<tr>
			<td/>
			<td t="1">Balance:</td>
			<td><xsl:value-of select="format-number(sum(transfer/trans-amount), '#,##0.00')"/></td>
		</tr>
		</blockTable>
	</xsl:template>

	<xsl:template match="transfer">
		<tr>
			<td><xsl:value-of select="trans-date"/></td>
			<td><para><xsl:value-of select="trans-name"/></para></td>
			<td><xsl:value-of select="trans-amount"/></td>
		</tr>
	</xsl:template>

</xsl:stylesheet>
