<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:import href="../../custom/corporate_defaults.xsl"/>
	<xsl:import href="../../base/report/rml_template.xsl"/>
	
	<xsl:template match="/">
		<xsl:call-template name="rml"/>
	</xsl:template>

	<xsl:template name="stylesheet">
		<blockTableStyle id="accounts">
			<blockAlignment value="RIGHT" start="-1,0" stop="-1,-1"/>
			<lineStyle kind="LINEABOVE" start="-1,-2" stop="-1,-2"/>
		</blockTableStyle>

		<paraStyle name="conditions" fontName="Helvetica-Bold" fontSize="8" alignment="justify"/>
		<paraStyle name="name" fontName="Helvetica-Bold"/>
		<paraStyle name="title" fontName="Helvetica-Bold" fontSize="22" alignment="center"/>
		<blockTableStyle id="products-totals">
			<blockValign value="TOP"/>
			<blockAlignment value="RIGHT"/>
			<lineStyle kind="LINEABOVE" colorName="black" start="-1,0" stop="-1,0"/>

			<!-- total box -->
			<lineStyle kind="BOX" colorName="black" start="-1,-1" stop="-1,-1"/>
			<blockBackground colorName="(0.85,0.85,0.85)" start="-1,-1" stop="-1,-1"/>
		</blockTableStyle>
		<blockTableStyle id="products">
			 <blockFont name="Helvetica-BoldOblique" size="12" start="0,0" stop="-1,0"/>
			 <blockValign value="TOP"/>
			 <blockAlignment value="RIGHT" start="1,0" stop="-1,-1"/>
			 <lineStyle kind="LINEBELOW" colorName="black" start="0,0" stop="-1,0"/>
		</blockTableStyle>
	</xsl:template>

	<xsl:template name="story">
		<xsl:apply-templates select="invoice-list"/>
	</xsl:template>

	<xsl:template match="invoice-list">
		<xsl:apply-templates select="invoice"/>
	</xsl:template>

	<xsl:template match="invoice">
		<xsl:apply-templates select="invoice-to"/>
		<nextFrame/>
		<xsl:variable name="title">
			<xsl:choose>
				<xsl:when test="invoice-state='draft'">
					<xsl:text t="1">DRAFT</xsl:text>
				</xsl:when>
				
				<xsl:when test="invoice-state='proforma'">
					<xsl:text t="1">PRO-FORMA INVOICE</xsl:text>
				</xsl:when>
				
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="invoice-type='out_invoice'">
							<xsl:text t="1">INVOICE</xsl:text>
						</xsl:when>
						
						<xsl:when test="invoice-type='in_invoice'">
							<xsl:text t="1">PURCHASE INVOICE</xsl:text>
						</xsl:when>
						
						<xsl:when test="invoice-type='out_refund'">
							<xsl:text t="1">REFUND INVOICE</xsl:text>
						</xsl:when>
						
						<xsl:when test="invoice-type='in_refund'">
							<xsl:text t="1">PURCHASE REFUND INVOICE</xsl:text>
						</xsl:when>
					</xsl:choose>
					<xsl:text> </xsl:text>
					<xsl:value-of select="invoice-number"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<para style="title"><xsl:value-of select="$title"/></para>
		
		<spacer length="2cm" width="2mm"/>
		
		<setNextTemplate name="other_pages"/>
		
		<para>
			<b t="1">Document</b>: <i><xsl:value-of select="invoice-name"/></i>
		</para><para>
			<b t="1">Date</b>: <i><xsl:value-of select="invoice-date"/></i>
		</para><para>
			<b t="1">Order Ref.</b>: <i><xsl:value-of select="invoice-id"/></i>
		</para>
		<xsl:if test="invoice-number!=''">
			<para>
				<b t="1">Invoice Ref.</b>: <i><xsl:value-of select="invoice-number"/></i>
			</para>
		</xsl:if>
		
		<spacer length="1cm" width="1mm"/>
		
		<xsl:apply-templates select="invoice-lines"/>
		
		<spacer length="8mm"/>
		
		<para style="conditions" t="1">
			Ont t soumis  la taxe conformment au rgime particulier d'une imposition de la marge, TVA non dductible.
		</para>
		
		<spacer length="3mm"/>
		
		<para style="conditions" t="1">
			Tout contrat conclu avec notre socit est exclusivement rgi par nos conditions gnrales telles que libelles au verso du prsent document
			et/ou sur notre site internet.
		</para>

		<setNextTemplate name="first_page"/>
		<pageBreak/>
	</xsl:template>

	<xsl:template match="invoice-to">
		<para style="name">
			<xsl:value-of select="corporation/title"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="corporation/name"/>
		</para>
		<para>
			<xsl:value-of select="address/title"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="address/name"/>
		</para>
		<para><xsl:value-of select="address/street"/></para>
		<para><xsl:value-of select="address/street2"/></para>
		<para>
			<xsl:value-of select="address/postcode"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="address/city"/></para>
		<para><xsl:value-of select="address/state"/></para>
		<para><xsl:value-of select="address/country"/></para>
			<spacer length="0.4cm" width="1mm"/>
			<para>
				<b t="1">VAT</b>
				<xsl:text>: </xsl:text>
				<xsl:choose>
					<xsl:when test="corporation/vat != ''">
						<xsl:value-of select="corporation/vat"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>/</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</para>
	</xsl:template>

	<xsl:template match="invoice-lines">
		<blockTable colWidths="8cm,3cm,1.4cm,2.2cm,2.2cm" style="products">
			<tr>
				<td t="1">Description</td>
				<td/>
				<td t="1">Qty</td>
				<td t="1">Unit Price</td>
				<td t="1">Net Price</td>
			</tr>
			<xsl:apply-templates select="invoice-line"/>
		</blockTable>
		
		<spacer length="0.4cm" width="1mm"/>

		<blockTable colWidths="8cm,3cm,1.4cm,2.2cm,2.2cm" style="products-totals">
			<xsl:if test="count(tax-line)>0">
				<tr>
					<td t="1">SUBTOTAL</td>
					<td/>
					<td/>
					<td/>
					<td><xsl:value-of select="format-number(sum(invoice-line/price-subtotal), '#,##0.00')"/></td>
				</tr>
			</xsl:if>
			<xsl:apply-templates select="tax-line"/>
			<tr>
				<td t="1">TOTAL</td>
				<td/>
				<td/>
				<td/>
				<td><xsl:value-of select="format-number(sum(invoice-line/price-subtotal)+sum(tax-line/amount), '#,##0.00')"/></td>
			</tr>
		</blockTable>
	</xsl:template>

	<xsl:template match="invoice-line">
		<tr>
			<td><para><xsl:value-of select="product"/></para></td>
			<td><para><xsl:apply-templates select="taxes"/></para></td>
			<xsl:choose>
				<xsl:when test="quantity>1">
					<td><xsl:value-of select="quantity"/></td>
					<td><xsl:value-of select="price-unit"/></td>
				</xsl:when>
				<xsl:otherwise>
					<td/>
					<td/>
				</xsl:otherwise>
			</xsl:choose>
			<td><xsl:value-of select="format-number(price-unit * quantity, '#,##0.00')"/></td>
		</tr>
	</xsl:template>

	<xsl:template match="taxes">
		<xsl:value-of select="taxe"/><xsl:text> </xsl:text>
	</xsl:template>

	<xsl:template match="tax-line">
		<tr>
			<td><xsl:value-of select="name"/></td>
			<td/>
			<td/>
			<td/>
			<td><xsl:value-of select="format-number(amount, '#,##0.00')"/></td>
		</tr>
	</xsl:template>

</xsl:stylesheet>
