<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="../../custom/corporate_defaults.xsl"/>
	<xsl:import href="../../base/report/rml_template.xsl"/>

	<xsl:template name="first_page_graphics_corporation"></xsl:template>
	<xsl:template name="first_page_frames">
		<frame id="main" x1="1cm" y1="7cm" width="19.0cm" height="22.0cm"/>
	</xsl:template>

	<xsl:template match="/">
		<xsl:call-template name="rml"/>
	</xsl:template>

	<xsl:template name="stylesheet">
		<blockTableStyle id="cadre">
			<blockAlignment value="CENTRE" start="0,0" stop="-1,-1" />
			<lineStyle kind="BOX" start="0,0" stop="-1,-1" colorName="black" />
			<blockValign value="TOP" start="0,0" stop="-1,-1" />
		</blockTableStyle>
		<blockTableStyle id="cadre1">
			<blockAlignment value="CENTRE" start="0,0" stop="-1,-1" />
			<lineStyle kind="GRID" start="0,0" stop="-1,-1" colorName="black" />
			<blockValign value="TOP" start="0,0" stop="-1,-1" />
		</blockTableStyle>
		<blockTableStyle id="cadresize">
			<blockAlignment value="CENTRE" start="0,0" stop="-1,-1" />
			<blockFont size="4" name="Helvetica" start="0,0" stop="-1,-1" />
		</blockTableStyle>
		<blockTableStyle id="align_top">
			<blockValign value="TOP" start="0,0" stop="-1,-1" />
		</blockTableStyle>
		<blockTableStyle id="cadre2">
			<blockAlignment value="CENTRE" start="0,0" stop="-1,-1" />
			<lineStyle kind="GRID" start="0,0" stop="0,0" colorName="black" />
			<lineStyle kind="GRID" start="2,0" stop="2,0" colorName="black" />
			<lineStyle kind="GRID" start="4,0" stop="4,0" colorName="black" />
		</blockTableStyle>
		<blockTableStyle id="inner_cadre2">
			<blockAlignment value="CENTRE" start="0,0" stop="-1,-1" />
			<lineStyle kind="GRID" start="0,0" stop="-1,-1" colorName="black" />
		</blockTableStyle>
		<blockTableStyle id="cadre3">
			<blockAlignment value="CENTRE" start="0,0" stop="-1,-1" />
			<lineStyle kind="GRID" start="0,0" stop="-1,-1" colorName="black" />
		</blockTableStyle>
		<paraStyle name="titre" fontName="Helvetica-Bold" fontSize="18" alignment="center"/>
		<paraStyle name="small" fontName="Helvetica" fontSize="6"/>
	</xsl:template>

	<xsl:template name="story">
		<xsl:apply-templates select="intracom"/>
	</xsl:template>

	<xsl:template match="intracom">
		<para style="titre">
			TAXE SUR LA VALEUR AJOUTEE
		</para>
		<spacer length="0.5cm" width="3mm"/>
		<blockTable style="cadre1" colWidths="19cm">
			<tr>
				<td>
					RELEVÉ TRIMESTRIEL À LA T.V.A. DES LIVRAISONS INTRACOMMUNAUTAIRES EXEMPTÉES 
				</td>
			</tr>
			<tr>
				<td>
					<blockTable colWidths="5cm,14cm">
						<tr>
							<td>
								N° de T.V.A. du déclarant:
							</td>
							<td>
								<blockTable style="align_top"
									colWidths="1cm,5cm,0.6cm,1.8cm,2cm,0.6cm,2cm">
									<tr>
										<td>
											<blockTable style="cadre"
												colWidths="0.7cm">
												<tr>
													<td>BE</td>
												</tr>
											</blockTable>
										</td>
										<td>
											<blockTable style="cadre"
												colWidths="4.5cm">
												<tr>
													<td></td>
												</tr>
											</blockTable>
										</td>
										<td>(1)</td>
										<td>Période</td>
										<td>
											<blockTable style="cadre"
												colWidths="1.5cm">
												<tr>
													<td></td>
												</tr>
											</blockTable>
										</td>
										<td>/</td>
										<td>
											<blockTable style="cadre"
												colWidths="2cm">
												<tr>
													<td></td>
												</tr>
											</blockTable>
										</td>
									</tr>
								</blockTable>
							</td>
						</tr>
						<tr>
							<td>
								<blockTable colWidths="1.5cm,2cm,1.5cm">
									<tr>
										<td>Page (2)</td>
										<td>
											<blockTable style="cadre"
												colWidths="1.5cm">
												<tr>
													<td></td>
												</tr>
											</blockTable>
										</td>
										<td>sur (3)</td>
									</tr>
								</blockTable>
							</td>
							<td>
								<blockTable style="cadresize" colWidths="3cm,11cm">
									<tr>
										<td>
											<blockTable style="cadre"
												colWidths="1.5cm">
												<tr>
													<td></td>
												</tr>
											</blockTable>
										</td>
										<td>
											<para style="small">(1) A completer obligatoirement
												sur chaque feuille du releve</para>
											<para style="small">(2) Les pages doivent être
												numérotées de manière ininterompue
												la première page du relevé porte le
												numéro 001</para>
											<para style="small">(3) Indiquer ici le nombre total
												de page du releve</para>
										</td>
									</tr>
								</blockTable>
							</td>
						</tr>
					</blockTable>
				</td>
			</tr>
		</blockTable>
		<spacer length="0.2cm" width="3mm"/>
		<para>
			CADRE I : A COMPLETER UNIQUEMENT A LA PREMIERE PAGE DU RELEVE
		</para>
		<spacer length="0.2cm" width="3mm"/>
		<blockTable style="cadre" colWidths="9.5cm,9.5cm" rowHeights="4cm,4cm">
			<tr>
				<td>
					<para>Nom et adresse du déclarant:</para>
				</td>
				<td>
					<blockTable style="align_top" colWidths="7cm">
						<tr>
							<td>
								ATTENTION : Si le relevé comprend plusieurs feuilles
								elles ne peuvent être attachées.
								Le feuilles doivent être rangées par numéro de
								feuille croissant.
							</td>
						</tr>
						<tr>
							<td>
								<blockTable style="align_top"
									colWidths="1cm,0.2cm,1cm,0.1cm,1cm,0.1cm,1cm">
									<tr>
										<td>Date :</td>
										<td></td>
										<td></td>
										<td></td>
										<td></td>
										<td></td>
										<td></td>
									</tr>
								</blockTable>
							</td>
						</tr>
					</blockTable>
				</td>
			</tr>
			<tr>
				<td>
					<para>Nom, qualité et numéro de téléphone dur (des)
						signataire(s)</para>
				</td>
				<td>
					<blockTable style="cadre" colWidths="9cm" rowHeights="3.5cm">
						<tr>
							<td>
								<para>
									Signature(s): CERTIFIE SINCERE ET VERITABLE
								</para>
							</td>
						</tr>
					</blockTable>
				</td>
			</tr>
		</blockTable>
		<spacer length="0.2cm" width="3mm"/>
		<para>
			CADRE II : RESERVE A L'ADMINISTRATION
		</para>
		<spacer length="0.2cm" width="3mm"/>
		<blockTable style="cadre" colWidths="5cm,3cm,3cm,3cm,5cm">
			<tr>
				<td>
					<blockTable style="cadre2" colWidths="1cm,0.1cm,0.5cm,0.1cm,0.5cm">
						<tr>
							<td></td>
							<td></td>
							<td></td>
							<td></td>
							<td></td>
						</tr>
						<tr>
							<td></td>
							<td></td>
							<td>Date de réception</td>
							<td></td>
							<td></td>
						</tr>
					</blockTable>
				</td>
				<td>
					<blockTable style="cadre2" colWidths="1cm">
						<tr>
							<td>E</td>
						</tr>
						<tr>
							<td>Monnaie</td>
						</tr>
					</blockTable>
				</td>
				<td>
					<blockTable style="cadre2" colWidths="1.5cm">
						<tr>
							<td></td>
						</tr>
						<tr>
							<td>Nombre de pages</td>
						</tr>
					</blockTable>
				</td>
				<td>
					<blockTable style="cadre2" colWidths="1.5cm">
						<tr>
							<td></td>
						</tr>
						<tr>
							<td>A/B/R</td>
						</tr>
					</blockTable>
				</td>
				<td>
					<blockTable style="cadre2" colWidths="1cm,0.1cm,0.5cm,0.1cm,0.5cm">
						<tr>
							<td></td>
							<td></td>
							<td></td>
							<td></td>
							<td></td>
						</tr>
						<tr>
							<td></td>
							<td></td>
							<td>Date de traitement</td>
							<td></td>
							<td></td>
						</tr>
					</blockTable>
				</td>
			</tr>
		</blockTable>
		<spacer length="0.2cm" width="3mm"/>
		<para>
			CADRE III : RELEVE DES CLIENTS
		</para>
		<spacer length="0.2cm" width="3mm"/>
		<blockTable style="cadre3" colWidths="1cm,7cm,1cm,7cm,1cm,2cm">
			<tr>
				<td>N°</td>
				<td>Code pays et numéro de T.V.A. du client</td>
				<td>Code</td>
				<td>Montant en euro</td>
				<td>Tri.</td>
				<td>Année</td>
			</tr>
			<xsl:for-each select="customer">
				<xsl:sort select="id" />
				<xsl:variable name="lastId" select="id" />
				<xsl:if test="not(preceding-sibling::customer[id=$lastId])">
					<tr>
						<td>
							<xsl:value-of select="1+count(preceding-sibling::customer[id=$lastId])" />
						</td>
						<td>
							<xsl:value-of select="vat/country" />
							<xsl:text> </xsl:text>
							<xsl:value-of select="vat/number" />
						</td>
						<td><xsl:text> </xsl:text></td>
						<td>
							<xsl:value-of select="sum(//customer[id=$lastId]/amount)" />
						</td>
						<td>
							<xsl:value-of select="/intracom/date/quarter" />
						</td>
						<td>
							<xsl:value-of select="/intracom/date/year" />
						</td>
					</tr>
				</xsl:if>
			</xsl:for-each>
		</blockTable>
	</xsl:template>

</xsl:stylesheet>
