##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

from osv import fields
from osv import osv

#
# Model definition
#
class account_project(osv.osv):
	_name = "account.project"
	def _project_rate(self, cr, uid, ids, prop, unknow_none,context={}):
		projects = self.browse(cr, uid, ids)
		project_rate = {}
		def list_project_ids(project):
			return [project.id] + reduce(lambda x,y:x+list_project_ids(y), project.child_ids, [])

		for project in projects:
			project_rate[project.id] = {}
			project_rate[project.id][project.id] = 1.0
			def set_rate_for_parent(project, project_rate, root):
				root['without_project'] = project
				if project.parent_id:
					project_childs = project.parent_id.child_ids
					#only childs who are parent of the root project are different from 1.0
					childs_rate = map(lambda x : project_rate.get(x.id, 1.0), project_childs)
					childs_ventilation_total = reduce(lambda x,y : x+y, map(lambda x : x.ventilation, project_childs), 0)
					if project.parent_id.ventilation_type == 'fix':
						project_rate[project.parent_id.id] = reduce(lambda x,y:x*y,  childs_rate, 1.0) * project.ventilation/childs_ventilation_total
					elif project.parent_id.ventilation_type == 'qty':
						total = 0.0
						moves_count = {}
						for child in project_childs:
							cr.execute("SELECT id FROM account_move where project_id in (%s)"% ','.join(map(lambda x : str(x), list_project_ids(child))))
							moves_count[child.id] = len(cr.fetchall())
							total = total + moves_count[child.id]
						if total:
							project_rate[project.parent_id.id] = moves_count[project.id] / (total or 1.0)
						else:
							project_rate[project.parent_id.id] = 1.0 / len(project_childs)
					elif project.parent_id.ventilation_type == 'val':
						for child in project_childs:
							print ','.join(map(lambda x : str(x), list_project_ids(child)))
							cr.execute("SELECT COALESCE(SUM(l.amount*a.sign),0) FROM account_account a LEFT JOIN account_move_line l ON (a.id=l.account_id) LEFT JOIN account_move m ON (m.id=l.move_id) WHERE m.project_id in (%s) GROUP BY m.project_id"% ','.join(map(lambda x : str(x), list_project_ids(child))))
							print cr.fetchall()
						pass
					set_rate_for_parent(project.parent_id, project_rate, root)
			def set_rate_for_childs(project, project_rate):
				if len(project.child_ids):
					for child_project in project.child_ids:
						project_rate[child_project.id] = 1.0
						set_rate_for_childs(child_project, project_rate)

			root = {}
			set_rate_for_parent(project, project_rate[project.id], root)
			set_rate_for_childs(project, project_rate[project.id])
			#acount move without 
			project_rate[project.id][None] = root['without_project'].ventilation
		return project_rate 

	_columns = {
		'name': fields.char('Name',size=64, required=True),
		'description': fields.text('Description'),
		'parent_id': fields.many2one('account.project', 'Parent Project'),
		'child_ids': fields.one2many('account.project', 'parent_id', 'Childs Projects'),
		'project_rate': fields.function(_project_rate, method=True, string='Project ?rate?'),
		'ventilation_type': fields.selection([('fix', 'fixe'), ('qty','Quantity')], 'ventilation type', required=True),
		'ventilation': fields.float('ventilation pourcentage'),
	}
	_defaults = {
		'ventilation_type': lambda *a: 'fix',
		'ventilation': lambda *a: 0.0,
	}

	def name_get(self, cr, uid, ids, context={}):
		if not len(ids):
			return []
		reads = self.read(cr, uid, ids, ['name','parent_id'], context)
		res = []
		for record in reads:
			name = record['name']
			if record['parent_id']:
				name = record['parent_id'][1]+' / '+name
			res.append((record['id'], name))
		return res

account_project()
