##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import gtk
import gobject
from xml.parsers import expat

import rpc
import gettext
import parse
from modules.gui.window import win_search

import copy

import time
import re
from sets import Set as set

class MyTreeView(gtk.TreeView):

	def __init__(self, parent, fields):
		super(MyTreeView, self).__init__()
		self.set_property('enable-search', False)
		self.connect_after('move-cursor', self._doMove)
		self.fields = fields
		self.ancestor = parent

	def on_quit_cell(self, path, idx, value):
		model = self.get_model()
		col0 = model.get_value(model.get_iter(path), 0)
		column = self.ancestor.fields_order[idx-1]
		if isinstance(value, tuple):
			val = value[0]
		else:
			val = value
		if self.ancestor.fields[column].get('change_default', False):
			res = rpc.session.rpc_exec_auth('/object', 'execute', 'ir.values', 'get', 'default', '%s=%s' % (column, val), [(self.ancestor.robject_name,False)], False, rpc.session.context)
			for id, name, value in res:
				col0[name] = value
				model.set_value(model.get_iter(path), self.ancestor.fields_order.index(name)+1, value)
		self.on_change(path, column, col0)

	def on_change(self, path, column, values):
		model = self.get_model()
		query = self.ancestor.on_change[column]
		if query:
			try:
				# split the query in two parts: the function name and the arguments
				res = re.compile('(.*)\((.*)\)').match(query)
				if not res:
					raise 'ERROR: Wrong on_change trigger: fnc(*args)'
				func_name = res.group(1)
				arg_names = [n.strip() for n in res.group(2).split(',')]

				# for each argument, get its value
				args = []
				for name in arg_names:
					if self.ancestor.is_relation_column(self.ancestor.fields_order.index(name)+1):
						if values[name]:
							args.append(values[name][0])
						else:
							args.append(False)
					else:
						args.append(values[name])
				# execute the onchange method on the server
				res2 = rpc.session.rpc_exec_auth('/object', 'execute', self.ancestor.robject_name, func_name, False, *args)
				print res2
				
				# Update the tree
				for idx, field in enumerate(self.ancestor.fields_order):
					if field in res2.get('value', {}):
						if self.ancestor.is_relation_column(self.ancestor.fields_order.index(field)+1):
							remote = self.ancestor.fetch_remote_fields({field : res2['value'][field]})
							values[field] = remote[field].items()[0]
							model.set_value(model.get_iter(path), idx+1, values[field][1])
						else:
							values[field] = res2['value'][field]
							model.set_value(model.get_iter(path), idx+1, values[field])

			except rpc.rpc_exception, e:
				pass

	def get_value(self, path, column, value):
		model = self.get_model()
		col0 =  model.get_value(model.get_iter(path), 0)
		if column not in col0['__modified']:
			return False, col0[self.ancestor.fields_order[column-1]]
		elif self.ancestor.is_relation_column(column):
			if column in col0['__edited']:
				if value:
					val = self.ancestor.get_remote(self.fields[column-1], value)
				else:
					return True, False
				col0['__edited'].remove(column)
			else:
				val = col0[self.ancestor.fields_order[column-1]]
			if val:
				return True, val
			else:
				return False, col0[self.ancestor.fields_order[column-1]]
		elif self.ancestor.is_bool_column(column):
			return True, value != '0'
		else:
			ctype = model.get_column_type(column)
			if ctype == gobject.TYPE_FLOAT:
				if not value:
					val = 0
				else:
					val = float(value)
			elif ctype == gobject.TYPE_INT:
				val = int(value)
			else:
				val = value
			if column in col0['__edited']:
				col0['__edited'].remove(column)
			return True, val

	def save_val(self, path, column, value):
		model = self.get_model()
		col0 = model.get_value(model.get_iter(path), 0)
		if self.ancestor.is_relation_column(column) and value is not False:
			col0[self.fields[column-1]] = value
			model.set_value(model.get_iter(path), column, value[1])
		elif self.ancestor.is_relation_column(column) and value is  False:
			col0[self.fields[column-1]] = False
			model.set_value(model.get_iter(path), column, '')
		elif self.ancestor.is_date_column(column) and value == '':
			col0[self.fields[column-1]] = False
		elif self.ancestor.is_bool_column(column):
			col0[self.fields[column-1]] = int(value)
			model.set_value(model.get_iter(path), column, str(int(value)))
		else:
			col0[self.fields[column-1]] = value
			model.set_value(model.get_iter(path), column, value)

	def set_modified(self, path, column):
		model = self.get_model()
		col0 = model.get_value(model.get_iter(path), 0)
		col0.setdefault('__modified', set()).add(column)
		col0.setdefault('__edited', set()).add(column)

	def _doMove(self, treeview, step, count, *args):
		path, focus = self.get_cursor()
		self.edit_line(path, focus)
		return True

	def edit_line(self, path, column=None):
		if column is None:
			column = self.get_columns()[1]
		model = self.get_model()
		col0 = model.get_value(model.get_iter(path), 0)
		self.set_cursor(path, column, True)
		if 'id' not in col0 or not col0['id']:
			msg = _('Editing new document')
		else:
			msg = _('Editing document: %s') % col0['id']
		if self.ancestor.isform:
			self.ancestor.state_callback(msg)

	def __find_next_column(self, col, way=1):
		columns = self.get_columns()
		ncol = col
		for a in range(len(columns)):
			ncol = ncol + way * a
			if 'readonly' not in self.ancestor.fields[self.ancestor.fields_order[ncol-1]]:
				break
		return self.get_column(ncol)
			
	def cursor_changed(self, entry, event):
		path, column = self.get_cursor()
		old_path = path
		columns = self.get_columns()
		current_column = columns.index(column)
		model = self.get_model()
		col0 = model.get_value(model.get_iter(path), 0)
		modified = col0.get('__modified', False)
		new_line = 'id' not in col0
		if event.keyval == gtk.keysyms.Down:
			if modified:
				valid, value = self.get_value(path, current_column, entry.get_text())
				self.save_val(path, current_column, value)
				self.ancestor.save_me(col0)
			if new_line and self.ancestor.unvalid(col0):
				pass
			elif self.ancestor.create_new == 'bottom' and len(model) == path[0]+1:
				self.ancestor.create_line()
				old_path, path = path, len(self.get_model()) - 1
			else:	
				old_path, path = path, (path[0] + 1) % len(self.get_model()),
		elif event.keyval == gtk.keysyms.Up:
			if modified:
				valid, value = self.get_value(path, current_column, entry.get_text())
				self.save_val(path, current_column, value)
				self.ancestor.save_me(col0)
			if new_line and self.ancestor.unvalid(col0):
				pass
			elif self.ancestor.create_new == 'top' and path[0] == 0:
				self.ancestor.create_line()
				old_path, path = path, 0
			else:
				old_path, path = path, (path[0] - 1) % len(self.get_model()),
		elif event.keyval == gtk.keysyms.Tab:
			if modified:
				valid, value = self.get_value(path, current_column, entry.get_text())
				if valid:
					self.save_val(path, current_column, value)
			column = self.__find_next_column(current_column % (len(columns)-1) + 1)
		elif event.keyval == gtk.keysyms.ISO_Left_Tab:
			if modified:
				valid, value = self.get_value(path, current_column, entry.get_text())
				if valid:
					self.save_val(path, current_column, value)
			column = self.__find_next_column((current_column-2) % (len(columns)-1) + 1, - 1)
		elif event.keyval in (gtk.keysyms.Return, gtk.keysyms.KP_Enter):
			if not self.ancestor.isform:
				return False
			if current_column not in col0['__edited']:
				value = col0[self.ancestor.fields_order[current_column-1]]
				self.ancestor.save_me(col0)
				column = self.get_column(1)
				self.ancestor.create_line()
				if self.ancestor.create_new == 'top':
					old_path, path = path, 0
				elif self.ancestor.create_new == 'bottom':
					old_path, path = path, len(self.get_model()) - 1
			elif current_column in col0['__modified']:
				valid, value = self.get_value(path, current_column, entry.get_text())
				if valid:
					self.save_val(path, current_column, value)
					self.ancestor.save_me(col0)
					column = self.get_column(1)
					self.ancestor.create_line()
					if self.ancestor.create_new == 'top':
						old_path, path = path, 0
					elif self.ancestor.create_new == 'bottom':
						old_path, path = path, len(self.get_model()) - 1
		elif event.keyval == gtk.keysyms.Escape:
			if new_line:
				if self.ancestor.isform:
					self.ancestor.message_callback("")
				model = self.get_model()
				model.remove(model.get_iter(path))
				for line in model:
					line[0]['__idx'] -= 1
#					self.ancestor.ids[line[0]['__idx']] = line[0]['id']
				if self.ancestor.create_new == 'bottom' :
					path = len(model) - 1
				else:
					path = 0
			else:
				return False
		elif event.keyval == gtk.keysyms.F1:
			pass
#			valid, value = self.get_value(current_column, entry.get_text())
#			if valid:
#				self.save_val(path, current_column, value[1], value[0])
		elif event.keyval == gtk.keysyms.F2:
			pass
#			valid, value = self.get_value(current_column, entry.get_text())
#			if valid:
#				self.save_val(path, current_column, value[1], value[0])

		if event.keyval in (gtk.keysyms.Down, gtk.keysyms.Up, gtk.keysyms.Tab, gtk.keysyms.ISO_Left_Tab, gtk.keysyms.Return, gtk.keysyms.KP_Enter ):
			if modified:
				self.on_quit_cell(old_path, current_column, value)
			self.edit_line(path, column)
			return True
		elif event.keyval == gtk.keysyms.Escape:
			self.edit_line(path, column)
			return True
		elif event.keyval in (gtk.keysyms.Shift_R, gtk.keysyms.Shift_L):
			return False
		else:
			self.set_modified(path, current_column)
			return False

def filterKey(renderer, editable, position, treeview):
	editable.connect('key_press_event', treeview.cursor_changed)

def many2one_sel(*args):
	context = {}
	context.update(rpc.session.context)
	
	if len(args)==7:
		sel_multi = args[6]
	else:
		sel_multi = False

	ids = rpc.session.rpc_exec_auth('/object', 'execute', args[0], 'name_search', args[1], [], 'ilike', context)
	if len(ids)==1:
		if sel_multi:
			res = [id[0] for id in ids]
		else:
			res = [ids[0][0]]
	else:
		res = rpc.session.rpc_exec_auth('/object', 'execute', args[0], 'fields_view_get', False, 'form', rpc.session.context)
		win = win_search.win_search(args[0], res, {'name':args[1]}, [], sel_multi=sel_multi, preload=True, ids=map(lambda x:x[0], ids), context=context)
		res = win.go()
		
	if res:
		res2 = rpc.session.rpc_exec_auth('/object', 'execute', args[0], 'name_get', res, context)
		if sel_multi:
			return res2
		return res2[0]
	return None

class tree(object):
	def __init__(self, xml, fields, model=None, triggers=[], parent=None, state="draft", sel_multi=False, search=False):
		self.issearch = search
		self.context = {}
		self.isform = False
		p = parse.parse(fields)
		p.parse(xml)
		self.editable = not self.issearch and p.editable
		self.create_new = p.create_new

		self.refresh = p.refresh
		if self.editable:
			self.widget = MyTreeView(self, p.fields_order)
			self.on_change = p.on_change
		else:
			self.widget = gtk.TreeView()
		self.widget.set_reorderable(True)

		if not sel_multi:
			selection_mode = 'single'
		else:
			selection_mode = gtk.SELECTION_MULTIPLE
		self.widget.get_selection().set_mode(selection_mode)

		self.robject_name = model
		self.fields = fields
		self.sort_col = False
		self.ids = {}

		p.build_widget(self.widget)
		self.name = p.title
		self.fields_order=p.fields_order
		self.colors={}
		if p.colors:
			self.colors=dict(map(lambda x: x.split(':'), p.colors.split(';')))

		self.widget.set_expander_column(self.widget.get_column(1))
		self.widget.set_headers_visible(True)

		types=[ gobject.TYPE_PYOBJECT ]
		float_digits = []
		for x in self.fields_order:
			types.append( fields_list_type.get(fields[x]['type'], gobject.TYPE_STRING))
			if fields_list_type.get(fields[x]['type']) == gobject.TYPE_FLOAT:
				float_digits.append(fields[x].get('digits',  [0,2]))
			float_digits.reverse()
		types.append( gobject.TYPE_STRING )
		self.model = gtk.ListStore(*types)
		self.widget.set_model(self.model)

		def render_format(format):
			def render_float(column, cell, model, iter):
				origstr = cell.get_property('text')
				sizestr = format % (float(origstr),)
				cell.set_property('text', sizestr)
			return render_float

		for i in range(len(types)-1):
			col = self.widget.get_column(i)
			renderer = col.get_cell_renderers()[0]
			if self.editable: 
				renderer.set_property('editable', True)
				renderer.connect_after('editing-started', filterKey, self.widget)
			if types[i] == gobject.TYPE_FLOAT:
				form= "%." + str(float_digits.pop()[1]) + "f"
				col.set_cell_data_func(renderer, render_format(form))
			col.add_attribute(renderer, 'foreground', len(types)-1)

		self.widget.get_column(0).set_visible(False)
		for i in range(len(types)-1):
			col = self.widget.get_column(i)
			col.set_sort_column_id(i)
			col.set_reorderable(True)
			col.set_clickable(True)
		self.widget.show_all()

	def _func_sel_get(self, *args):
		pos = int(args[0].get_value(args[2], 0)['__idx'])
		if pos in self.ids:
			args[3].append(self.ids[pos])

	def sel_ids_get(self):
		sel = self.widget.get_selection()
		ids = []
		sel.selected_foreach(self._func_sel_get, ids)
		return ids

	def sel_id_get(self):
		return self.ids.get(self.pos_get(), False)

	def pos_get(self):
		sel = self.widget.get_selection().get_selected()
		if sel:
			model, iter = sel
			if not iter:
				return None
			pos = model.get_value(iter,0)
			return int(pos['__idx'])
		return None

	def get_modified_rows(self):
		modified  = []
		for row in self.model:
			if '__modified' in row[0] and row[0]['__modified']:
				modified.append(row[0]['__idx'])
		return modified

	def get_row(self, idx):
		row = copy.copy(self.model[idx][0])
		if '__edited' in row:
			del row['__edited']
		if '__modified' in row:
			del row['__modified']
		if '__idx' in row:
			del row['__idx']
		for field in row:
			if isinstance(row[field], (list, tuple)):
				row[field] = row[field][0]
		return row

	def fetch_remote_fields(self, res):
		result = {}
		for field in [f for f in res if not f.startswith('__') and f in self.fields]:
			if self.fields[field]['type'] in ('many2one', 'one2one') and isinstance(res[field], int):
				ids = [res.get(field, '')]
			elif self.fields[field]['type'] in ('one2many', 'many2many'):
				if res[field] and isinstance(res[field][0], tuple):
					ids = [t[1] for t in res[field]]
				else:
					ids = res[field]
			else:
				ids = []
			ids = filter(None, ids)
			if ids:
				result[field] = dict(rpc.session.rpc_exec_auth('/object', 'execute', self.fields[field]['relation'], 'name_get', ids))
		return result

	def construct_line(self, res, line, remote_fields={}):
		line[0]['__edited'] = set()
		if 'id' not in line[0] and '__modified' not in line[0]:
			line[0]['__modified'] = set()
			line[0]['__modified'].add(0)

		for field in self.fields_order:
			col_val = res.get(field, False)
			to_show = 0

			if not col_val:
				line[0][field] = False
				if self.fields[field]['type'] in ('integer', 'float'):
					line.append(0)
				elif self.fields[field]['type'] == 'boolean':
					line.append('0')
					line[0][field] = 0
				else:
					line.append('')
				continue
			if self.fields[field]['type'] in ('char', 'selection', 'integer', 'float', 'date', 'datetime', 'boolean'):
				to_show = col_val
			elif self.fields[field]['type'] == 'many2one':
				if isinstance(col_val, int):
					to_show = remote_fields[field][col_val]
					line[0][field] = [col_val, to_show]
				elif isinstance(col_val, (list, tuple)):
					to_show = col_val[1]
			
			elif self.fields[field]['type'] in ('one2many', 'many2many'):
				to_show = ','.join([remote_fields[field].get(x, '') for x in col_val])
				line[0][field] = [col_val, to_show]
			
			line.append(to_show)

		for field in [f for f in res if f not in self.fields_order and isinstance(res[f], (list, tuple))]:
			if len(res[field]) == 2:
				line[0][field] = res[field]
			else:
				line[0][field] = [res[field], '']

		color = 'black'
		for col in self.colors:
			res2 = copy.copy(res)
			res2['current_date'] = time.strftime('%Y-%m-%d')
			if eval(self.colors[col], res2):
				color = col
		line.append(color)

	def add_line(self, res, remote_fields={}, where='bottom', modification=False):
		vals = [res]
		if not remote_fields:
			remote_fields = self.fetch_remote_fields(res)

		if modification:
			res['__modified'] = set([0])
		self.construct_line(res, vals, remote_fields)


		if where == 'top':
			res['__idx'] = 0
			self.model.prepend(vals)
		else:
			res['__idx'] = len(self.model)
			self.model.append(vals)

		if self.isform:
			msg = _('Editing new document')
			self.state_callback(msg)

	def create_line(self):
		path, column = self.widget.get_cursor()
		if path is None or 'id' in self.model.get_value(self.model.get_iter(path), 0):
			def_val = self.get_default()
			if self.create_new == 'bottom':
				nidx = len(self.model)
			elif self.create_new == 'top':
				nidx = 0
				for row in self.model:
					row[0]['__idx'] += 1
					self.ids[row[0]['__idx']] = row[0]['id']
			self.ids[nidx] = False
			self.add_line(def_val, where=self.create_new)
	
	def get_default(self, context={}):
		self.context.update(rpc.session.context)
		defaults = rpc.session.rpc_exec_auth('/object', 'execute', self.robject_name, 'default_get', self.fields.keys(), self.context)
		defaults['__modified'] = set([self.fields_order.index(name)+1 for name, value in defaults.items() if value is not False])
		return defaults

	def _value_get(self):
		return []

	def _value_set(self, val):
		self.model.clear()
		to_change = {}
		if val:
			for field in [f for f in val[0] if f in self.fields]:
				if self.fields[field]['type'] in ('many2one', 'one2one'):
					ids = [v.get(field, '') for v in val if isinstance(v[field], int)]
				elif self.fields[field]['type'] in ('one2many', 'many2many'):
					ids = []
					for v in val:
						if v[field] and isinstance(v[field][0], tuple):
							ids += [t[1] for t in v[field]]
						else:
							ids += v[field]
				else:
					ids = []
				ids = filter(None, ids)
				if ids:
					values = dict(rpc.session.rpc_exec_auth('/object', 'execute', self.fields[field]['relation'], 'name_get', ids))
					to_change[field] = values
		for res in val:
			nidx = len(self.model)
			self.ids[nidx] = res.get('id', False)
			res['__idx'] = nidx
			res['__modified'] = set()
			self.add_line(res, to_change)


	value = property(_value_get, _value_set, None,
	  'The content of the widget or ValueError if not valid')

	def is_relation_column(self, column):
		return self.fields[self.fields_order[column-1]]['type'] == 'many2one'

	def is_bool_column(self, column):
		return self.fields[self.fields_order[column-1]]['type'] == 'boolean'

	def is_date_column(self, column):
		return self.fields[self.fields_order[column-1]]['type'] == 'date'

	def get_remote(self, fname, content):
		if not self.fields[fname]['type'] == 'many2one':
			return []
		return many2one_sel(self.fields[fname]['relation'], content)

	def unvalid(self, data):
		required_cols = [field for field in self.fields if self.fields[field].get('required', False)]
		for col in required_cols:
			if data[col] == False:
				return col
		return False

	def message(self, message, context='message'):
		sb = self.glade.get_widget('stat_form')
		cid = sb.get_context_id(context)
		sb.push(cid, message)
	
	def refresh_row(self, idx, data):
		data['__idx'] = idx
		line = [data]
		self.construct_line(data, line, {})
		self.model[idx] = line

	def refresh_rows(self, rmin, rmax):
		objs_ids = [self.ids[x] for x in range(rmin, rmax)]
		objs = rpc.session.rpc_exec_auth('/object', 'execute', self.robject_name, 'read', [self.ids[x] for x in range(rmin, rmax)])
		sobj = [obj for obj_id in objs_ids for obj in objs if obj['id'] == obj_id]
		for idx, obj in zip(range(rmin, rmax), sobj):
			self.refresh_row(idx, obj)

	def save_me(self, data):
		not_valid = self.unvalid(data)
		if self.isform and not not_valid:
			old_modif = data.get('__modified', set())
			data['__modified'] = set()
			cdata = self.get_row(data['__idx'])
			if 'id' in data:
				id = self.save_callback(data['id'], cdata)
				self.refresh_rows(max(0, data['__idx'] - self.refresh), min(len(self.ids), data['__idx'] + self.refresh))
			else:
				id = self.save_callback(None, cdata)
				if id:
					data['id'] = id
					self.ids[data['__idx']] = id
					self.refresh_rows(max(0, data['__idx'] - self.refresh), min(len(self.ids), data['__idx'] + self.refresh + 1))
					self.message_callback('')
				else:
					data['__modified'] = old_modif
		elif self.isform:
			self.message_callback(_("The column '%s' is required") % self.fields[not_valid]['string'])
	
fields_list_type = {
	'boolean': gobject.TYPE_STRING,
	'integer': gobject.TYPE_INT,
	'float': gobject.TYPE_FLOAT
}

# vim:noexpandtab:
