##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import gtk
from gtk import glade
import gobject
import gettext
import xmlrpclib
import win_list
import common

from view_tree import parse
import widget.search
import rpc

import service

fields_list_type = {
	'checkbox': gobject.TYPE_BOOLEAN
}

class win_search(object):
	def __init__(self, model, view_form, start_values, domain = [], sel_multi=True, preload=False, ids=[], triggers = [], context={}):
		self.sel_multi = sel_multi
		self.domain = domain
		self.glade = glade.XML(common.terp_path("terp.glade"),'win_search',gettext.textdomain())
		self.win = self.glade.get_widget('win_search')
		#iself.glade.get_widget('sea_but_find').set_flags(gtk.CAN_DEFAULT)
		#self.glade.get_widget('sea_but_find').grab_default()
		#self.glade.get_widget('sea_but_find').grab_focus()
		self.glade.signal_connect('on_sea_but_find_clicked', self.find)
		vp = self.glade.get_widget('search_vp_tree')

		self.view = win_list.win_list(model, sel_multi, context=context, search=True)
		self.fields_order = self.view.fields_order
		if not sel_multi:
			self.view.widget.get_selection().set_mode('single')
		else:
			self.view.widget.get_selection().set_mode(gtk.SELECTION_MULTIPLE)
		vp.add(self.view.widget)
		self.view.widget.connect('row_activated', self.sig_activate)

		self.model_name = model
		self.form = widget.search.form(view_form['arch'], view_form['fields'], model, parent=self.win, triggers=triggers)
		wid_list = self.form.widget.get_children()
		wid_list.reverse()
		#wid_list[0].get_children()[1].set_flags(gtk.CAN_DEFAULT)
		#wid_list[0].get_children()[1].grab_default()
		#wid_list[0].get_children()[1].set_flags(gtk.CAN_FOCUS)
		#wid_list[0].get_children()[1].grab_add()

		(x, y) = self.form.widget.size_request()
		self.form.value = start_values
		self.glade.get_widget('search_hbox').pack_start(self.form.widget)

		self.old_search = None
		self.old_offset = self.old_limit = None
		self.ids = ids
		if preload:
			self.reload()

	def sig_activate(self, *args):
		self.win.response(gtk.RESPONSE_OK)
		return True

	def find(self, widget=None, *args):
		limit = self.glade.get_widget('search_spin_limit').get_value_as_int()
		offset = self.glade.get_widget('search_spin_offset').get_value_as_int()
		if (self.old_search == self.form.value) and (self.old_limit==limit) and (self.old_offset==offset):
			self.win.response(gtk.RESPONSE_OK)
			return
		self.old_offset = offset
		self.old_limit = limit
		print self.form.value, self.domain, self.form.value+self.domain
		v = self.form.value
		v_keys = map(lambda x: x[0], v)
		for f in self.domain:
			if f[0] not in v_keys:
				v.append(f)
		self.ids = rpc.session.rpc_exec_auth('/object', 'execute', self.model_name, 'search', v, offset, limit)
		self.reload()
		self.old_search = self.form.value
		return True

	def reload(self):
		self.view.reload(self.ids)

	def sel_ids_get(self):
		return self.view.sel_ids_get()

	def destroy(self):
		self.win.destroy()

	def go(self):
		button = self.win.run()
		if button==gtk.RESPONSE_OK:
			res = self.sel_ids_get() or self.ids
		else:
			res = None
		self.destroy()
		return res

